﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data;

namespace Babebi4
{
	internal class GuiTable__BookSentence : DataTable
	{
		private MainForm mainForm;

		internal DataSet DataSet__for__BindingSource { get ; private set; }

		private string current__Language__Code
		{
			get { return this.mainForm.Current__Language.Code; }
		}

		#region		Columns

		internal	DataColumn BookSentenceIndex { get; private set; }
		private		DataColumn LanguageString;
		private		DataColumn SentenceId;
		private		DataColumn BabebiString;

		#endregion	Columns

		public GuiTable__BookSentence(MainForm mainForm) : base("BookSentence_")
		{
			this.mainForm = mainForm;

			this.DataSet__for__BindingSource = new DataSet();

			this.DataSet__for__BindingSource.Tables.Add(this);

			#region		Columns

			this.BookSentenceIndex	= new DataColumn("BookSentenceIndex", typeof(int	));
			this.LanguageString		= new DataColumn("LanguageString"	, typeof(string	));
			this.SentenceId			= new DataColumn("SentenceId"		, typeof(long	));
			this.BabebiString		= new DataColumn("BabebiString"		, typeof(string	));

			this.BookSentenceIndex	.AllowDBNull = false;
			this.LanguageString	.AllowDBNull = false;
			this.SentenceId		.AllowDBNull = false;
			this.BabebiString	.AllowDBNull = false;

			this.LanguageString	 .MaxLength = 256;
			this.BabebiString	 .MaxLength = 256;

			this.Columns.Add(this.BookSentenceIndex	);
			this.Columns.Add(this.LanguageString	);
			this.Columns.Add(this.SentenceId		);
			this.Columns.Add(this.BabebiString		);

			#endregion	Columns

			this.PrimaryKey	= new DataColumn[] { this.BookSentenceIndex };

			#region		events

			this.mainForm.DataSet.BookSentence.RowChanged += BookSentence__RowChanged;

			this.mainForm.DataSet.Sentence.RowChanged			+= Sentence__RowChanged;
			this.mainForm.DataSet.Sentence_Language.RowChanged	+= Sentence_Language__RowChanged;

			#endregion	events
		}

		#region		events

		private void BookSentence__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			BabebiDataSet.BookSentenceRow bookSentence = (BabebiDataSet.BookSentenceRow)(e.Row);

			if (e.Action == DataRowAction.Add)
			{
				this.addGuiRow(bookSentence);
			}
		}

		private void Sentence__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			BabebiDataSet.SentenceRow sentence = (BabebiDataSet.SentenceRow)(e.Row);

			if (e.Action == DataRowAction.Change)
			{
				foreach (BabebiDataSet.BookSentenceRow bookSentence in sentence.GetBookSentenceRows())
				{
					if (bookSentence.BookId != this.mainForm.Current__Book.Id)
					{
						continue;
					}

					DataRow guiDataRow = this.Find(bookSentence.Index);

					if (guiDataRow != null)
					{
						if (guiDataRow.Field<string>(this.BabebiString) != sentence.String)
						{
							guiDataRow.SetField<string>(this.BabebiString, sentence.String);
						}
					}
				}
			}
		}
		private void Sentence_Language__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			BabebiDataSet.Sentence_LanguageRow sentence_Language = (BabebiDataSet.Sentence_LanguageRow)(e.Row);

			if (e.Action == DataRowAction.Change)
			{
				foreach (BabebiDataSet.BookSentenceRow bookSentence in sentence_Language.SentenceRow.GetBookSentenceRows())
				{
					if (bookSentence.BookId != this.mainForm.Current__Book.Id)
					{
						continue;
					}
 
					DataRow guiDataRow = this.Find(bookSentence.Index);

					if (guiDataRow != null)
					{
						string existingLanguageString = guiDataRow.Field<string>(this.LanguageString);

						if (existingLanguageString != sentence_Language.String)
						{
							guiDataRow.SetField<string>(this.LanguageString, sentence_Language.String);
						}
					}
				}
			}
		}

		#endregion	events

		internal	DataRow		Find(int bookSentenceIndex)
		{ 
			return this.Rows.Find(bookSentenceIndex);
		}

		internal	void		Populate()
		{ 
			this.Rows.Clear();

			foreach (BabebiDataSet.BookSentenceRow bookSentence in this.mainForm.Current__Book.GetBookSentenceRows())
			{
				this.addGuiRow(bookSentence);
			}
		}

		private		DataRow		addGuiRow(BabebiDataSet.BookSentenceRow bookSentence)
		{
			BabebiDataSet.SentenceRow sentence	= bookSentence.SentenceRow;

			BabebiDataSet.Sentence_LanguageRow	sentence_Language	
				= this.mainForm.DataSet.Sentence_Language
				.FindBySentenceIdLanguageCode
				(
					sentence.Id, 
					current__Language__Code
				);

			DataRow dataRow
				= this.Rows.Add
				(
					bookSentence.Index,			/// BookSentenceId;
					sentence_Language.String,	/// LanguageString;
					sentence.Id,				/// SentenceId;
					sentence.String				/// BabebiString;
				);

			return dataRow;
		}
	}
}
