﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data;

namespace Babebi4
{
	public class GuiTable__DerivatingWordType_DerivatedWordType : DataTable
	{
		private MainForm					mainForm;
		private BabebiDataSet				dataSet
		{
			get
			{
				return this.mainForm.DataSet;
			}
		}
		private BabebiDataSet.LanguageRow	current__Language
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}

		public DataSet		DataSetForBindingSource;

		public DataColumn	DerivatingWordTypeId;
		public DataColumn	DerivatedWordTypeId;
		public DataColumn	DerivatingWordType_LanguageName;
		public DataColumn	DerivatedWordType_LanguageName;

		/// ctor
		public GuiTable__DerivatingWordType_DerivatedWordType(MainForm mainform) 
		: base("DerivatingWordType_DerivatedWordType_")
		{
			this.mainForm = mainform;

			this.DataSetForBindingSource = new DataSet("DerivatingWordType_DerivatedWordType__DataSet");

			this.DataSetForBindingSource.Tables.Add(this);

			this.DerivatingWordTypeId				= this.Columns.Add("DerivatingWordTypeId"			, typeof(short));
			this.DerivatedWordTypeId				= this.Columns.Add("DerivatedWordTypeId"			, typeof(short));
			this.DerivatingWordType_LanguageName	= this.Columns.Add("DerivatingWordType_LanguageName", typeof(string));
			this.DerivatedWordType_LanguageName		= this.Columns.Add("DerivatedWordType_LanguageName"	, typeof(string));

			this.DerivatingWordTypeId				.AllowDBNull = false;
			this.DerivatedWordTypeId				.AllowDBNull = false;
			this.DerivatingWordType_LanguageName	.AllowDBNull = false;
			this.DerivatedWordType_LanguageName		.AllowDBNull = false;

			this.DerivatingWordType_LanguageName.MaxLength = 256;
			this.DerivatedWordType_LanguageName	.MaxLength = 256;

			this.PrimaryKey 
				= new DataColumn[]
				{
					this.DerivatingWordTypeId,
					this.DerivatedWordTypeId
				};

			this.dataSet.DerivatingWordType_DerivatedWordType.RowChanged += DerivatingWordType_DerivatedWordType_RowChanged;
			this.dataSet.DerivatingWordType_DerivatedWordType.RowDeleted += DerivatingWordType_DerivatedWordType_RowDeleted;
		}

		/// getters of column values
		public short	GetValue__DerivatingWordTypeId(DataRow dataRow)				{ return dataRow.Field<short	>(this.DerivatingWordTypeId				); }
		public short	GetValue__DerivatedWordTypeId(DataRow dataRow)				{ return dataRow.Field<short	>(this.DerivatedWordTypeId				); }
		public string	GetValue__DerivatingWordType_LanguageName(DataRow dataRow)	{ return dataRow.Field<string	>(this.DerivatingWordType_LanguageName	); }
		public string	GetValue__DerivatedWordType_LanguageName(DataRow dataRow)	{ return dataRow.Field<string	>(this.DerivatedWordType_LanguageName	); }

		/// events
		private void DerivatingWordType_DerivatedWordType_RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (this.mainForm.DoNotTriggerCurrentChangedEvent)
			{
				return;
			}

			if (e.Action == DataRowAction.Add)
			{
				DataRow			dataRow			= e.Row;

				BabebiDataSet.DerivatingWordType_DerivatedWordTypeRow derivatingWordType_derivatedWordType
					= (BabebiDataSet.DerivatingWordType_DerivatedWordTypeRow)(e.Row);

				short derivatingWordTypeId	= derivatingWordType_derivatedWordType.DerivatingWordTypeId;
				short derivatedWordTypeId	= derivatingWordType_derivatedWordType.DerivatedWordTypeId;

				BabebiDataSet.DerivatingWordType_LanguageRow derivatingWordType_Language
					= this.dataSet.DerivatingWordType_Language.FindByDerivatingWordTypeIdLanguageCode
					(
						derivatingWordTypeId,
						this.current__Language.Code
					);

				BabebiDataSet.DerivatedWordType_LanguageRow derivatedWordType_Language
					= this.dataSet.DerivatedWordType_Language.FindByDerivatedWordTypeIdLanguageCode
					(
						derivatedWordTypeId,
						this.current__Language.Code
					);

				DataRow guiDataRow 
					= this.Rows
					.Add
					(
						derivatingWordTypeId,
						derivatedWordTypeId,
						derivatingWordType_Language.Name,
						derivatedWordType_Language.Name
					);

				
				MainForm.FocusGridRow(this.mainForm.BindingSource__DerivatingWordType_DerivatedWordType, 	guiDataRow);

			}
		}
		private void DerivatingWordType_DerivatedWordType_RowDeleted(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Delete)
			{
				short derivatingWordTypeId	
					= 
					(short)
					(
						e.Row
						[
							this.mainForm.DataSet.DerivatingWordType_DerivatedWordType.DerivatingWordTypeIdColumn, 
							DataRowVersion.Original
						]
					);


				short derivatedWordTypeId	
					= 
					(short)
					(
						e.Row
						[
							this.mainForm.DataSet.DerivatingWordType_DerivatedWordType.DerivatedWordTypeIdColumn, 
							DataRowVersion.Original
						]
					);

				DataRow deletedDataRow 
					= this
					.Find
					(
						derivatingWordTypeId, 
						derivatedWordTypeId
					);

				this.Rows.Remove(deletedDataRow);
			}
		}

		public void Populate()
		{
			this.mainForm.DoNotTriggerCurrentChangedEvent = true;
			this.Clear();
			this.mainForm.DoNotTriggerCurrentChangedEvent = false;

			if (this.current__Language == null)
			{
				return;
			}

			foreach 
			(
				BabebiDataSet.DerivatingWordType_DerivatedWordTypeRow derivatingWordType_derivatedWordType 
				in 
				this.dataSet.DerivatingWordType_DerivatedWordType.Rows)
			{
				BabebiDataSet.DerivatingWordType_LanguageRow derivatingWordType_language 
					= this.dataSet.DerivatingWordType_Language.FindByDerivatingWordTypeIdLanguageCode
					(
						derivatingWordType_derivatedWordType.DerivatingWordTypeId,
						this.current__Language.Code
					);

				BabebiDataSet.DerivatedWordType_LanguageRow derivatedWordType_language 
					= this.dataSet.DerivatedWordType_Language.FindByDerivatedWordTypeIdLanguageCode
					(
						derivatingWordType_derivatedWordType.DerivatedWordTypeId,
						this.current__Language.Code
					);

				this.mainForm.DoNotTriggerCurrentChangedEvent = true;
				this.Rows.Add
				(
					derivatingWordType_derivatedWordType.DerivatingWordTypeId,
					derivatingWordType_derivatedWordType.DerivatedWordTypeId,
					derivatingWordType_language.Name,
					derivatedWordType_language.Name
				);
				this.mainForm.DoNotTriggerCurrentChangedEvent = false;
			}
		}

		public DataRow Find(short derivatingWordTypeId, short derivatedWordTypeId)
		{
			return this.Rows.Find(new object[] { derivatingWordTypeId, derivatedWordTypeId});
		}
	}
}
