﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data;

namespace Babebi4
{
	/// voir maintenant le fichier GuiTable__PatternByInsertion__of__Current__.cs

	#region	(ancienne version)	
	/*
	public class GuiTable__PatternByInsertion__of__Current__Pattern : DataTable
	{
		private MainForm		mainForm;
		private BabebiDataSet	dataSet
		{
			get
			{
				return this.mainForm.DataSet;
			}
		}

		private BabebiDataSet.LanguageRow	currentLanguage
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}
		private string						currentLanguageCode
		{
			get
			{
				return this.mainForm.Current__Language.Code;
			}
		}

		public DataSet		DataSetForBindingSource;

		#region		Columns

		public DataColumn	Column__Id;
		public DataColumn	Column__UniqueKeyString;
		public DataColumn	Column__Meaning;
		public DataColumn	Column__InsertionIndexString;
		public DataColumn	Column__LetterOrSymbolClusterString;

		#endregion	Columns

		#region		getters : GetValue__[columnName](guiDataRow)

		public int		GetValue__Id(DataRow guiDataRow)							{return guiDataRow.Field<int	>(this.Column__Id);}
		public string	GetValue__UniqueKeyString(DataRow guiDataRow)				{return guiDataRow.Field<string	>(this.Column__UniqueKeyString);}
		public string	GetValue__Meaning(DataRow guiDataRow)						{return guiDataRow.Field<string	>(this.Column__Meaning);}
		public string	GetValue__InsertionIndexString(DataRow guiDataRow)			{return guiDataRow.Field<string	>(this.Column__InsertionIndexString);}
		public string	GetValue__LetterOrSymbolClusterString(DataRow guiDataRow)	{return guiDataRow.Field<string	>(this.Column__LetterOrSymbolClusterString);}

		#endregion	getters : GetValue__[columnName](guiDataRow)

		/// ctor
		public GuiTable__PatternByInsertion__of__Current__Pattern(MainForm mainform) 
		: base("ParrentByInsertion__of__Current__Pattern")
		{
			this.mainForm = mainform;

			this.DataSetForBindingSource = new DataSet("ParrentByInsertion__of__Current__Pattern__DATASET");

			this.DataSetForBindingSource.Tables.Add(this);

			#region		columns

			this.Column__Id								= this.Columns.Add("Id"							, typeof(int));
			this.Column__UniqueKeyString				= this.Columns.Add("UniqueKeyString"			, typeof(string));
			this.Column__Meaning						= this.Columns.Add("Meaning"					, typeof(string));
			this.Column__InsertionIndexString			= this.Columns.Add("InsertionIndexString"		, typeof(string));
			this.Column__LetterOrSymbolClusterString	= this.Columns.Add("LetterOrSymbolClusterString", typeof(string));

			this.Column__Id						.AllowDBNull = false;
			this.Column__UniqueKeyString		.AllowDBNull = false;
			this.Column__Meaning				.AllowDBNull = false;
			this.Column__InsertionIndexString	.AllowDBNull = false;
			this.Column__LetterOrSymbolClusterString	.AllowDBNull = false;

			this.Column__UniqueKeyString		.MaxLength = 32;
			this.Column__Meaning				.MaxLength = 256;
			this.Column__InsertionIndexString	.MaxLength = 32;
			this.Column__LetterOrSymbolClusterString	.MaxLength = 8;

			this.PrimaryKey 	= new DataColumn[]{this.Column__Id};

			#endregion	columns

			this.dataSet.PatternByInsertion.RowChanged	+= PatternByInsertion__RowChanged;
			this.dataSet.Pattern.RowChanged				+= Pattern_RowChanged;
			this.dataSet.Pattern_Language.RowChanged	+= Pattern_Language__RowChanged;

			this.dataSet.PatternByInsertion.RowDeleting += PatternByInsertion__RowDeleting;
			this.dataSet.Pattern.PatternRowDeleting		+= Pattern__PatternRowDeleting;
		}

		#region		DataSet events listening

		private void PatternByInsertion__RowChanged	(object sender, DataRowChangeEventArgs e)
		{
			BabebiDataSet.PatternByInsertionRow patternByInsertion = (BabebiDataSet.PatternByInsertionRow)(e.Row);

			if (e.Action == DataRowAction.Add)
			{
				if 
				(
					patternByInsertion.WordOrPatternRowParent.SubscriberId		== this.mainForm.Current__Pattern.Id
					&&
					patternByInsertion.WordOrPatternRowParent.SubscriberCode	== MainForm.SubscriberCode_Pattern
				)
				{
					this.addGuiDataRow(patternByInsertion);
				}
			}
			else if (e.Action == DataRowAction.Change)
			{
				DataRow guiDataRow	= this.findGuiDataRow(patternByInsertion.Id);

				if (guiDataRow != null)
				{
					#region		still here ?
					
					if
					(
						patternByInsertion.WordOrPatternRowParent.SubscriberCode	!= MainForm.SubscriberCode_Pattern
						||
						patternByInsertion.WordOrPatternRowParent.SubscriberId		!= this.mainForm.Current__Pattern.Id
					)
					{ 
						this.Rows.Remove(guiDataRow);

						return;
					}

					#endregion	still here ?
					#region		InsertionIndex

					string	insertionIndexString
							= MainForm
							.Convert__InsertionIndex__into__ComboBoxSelectedItem
							(
								patternByInsertion.InsertionIndex
							);
					
					if (this.GetValue__InsertionIndexString(guiDataRow) != insertionIndexString)
					{
						guiDataRow[this.Column__InsertionIndexString] = insertionIndexString;
					}

					#endregion	InsertionIndex
					#region		LetterOrSymbolClusterString

					if (this.GetValue__LetterOrSymbolClusterString(guiDataRow) != patternByInsertion.LetterOrSymbolClusterRow.String)
					{
						guiDataRow[this.Column__LetterOrSymbolClusterString] = patternByInsertion.LetterOrSymbolClusterRow.String;
					}

					#endregion	LetterOrSymbolClusterString
				}
			}
		}
		private void Pattern_RowChanged				(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Change)
			{
				BabebiDataSet.PatternRow pattern = (BabebiDataSet.PatternRow)(e.Row);

				#region		where the out-of-scope rows are return-trapped.

				if (pattern.ModeCode != MainForm.ModeCode_ByInsertion)
				{
					return;
				}

				BabebiDataSet.PatternByInsertionRow patternByInsertion
					= this.dataSet.PatternByInsertion
					.FindById(pattern.Id);

				if 
				(
					patternByInsertion == null
					||
					patternByInsertion.WordOrPatternSubscriberCode	!= MainForm.SubscriberCode_Pattern
					||
					patternByInsertion.WordOrPatternSubscriberId	!= this.mainForm.Current__Pattern.Id
				)
				{
					return;
				}

				#endregion	where the out-of-scope rows are return-trapped.

				DataRow guiDataRow = this.findGuiDataRow(pattern.Id);

				if (guiDataRow != null)
				{
					if (this.GetValue__Id(guiDataRow) != pattern.Id)
					{
						guiDataRow[this.Column__Id] = pattern.Id;
					}

					if (this.GetValue__UniqueKeyString(guiDataRow) != pattern.UniqueKeyString)
					{
						guiDataRow[this.Column__UniqueKeyString] = pattern.UniqueKeyString;
					}
				}
			}
		}
		private void Pattern_Language__RowChanged	(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Change)
			{
				BabebiDataSet.Pattern_LanguageRow pattern_language = (BabebiDataSet.Pattern_LanguageRow)(e.Row);

				if (pattern_language.LanguageRow.Code != this.currentLanguageCode)
				{
					return;
				}

				#region		where the out-of-scope rows are return-trapped.

				if (pattern_language.PatternRow.ModeCode != MainForm.ModeCode_ByInsertion)
				{
					return;
				}

				BabebiDataSet.PatternByInsertionRow patternByInsertion
					= this.dataSet.PatternByInsertion
					.FindById(pattern_language.PatternId);

				if 
				(
					patternByInsertion.WordOrPatternSubscriberCode	!= MainForm.SubscriberCode_Pattern
					&&
					patternByInsertion.WordOrPatternSubscriberId	!= this.mainForm.Current__Pattern.Id
				)
				{
					return;
				}

				#endregion	where the out-of-scope rows are return-trapped.

				DataRow guiDataRow = this.findGuiDataRow(pattern_language.PatternId);

				if (guiDataRow != null && this.GetValue__Meaning(guiDataRow) != pattern_language.Meaning)
				{
					guiDataRow[this.Column__Meaning] = pattern_language.Meaning;
				}
			}
		}

		private void PatternByInsertion__RowDeleting(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Delete)
			{
				BabebiDataSet.PatternByInsertionRow patternByInsertion = (BabebiDataSet.PatternByInsertionRow)(e.Row);

				DataRow guiDataRow = Find(patternByInsertion.Id);

				if (guiDataRow != null)
				{
					this.Rows.Remove(guiDataRow);
				}
			}			
		}
		private void Pattern__PatternRowDeleting	(object sender, BabebiDataSet.PatternRowChangeEvent e)
		{
			if (e.Action == DataRowAction.Delete)
			{				
				BabebiDataSet.PatternRow pattern = e.Row;

				DataRow guiDataRow = this.Find(pattern.Id);

				if (guiDataRow != null)
				{
					this.Rows.Remove(guiDataRow);
				}
			}
		}

		#endregion	DataSet events listening

		public bool? Populate()
		{
			this.Clear();

			if (this.currentLanguage == null)
			{
				return null;
			}

			bool has1RowAtLeast = false;
			foreach
			(
				BabebiDataSet.PatternByInsertionRow patternByInsertion
				in
				this.mainForm.Current__Pattern.WordOrPatternRowParent.GetPatternByInsertionRows()
			)
			{
				this.addGuiDataRow(patternByInsertion);

				if (!has1RowAtLeast)
				{
					has1RowAtLeast = true;
				}
			}

			return has1RowAtLeast;
		}

		private DataRow addGuiDataRow(BabebiDataSet.PatternByInsertionRow patternByInsertion)
		{
			BabebiDataSet.PatternRow pattern = patternByInsertion.PatternRowParent;

			BabebiDataSet.Pattern_LanguageRow pattern_language
				=
				this.dataSet.Pattern_Language
				.FindByPatternIdLanguageCode
				(
					pattern.Id,
					this.currentLanguageCode
				);

			string	insertionIndexString
					= MainForm
					.Convert__InsertionIndex__into__ComboBoxSelectedItem
					(
						patternByInsertion.InsertionIndex
					);

			return this.Rows.Add
			(
				pattern.Id,
				pattern.UniqueKeyString,
				pattern_language.Meaning,
				insertionIndexString,
				patternByInsertion.LetterOrSymbolClusterRow.String
			);
		}

		public DataRow Find(int patternId)
		{
			return this.Rows.Find(patternId);
		}

		private DataRow findGuiDataRow(int dataSetPatternId)
		{
			DataRow guiDataRow = this.Find(dataSetPatternId);

			if (guiDataRow == null)
			{
				int guiPatternId = this.mainForm.DataGridView__PatternByInsertion__of__Current__Pattern__CurrentPatternId;

				if (guiPatternId != -1)
				{
					guiDataRow = this.Find(guiPatternId);

					if (guiDataRow != null)
					{
						guiDataRow[this.Column__Id] = dataSetPatternId;

						this.mainForm.DataGridView__PatternByInsertion__of__Current__Pattern__CurrentPatternId = dataSetPatternId;
					}
				}
			}

			return guiDataRow;
		}
	}
	*/
	#endregion	(ancienne version)
}
