﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data;

namespace Babebi4
{
	internal class GuiTable__PatternFromPattern__of__Current__Pattern : GuiTable__Word_Pattern
	{
		private DataColumn	LetterDictionaryString;
		private DataColumn	GuiHorizontalShift;
		private DataColumn	SORTING;

		public string	GetValue__LetterDictionaryString	(DataRow guiDataRow){return guiDataRow.Field<string	>(this.LetterDictionaryString	);}
		public short	GetValue__GuiHorizontalShift		(DataRow guiDataRow){return guiDataRow.Field<short	>(this.GuiHorizontalShift		);}
		public int		GetValue__SORTING					(DataRow guiDataRow){return guiDataRow.Field<int	>(this.SORTING					);}

		internal GuiTable__PatternFromPattern__of__Current__Pattern(MainForm mainform) : base(mainform, false, MainForm.ModeCode_FromPattern)
		{
			#region		columns

			this.LetterDictionaryString	= this.Columns.Add("LetterDictionaryString"	, typeof(string	));
			this.GuiHorizontalShift		= this.Columns.Add("GuiHorizontalShift"		, typeof(short	));
			this.SORTING				= this.Columns.Add("SORTING"				, typeof(int	));

			this.LetterDictionaryString	.AllowDBNull = false;
			this.GuiHorizontalShift		.AllowDBNull = false;
			this.SORTING				.AllowDBNull = false;

			this.LetterDictionaryString	.MaxLength = 256;

			#endregion	columns

			this.dataSet.PatternFromPattern.RowChanged	+= PatternFromPattern__RowChanged;
			this.dataSet.FromPattern.RowChanged			+= FromPattern__RowChanged;
			this.dataSet.FromPatternLetter.RowChanged	+= FromPatternLetter__RowChanged;

			this.dataSet.FromPatternLetter.RowDeleting	+= FromPatternLetter__RowDeleting;
			this.dataSet.PatternFromPattern.RowDeleting	+= PatternFromPattern__RowDeleting;
		}

		#region		listening to the DataSet events

		private void PatternFromPattern__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			BabebiDataSet.PatternFromPatternRow patternFromPattern = (BabebiDataSet.PatternFromPatternRow)(e.Row);

			if (e.Action == DataRowAction.Add)
			{
				if(!this.isParentTheCurrent(patternFromPattern))
				{
					return;
				}

				List<object> valueList = this.buildValueList(patternFromPattern);

				DataRow guiDataRow = this.addGuiDataRow(valueList);

				guiDataRow.AcceptChanges();
			}
			else if(e.Action == DataRowAction.Change)
			{
				/// rien à faire ici car PatternFromPattern ne porte aucune information
				/// à part Pattern.Id MAIS ce n'est pas ici que cela est géré.
			}
		}
		private void FromPattern__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			BabebiDataSet.FromPatternRow fromPattern = (BabebiDataSet.FromPatternRow)(e.Row);

			if (fromPattern.SubscriberCode != MainForm.SubscriberCode_Pattern)
			{
				return;
			}

			if(e.Action == DataRowAction.Change)
			{
				DataRow guiDataRow = Find(fromPattern.SubscriberId);

				if (guiDataRow != null)
				{
					if (fromPattern.PatternId != this.mainForm.Current__Pattern.Id)
					{
						this.Rows.Remove(guiDataRow);

						return;
					}
					else
					{
						/// GuiHorizontalShift
						if (this.GetValue__GuiHorizontalShift(guiDataRow) != fromPattern.GuiHorizontalShift)
						{
							guiDataRow[this.GuiHorizontalShift] = fromPattern.GuiHorizontalShift;
						}
					}
				}
				else
				{
					if (fromPattern.PatternId == this.mainForm.Current__Pattern.Id)
					{
						BabebiDataSet.PatternFromPatternRow patternFromPattern
							= this.dataSet.PatternFromPattern
							.FindById
							(
								fromPattern.SubscriberId
							);

						List<object> valueList = this.buildValueList(patternFromPattern);

						guiDataRow = this.addGuiDataRow(valueList);

						guiDataRow.AcceptChanges();
					}
					else
					{
						/// pas de guiRow et il ne doit pas y en avoir.
					}
				}
			}
		}
		private void FromPatternLetter__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			if (e.Action == DataRowAction.Change || e.Action == DataRowAction.Add)
			{
				BabebiDataSet.FromPatternLetterRow fromPatternLetter = (BabebiDataSet.FromPatternLetterRow)(e.Row);

				BabebiDataSet.FromPatternRow fromPattern = fromPatternLetter.FromPatternRowParent;

				DataRow guiDataRow = this.Find(fromPatternLetter.FromPatternSubscriberId);

				if (guiDataRow != null)
				{
					/// LetterDictionaryString

					if (fromPattern != null)		/// à cause d'un Update du Pattern Id....
					{
						/// LetterDictionaryString
						string letterDictionaryString = MainForm.Compute__LetterDictionaryString__for_Pattern(fromPattern);
						if (this.GetValue__LetterDictionaryString(guiDataRow) != letterDictionaryString)
						{
							guiDataRow[this.LetterDictionaryString] = letterDictionaryString;
						}

						/// SORTING
						int sorting = this.mainForm.Compute__Sorting(fromPattern);
						if (this.GetValue__SORTING(guiDataRow) != sorting)
						{
							guiDataRow[this.SORTING] = sorting;
						}
					}
				}
			}
		}

		private void FromPatternLetter__RowDeleting(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			BabebiDataSet.FromPatternLetterRow	fromPatternLetter = (BabebiDataSet.FromPatternLetterRow)(e.Row);

			BabebiDataSet.FromPatternRow		fromPattern = fromPatternLetter.FromPatternRowParent;

			if (e.Action == DataRowAction.Delete)
			{
				DataRow guiDataRow = Find(fromPatternLetter.FromPatternSubscriberId);

				if (guiDataRow != null)
				{					
					/// LetterDictionaryString
					string letterDictionaryString = MainForm.Compute__LetterDictionaryString__for_Pattern(fromPattern, fromPatternLetter);
					if (this.GetValue__LetterDictionaryString(guiDataRow) != letterDictionaryString)
					{
						guiDataRow[this.LetterDictionaryString] = letterDictionaryString;
					}

					/// SORTING
					int sorting = this.mainForm.Compute__Sorting(fromPattern, fromPatternLetter);
					if (this.GetValue__SORTING(guiDataRow) != sorting)
					{
						guiDataRow[this.SORTING] = sorting;
					}
				}
			}
		}
		private void PatternFromPattern__RowDeleting(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			if (e.Action == DataRowAction.Delete)
			{
				BabebiDataSet.PatternFromPatternRow patternFromPattern = (BabebiDataSet.PatternFromPatternRow)(e.Row);

				DataRow guiDataRow = Find(patternFromPattern.Id);

				if (guiDataRow != null)
				{
					this.Rows.Remove(guiDataRow);
				}
			}
		}

		#endregion	listening the DataSet events

		private List<object> buildValueList(BabebiDataSet.PatternFromPatternRow patternFromPattern)
		{
			List<object> valueList = base.guiDataRow_ValueList(patternFromPattern.PatternRowParent);

			string	letterDictionaryString	= MainForm.Compute__LetterDictionaryString__for_Pattern(patternFromPattern.FromPatternRowParent);
			short	guiHorizontalShift		= patternFromPattern.FromPatternRowParent.GuiHorizontalShift;
			int		sorting					= this.mainForm.Compute__Sorting(patternFromPattern.FromPatternRowParent);

			valueList.Add(letterDictionaryString	);	/// LetterDictionaryString	
			valueList.Add(guiHorizontalShift		);	/// GuiHorizontalShift		
			valueList.Add(sorting					);	/// SORTING				

			return valueList;
		}

		private bool isParentTheCurrent(BabebiDataSet.PatternFromPatternRow patternFromPattern)
		{ 
			if
			(
				patternFromPattern == null 
				|| 
				this.mainForm.Current__Pattern == null
				||
				patternFromPattern.FromPatternRowParent.PatternId != this.mainForm.Current__Pattern.Id
			)
			{
				return false;
			}
			else
			{ 
				return true;
			}
		}

		#region		virtual and abstract methods

		protected override bool isParentTheCurrent(int dataRow__Id)
		{
			BabebiDataSet.PatternFromPatternRow patternFromPattern
				= this.dataSet.PatternFromPattern
				.FindById(dataRow__Id);

			return this.isParentTheCurrent(patternFromPattern);
		}

		protected override List<object>[] getValueListArray()
		{
			BabebiDataSet.PatternRow pattern = this.mainForm.Current__Pattern;

			List<List<object>> valueListList = new List<List<object>>();

			foreach (BabebiDataSet.FromPatternRow fromPattern in pattern.GetFromPatternRows())
			{
				if (fromPattern.SubscriberCode == MainForm.SubscriberCode_Word)
				{
					continue;
				}

				BabebiDataSet.PatternFromPatternRow patternFromPattern
					= this.dataSet.PatternFromPattern
					.FindById(fromPattern.SubscriberId);


				List<object> valueList = this.buildValueList(patternFromPattern);

				valueListList.Add(valueList);
			}

			return valueListList.ToArray();
		}

		#endregion	virtual and abstract methods
		
	}

	#region		(ancienne version)
	/*
	public class GuiTable__PatternFromPattern__of__Current__Pattern : DataTable
	{
		private MainForm mainForm;

		private BabebiDataSet dataSet
		{
			get
			{
				return this.mainForm.DataSet;
			}
		}

		#region		shortcuts about tables

		private BabebiDataSet.PatternDataTable				table__Pattern
		{
			get { return this.dataSet.Pattern; }
		}
		private BabebiDataSet.Pattern_LanguageDataTable		table__Pattern_Language
		{
			get { return this.dataSet.Pattern_Language; }
		}
		private BabebiDataSet.PatternFromPatternDataTable	table__PatternFromPattern
		{
			get { return this.dataSet.PatternFromPattern; }
		}
		private BabebiDataSet.FromPatternDataTable			table__FromPattern
		{
			get { return this.dataSet.FromPattern; }
		}
		private BabebiDataSet.FromPatternLetterDataTable	table__FromPatternLetter
		{
			get { return this.dataSet.FromPatternLetter; }
		}

		#endregion	shortcuts about tables

		private BabebiDataSet.LanguageRow	currentLanguage
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}
		private string						currentLanguageCode
		{ 
			get
			{
				return this.mainForm.Current__Language.Code;
			}
		}

		/// <summary>
		/// public car la MainForm y accède lors du loading pour le binder à la DGV.
		/// </summary>
		public DataSet DataSet__for__the__BindingSource;

		#region		Columns

		public DataColumn	PatternId;
		public DataColumn	PatternUniqueKeyString;
		public DataColumn	Pattern_LanguageMeaning;
		public DataColumn	LetterDictionaryString;
		public DataColumn	GuiHorizontalShift;
		public DataColumn	SORTING;

		#endregion	Columns

		#region		getters : GetValue__'ColumnName'(guiDataRow) 
		
		/// Remarque : les getters sont nécessaires pour avoir des valeurs typées-simples. 
		/// Pas de setters car pour le setting on n'a pas de problème de type ; on écrit : 
		/// guiDataRow[this.ColumnName] = value.

		public int		GetValue__PatternId(DataRow guiDataRow)					{return guiDataRow.Field<int	>(this.PatternId				);}
		public string	GetValue__PatternUniqueKeyString(DataRow guiDataRow)	{return guiDataRow.Field<string	>(this.PatternUniqueKeyString	);}
		public string	GetValue__Pattern_LanguageMeaning(DataRow guiDataRow)	{return guiDataRow.Field<string	>(this.Pattern_LanguageMeaning	);}
		public string	GetValue__LetterDictionaryString(DataRow guiDataRow)	{return guiDataRow.Field<string	>(this.LetterDictionaryString	);}
		public short	GetValue__GuiHorizontalShift(DataRow guiDataRow)		{return guiDataRow.Field<short	>(this.GuiHorizontalShift		);}
		public int		GetValue__SORTING(DataRow guiDataRow)					{return guiDataRow.Field<int	>(this.SORTING					);}

		#endregion	getters : GetValue__'ColumnName'(guiDataRow)

		/// ctor
		public GuiTable__PatternFromPattern__of__Current__Pattern(MainForm mainform) 
		: base("PatternFromPattern__of__Current__Pattern_")	/// on rajouter un '_' à la fin pour bien se souvenir que ce n'est pas une table du DS.
		{
			this.mainForm = mainform;

			this.DataSet__for__the__BindingSource = new DataSet("PatternFromPattern__of__Current__Pattern__DataSet");

			this.DataSet__for__the__BindingSource.Tables.Add(this);

			#region		columns

			this.PatternId					= this.Columns.Add("PatternId"				, typeof(int));
			this.PatternUniqueKeyString		= this.Columns.Add("PatternUniqueKeyString"	, typeof(string));
			this.Pattern_LanguageMeaning	= this.Columns.Add("Pattern_LanguageMeaning", typeof(string));
			this.LetterDictionaryString		= this.Columns.Add("LetterDictionaryString"	, typeof(string));
			this.GuiHorizontalShift			= this.Columns.Add("GuiHorizontalShift"		, typeof(short));
			this.SORTING					= this.Columns.Add("SORTING"				, typeof(int));

			this.PatternId				.AllowDBNull = false;
			this.PatternUniqueKeyString	.AllowDBNull = false;
			this.Pattern_LanguageMeaning.AllowDBNull = false;
			this.LetterDictionaryString	.AllowDBNull = false;
			this.GuiHorizontalShift		.AllowDBNull = false;
			this.SORTING				.AllowDBNull = false;

			this.PatternUniqueKeyString	.MaxLength = 32;
			this.Pattern_LanguageMeaning.MaxLength = 256;
			this.LetterDictionaryString	.MaxLength = 256;

			this.PrimaryKey 	= new DataColumn[]{this.PatternId};

			#endregion	columns

			this.dataSet.PatternFromPattern.RowChanged	+= PatternFromPattern__RowChanged;	/// à mettre en premier !
			this.dataSet.Pattern.RowChanged				+= Pattern_RowChanged;
			this.dataSet.Pattern_Language.RowChanged	+= Pattern_Language__RowChanged; 
			this.dataSet.FromPattern.RowChanged			+= FromPattern__RowChanged;
			this.dataSet.FromPatternLetter.RowChanged	+= FromPatternLetter__RowChanged;

			this.dataSet.FromPatternLetter.RowDeleting	+= FromPatternLetter__RowDeleting;
			this.dataSet.PatternFromPattern.RowDeleting	+= PatternFromPattern__RowDeleting;
		}

		#region		listening the DataSet events

		private void Pattern_RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			if (e.Action == DataRowAction.Change)
			{
				BabebiDataSet.PatternRow pattern = (BabebiDataSet.PatternRow)(e.Row);

				#region		where the out-of-scope rows are return-trapped.

				if (pattern.ModeCode != MainForm.ModeCode_FromPattern)
				{
					return;
				}

				BabebiDataSet.PatternFromPatternRow patternFromPattern
					= this.dataSet.PatternFromPattern
					.FindById(pattern.Id);

				if (patternFromPattern.FromPatternRowParent.PatternId != this.mainForm.Current__Pattern.Id)
				{
					return;
				}

				#endregion	where the out-of-scope rows are return-trapped.

				DataRow guiDataRow = this.find(pattern.Id);

				if (guiDataRow != null)
				{
					/// Id => s'il a eu lieu, cela a été géré dans le 'this.find(pattern.Id)' ci-dessus.

					/// UniqueKeyString
					if (this.GetValue__PatternUniqueKeyString(guiDataRow) != pattern.UniqueKeyString)
					{
						guiDataRow[this.PatternUniqueKeyString] = pattern.UniqueKeyString;
					}
				}
			}
		}
		private void Pattern_Language__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			if (e.Action == DataRowAction.Change)
			{
				BabebiDataSet.Pattern_LanguageRow pattern_language = (BabebiDataSet.Pattern_LanguageRow)(e.Row);

				if (pattern_language.LanguageRow != this.currentLanguage)
				{
					return;
				}

				#region		where the out-of-scope rows are return-trapped.

				if (pattern_language.PatternRow.ModeCode != MainForm.ModeCode_FromPattern)
				{
					return;
				}

				BabebiDataSet.PatternFromPatternRow patternFromPattern
					= this.dataSet.PatternFromPattern
					.FindById(pattern_language.PatternId);

				if (patternFromPattern.FromPatternRowParent.PatternId != this.mainForm.Current__Pattern.Id)
				{
					return;
				}

				#endregion	where the out-of-scope rows are return-trapped.

				DataRow guiDataRow = find(pattern_language.PatternId);

				/// Meaning
				if (guiDataRow != null && this.GetValue__Pattern_LanguageMeaning(guiDataRow) != pattern_language.Meaning)
				{
					guiDataRow[this.Pattern_LanguageMeaning] = pattern_language.Meaning;
				}
			}
		}
		private void PatternFromPattern__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			BabebiDataSet.PatternFromPatternRow patternFromPattern = (BabebiDataSet.PatternFromPatternRow)(e.Row);

			if (e.Action == DataRowAction.Add)
			{
				/// CREATE

				if (this.mainForm.Current__Pattern.Id == patternFromPattern.FromPatternRowParent.PatternId)
				{
					this.addGuiDataRow(patternFromPattern);
				}
			}
			else if(e.Action == DataRowAction.Change)
			{
				DataRow guiDataRow = find(patternFromPattern.Id);

				if (guiDataRow != null)
				{
					/// aucun field à updater.
				}
			}
		}
		private void FromPattern__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			BabebiDataSet.FromPatternRow fromPattern = (BabebiDataSet.FromPatternRow)(e.Row);

			if (fromPattern.SubscriberCode != MainForm.SubscriberCode_Pattern)
			{
				return;
			}


			if(e.Action == DataRowAction.Change)
			{
				DataRow guiDataRow = find(fromPattern.SubscriberId);

				if (guiDataRow != null)
				{
					#region		still here ?

					if(fromPattern.PatternId != this.mainForm.Current__Pattern.Id)
					{
						this.Rows.Remove(guiDataRow);

						return;
					}

					#endregion	still here ?


					/// GuiHorizontalShift
					if (guiDataRow != null && this.GetValue__GuiHorizontalShift(guiDataRow) != fromPattern.GuiHorizontalShift)
					{
						guiDataRow[this.GuiHorizontalShift] = fromPattern.GuiHorizontalShift;
					}
				}
			}
		}
		private void FromPatternLetter__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}
			else if (e.Action == DataRowAction.Change || e.Action == DataRowAction.Add)
			{
				BabebiDataSet.FromPatternLetterRow fromPatternLetter = (BabebiDataSet.FromPatternLetterRow)(e.Row);

				BabebiDataSet.FromPatternRow fromPattern = fromPatternLetter.FromPatternRowParent;

				DataRow guiDataRow = Find(fromPatternLetter.FromPatternSubscriberId);

				if (guiDataRow != null)
				{
					if (fromPattern != null)		/// à cause d'un Update du Pattern Id....
					{
						/// LetterDictionaryString
						string letterDictionaryString = MainForm.Compute__LetterDictionaryString__for_Pattern(fromPattern);
						if (this.GetValue__LetterDictionaryString(guiDataRow) != letterDictionaryString)
						{
							guiDataRow[this.LetterDictionaryString] = letterDictionaryString;
						}

						/// SORTING
						int sorting = this.mainForm.Compute__Sorting(fromPattern);
						if (this.GetValue__SORTING(guiDataRow) != sorting)
						{
							guiDataRow[this.SORTING] = sorting;
						}
					}
				}
			}
		}

		private void FromPatternLetter__RowDeleting(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			BabebiDataSet.FromPatternLetterRow	fromPatternLetter = (BabebiDataSet.FromPatternLetterRow)(e.Row);

			BabebiDataSet.FromPatternRow fromPattern = fromPatternLetter.FromPatternRowParent;

			if (e.Action == DataRowAction.Delete)
			{
				DataRow guiDataRow = Find(fromPatternLetter.FromPatternSubscriberId);

				if (guiDataRow != null)
				{
					BabebiDataSet.PatternFromPatternRow patternFromPattern 
						= this.table__PatternFromPattern
						.FindById(fromPattern.SubscriberId);						
						
					/// LetterDictionaryString
					string letterDictionaryString = MainForm.Compute__LetterDictionaryString__for_Pattern(fromPattern, fromPatternLetter);
					if (this.GetValue__LetterDictionaryString(guiDataRow) != letterDictionaryString)
					{
						guiDataRow[this.LetterDictionaryString] = letterDictionaryString;
					}

					/// SORTING
					int sorting = this.mainForm.Compute__Sorting(fromPattern, fromPatternLetter);
					if (this.GetValue__SORTING(guiDataRow) != sorting)
					{
						guiDataRow[this.SORTING] = sorting;
					}
				}
			}
		}
		private void PatternFromPattern__RowDeleting(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}
			if (e.Action == DataRowAction.Delete)
			{
				BabebiDataSet.PatternFromPatternRow patternFromPattern 
					= (BabebiDataSet.PatternFromPatternRow)(e.Row);

				DataRow guiDataRow = Find(patternFromPattern.Id);

				if (guiDataRow != null)
				{
					this.Rows.Remove(guiDataRow);
				}
			}
		}

		#endregion	listening the DataSet events

		/// <returns>null if 'unmanaged state' ; false if no row ; true if at least 1 row.</returns>
		public bool? Populate()
		{
			this.Clear();

			this.AcceptChanges();

			if (this.currentLanguage == null)
			{
				return null;
			}
			if (this.mainForm.Current__Pattern == null)
			{
				return null;
			}

			bool has1RowAtleast = false;
			foreach 
			(
				BabebiDataSet.FromPatternRow fromPattern 
				in 
				this.mainForm.Current__Pattern.GetFromPatternRows()
			)
			{
				if (fromPattern.SubscriberCode == MainForm.SubscriberCode_Word)
				{
					continue;
				}

				BabebiDataSet.PatternFromPatternRow patternFromPattern 
				 = this.dataSet.PatternFromPattern
				 .FindById
				 (
					fromPattern.SubscriberId
				 );

				this.addGuiDataRow(patternFromPattern);

				if (!has1RowAtleast)
				{
					has1RowAtleast = true;
				}
			}

			return has1RowAtleast;
		}

		private DataRow addGuiDataRow(BabebiDataSet.PatternFromPatternRow patternFromPattern)
		{
			BabebiDataSet.PatternRow pattern = patternFromPattern.PatternRowParent;

			BabebiDataSet.FromPatternRow fromPattern = patternFromPattern.FromPatternRowParent;

			BabebiDataSet.Pattern_LanguageRow pattern_language
				= this.table__Pattern_Language
				.FindByPatternIdLanguageCode(pattern.Id, this.currentLanguageCode);

			string letterDictionaryString = MainForm.Compute__LetterDictionaryString__for_Pattern(patternFromPattern.FromPatternRowParent);

			int sorting = this.mainForm.Compute__Sorting(patternFromPattern.FromPatternRowParent);

			DataRow guiDataRow
				= this.Find(pattern.Id);

			if (guiDataRow == null)
			{
				guiDataRow = this.Rows.Add
				(
					pattern.Id,                       
					pattern.UniqueKeyString,          
					pattern_language.Meaning,         
					letterDictionaryString,           
					fromPattern.GuiHorizontalShift,   
					sorting
				);

				guiDataRow.AcceptChanges();
			}
			return guiDataRow;
		}

		/// <summary>
		/// Find(...) dans cette GuiTable grâce au Word Id (pour ne pas à avoir à taper : 'this.Rows.Find(wordId);'... On gagne '.Rows') !
		/// </summary>
		public DataRow Find(int wordId)
		{
			return this.Rows.Find(wordId);
		}

		/// <summary>
		/// used when the WordId has been updated.
		/// </summary>
		private DataRow find(int dataSet__WordId)
		{
			DataRow guiDataRow = this.Find(dataSet__WordId);

			int guiTable__WordId = this.mainForm.DataGridView__PatternFromPattern__of__Current__Pattern__CurrentPatternId;

			if (guiDataRow == null && guiTable__WordId != -1)
			{
				guiDataRow = this.Find(guiTable__WordId);

				if (guiDataRow != null)
				{
					guiDataRow[this.PatternId] = dataSet__WordId;

					guiDataRow.AcceptChanges();
				}

				this.mainForm.DataGridView__PatternFromPattern__of__Current__Pattern__CurrentPatternId = dataSet__WordId;
			}

			return guiDataRow;
		}
	}
	*/
	#endregion	(ancienne version)	
}
