﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data;

namespace Babebi4
{
	internal class GuiTable__WordByInsertion__of__Current__Word : GuiTable__Word
	{
		private DataColumn	Column__InsertionIndexString;
		private DataColumn	Column__LetterClusterString;

		#region		getters : GetValue__[columnName](guiDataRow)

		private string	GetValue__InsertionIndexString	(DataRow guiDataRow){return guiDataRow.Field<string	>(this.Column__InsertionIndexString);}
		private string	GetValue__LetterClusterString	(DataRow guiDataRow){return guiDataRow.Field<string	>(this.Column__LetterClusterString);}

		#endregion	getters : GetValue__[columnName](guiDataRow)

		internal GuiTable__WordByInsertion__of__Current__Word(MainForm mainform) : base(mainform, MainForm.ModeCode_ByInsertion)
		{
			#region		columns

			this.Column__InsertionIndexString		= this.Columns.Add("InsertionIndexString"	, typeof(string));
			this.Column__LetterClusterString		= this.Columns.Add("LetterClusterString"	, typeof(string));

			this.Column__InsertionIndexString	.AllowDBNull = false;
			this.Column__LetterClusterString	.AllowDBNull = false;

			this.Column__InsertionIndexString	.MaxLength = 32;
			this.Column__LetterClusterString	.MaxLength = 8;

			#endregion	columns

			this.dataSet.WordByInsertion.RowChanged		+= WordByInsertion__RowChanged;
			this.dataSet.WordByInsertion.RowDeleting	+= WordByInsertion__RowDeleting;
		}

		#region		DataSet events listening

		private void WordByInsertion__RowChanged	(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			BabebiDataSet.WordByInsertionRow wordByInsertion = (BabebiDataSet.WordByInsertionRow)(e.Row);

			if (e.Action == DataRowAction.Add)
			{
				if(!this.isParentTheCurrent(wordByInsertion))
				{
					return;
				}

				List<object> valueList = this.buildValueList(wordByInsertion);

				DataRow guiDataRow = this.addGuiDataRow(valueList);

				guiDataRow.AcceptChanges();
			}
			else if(e.Action == DataRowAction.Change)
			{
				DataRow guiDataRow	= this.Find(wordByInsertion.Id);

				if (guiDataRow != null)
				{
					if (wordByInsertion.WordRowByWordByInsertion__Word__Origin.Id != this.mainForm.Current__Word.Id)
					{
						this.Rows.Remove(guiDataRow);
					}
					else
					{
						/// InsertionIndexString
						string insertionIndexString
								= MainForm
								.Convert__InsertionIndex__into__ComboBoxSelectedItem
								(
									wordByInsertion.InsertionIndex
								);

						if (this.GetValue__InsertionIndexString(guiDataRow) != insertionIndexString)
						{
							guiDataRow[this.Column__InsertionIndexString] = insertionIndexString;
						}

						/// LetterClusterString
						if (this.GetValue__LetterClusterString(guiDataRow) != wordByInsertion.LetterClusterRow.String)
						{
							guiDataRow[this.Column__LetterClusterString] = wordByInsertion.LetterClusterRow.String;
						}
					}
				}
				else /// guiDataRow == null
				{
					if (wordByInsertion.WordRowByWordByInsertion__Word__Origin.Id != this.mainForm.Current__Word.Id)
					{
						/// rien à faire.
					}
					else
					{
						List<object> valueList = this.buildValueList(wordByInsertion);

						guiDataRow = this.addGuiDataRow(valueList);

						guiDataRow.AcceptChanges();
					}
				}
			}
		}

		private void WordByInsertion__RowDeleting	(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Delete)
			{
				BabebiDataSet.WordByInsertionRow wordByInsertion 
					= (BabebiDataSet.WordByInsertionRow)(e.Row);

				DataRow guiDataRow = Find(wordByInsertion.Id);

				if (guiDataRow != null)
				{
					this.Rows.Remove(guiDataRow);
				}
			}			
		}

		#endregion	DataSet events listening

		private List<object> buildValueList(BabebiDataSet.WordByInsertionRow wordByInsertion)
		{
			List<object> valueList = base.guiDataRow_ValueList(wordByInsertion.WordRowParentByWordByInsertion__Word);

			string	insertionIndexString	= MainForm.Convert__InsertionIndex__into__ComboBoxSelectedItem(wordByInsertion.InsertionIndex);
			string	letterClusterString		= wordByInsertion.LetterClusterRow.String;

			valueList.Add(insertionIndexString	);
			valueList.Add(letterClusterString	);

			return valueList;
		}

		private bool isParentTheCurrent(BabebiDataSet.WordByInsertionRow wordByInsertion)
		{ 
			if
			(
				wordByInsertion == null 
				|| 
				this.mainForm.Current__Word == null
				||
				wordByInsertion.WordRowByWordByInsertion__Word__Origin.Id != this.mainForm.Current__Word.Id
			)
			{
				return false;
			}
			else
			{ 
				return true;
			}
		}

		#region		virtual and abstract methods

		protected override bool isParentTheCurrent(int dataRow__Id)
		{
			BabebiDataSet.WordByInsertionRow wordByInsertion
				= this.dataSet.WordByInsertion
				.FindById(dataRow__Id);

			return this.isParentTheCurrent(wordByInsertion);
		}

		protected override List<object>[] getValueListArray()
		{
			List<List<object>> valueListList = new List<List<object>>();

			foreach 
			(
				BabebiDataSet.WordByInsertionRow wordByInsertion 
				in 
				this.mainForm.Current__Word.GetWordByInsertionRowsByWordByInsertion__Word__Origin()
			)
			{
				List<object> valueList = this.buildValueList(wordByInsertion);

				valueListList.Add(valueList);
			}

			return valueListList.ToArray();
		}

		#endregion	virtual and abstract methods
	}

	#region		(anciennne version)
	/*
	public class GuiTable__WordByInsertion__of__Current__Word : DataTable
	{
		private MainForm	 mainForm;
		private BabebiDataSet dataSet
		{
			get
			{
				return this.mainForm.DataSet;
			}
		}

		#region		shortcuts about tables

		private BabebiDataSet.WordDataTable					table__word
		{
			get { return this.dataSet.Word; }
		}
		private BabebiDataSet.Word_LanguageDataTable		table__word_language
		{
			get { return this.dataSet.Word_Language; }
		}
		private BabebiDataSet.Word_LanguageWordDataTable	table__word_languageWord
		{
			get { return this.dataSet.Word_LanguageWord; }
		}
		private BabebiDataSet.LanguageWordDataTable			table__languageWord
		{
			get { return this.dataSet.LanguageWord; }
		}

		#endregion	shortcuts about tables

		private BabebiDataSet.LanguageRow	currentLanguage
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}
		private string	currentLanguageCode
		{
			get
			{
				return this.mainForm.Current__Language.Code;
			}
		}

		public DataSet		DataSetForBindingSource;

		#region		Columns

		public DataColumn	Column__Id;
		public DataColumn	Column__UniqueKeyString;
		public DataColumn	Column__Meaning;
		public DataColumn	Column__InsertionIndexString;
		public DataColumn	Column__LetterClusterString;

		/// TODO : manque le WordType

		#endregion	Columns

		#region		getters : GetValue__[columnName](guiDataRow)

		public int		GetValue__Id(DataRow guiDataRow)						{return guiDataRow.Field<int	>(this.Column__Id);}
		public string	GetValue__UniqueKeyString(DataRow guiDataRow)			{return guiDataRow.Field<string	>(this.Column__UniqueKeyString);}
		public string	GetValue__Meaning(DataRow guiDataRow)					{return guiDataRow.Field<string	>(this.Column__Meaning);}
		public string	GetValue__InsertionIndexString(DataRow guiDataRow)		{return guiDataRow.Field<string	>(this.Column__InsertionIndexString);}
		public string	GetValue__LetterClusterString(DataRow guiDataRow)		{return guiDataRow.Field<string	>(this.Column__LetterClusterString);}

		#endregion	getters : GetValue__[columnName](guiDataRow)

		/// ctor
		public GuiTable__WordByInsertion__of__Current__Word(MainForm mainform) 
		: base("WordByInsertion__of__Current__Word")
		{
			this.mainForm = mainform;

			this.DataSetForBindingSource = new DataSet("WordByInsertion__of__Current__Word__DATASET");

			this.DataSetForBindingSource.Tables.Add(this);

			#region		columns

			this.Column__Id							= this.Columns.Add("Id"						, typeof(int));
			this.Column__UniqueKeyString			= this.Columns.Add("UniqueKeyString"		, typeof(string));
			this.Column__Meaning					= this.Columns.Add("Meaning"				, typeof(string));
			this.Column__InsertionIndexString		= this.Columns.Add("InsertionIndexString"	, typeof(string));
			this.Column__LetterClusterString		= this.Columns.Add("LetterClusterString"	, typeof(string));

			this.Column__Id						.AllowDBNull = false;
			this.Column__UniqueKeyString		.AllowDBNull = false;
			this.Column__Meaning				.AllowDBNull = false;
			this.Column__InsertionIndexString	.AllowDBNull = false;
			this.Column__LetterClusterString	.AllowDBNull = false;

			this.Column__UniqueKeyString		.MaxLength = 32;
			this.Column__Meaning				.MaxLength = 256;
			this.Column__InsertionIndexString	.MaxLength = 32;
			this.Column__LetterClusterString	.MaxLength = 8;

			this.PrimaryKey 	= new DataColumn[]{this.Column__Id};

			#endregion	columns

			this.dataSet.WordByInsertion.RowChanged	+= WordByInsertion__RowChanged;
			this.dataSet.Word.RowChanged			+= Word_RowChanged;
			this.dataSet.Word_Language.RowChanged	+= Word_Language__RowChanged; 

			this.dataSet.WordByInsertion.RowDeleting	+= WordByInsertion__RowDeleting;
			this.dataSet.Word.WordRowDeleting			+= Word__RowDeleting;
		}

		#region		DataSet events listening

		private void WordByInsertion__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			BabebiDataSet.WordByInsertionRow wordByInsertion = (BabebiDataSet.WordByInsertionRow)(e.Row);

			if (e.Action == DataRowAction.Add)
			{
				if 
				(
					wordByInsertion.WordRowByWordByInsertion__Word__Origin.Id
					==
					this.mainForm.Current__Word.Id
				)
				{
					this.addGuiDataRow(wordByInsertion);
				}
			}
			else if (e.Action == DataRowAction.Change)
			{
				DataRow guiDataRow	= this.findGuiDataRow(wordByInsertion.Id);

				if (guiDataRow != null)
				{
					#region		still here ?
					
					if(wordByInsertion.WordRowByWordByInsertion__Word__Origin.Id != this.mainForm.Current__Word.Id)
					{ 
						this.Rows.Remove(guiDataRow);

						return;
					}

					#endregion	still here ?

					string	insertionIndexString
							= MainForm
							.Convert__InsertionIndex__into__ComboBoxSelectedItem
							(
								wordByInsertion.InsertionIndex
							);
					
					if (this.GetValue__InsertionIndexString(guiDataRow) != insertionIndexString)
					{
						guiDataRow[this.Column__InsertionIndexString] = insertionIndexString;
					}

					if (this.GetValue__LetterClusterString(guiDataRow) != wordByInsertion.LetterClusterRow.String)
					{
						guiDataRow[this.Column__LetterClusterString] = wordByInsertion.LetterClusterRow.String;
					}
				}
			}
		}
		private void Word_RowChanged			(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Change)
			{
				BabebiDataSet.WordRow word = (BabebiDataSet.WordRow)(e.Row);

				#region		where the out-of-scope rows are return-trapped.

				if (word.ModeCode != MainForm.ModeCode_ByInsertion)
				{
					return;
				}

				BabebiDataSet.WordByInsertionRow wordByInsertion
					= this.dataSet.WordByInsertion
					.FindById(word.Id);

				if (wordByInsertion == null || wordByInsertion.WordRowByWordByInsertion__Word__Origin.Id != this.mainForm.Current__Word.Id)
				{
					return;
				}

				#endregion	where the out-of-scope rows are return-trapped.


				DataRow guiDataRow = this.findGuiDataRow(word.Id);

				if (guiDataRow != null)
				{
					if (this.GetValue__Id(guiDataRow) != word.Id)
					{
						guiDataRow[this.Column__Id] = word.Id;
					}

					if (this.GetValue__UniqueKeyString(guiDataRow) != word.UniqueKeyString)
					{
						guiDataRow[this.Column__UniqueKeyString] = word.UniqueKeyString;
					}
				}
			}
		}
		private void Word_Language__RowChanged	(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Change)
			{
				BabebiDataSet.Word_LanguageRow word_language = (BabebiDataSet.Word_LanguageRow)(e.Row);

				if (word_language.LanguageRow.Code != this.currentLanguageCode)
				{
					return;
				}

				#region		where the out-of-scope rows are return-trapped.

				if(word_language.WordRowParent == null || word_language.WordRowParent.ModeCode != MainForm.ModeCode_ByInsertion)
				{
					return;
				}

				BabebiDataSet.WordByInsertionRow wordByInsertion
					= this.dataSet.WordByInsertion
					.FindById(word_language.WordId);

				if (wordByInsertion.WordRowByWordByInsertion__Word__Origin.Id != this.mainForm.Current__Word.Id)
				{
					return;
				}

				#endregion	where the out-of-scope rows are return-trapped.

				DataRow guiDataRow = this.findGuiDataRow(word_language.WordId);

				if (guiDataRow != null && this.GetValue__Meaning(guiDataRow) != word_language.Meaning)
				{
					guiDataRow[this.Column__Meaning] = word_language.Meaning;
				}
			}
		}

		private void WordByInsertion__RowDeleting(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Delete)
			{
				BabebiDataSet.WordByInsertionRow wordByInsertion 
					= (BabebiDataSet.WordByInsertionRow)(e.Row);

				DataRow guiDataRow = Find(wordByInsertion.Id);

				if (guiDataRow != null)
				{
					this.Rows.Remove(guiDataRow);
				}
			}			
		}
		private void Word__RowDeleting(object sender, BabebiDataSet.WordRowChangeEvent e)
		{
			if (e.Action == DataRowAction.Delete)
			{				
				BabebiDataSet.WordRow word = e.Row;

				DataRow guiDataRow = this.Find(word.Id);

				if (guiDataRow != null)
				{
					this.Rows.Remove(guiDataRow);
				}
			}
		}

		#endregion	DataSet events listening

		public bool? Populate()
		{
			this.Clear();

			if (this.currentLanguage == null)
			{
				return null;
			}

			bool has1RowAtLeast = false;
			foreach
			(
				BabebiDataSet.WordByInsertionRow wordByInsertion
				in
				this.mainForm.Current__Word.GetWordByInsertionRowsByWordByInsertion__Word__Origin()
			)
			{
				this.addGuiDataRow(wordByInsertion);

				if (!has1RowAtLeast)
				{
					has1RowAtLeast = true;
				}
			}

			return has1RowAtLeast;
		}

		private DataRow addGuiDataRow(BabebiDataSet.WordByInsertionRow wordByInsertion)
		{
			BabebiDataSet.WordRow word = wordByInsertion.WordRowParentByWordByInsertion__Word;

			BabebiDataSet.Word_LanguageRow word_language
				=
				this.dataSet.Word_Language
				.FindByWordIdLanguageCode
				(
					word.Id,
					this.currentLanguageCode
				);

			BabebiDataSet.Word_LanguageWordRow[] allWord_LanguageWords
				= word_language.GetWord_LanguageWordRows();

			string	insertionIndexString
					= MainForm
					.Convert__InsertionIndex__into__ComboBoxSelectedItem
					(
						wordByInsertion.InsertionIndex
					);

			return this.Rows.Add
			(
				word.Id,
				word.UniqueKeyString,
				word_language.Meaning,
				insertionIndexString,
				wordByInsertion.LetterClusterRow.String
			);
		}

		public DataRow Find(int wordId)
		{
			return this.Rows.Find(wordId);
		}

		private DataRow findGuiDataRow(int dataSetWordId)
		{
			DataRow guiDataRow = this.Find(dataSetWordId);

			if (guiDataRow == null)
			{
				int guiWordId = this.mainForm.DataGridView__WordByInsertion__of__Current__Word__CurrentWordId;

				if (guiWordId != -1)
				{
					guiDataRow = this.Find(guiWordId);

					if (guiDataRow != null)
					{
						guiDataRow[this.Column__Id] = dataSetWordId;

						this.mainForm.DataGridView__WordByInsertion__of__Current__Word__CurrentWordId = dataSetWordId;
					}
				}
			}

			return guiDataRow;
		}
	}
	*/
	#endregion	(anciennne version)
}