﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data;

namespace Babebi4
{
	/// <summary>
	/// Inclus une colonne DataRow correspondant à la DataSet.Row source...
	/// </summary>

	public class GuiTable__WordConcatenating : DataTable
	{
		private MainForm		mainForm;
		private BabebiDataSet	dataSet
		{
			get
			{
				return this.mainForm.DataSet;
			}
		}

		#region		shortcuts about tables

		private BabebiDataSet.WordDataTable							table__word
		{
			get { return this.dataSet.Word; }
		}
		private BabebiDataSet.Word_LanguageDataTable				table__word_language
		{
			get { return this.dataSet.Word_Language; }
		}
		private BabebiDataSet.Word_LanguageWordDataTable			table__word_languageWord
		{
			get { return this.dataSet.Word_LanguageWord; }
		}
		private BabebiDataSet.LanguageWordDataTable					table__languageWord
		{
			get { return this.dataSet.LanguageWord; }
		}
		private BabebiDataSet.WordConcatenatedDataTable				table__wordConcatenated
		{
			get { return this.dataSet.WordConcatenated; }
		}
		private BabebiDataSet.WordConcatenatedComponentDataTable	table__wordConcatenatedComponent
		{
			get { return this.dataSet.WordConcatenatedComponent; }
		}

		#endregion	shortcuts about tables

		private BabebiDataSet.LanguageRow	currentLanguage
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}

		public DataSet		DataSetForBindingSource;

		#region		Columns

		public DataColumn	WordConcatenatedId;					/// PK
		public DataColumn	WordConcatenatedString;				/// from parent
		public DataColumn	WordConcatenated_LanguageMeaning;	//  from Word_Language
		public DataColumn	Rank;								/// native
		public DataColumn	SubStringIndex;						//	native
		public DataColumn	SubStringLength;					//	native
		public DataColumn	WordConcatenatedComponentRow;		//	hidden

		#endregion	Columns

		#region		getters : GetValue__[columnName](guiDataRow)

		public int		GetValue__WordConcatenatedId(DataRow guiDataRow)	{return guiDataRow.Field<int	>(this.WordConcatenatedId				);}
		public string	GetValue__WordString(DataRow guiDataRow)			{return guiDataRow.Field<string	>(this.WordConcatenatedString			);}
		public string	GetValue__Word_LanguageMeaning(DataRow guiDataRow)	{return guiDataRow.Field<string	>(this.WordConcatenated_LanguageMeaning	);}
		public short	GetValue__Rank(DataRow guiDataRow)					{return guiDataRow.Field<short	>(this.Rank								);}

		public short?	GetValue__SubStringIndex(DataRow guiDataRow)	
		{
			object subStringIndex = guiDataRow[this.SubStringIndex];
			if(subStringIndex == DBNull.Value)
			{
				return null;
			}
			else
			{
				return (short)(subStringIndex);
			}
		}
		public short?	GetValue__SubStringLength(DataRow guiDataRow)
		{
			object subStringLength = guiDataRow[this.SubStringLength];
			if(subStringLength == DBNull.Value)
			{
				return null;
			}
			else
			{
				return (short)(subStringLength);
			}
		}

		/// truc de ouf !
		public BabebiDataSet.WordConcatenatedComponentRow	GetValue__WordConcatenatedComponentRow(DataRow guiDataRow)
		{
			return (BabebiDataSet.WordConcatenatedComponentRow)(guiDataRow[this.WordConcatenatedComponentRow]);
		}

		#endregion	getters : GetValue__[columnName](guiDataRow)

		/// ctor
		public GuiTable__WordConcatenating(MainForm mainform) : base("WordConcatenating_")
		{
			this.mainForm = mainform;

			this.DataSetForBindingSource = new DataSet("WordConcatenating__DataSet");

			this.DataSetForBindingSource.Tables.Add(this);

			#region		columns

			this.WordConcatenatedId					= this.Columns.Add("WordConcatenatedId"					, typeof(int));
			this.WordConcatenatedString				= this.Columns.Add("WordConcatenatedString"				, typeof(string));
			this.WordConcatenated_LanguageMeaning	= this.Columns.Add("WordConcatenated_LanguageMeaning"	, typeof(string));
			this.Rank								= this.Columns.Add("Rank"								, typeof(short));
			this.SubStringIndex						= this.Columns.Add("SubStringIndex"						, typeof(short));
			this.SubStringLength					= this.Columns.Add("SubStringLength"					, typeof(short));
			this.WordConcatenatedComponentRow		= this.Columns.Add("WordConcatenatedComponent"			, typeof(BabebiDataSet.WordConcatenatedComponentRow));

			this.WordConcatenatedId					.AllowDBNull = false;
			this.WordConcatenatedString				.AllowDBNull = false;
			this.WordConcatenated_LanguageMeaning	.AllowDBNull = false;
			this.Rank								.AllowDBNull = false;
			this.SubStringIndex						.AllowDBNull = true;
			this.SubStringLength					.AllowDBNull = true;
			this.WordConcatenatedComponentRow		.AllowDBNull = false;

			this.WordConcatenatedString				.MaxLength = 32;
			this.WordConcatenated_LanguageMeaning	.MaxLength = 256;

			this.PrimaryKey 	= new DataColumn[]{this.WordConcatenatedId, this.Rank};

			#endregion	columns

			this.dataSet.WordConcatenatedComponent	.WordConcatenatedComponentRowChanged	+= WordConcatenatedComponent_WordConcatenatedComponentRowChanged;
			this.dataSet.WordConcatenatedComponent	.WordConcatenatedComponentRowDeleted	+= WordConcatenatedComponent_WordConcatenatedComponentRowDeleted;
			this.dataSet.Word						.WordRowChanged							+= Word_WordRowChanged;
			this.dataSet.Word_Language				.Word_LanguageRowChanged				+= Word_Language_Word_LanguageRowChanged;
		}

		private DataRow find(int wordId, short rank)
		{
			return this.Rows.Find(new object[] { wordId, rank });
		}
		public	DataRow Find(BabebiDataSet.WordConcatenatedComponentRow wordConcatenatedComponentRow)
		{
			foreach (DataRow guiDataRow in this.Rows)
			{
				if (this.GetValue__WordConcatenatedComponentRow(guiDataRow) == wordConcatenatedComponentRow)
				{
					return guiDataRow;
				}
			}

			return null;
		}

		#region		listening the DataSet events

		private void WordConcatenatedComponent_WordConcatenatedComponentRowChanged(object sender, BabebiDataSet.WordConcatenatedComponentRowChangeEvent e)
		{
			if (this.mainForm.DoNotTriggerCurrentChangedEvent)
			{
				return;
			}

			BabebiDataSet.WordConcatenatedComponentRow wordConcatenatedComponent = e.Row;

			if (wordConcatenatedComponent.RowState == DataRowState.Detached || wordConcatenatedComponent.WordRow.Id != this.mainForm.Current__Word.Id)
			{
				return;
			}

			if (e.Action == DataRowAction.Add)
			{
				this.addGuiDataRow(wordConcatenatedComponent);
			}
			else if(e.Action == DataRowAction.Change)
			{
				this.updateGuiDataRow(wordConcatenatedComponent);
			}
			else if(e.Action == DataRowAction.Commit)
			{
			}
			else
			{
				throw new Exception();
			}
		}

		private void WordConcatenatedComponent_WordConcatenatedComponentRowDeleted(object sender, BabebiDataSet.WordConcatenatedComponentRowChangeEvent e)
		{
			if (this.mainForm.DoNotTriggerCurrentChangedEvent)
			{
				return;
			}

			DataRow guiDataRow = this.Find(e.Row);
			if (guiDataRow == null)
			{
				return;
			}

			this.Rows.Remove(guiDataRow);
		}

		private void Word_WordRowChanged(object sender, BabebiDataSet.WordRowChangeEvent e)
		{
			if (this.mainForm.DoNotTriggerCurrentChangedEvent)
			{
				return;
			}

			if (e.Action == DataRowAction.Change)
			{
				BabebiDataSet.WordRow word = e.Row;

				foreach (DataRow guiDataRow in this.Rows)
				{
					if (this.GetValue__WordConcatenatedId(guiDataRow) == word.Id)
					{
						guiDataRow[this.WordConcatenatedString] = word.UniqueKeyString;
					}
				}
			}
		}

		private void Word_Language_Word_LanguageRowChanged(object sender, BabebiDataSet.Word_LanguageRowChangeEvent e)
		{
			if (this.mainForm.DoNotTriggerCurrentChangedEvent)
			{
				return;
			}

			if (e.Action == DataRowAction.Change)
			{
				BabebiDataSet.Word_LanguageRow word_language = e.Row;
				if (word_language.LanguageRow != this.currentLanguage)
				{
					return;
				}

				foreach (DataRow guiDataRow in this.Rows)
				{
					if (this.GetValue__WordConcatenatedId(guiDataRow) == word_language.WordId)
					{
						guiDataRow[this.WordConcatenated_LanguageMeaning] = word_language.Meaning;
					}
				}
			}
		}

		#endregion	listening the DataSet events

		public void Populate()
		{
			this.Clear();

			if (this.currentLanguage == null)
			{
				return;
			}

			foreach 
			(
				BabebiDataSet.WordConcatenatedComponentRow wordConcatenatedComponent
				in 
				this.mainForm.Current__Word.GetWordConcatenatedComponentRows()
			)
			{
				this.addGuiDataRow(wordConcatenatedComponent);
			}
		}

		private void addGuiDataRow(BabebiDataSet.WordConcatenatedComponentRow wordConcatenatedComponent)
		{
			BabebiDataSet.WordRow			word___Concatenated				= wordConcatenatedComponent.WordConcatenatedRow.WordRowParent;
			BabebiDataSet.Word_LanguageRow	word_language___Concatenated 	= (BabebiDataSet.Word_LanguageRow)(this.mainForm.DataRow__Language(word___Concatenated));
				
			this.mainForm.DoNotTriggerCurrentChangedEvent = true;

			DataRow guiDataRow = this.NewRow();

			guiDataRow[this.WordConcatenatedId					] = word___Concatenated.Id;
			guiDataRow[this.WordConcatenatedString				] = word___Concatenated.UniqueKeyString;
			guiDataRow[this.WordConcatenated_LanguageMeaning	] = word_language___Concatenated.Meaning;
			guiDataRow[this.Rank								] = wordConcatenatedComponent.Rank;

			if( ! wordConcatenatedComponent.IsSubStringIndexNull())
			{
				guiDataRow[this.SubStringIndex				] = wordConcatenatedComponent.SubStringIndex;
			}

			if( ! wordConcatenatedComponent.IsSubStringLengthNull())
			{
				guiDataRow[this.SubStringLength				] = wordConcatenatedComponent.SubStringLength;
			}

			guiDataRow[this.WordConcatenatedComponentRow	] = wordConcatenatedComponent;

			this.Rows.Add(guiDataRow);

			this.mainForm.DoNotTriggerCurrentChangedEvent = false;
		}
		private void updateGuiDataRow(BabebiDataSet.WordConcatenatedComponentRow wordConcatenatedComponent)
		{
			DataRow guiDataRow = this.Find(wordConcatenatedComponent);
			if(guiDataRow == null)
			{
				return;
			}

			BabebiDataSet.WordRow			word___Concatenated				= wordConcatenatedComponent.WordRow;
			BabebiDataSet.Word_LanguageRow	word_language___Concatenated 	= (BabebiDataSet.Word_LanguageRow)(this.mainForm.DataRow__Language(word___Concatenated));
			
			this.mainForm.DoNotTriggerCurrentChangedEvent = true;

			#region		Word

			if(this.GetValue__WordConcatenatedId(guiDataRow) != word___Concatenated.Id)
			{
				guiDataRow[this.WordConcatenatedId				] = word___Concatenated.Id;
				guiDataRow[this.WordConcatenatedString			] = word___Concatenated.UniqueKeyString;
				guiDataRow[this.WordConcatenated_LanguageMeaning] = word_language___Concatenated.Meaning;
			}

			#endregion	Word
			#region		Rank

			short currentRank = this.GetValue__Rank(guiDataRow);

			if(wordConcatenatedComponent.Rank != currentRank)
			{
				guiDataRow[this.Rank] = currentRank;
			}

			#endregion	Rank
			#region		SubStringIndex

			short? currentGuiSubStringIndex = this.GetValue__SubStringIndex(guiDataRow);

			if(wordConcatenatedComponent.IsSubStringIndexNull())
			{
				if(currentGuiSubStringIndex.HasValue)
				{
					guiDataRow[this.SubStringIndex] = DBNull.Value;
				}
			}
			else
			{
				if( ! currentGuiSubStringIndex.HasValue)
				{
					guiDataRow[this.SubStringIndex] = wordConcatenatedComponent.SubStringIndex;
				}
				else
				{
					if(currentGuiSubStringIndex != wordConcatenatedComponent.SubStringIndex)
					{
						guiDataRow[this.SubStringIndex] = wordConcatenatedComponent.SubStringIndex;
					}
				}
			}

			#endregion	SubStringIndex
			#region		SubStringLength

			short? currentGuiSubStringLength = this.GetValue__SubStringLength(guiDataRow);

			if(wordConcatenatedComponent.IsSubStringLengthNull())
			{
				if(currentGuiSubStringLength.HasValue)
				{
					guiDataRow[this.SubStringLength] = DBNull.Value;
				}
			}
			else
			{
				if( ! currentGuiSubStringLength.HasValue)
				{
					guiDataRow[this.SubStringLength] = wordConcatenatedComponent.SubStringLength;
				}
				else
				{
					if(currentGuiSubStringLength != wordConcatenatedComponent.SubStringLength)
					{
						guiDataRow[this.SubStringLength] = wordConcatenatedComponent.SubStringLength;
					}
				}
			}

			#endregion	SubStringLength

			this.mainForm.DoNotTriggerCurrentChangedEvent = false;
		}
	}
}
