﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data;

namespace Babebi4
{

	internal class GuiTable__WordDerivated__of__WordDerivating : GuiTable__Word
	{
		internal DataColumn	DerivatedWordType_LanguageName;
		internal DataColumn	Derivating_LanguageName;
		internal DataColumn	DerivatingString;

		internal string	GetValue__DerivatedWordType_LanguageName(DataRow guiDataRow){return guiDataRow.Field<string	>(this.DerivatedWordType_LanguageName	);}
		internal string	GetValue__Derivating_LanguageName(DataRow guiDataRow)		{return guiDataRow.Field<string	>(this.Derivating_LanguageName			);}
		internal string	GetValue__DerivatingString(DataRow guiDataRow)				{return guiDataRow.Field<string	>(this.DerivatingString					);}

		internal GuiTable__WordDerivated__of__WordDerivating(MainForm mainform) : base(mainform, MainForm.ModeCode_Derivated)
		{
			this.DerivatedWordType_LanguageName	= this.Columns.Add("DerivatedWordType_LanguageName"	, typeof(string));
			this.Derivating_LanguageName		= this.Columns.Add("Derivating_LanguageName"		, typeof(string));
			this.DerivatingString				= this.Columns.Add("DerivatingString"				, typeof(string));

			this.DerivatedWordType_LanguageName	.AllowDBNull = false;
			this.Derivating_LanguageName		.AllowDBNull = false;
			this.DerivatingString				.AllowDBNull = false;

			this.DerivatedWordType_LanguageName	.MaxLength = 256;
			this.Derivating_LanguageName		.MaxLength = 256;
			this.DerivatingString				.MaxLength = 8;

			this.dataSet.WordDerivated.RowChanged	+= WordDerivated__RowChanged;
			this.dataSet.WordDerivated.RowDeleting	+= WordDerivated__RowDeleting;

			this.dataSet.Derivating.RowChanged			+= Derivating__RowChanged;
			this.dataSet.Derivating_Language.RowChanged	+= Derivating_Language__RowChanged;
		}

		#region		listening to the DataSet events

		private void WordDerivated__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			BabebiDataSet.WordDerivatedRow wordDerivated = (BabebiDataSet.WordDerivatedRow)(e.Row);

			if (e.Action == DataRowAction.Add)
			{
				if(!this.isParentTheCurrent(wordDerivated))
				{
					return; /// mais on ne voit pas comment cela pourrait arriver.
				}

				List<object> valueList = this.buildValueList(wordDerivated);

				DataRow guiDataRow = this.addGuiDataRow(valueList);

				guiDataRow.AcceptChanges();
			}
			else if(e.Action == DataRowAction.Change)
			{
				DataRow guiDataRow = this.Find(wordDerivated.Id);

				if (guiDataRow != null)
				{
					#region		still here ?
					
					if(wordDerivated.WordDerivatingId != this.mainForm.Current__WordDerivating.WordId)
					{ 
						this.Rows.Remove(guiDataRow);

						return;
					}

					#endregion	still here ?

					this.getStateRows
					(
						wordDerivated,
					out BabebiDataSet.DerivatedWordType_LanguageRow	derivatedWordType_language,
					out	BabebiDataSet.DerivatingRow					derivating,
					out BabebiDataSet.Derivating_LanguageRow		derivating_language
					);

					string derivatedWordType_LanguageName = this.GetValue__DerivatedWordType_LanguageName(guiDataRow);
					if (derivatedWordType_LanguageName != derivatedWordType_language.Name)
					{
						guiDataRow[this.DerivatedWordType_LanguageName] = derivatedWordType_language.Name;
					}

					string derivating_LanguageName = this.GetValue__Derivating_LanguageName(guiDataRow);
					if (derivating_LanguageName != derivating_language.Name)
					{
						guiDataRow[this.Derivating_LanguageName] = derivating_language.Name;
					}

					string derivatingString = this.GetValue__DerivatingString(guiDataRow);
					if (derivatingString != wordDerivated.DerivatingRowParent.LetterClusterString)
					{
						guiDataRow[this.DerivatingString] = wordDerivated.DerivatingRowParent.LetterClusterString;
					}
				}
			}
		}
		private void WordDerivated__RowDeleting(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Delete)
			{
				BabebiDataSet.WordDerivatedRow wordDerivated = (BabebiDataSet.WordDerivatedRow)(e.Row);

				DataRow guiDataRow = Find(wordDerivated.Id);

				if (guiDataRow != null)
				{
					this.Rows.Remove(guiDataRow);
				}
			}
		}

		private void Derivating__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			BabebiDataSet.DerivatingRow derivating = (BabebiDataSet.DerivatingRow)(e.Row);

			if (e.Action == DataRowAction.Change)
			{
				foreach (DataRow guiDataRow in this.Rows)
				{ 
					int word__Id = this.GetValue__Id(guiDataRow);

					BabebiDataSet.WordDerivatedRow wordDerivated = this.dataSet.WordDerivated.FindById(word__Id);

					if (wordDerivated.DerivatingId == derivating.Id)
					{
						string currentDerivatingString = this.GetValue__DerivatingString(guiDataRow);
						if (currentDerivatingString != derivating.LetterClusterString)
						{
							guiDataRow.SetField<string>(this.DerivatingString, derivating.LetterClusterString);
						}
					}
				}
			}
		}
		private void Derivating_Language__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			BabebiDataSet.Derivating_LanguageRow derivating_Language = (BabebiDataSet.Derivating_LanguageRow)(e.Row);

			if (derivating_Language.LanguageCode != this.currentLanguageCode)
			{
				return;
			}

			if (e.Action == DataRowAction.Change)
			{
				foreach (DataRow guiDataRow in this.Rows)
				{ 
					int word__Id = this.GetValue__Id(guiDataRow);

					BabebiDataSet.WordDerivatedRow wordDerivated = this.dataSet.WordDerivated.FindById(word__Id);

					if (wordDerivated.DerivatingId == derivating_Language.DerivatingId)
					{
						string currentDerivating_LanguageName = this.GetValue__Derivating_LanguageName(guiDataRow);
						if (currentDerivating_LanguageName != derivating_Language.Name)
						{
							guiDataRow.SetField<string>(this.Derivating_LanguageName, derivating_Language.Name);
						}
					}
				}
			}
		}

		#endregion		listening to the DataSet events


		private void getStateRows
		(
			BabebiDataSet.WordDerivatedRow wordDerivated,
		out BabebiDataSet.DerivatedWordType_LanguageRow	derivatedWordType_language,
		out	BabebiDataSet.DerivatingRow	derivating,
		out BabebiDataSet.Derivating_LanguageRow derivating_language
		)
		{ 
			derivatedWordType_language
				= this.dataSet.DerivatedWordType_Language
				.FindByDerivatedWordTypeIdLanguageCode
				(
					wordDerivated.DerivatedWordTypeId, 
					this.currentLanguageCode
				);

			derivating = wordDerivated.DerivatingRowParent;

			derivating_language
				=
				this.dataSet.Derivating_Language
				.FindByDerivatingIdLanguageCode
				(
					derivating.Id, 
					this.currentLanguageCode
				);
		}

		private List<object> buildValueList(BabebiDataSet.WordDerivatedRow wordDerivated)
		{
			List<object> valueList = base.guiDataRow_ValueList(wordDerivated.WordRowParent);

			this.getStateRows
			(
				wordDerivated,
			out BabebiDataSet.DerivatedWordType_LanguageRow	derivatedWordType_language,
			out	BabebiDataSet.DerivatingRow					derivating,
			out BabebiDataSet.Derivating_LanguageRow		derivating_language
			);

			valueList.Add(derivatedWordType_language.Name	);	/// DerivatedWordType_LanguageName
			valueList.Add(derivating_language.Name			);	/// Derivating_LanguageName
			valueList.Add(derivating.LetterClusterString	);	/// DerivatingString

			return valueList;
		}

		private bool isParentTheCurrent(BabebiDataSet.WordDerivatedRow wordDerivated)
		{ 
			if
			(
				wordDerivated == null 
				|| 
				this.mainForm.Current__WordDerivating == null
				||
				wordDerivated.WordDerivatingId != this.mainForm.Current__WordDerivating.WordId
			)
			{
				return false;
			}
			else
			{ 
				return true;
			}
		}

		#region		virtual and abstract methods

		protected override bool isParentTheCurrent(int dataRow__Id)
		{
			BabebiDataSet.WordDerivatedRow wordDerivated
				= this.dataSet.WordDerivated
				.FindById(dataRow__Id);

			return this.isParentTheCurrent(wordDerivated);
		}

		protected override List<object>[] getValueListArray()
		{
			BabebiDataSet.WordRow word__Parent = this.mainForm.Current__Word;

			if (!word__Parent.HasDerivating)
			{
				return new List<object>[0];
			}
			else
			{ 
				BabebiDataSet.WordDerivatingRow wordDerivating__Parent 
					= this.dataSet.WordDerivating
					.FindByWordId(word__Parent.Id);
				
				List<List<object>> valueListList = new List<List<object>>();

				foreach (BabebiDataSet.WordDerivatedRow wordDerivated in wordDerivating__Parent.GetWordDerivatedRows())
				{
					List<object> valueList = this.buildValueList(wordDerivated);

					valueListList.Add(valueList);
				}

				return valueListList.ToArray();
			}
		}

		#endregion	virtual and abstract methods
	}

	#region	(ancienne version non mutualisée)
	/*
	/// <summary>
	/// Comme on veut afficher des colonnes de type "#_Language", la valeur de ces dernières
	/// ne peut pas être calculée par des Expressions (puisque le language est un choix de 
	/// l'instance de application et pas du dataset qui est commun à tout les users. Ainsi WDed
	/// ne peut pas être la table de fondement de la DGV : il faut créer / gérer une table ad 
	/// hoc : GuiTable__WordDerivated__of__WordDerivating.
	/// </summary>
	public class GuiTable__WordDerivated__of__WordDerivating : DataTable
	{
		private MainForm mainForm;

		private BabebiDataSet dataSet
		{
			get
			{
				return this.mainForm.DataSet;
			}
		}

		#region		shortcuts about tables

		private BabebiDataSet.WordDataTable					table__Word
		{
			get { return this.dataSet.Word; }
		}
		private BabebiDataSet.Word_LanguageDataTable		table__Word_Language
		{
			get { return this.dataSet.Word_Language; }
		}
		private BabebiDataSet.Word_LanguageWordDataTable	table__Word_LanguageWord
		{
			get { return this.dataSet.Word_LanguageWord; }
		}
		private BabebiDataSet.LanguageWordDataTable			table__LanguageWord
		{
			get { return this.dataSet.LanguageWord; }
		}
		private BabebiDataSet.WordDerivatedDataTable		table__WordDerivated
		{
			get { return this.dataSet.WordDerivated; }
		}
		private BabebiDataSet.WordType_LanguageDataTable		table__WordType_Language
		{
			get { return this.dataSet.WordType_Language; }
		}
		private BabebiDataSet.DerivatedWordType_LanguageDataTable		table__DerivatedWordType_Language
		{
			get { return this.dataSet.DerivatedWordType_Language; }
		}
		private BabebiDataSet.Derivating_LanguageDataTable		table__Derivating_Language
		{
			get { return this.dataSet.Derivating_Language; }
		}

		#endregion	shortcuts about tables

		private BabebiDataSet.LanguageRow	currentLanguage
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}
		private string						currentLanguageCode
		{ 
			get
			{
				return this.mainForm.Current__Language.Code;
			}
		}

		/// <summary>
		/// public car la MainForm y accède lors du loading pour le binder à la DGV.
		/// </summary>
		public DataSet DataSet__for__the__BindingSource;

		#region		Columns

		public DataColumn	WordId;
		public DataColumn	WordString;
		public DataColumn	Word_LanguageMeaning;
		public DataColumn	WordType_LanguageName;
		public DataColumn	DerivatedWordType_LanguageName;
		public DataColumn	Derivating_LanguageName;
		public DataColumn	DerivatingString;

		#endregion	Columns

		#region		getters : GetValue__[columnName](guiDataRow)

		public int		GetValue__WordId(DataRow guiDataRow)						{return guiDataRow.Field<int	>(this.WordId							);}
		public string	GetValue__WordString(DataRow guiDataRow)					{return guiDataRow.Field<string	>(this.WordString						);}
		public string	GetValue__Word_LanguageMeaning(DataRow guiDataRow)			{return guiDataRow.Field<string	>(this.Word_LanguageMeaning				);}
		public string	GetValue__WordType_LanguageName(DataRow guiDataRow)			{return guiDataRow.Field<string	>(this.WordType_LanguageName			);}
		public string	GetValue__DerivatedWordType_LanguageName(DataRow guiDataRow){return guiDataRow.Field<string	>(this.DerivatedWordType_LanguageName	);}
		public string	GetValue__Derivating_LanguageName(DataRow guiDataRow)		{return guiDataRow.Field<string	>(this.Derivating_LanguageName			);}
		public string	GetValue__DerivatingString(DataRow guiDataRow)				{return guiDataRow.Field<string	>(this.DerivatingString					);}

		#endregion	getters : GetValue__[columnName](guiDataRow)

		/// ctor
		public GuiTable__WordDerivated__of__WordDerivating(MainForm mainform) 
		: base("WordDerivated__of__WordDerivating_")	/// on rajouter un '_' à la fin pour bien se souvenir que ce n'est pas la table WordDerivated du DS.
		{
			this.mainForm = mainform;

			#region		dataSet (used to have a BindingSource in the MainFrom) + Columns 

			this.DataSet__for__the__BindingSource = new DataSet("WordDerivated__of__WordDerivating__DataSet");

			this.DataSet__for__the__BindingSource.Tables.Add(this);

			#region		columns

			this.WordId							= this.Columns.Add("WordId"							, typeof(int));
			this.WordString						= this.Columns.Add("WordString"						, typeof(string));
			this.Word_LanguageMeaning			= this.Columns.Add("Word_LanguageMeaning"			, typeof(string));
			this.WordType_LanguageName			= this.Columns.Add("WordType_LanguageName"			, typeof(string));
			this.DerivatedWordType_LanguageName	= this.Columns.Add("DerivatedWordType_LanguageName"	, typeof(string));
			this.Derivating_LanguageName		= this.Columns.Add("Derivating_LanguageName"		, typeof(string));
			this.DerivatingString				= this.Columns.Add("DerivatingString"				, typeof(string));

			this.WordId							.AllowDBNull = false;
			this.WordString						.AllowDBNull = false;
			this.Word_LanguageMeaning			.AllowDBNull = false;
			this.WordType_LanguageName			.AllowDBNull = false;
			this.DerivatedWordType_LanguageName	.AllowDBNull = false;
			this.Derivating_LanguageName		.AllowDBNull = false;
			this.DerivatingString				.AllowDBNull = false;

			this.WordString						.MaxLength = 32;
			this.Word_LanguageMeaning			.MaxLength = 256;
			this.WordType_LanguageName			.MaxLength = 256;
			this.DerivatedWordType_LanguageName	.MaxLength = 256;
			this.Derivating_LanguageName		.MaxLength = 256;
			this.DerivatingString				.MaxLength = 8;

			this.PrimaryKey 	= new DataColumn[]{this.WordId};

			#endregion	columns

			#endregion	dataSet (used to have a BindingSource in the MainFrom) + Columns 
			#region		subscribe to DataSet events

			this.dataSet.WordDerivated.RowChanged	+= WordDerivated__RowChanged;
			this.dataSet.Word.RowChanged			+= Word_RowChanged;
			this.dataSet.Word_Language.RowChanged	+= Word_Language__RowChanged;

			this.dataSet.WordDerivated.RowDeleting	+= WordDerivated_RowDeleting;
			this.dataSet.Word.WordRowDeleting		+= Word__WordRowDeleting;

			#endregion	subscribe to DataSet events
		}

		#region		listening the DataSet events

		private void WordDerivated__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			BabebiDataSet.WordDerivatedRow wordDerivated = (BabebiDataSet.WordDerivatedRow)(e.Row);

			if (e.Action == DataRowAction.Add)
			{
				if (wordDerivated.WordDerivatingRowParent != this.mainForm.Current__WordDerivating)
				{
					return; /// mais on ne voit pas comment cela pourrait arriver.
				}

				DataRow guiDataRow = this.addGuiDataRow(wordDerivated);

				guiDataRow.AcceptChanges();
			}
			else if(e.Action == DataRowAction.Change)
			{
				DataRow guiDataRow = findGuiDataRow(wordDerivated, this.table__WordDerivated.IdColumn);

				if (guiDataRow != null)
				{
					#region		still here ?
					
					if(wordDerivated.WordDerivatingId != this.mainForm.Current__WordDerivating.WordId)
					{ 
						this.Rows.Remove(guiDataRow);

						return;
					}

					#endregion	still here ?

					BabebiDataSet.DerivatedWordType_LanguageRow derivatedWordType_language
						=
						(BabebiDataSet.DerivatedWordType_LanguageRow)
						(this.mainForm.DataRow__Language(wordDerivated.DerivatingRowParent.DerivatingWordType_DerivatedWordTypeRowParent.DerivatedWordTypeRow));

					if (this.GetValue__DerivatedWordType_LanguageName(guiDataRow) != derivatedWordType_language.Name)
					{
						guiDataRow[this.DerivatedWordType_LanguageName] = derivatedWordType_language.Name;
					}

					BabebiDataSet.Derivating_LanguageRow derivating_language
						=
						(BabebiDataSet.Derivating_LanguageRow)
						(this.mainForm.DataRow__Language(wordDerivated.DerivatingRowParent));

					if (this.GetValue__Derivating_LanguageName(guiDataRow) != derivating_language.Name)
					{
						guiDataRow[this.Derivating_LanguageName] = derivating_language.Name;
					}

					if (this.GetValue__DerivatingString(guiDataRow) != wordDerivated.DerivatingRowParent.LetterClusterString)
					{
						guiDataRow[this.DerivatingString] = wordDerivated.DerivatingRowParent.LetterClusterString;
					}
				}
			}
		}
		private void Word_RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			if (e.Action == DataRowAction.Change)
			{
				BabebiDataSet.WordRow word = (BabebiDataSet.WordRow)(e.Row);

				#region		where the out-of-scope rows are return-trapped.

				if (word.ModeCode != MainForm.ModeCode_Derivated)
				{
					return;
				}

				BabebiDataSet.WordDerivatedRow wordDerivated 
					= this.dataSet.WordDerivated
					.FindById(word.Id);

				if (this.mainForm.Current__WordDerivating == null || wordDerivated.WordDerivatingId != this.mainForm.Current__WordDerivating.WordId)
				{
					return;
				}

				#endregion	where the out-of-scope rows are return-trapped.

				DataRow guiDataRow = findGuiDataRow(word, this.table__Word.IdColumn);

				if (guiDataRow != null)
				{
					if (this.GetValue__WordId(guiDataRow) != word.Id)
					{
						guiDataRow[this.WordId] = word.Id;

					/// FaisPasChier	this.mainForm.DataGridView__WordDerivated__of__WordDerivating__CurrentWordId = word.Id;
					}

					if (this.GetValue__WordString(guiDataRow) != word.UniqueKeyString)
					{
						guiDataRow[this.WordString] = word.UniqueKeyString;
					}

					BabebiDataSet.WordType_LanguageRow wordType_language
						=
						(BabebiDataSet.WordType_LanguageRow)
						(this.mainForm.DataRow__Language(word.WordTypeRow));

					if (this.GetValue__WordType_LanguageName(guiDataRow) != wordType_language.Name)
					{
						guiDataRow[this.WordType_LanguageName] = wordType_language.Name;
					}
				}
			}
		}
		private void Word_Language__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			if (e.Action == DataRowAction.Change)
			{
				BabebiDataSet.Word_LanguageRow word_language = (BabebiDataSet.Word_LanguageRow)(e.Row);

				if (word_language.LanguageRow != this.currentLanguage)
				{
					return;
				}

				#region		where the out-of-scope rows are return-trapped.

				if (word_language.WordRowParent == null || word_language.WordRowParent.ModeCode != MainForm.ModeCode_Derivated)
				{
					return;
				}

				BabebiDataSet.WordDerivatedRow wordDerivated 
					= this.dataSet.WordDerivated
					.FindById(word_language.WordId);

				if (wordDerivated.WordDerivatingId != this.mainForm.Current__WordDerivating.WordId)
				{
					return;
				}

				#endregion	where the out-of-scope rows are return-trapped.

				DataRow guiDataRow = findGuiDataRow(word_language, this.table__Word_Language.WordIdColumn);

				if (guiDataRow != null && this.GetValue__Word_LanguageMeaning(guiDataRow) != word_language.Meaning)
				{
					guiDataRow[this.Word_LanguageMeaning] = word_language.Meaning;
				}
			}
		}

		private void WordDerivated_RowDeleting(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			if (e.Action == DataRowAction.Delete)
			{
				BabebiDataSet.WordDerivatedRow wordDerivated = (BabebiDataSet.WordDerivatedRow)(e.Row);

				DataRow guiDataRow = Find(wordDerivated.Id);

				if (guiDataRow != null)
				{
					this.Rows.Remove(guiDataRow);
				}
			}			
		}

		private void Word__WordRowDeleting(object sender, BabebiDataSet.WordRowChangeEvent e)
		{
			if (e.Action == DataRowAction.Delete)
			{				
				BabebiDataSet.WordRow word = e.Row;

				DataRow guiDataRow = this.Find(word.Id);

				if (guiDataRow != null)
				{
					this.Rows.Remove(guiDataRow);
				}
			}
		}

		#endregion	listening the DataSet events

		/// <returns>null if 'unmanaged state' ; false if no row ; true if at least 1 row.</returns>
		public bool? Populate()
		{
			this.Clear();

			this.AcceptChanges();

			if (this.currentLanguage == null)
			{
				return null;
			}
			if (this.mainForm.Current__WordDerivating == null)
			{
				return null;
			}

			bool has1RowAtleast = false;
			foreach 
			(
				BabebiDataSet.WordDerivatedRow wordDerivated 
				in 
				this.mainForm.Current__WordDerivating.GetWordDerivatedRows()
			)
			{
				this.addGuiDataRow(wordDerivated);

				if (!has1RowAtleast)
				{
					has1RowAtleast = true;
				}
			}

			if (has1RowAtleast)
			{ 
				this.AcceptChanges();
			}

			return has1RowAtleast;
		}

		private DataRow addGuiDataRow(BabebiDataSet.WordDerivatedRow wordDerivated)
		{
			BabebiDataSet.WordRow word = wordDerivated.WordRowParent;

			BabebiDataSet.Word_LanguageRow word_language 
				= this.table__Word_Language.FindByWordIdLanguageCode(word.Id, this.currentLanguageCode);

			BabebiDataSet.Word_LanguageWordRow[] childWord_LanguageWords 
				= word_language.GetWord_LanguageWordRows();

			BabebiDataSet.LanguageWordRow firstLanguageWord;
			if (childWord_LanguageWords.Length != 0)
			{
				firstLanguageWord = childWord_LanguageWords[0].LanguageWordRowParent;
			}
			else
			{
				firstLanguageWord = null;
			} 
				
			BabebiDataSet.WordType_LanguageRow wordType_language
				= word_language.WordType_LanguageRowParent;

			BabebiDataSet.DerivatedWordType_LanguageRow	derivatedWordType_language
				= this.table__DerivatedWordType_Language
				.FindByDerivatedWordTypeIdLanguageCode
				(
					wordDerivated.DerivatedWordTypeId, 
					this.currentLanguageCode
				);
	
			BabebiDataSet.DerivatingRow	derivating = wordDerivated.DerivatingRowParent;

			BabebiDataSet.Derivating_LanguageRow derivating_language
				=
				this.table__Derivating_Language
				.FindByDerivatingIdLanguageCode
				(
					derivating.Id, 
					this.currentLanguageCode
				);

			return this.Rows.Add
			(
				word.Id,						
				word.UniqueKeyString,			
				word_language.Meaning,			
				wordType_language.Name,			
				derivatedWordType_language.Name,
				derivating_language.Name,		
				derivating.LetterClusterString	
			);
		}

		/// <summary>
		/// Find(...) dans cette GuiTable grâce au Word Id (pour ne pas à avoir à taper : 'this.Rows.Find(wordId);'... On gagne '.Rows').
		/// </summary>
		public DataRow Find(int wordId)
		{
			return this.Rows.Find(wordId);
		}

		private DataRow findGuiDataRow(DataRow typedDataRow, DataColumn wordIdDataColumn)
		{
			DataRow guiDataRow;

			int dataSetWordId = (int)typedDataRow[wordIdDataColumn];

			guiDataRow = this.Find(dataSetWordId);

			if (guiDataRow == null)
			{
				/// FaisPasChier int guiWordId = this.mainForm.DataGridView__WordDerivated__of__WordDerivating__CurrentWordId;

				/// FaisPasChier guiDataRow = this.Find(guiWordId);
			}

			return guiDataRow;
		}
	}
	*/
	#endregion	(ancienne version non mutualisée)
}
