﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Data;

namespace Babebi4
{
	internal class GuiTable__WordFromPattern__of__Current__Pattern : GuiTable__Word
	{
		private DataColumn	LetterDictionaryString;
		private DataColumn	GuiHorizontalShift;
		private DataColumn	SORTING;

		public string	GetValue__LetterDictionaryString	(DataRow guiDataRow){return guiDataRow.Field<string	>(this.LetterDictionaryString	);}
		public short	GetValue__GuiHorizontalShift		(DataRow guiDataRow){return guiDataRow.Field<short	>(this.GuiHorizontalShift		);}
		public int		GetValue__SORTING					(DataRow guiDataRow){return guiDataRow.Field<int	>(this.SORTING					);}

		internal GuiTable__WordFromPattern__of__Current__Pattern(MainForm mainform) : base(mainform, MainForm.ModeCode_FromPattern)
		{
			#region		columns

			this.LetterDictionaryString	= this.Columns.Add("LetterDictionaryString"	, typeof(string	));
			this.GuiHorizontalShift		= this.Columns.Add("GuiHorizontalShift"		, typeof(short	));
			this.SORTING				= this.Columns.Add("SORTING"				, typeof(int	));

			this.LetterDictionaryString	.AllowDBNull = false;
			this.GuiHorizontalShift		.AllowDBNull = false;
			this.SORTING				.AllowDBNull = false;

			this.LetterDictionaryString	.MaxLength = 256;

			#endregion	columns

			this.dataSet.WordFromPattern.RowChanged		+= WordFromPattern__RowChanged;
			this.dataSet.FromPattern.RowChanged			+= FromPattern__RowChanged;
			this.dataSet.FromPatternLetter.RowChanged	+= FromPatternLetter__RowChanged;

			this.dataSet.FromPatternLetter.RowDeleting	+= FromPatternLetter__RowDeleting;
			this.dataSet.WordFromPattern.RowDeleting	+= WordFromPattern__RowDeleting;
		}

		#region		listening to the DataSet events

		private void WordFromPattern__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			BabebiDataSet.WordFromPatternRow wordFromPattern = (BabebiDataSet.WordFromPatternRow)(e.Row);

			if (e.Action == DataRowAction.Add)
			{
				if(!this.isParentTheCurrent(wordFromPattern))
				{
					return;
				}

				List<object> valueList = this.buildValueList(wordFromPattern);

				DataRow guiDataRow = this.addGuiDataRow(valueList);

				guiDataRow.AcceptChanges();
			}
			else if(e.Action == DataRowAction.Change)
			{
				/// rien à faire ici car WordFromPattern ne porte aucune information
				/// à part Word.Id MAIS ce n'est pas ici que cela est géré.
			}
		}
		private void FromPattern__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			if (this.mainForm.Current__Pattern == null)
			{ 
				return;
			}

			BabebiDataSet.FromPatternRow fromPattern = (BabebiDataSet.FromPatternRow)(e.Row);

			if (fromPattern.SubscriberCode != MainForm.SubscriberCode_Word)
			{
				return;
			}

			if(e.Action == DataRowAction.Change)
			{

				DataRow guiDataRow = Find(fromPattern.SubscriberId);

				if (guiDataRow != null)
				{
					if (fromPattern.PatternId != this.mainForm.Current__Pattern.Id)
					{
						this.Rows.Remove(guiDataRow);

						return;
					}
					else
					{
						/// GuiHorizontalShift
						if (guiDataRow != null && this.GetValue__GuiHorizontalShift(guiDataRow) != fromPattern.GuiHorizontalShift)
						{
							guiDataRow[this.GuiHorizontalShift] = fromPattern.GuiHorizontalShift;
						}
					}
				}
				else
				{
					if (fromPattern.PatternId == this.mainForm.Current__Pattern.Id)
					{
						BabebiDataSet.WordFromPatternRow wordFromPattern
							= this.dataSet.WordFromPattern
							.FindById
							(
								fromPattern.SubscriberId
							);


						List<object> valueList = this.buildValueList(wordFromPattern);

						guiDataRow = this.addGuiDataRow(valueList);

						guiDataRow.AcceptChanges();
					}
					else
					{
						/// pas de guiRow et il ne doit pas y en avoir.
					}
				}
			}
		}
		private void FromPatternLetter__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			if (e.Action == DataRowAction.Change || e.Action == DataRowAction.Add)
			{
				BabebiDataSet.FromPatternLetterRow fromPatternLetter = (BabebiDataSet.FromPatternLetterRow)(e.Row);

				BabebiDataSet.FromPatternRow fromPattern = fromPatternLetter.FromPatternRowParent;

				DataRow guiDataRow = this.Find(fromPatternLetter.FromPatternSubscriberId);

				if (guiDataRow != null)
				{
					/// LetterDictionaryString

					if (fromPattern != null)		/// à cause d'un Update du Word Id....
					{
						/// LetterDictionaryString
						string letterDictionaryString = MainForm.Compute__LetterDictionaryString__for_Word(fromPattern);
						if (this.GetValue__LetterDictionaryString(guiDataRow) != letterDictionaryString)
						{
							guiDataRow[this.LetterDictionaryString] = letterDictionaryString;
						}

						/// SORTING
						int sorting = this.mainForm.Compute__Sorting(fromPattern);
						if (this.GetValue__SORTING(guiDataRow) != sorting)
						{
							guiDataRow[this.SORTING] = sorting;
						}
					}
				}
			}
		}

		private void FromPatternLetter__RowDeleting(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			BabebiDataSet.FromPatternLetterRow	fromPatternLetter = (BabebiDataSet.FromPatternLetterRow)(e.Row);

			BabebiDataSet.FromPatternRow		fromPattern = fromPatternLetter.FromPatternRowParent;

			if (e.Action == DataRowAction.Delete)
			{
				DataRow guiDataRow = Find(fromPatternLetter.FromPatternSubscriberId);

				if (guiDataRow != null)
				{					
					/// LetterDictionaryString
					string letterDictionaryString = MainForm.Compute__LetterDictionaryString__for_Word(fromPattern, fromPatternLetter);
					if (this.GetValue__LetterDictionaryString(guiDataRow) != letterDictionaryString)
					{
						guiDataRow[this.LetterDictionaryString] = letterDictionaryString;
					}

					/// SORTING
					int sorting = this.mainForm.Compute__Sorting(fromPattern, fromPatternLetter);
					if (this.GetValue__SORTING(guiDataRow) != sorting)
					{
						guiDataRow[this.SORTING] = sorting;
					}
				}
			}
		}
		private void WordFromPattern__RowDeleting(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			if (e.Action == DataRowAction.Delete)
			{
				BabebiDataSet.WordFromPatternRow wordFromPattern = (BabebiDataSet.WordFromPatternRow)(e.Row);

				DataRow guiDataRow = Find(wordFromPattern.Id);

				if (guiDataRow != null)
				{
					this.Rows.Remove(guiDataRow);
				}
			}
		}

		#endregion	listening the DataSet events

		private List<object> buildValueList(BabebiDataSet.WordFromPatternRow wordFromPattern)
		{
			List<object> valueList = base.guiDataRow_ValueList(wordFromPattern.WordRowParent);

			string	letterDictionaryString	= MainForm.Compute__LetterDictionaryString__for_Word(wordFromPattern.FromPatternRowParent);
			short	guiHorizontalShift		= wordFromPattern.FromPatternRowParent.GuiHorizontalShift;
			int		sorting					= this.mainForm.Compute__Sorting(wordFromPattern.FromPatternRowParent);

			valueList.Add(letterDictionaryString	);	/// LetterDictionaryString	
			valueList.Add(guiHorizontalShift		);	/// GuiHorizontalShift		
			valueList.Add(sorting					);	/// SORTING				

			return valueList;
		}

		private bool isParentTheCurrent(BabebiDataSet.WordFromPatternRow wordFromPattern)
		{ 
			if
			(
				wordFromPattern == null 
				|| 
				this.mainForm.Current__Pattern == null
				||
				wordFromPattern.FromPatternRowParent.PatternId != this.mainForm.Current__Pattern.Id
			)
			{
				return false;
			}
			else
			{ 
				return true;
			}
		}

		#region		virtual and abstract methods

		protected override bool isParentTheCurrent(int dataRow__Id)
		{
			BabebiDataSet.WordFromPatternRow wordFromPattern
				= this.dataSet.WordFromPattern
				.FindById(dataRow__Id);

			return this.isParentTheCurrent(wordFromPattern);
		}

		protected override List<object>[] getValueListArray()
		{
			BabebiDataSet.PatternRow pattern = this.mainForm.Current__Pattern;

			List<List<object>> valueListList = new List<List<object>>();

			foreach (BabebiDataSet.FromPatternRow fromPattern in pattern.GetFromPatternRows())
			{
				if (fromPattern.SubscriberCode == MainForm.SubscriberCode_Pattern)
				{
					continue;
				}

				BabebiDataSet.WordFromPatternRow wordFromPattern
					= this.dataSet.WordFromPattern
					.FindById(fromPattern.SubscriberId);


				List<object> valueList = this.buildValueList(wordFromPattern);

				valueListList.Add(valueList);
			}

			return valueListList.ToArray();
		}

		#endregion	virtual and abstract methods
	}

	/*
	public class GuiTable__WordFromPattern__of__Current__Pattern : DataTable
	{
		private MainForm mainForm;

		private BabebiDataSet dataSet
		{
			get
			{
				return this.mainForm.DataSet;
			}
		}

		#region		shortcuts about tables

		private BabebiDataSet.WordDataTable					table__Word
		{
			get { return this.dataSet.Word; }
		}
		private BabebiDataSet.Word_LanguageDataTable		table__Word_Language
		{
			get { return this.dataSet.Word_Language; }
		}
		private BabebiDataSet.Word_LanguageWordDataTable	table__Word_LanguageWord
		{
			get { return this.dataSet.Word_LanguageWord; }
		}
		private BabebiDataSet.LanguageWordDataTable			table__LanguageWord
		{
			get { return this.dataSet.LanguageWord; }
		}
		private BabebiDataSet.WordFromPatternDataTable		table__WordFromPattern
		{
			get { return this.dataSet.WordFromPattern; }
		}
		private BabebiDataSet.FromPatternDataTable		table__FromPattern
		{
			get { return this.dataSet.FromPattern; }
		}
		private BabebiDataSet.FromPatternLetterDataTable		table__FromPatternLetter
		{
			get { return this.dataSet.FromPatternLetter; }
		}
		private BabebiDataSet.WordType_LanguageDataTable		table__WordType_Language
		{
			get { return this.dataSet.WordType_Language; }
		}

		#endregion	shortcuts about tables

		private BabebiDataSet.LanguageRow	currentLanguage
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}
		private string						currentLanguageCode
		{ 
			get
			{
				return this.mainForm.Current__Language.Code;
			}
		}

		/// <summary>
		/// public car la MainForm y accède lors du loading pour le binder à la DGV.
		/// </summary>
		public DataSet DataSet__for__the__BindingSource;

		#region		Columns

		public DataColumn	WordId;
		public DataColumn	WordUniqueKeyString;
		public DataColumn	Word_LanguageMeaning;
		public DataColumn	WordType_LanguageName;
		public DataColumn	LetterDictionaryString;
		public DataColumn	GuiHorizontalShift;
		public DataColumn	WordTypeId__HIDDEN;
		public DataColumn	SORTING;

		#endregion	Columns

		#region		getters : GetValue__'ColumnName'(guiDataRow) 
		
		/// Remarque : les getters sont nécessaires pour avoir des valeurs typées-simples. 
		/// Pas de setters car pour le setting on n'a pas de problème de type ; on écrit : 
		/// guiDataRow[this.ColumnName] = value.

		public int		GetValue__WordId(DataRow guiDataRow)				{return guiDataRow.Field<int	>(this.WordId					);}
		public string	GetValue__WordUniqueKeyString(DataRow guiDataRow)	{return guiDataRow.Field<string	>(this.WordUniqueKeyString		);}
		public string	GetValue__Word_LanguageMeaning(DataRow guiDataRow)	{return guiDataRow.Field<string	>(this.Word_LanguageMeaning		);}
		public string	GetValue__WordType_LanguageName(DataRow guiDataRow)	{return guiDataRow.Field<string	>(this.WordType_LanguageName	);}
		public string	GetValue__LetterDictionaryString(DataRow guiDataRow){return guiDataRow.Field<string	>(this.LetterDictionaryString	);}
		public short	GetValue__GuiHorizontalShift(DataRow guiDataRow)	{return guiDataRow.Field<short	>(this.GuiHorizontalShift		);}
		public short	GetValue__WordTypeId__HIDDEN(DataRow guiDataRow)	{return guiDataRow.Field<short	>(this.WordTypeId__HIDDEN		);}
		public int		GetValue__SORTING(DataRow guiDataRow)				{return guiDataRow.Field<int	>(this.SORTING					);}

		#endregion	getters : GetValue__'ColumnName'(guiDataRow)

		/// ctor
		public GuiTable__WordFromPattern__of__Current__Pattern(MainForm mainform) 
		: base("WordFromPattern__of__Current__Pattern_")	/// on rajouter un '_' à la fin pour bien se souvenir que ce n'est pas une table du DS.
		{
			this.mainForm = mainform;

			this.DataSet__for__the__BindingSource = new DataSet("WordFromPattern__of__Current__Pattern__DataSet");

			this.DataSet__for__the__BindingSource.Tables.Add(this);

			#region		columns

			this.WordId					= this.Columns.Add("WordId"					, typeof(int));
			this.WordUniqueKeyString	= this.Columns.Add("WordUniqueKeyString"	, typeof(string));
			this.Word_LanguageMeaning	= this.Columns.Add("Word_LanguageMeaning"	, typeof(string));
			this.WordType_LanguageName	= this.Columns.Add("WordType_LanguageName"	, typeof(string));
			this.LetterDictionaryString	= this.Columns.Add("LetterDictionaryString"	, typeof(string));
			this.GuiHorizontalShift		= this.Columns.Add("GuiHorizontalShift"		, typeof(short));
			this.WordTypeId__HIDDEN		= this.Columns.Add("WordTypeId__HIDDEN"		, typeof(short));
			this.SORTING				= this.Columns.Add("SORTING"				, typeof(int));

			this.WordId					.AllowDBNull = false;
			this.WordUniqueKeyString	.AllowDBNull = false;
			this.Word_LanguageMeaning	.AllowDBNull = false;
			this.WordType_LanguageName	.AllowDBNull = false;
			this.LetterDictionaryString	.AllowDBNull = false;
			this.GuiHorizontalShift		.AllowDBNull = false;
			this.WordTypeId__HIDDEN		.AllowDBNull = false;
			this.SORTING				.AllowDBNull = false;

			this.WordUniqueKeyString	.MaxLength = 32;
			this.Word_LanguageMeaning	.MaxLength = 256;
			this.WordType_LanguageName	.MaxLength = 256;
			this.LetterDictionaryString	.MaxLength = 256;

			this.PrimaryKey 	= new DataColumn[]{this.WordId};

			#endregion	columns

			this.dataSet.WordFromPattern.RowChanged		+= WordFromPattern__RowChanged;
			this.dataSet.Word.RowChanged				+= Word_RowChanged;
			this.dataSet.Word_Language.RowChanged		+= Word_Language__RowChanged; 
			this.dataSet.FromPattern.RowChanged			+= FromPattern__RowChanged;
			this.dataSet.WordType_Language.RowChanged   += WordType_Language__RowChanged;
			this.dataSet.FromPatternLetter.RowChanged	+= FromPatternLetter__RowChanged;

			this.dataSet.FromPatternLetter.RowDeleting	+= FromPatternLetter__RowDeleting;
			this.dataSet.WordFromPattern.RowDeleting	+= WordFromPattern__RowDeleting;
		}

		#region		listening the DataSet events

		private void Word_RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			if (e.Action == DataRowAction.Change)
			{
				BabebiDataSet.WordRow word = (BabebiDataSet.WordRow)(e.Row);

				#region		where the out-of-scope rows are return-trapped.

				if (word.ModeCode != MainForm.ModeCode_FromPattern)
				{
					return;
				}

				BabebiDataSet.WordFromPatternRow wordFromPattern 
					= this.dataSet.WordFromPattern
					.FindById(word.Id);

				if (wordFromPattern == null || wordFromPattern.FromPatternRowParent.PatternId != this.mainForm.Current__Pattern.Id)
				{
					return;
				}

				#endregion	where the out-of-scope rows are return-trapped.

				DataRow guiDataRow = this.find(word.Id);

				if (guiDataRow != null)
				{
					/// Id => s'il a eu lieu, cela a été géré dans le 'this.find(word.Id)' ci-dessus.

					/// UniqueKeyString
					if (this.GetValue__WordUniqueKeyString(guiDataRow) != word.UniqueKeyString)
					{
						guiDataRow[this.WordUniqueKeyString] = word.UniqueKeyString;
					}

					/// WordType
					BabebiDataSet.WordType_LanguageRow wordType_language
						=
						this.dataSet.WordType_Language
						.FindByWordTypeIdLanguageCode
						(
							word.WordTypeId,
							this.currentLanguageCode
						);

					if (this.GetValue__WordType_LanguageName(guiDataRow) != wordType_language.Name)
					{
						guiDataRow[this.WordType_LanguageName] = wordType_language.Name;
					}
				}
			}
		}
		private void Word_Language__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			if (e.Action == DataRowAction.Change)
			{
				BabebiDataSet.Word_LanguageRow word_language = (BabebiDataSet.Word_LanguageRow)(e.Row);

				if (word_language.LanguageRow != this.currentLanguage)
				{
					return;
				}

				#region		where the out-of-scope rows are return-trapped.

				if (word_language.WordRowParent == null || word_language.WordRowParent.ModeCode != MainForm.ModeCode_FromPattern)
				{
					return;
				}

				BabebiDataSet.WordFromPatternRow wordFromPattern 
					= this.dataSet.WordFromPattern
					.FindById(word_language.WordId);

				if (wordFromPattern.FromPatternRowParent.PatternId != this.mainForm.Current__Pattern.Id)
				{
					return;
				}

				#endregion	where the out-of-scope rows are return-trapped.

				DataRow guiDataRow = find(word_language.WordId);

				/// Meaning
				if (guiDataRow != null && this.GetValue__Word_LanguageMeaning(guiDataRow) != word_language.Meaning)
				{
					guiDataRow[this.Word_LanguageMeaning] = word_language.Meaning;
				}
			}
		}
		private void WordFromPattern__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			BabebiDataSet.WordFromPatternRow wordFromPattern = (BabebiDataSet.WordFromPatternRow)(e.Row);

			if (e.Action == DataRowAction.Add)
			{
				if (this.mainForm.Current__Pattern.Id == wordFromPattern.FromPatternRowParent.PatternId)
				{
					/// CREATE
					this.addGuiDataRow(wordFromPattern);
				}
			}
			else if(e.Action == DataRowAction.Change)
			{
				DataRow guiDataRow = find(wordFromPattern.Id);

				if (guiDataRow != null)
				{
					/// aucun field à updater.
				}
			}
		}
		private void FromPattern__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}

			BabebiDataSet.FromPatternRow fromPattern = (BabebiDataSet.FromPatternRow)(e.Row);

			if(e.Action == DataRowAction.Change)
			{
				DataRow guiDataRow = Find(fromPattern.SubscriberId);

				#region		est-ce que le parent pattern à changer ?

				if (guiDataRow != null && fromPattern.PatternId != this.mainForm.Current__Pattern.Id)
				{
					this.Rows.Remove(guiDataRow);

					return;
				}

				#endregion	est-ce que le parent pattern à changer ?

				/// GuiHorizontalShift
				if (guiDataRow != null && this.GetValue__GuiHorizontalShift(guiDataRow) != fromPattern.GuiHorizontalShift)
				{
					guiDataRow[this.GuiHorizontalShift] = fromPattern.GuiHorizontalShift;
				}
			}
		}
		private void WordType_Language__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			BabebiDataSet.WordType_LanguageRow wordType_Language = (BabebiDataSet.WordType_LanguageRow)(e.Row);

			if (e.Action == DataRowAction.Commit)
			{ 
				return;
			}
			else if(e.Action == DataRowAction.Change)
			{
				foreach (DataRow guiDataRow in this.Rows)
				{
					if (this.GetValue__WordTypeId__HIDDEN(guiDataRow) == wordType_Language.WordTypeId)
					{
						if (this.GetValue__WordType_LanguageName(guiDataRow) != wordType_Language.Name)
						{
							guiDataRow[this.WordType_LanguageName] = wordType_Language.Name;
						}
					}
				}
			}
		}
		private void FromPatternLetter__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}
			else if (e.Action == DataRowAction.Change || e.Action == DataRowAction.Add)
			{
				BabebiDataSet.FromPatternLetterRow fromPatternLetter = (BabebiDataSet.FromPatternLetterRow)(e.Row);

				BabebiDataSet.FromPatternRow fromPattern = fromPatternLetter.FromPatternRowParent;

				DataRow guiDataRow = Find(fromPatternLetter.FromPatternSubscriberId);

				if (guiDataRow != null)
				{
					/// LetterDictionaryString

					if (fromPattern != null)		/// à cause d'un Update du Word Id....
					{
						/// LetterDictionaryString
						string letterDictionaryString = MainForm.Compute__LetterDictionaryString__for_Word(fromPattern);
						if (this.GetValue__LetterDictionaryString(guiDataRow) != letterDictionaryString)
						{
							guiDataRow[this.LetterDictionaryString] = letterDictionaryString;
						}

						/// SORTING
						int sorting = this.mainForm.Compute__Sorting(fromPattern);
						if (this.GetValue__SORTING(guiDataRow) != sorting)
						{
							guiDataRow[this.SORTING] = sorting;
						}
					}
				}
			}
		}

		private void FromPatternLetter__RowDeleting(object sender, DataRowChangeEventArgs e)
		{
			BabebiDataSet.FromPatternLetterRow	fromPatternLetter = (BabebiDataSet.FromPatternLetterRow)(e.Row);

			BabebiDataSet.FromPatternRow		fromPattern = fromPatternLetter.FromPatternRowParent;

			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			if (e.Action == DataRowAction.Delete)
			{
				DataRow guiDataRow = Find(fromPatternLetter.FromPatternSubscriberId);

				if (guiDataRow != null)
				{					
					/// LetterDictionaryString
					string letterDictionaryString = MainForm.Compute__LetterDictionaryString__for_Word(fromPattern, fromPatternLetter);
					if (this.GetValue__LetterDictionaryString(guiDataRow) != letterDictionaryString)
					{
						guiDataRow[this.LetterDictionaryString] = letterDictionaryString;
					}

					/// SORTING
					int sorting = this.mainForm.Compute__Sorting(fromPattern, fromPatternLetter);
					if (this.GetValue__SORTING(guiDataRow) != sorting)
					{
						guiDataRow[this.SORTING] = sorting;
					}
				}
			}
		}

		private void WordFromPattern__RowDeleting(object sender, DataRowChangeEventArgs e)
		{
			if (e.Action == DataRowAction.Commit)
			{
				return;
			}

			if (e.Action == DataRowAction.Delete)
			{
				BabebiDataSet.WordFromPatternRow wordFromPattern = (BabebiDataSet.WordFromPatternRow)(e.Row);

				DataRow guiDataRow = Find(wordFromPattern.Id);

				if (guiDataRow != null)
				{
					this.Rows.Remove(guiDataRow);
				}
			}
		}

		#endregion	listening the DataSet events

		/// <returns>null if 'unmanaged state' ; false if no row ; true if at least 1 row.</returns>
		public bool? Populate()
		{
			this.Clear();

			this.AcceptChanges();

			if (this.currentLanguage == null)
			{
				return null;
			}
			if (this.mainForm.Current__Pattern == null)
			{
				return null;
			}

			BabebiDataSet.FromPatternRow[] fromPatterns = this.mainForm.Current__Pattern.GetFromPatternRows();

			bool has1RowAtleast = false;
			foreach(BabebiDataSet.FromPatternRow fromPattern in fromPatterns)
			{
				if (fromPattern.SubscriberCode == MainForm.SubscriberCode_Pattern)
				{
					continue;
				}

				BabebiDataSet.WordFromPatternRow wordFromPattern 
				 = this.dataSet.WordFromPattern
				 .FindById
				 (
					fromPattern.SubscriberId
				 );

				this.addGuiDataRow(wordFromPattern);

				if (!has1RowAtleast)
				{
					has1RowAtleast = true;
				}
			}

			return has1RowAtleast;
		}

		private DataRow addGuiDataRow(BabebiDataSet.WordFromPatternRow wordFromPattern)
		{
			BabebiDataSet.WordRow word = wordFromPattern.WordRowParent;

			BabebiDataSet.FromPatternRow fromPattern = wordFromPattern.FromPatternRowParent;

			BabebiDataSet.Word_LanguageRow word_language
				= this.table__Word_Language
				.FindByWordIdLanguageCode(word.Id, this.currentLanguageCode);

			BabebiDataSet.WordType_LanguageRow wordType_language
				= word_language.WordType_LanguageRowParent;

			string letterDictionaryString = MainForm.Compute__LetterDictionaryString__for_Word(wordFromPattern.FromPatternRowParent);

			int sorting = this.mainForm.Compute__Sorting(wordFromPattern.FromPatternRowParent);

			DataRow guiDataRow
				= this.Find(word.Id);

			if (guiDataRow == null)
			{
				guiDataRow = this.Rows.Add
				(
					word.Id,                            
					word.UniqueKeyString,               
					word_language.Meaning,              
					wordType_language.Name,             
					letterDictionaryString,             
					fromPattern.GuiHorizontalShift,     
					word.WordTypeId,                    
					sorting
				);

				guiDataRow.AcceptChanges();
			}
			return guiDataRow;
		}

		/// <summary>
		/// Find(...) dans cette GuiTable grâce au Word Id (pour ne pas à avoir à taper : 'this.Rows.Find(wordId);'... On gagne '.Rows') !
		/// </summary>
		public DataRow Find(int wordId)
		{
			return this.Rows.Find(wordId);
		}

		/// <summary>
		/// used when the WordId has been updated.
		/// </summary>
		private DataRow find(int dataSet__WordId)
		{
			DataRow guiDataRow = this.Find(dataSet__WordId);

			int guiTable__WordId = this.mainForm.DataGridView__WordFromPattern__of__Current__Pattern__CurrentWordId;

			if (guiDataRow == null && guiTable__WordId != -1)
			{
				guiDataRow = this.Find(guiTable__WordId);

				if (guiDataRow != null)
				{
					guiDataRow[this.WordId] = dataSet__WordId;

					guiDataRow.AcceptChanges();
				}

				this.mainForm.DataGridView__WordFromPattern__of__Current__Pattern__CurrentWordId = dataSet__WordId;
			}

			return guiDataRow;
		}
	}
	*/
}
