﻿using System;
using System.Data;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		#region		Current__#s

		internal BabebiDataSet.BookRow							Current__Book;
		internal BabebiDataSet.Book_LanguageRow					Current__Book_Language;
		internal BabebiDataSet.BookSentenceRow					Current__BookSentence;
		internal BabebiDataSet.SentenceRow						Current__Sentence;
		internal BabebiDataSet.Sentence_LanguageRow				Current__Sentence_Language;
		internal BabebiDataSet.SentenceWordRow					Current__SentenceWord;
		internal BabebiDataSet.Sentence_LanguageLanguageWordRow	Current__Sentence_LanguageLanguageWord;
		internal BabebiDataSet.SentenceWord_LanguageWordRow		Current__SentenceWord_LanguageWord;

		#endregion	Current__#s
		#region		functions

		private void populate__Book
		(
			int		book__Id,
			int		bookSentence__Index,
			short	bookSentenceLanguageWordIndex,
			short	bookSentenceWordIndex
		)
		{
			this.Current__Book = this.DataSet.Book.FindById(book__Id);

			this.Current__Book_Language = this.DataSet.Book_Language.FindByBookIdLanguageCode(this.Current__Book.Id, this.Current__Language.Code);

			this.Current__BookSentence = this.DataSet.BookSentence.FindByBookIdIndex(book__Id, bookSentence__Index);

			if (this.Current__BookSentence != null)
			{
				this.Current__Sentence = this.DataSet.Sentence.FindById(this.Current__BookSentence.SentenceId);

				this.Current__Sentence_Language = this.DataSet.Sentence_Language.FindBySentenceIdLanguageCode(this.Current__Sentence.Id, this.Current__Language.Code);

				this.Current__SentenceWord = this.DataSet.SentenceWord.FindBySentenceIdIndex(this.Current__Sentence.Id, bookSentenceWordIndex);

				this.Current__Sentence_LanguageLanguageWord
					= this.DataSet.Sentence_LanguageLanguageWord
					.FindBySentenceIdLanguageCodeIndex
					(
						this.Current__Sentence.Id,
						this.Current__Language.Code,
						bookSentenceLanguageWordIndex
					);

				this.Current__SentenceWord_LanguageWord
					= this.DataSet.SentenceWord_LanguageWord
					.FindBySentenceIdLanguageCodeSentenceWordIndexSentence_LanguageLanguageWordIndex
					(
						this.Current__Sentence.Id,
						this.Current__Language.Code,
						bookSentenceWordIndex,
						bookSentenceLanguageWordIndex
					);
			}

			this.textBox__Book__Author__Babebi	.Text	= this.Current__Book.AuthorRow.Name;
			this.textBox__Book__Author__Language.Text	= this.Current__Book_Language.Author_LanguageRowParent.Name;
			this.textBox__Book__Title__Babebi	.Text	= this.Current__Book.Title;
			this.textBox__Book__Title__Language	.Text	= this.Current__Book_Language.Title;
			this.textBox__Book__ISBN			.Text	= this.Current__Book.ISBN;

			this.guiTable__BookSentence.Populate();

			this.guiTable__SentenceWord.Populate();
		}

		private void bindingSource__BookSentence__CurrentChanged					(object sender, EventArgs e)
		{
			if (this.bindingSource__BookSentence.Current == null)
			{ 
				return;
			}

			DataRow guiDataRow = ((DataRowView)(this.bindingSource__BookSentence.Current)).Row;

			int bookSentence__Index = guiDataRow.Field<int>(this.guiTable__BookSentence.BookSentenceIndex);

			this.Current__BookSentence		= this.DataSet.BookSentence.FindByBookIdIndex(this.Current__Book.Id, bookSentence__Index);

			this.Current__Sentence			= this.Current__BookSentence.SentenceRow;

			this.Current__Sentence_Language 
				= this.DataSet.Sentence_Language
				.FindBySentenceIdLanguageCode
				(	
					this.Current__Sentence.Id, 
					this.Current__Language.Code
				);
			
			string filter = "";
			filter += "SentenceId = '" + this.Current__Sentence.Id.ToString() + "'";
			filter += " AND ";
			filter += "LanguageCode = '" + this.Current__Language.Code + "'";

			this.bindingSource__Sentence_LanguageLanguageWord.Filter = filter;

			this.guiTable__SentenceWord.Populate();

		}
		private void bindingSource__Sentence_LanguageLanguageWord_CurrentChanged	(object sender, EventArgs e)
		{
			if (this.bindingSource__Sentence_LanguageLanguageWord.Current == null)
			{ 
				return;
			}

			this.Current__Sentence_LanguageLanguageWord
				= 
				(BabebiDataSet.Sentence_LanguageLanguageWordRow)
				(
					(
						(DataRowView)
						(this.bindingSource__Sentence_LanguageLanguageWord.Current)
					).Row
				);

			if (this.Current__SentenceWord != null)
			{
				this.Current__SentenceWord_LanguageWord
					= this.DataSet.SentenceWord_LanguageWord
					.FindBySentenceIdLanguageCodeSentenceWordIndexSentence_LanguageLanguageWordIndex
					(
						this.Current__Sentence.Id, 
						this.Current__Language.Code, 
						this.Current__SentenceWord.Index, 
						this.Current__Sentence_LanguageLanguageWord.Index
					);
			}

		}
		private void bindingSource__SentenceWord_LanguageWord__CurrentChanged		(object sender, EventArgs e)
		{ 
			if (this.bindingSource__SentenceWord.Current == null)
			{ 
				return;
			}

			DataRow guiDataRow
				= 
				(
					(DataRowView)
					(this.bindingSource__SentenceWord.Current)
				).Row;

			short sentenceWordIndex = guiDataRow.Field<short>(this.guiTable__SentenceWord.SentenceWordIndex);

			this.Current__SentenceWord = this.DataSet.SentenceWord.FindBySentenceIdIndex(this.Current__Sentence.Id, sentenceWordIndex);

			if (this.Current__Sentence_LanguageLanguageWord != null)
			{
				this.Current__SentenceWord_LanguageWord
					= this.DataSet.SentenceWord_LanguageWord
					.FindBySentenceIdLanguageCodeSentenceWordIndexSentence_LanguageLanguageWordIndex
					(
						this.Current__Sentence.Id, 
						this.Current__Language.Code, 
						this.Current__SentenceWord.Index, 
						this.Current__Sentence_LanguageLanguageWord.Index
					);
			}
		}

		#endregion	functions
		#region		buttons

		private void button__Book__Sentence__Last__Click(object sender, EventArgs e)
		{
			var v = this.dataGridView__Book__SentenceLanguageWord.SelectedRows;
		}

		private void button__Book__Sentence__Create__Click(object sender, EventArgs e)
		{
			Form__BookSentence__CreateUpdate form = new Form__BookSentence__CreateUpdate(this, true);

			if (form.ShowDialog() != DialogResult.OK)
			{
				return;
			}

			DataRow focusedGuiDataRow = this.guiTable__BookSentence.Find(this.Current__BookSentence.Index);

			FocusGridRow(this.bindingSource__BookSentence, focusedGuiDataRow);
		}

		private void button__Book__Sentence__Update__Click(object sender, EventArgs e)
		{
			Form__BookSentence__CreateUpdate form = new Form__BookSentence__CreateUpdate(this, false);

			form.ShowDialog();
		}

		private void button__Book__Sentence__Delete__Click(object sender, EventArgs e)
		{

		}

		private void button__Book__Word__Append__Click(object sender, EventArgs e)
		{
			Form__SentenceWord form = new Form__SentenceWord(this);

			if (form.ShowDialog() != DialogResult.OK)
			{
				return;
			}

			DataRow focusedGuiDataRow = this.guiTable__SentenceWord.Find(this.Current__SentenceWord.Index);

			FocusGridRow(this.bindingSource__SentenceWord, focusedGuiDataRow);
		}

		private void button__Book__Word__Remove__Click(object sender, EventArgs e)
		{
			BabebiDataSet.Word_LanguageRow word_Language
				= this.DataSet.Word_Language
				.FindByWordIdLanguageCode
				(
					this.Current__SentenceWord.WordId,
					this.Current__Language.Code
				);

			string message = "";

			message += "Do you want to remove the following 'Sentence word' :\n\n";
			message += "Sentence Id = '"	+ this.Current__SentenceWord.SentenceId.ToString() + "'\n";
			message += "Word Index = '"		+ this.Current__SentenceWord.Index.ToString() + "'\n";
			message += "Word String = '"	+ this.Current__SentenceWord.WordRow.UniqueKeyString + "'\n";
			message += "Word Meaning = '"	+ word_Language.Meaning + "'\n";
			message += "Word Id = '"		+ this.Current__SentenceWord.WordId + "'";

			DialogResult dialogResult = MessageBox.Show(message, "Sentence Word Deleting ?", MessageBoxButtons.YesNo, MessageBoxIcon.Question);

			if (dialogResult == DialogResult.No)
			{
				return;
			}

			short removedIndex = this.Current__SentenceWord.Index;

			this.DataSet.SentenceWord.RemoveSentenceWordRow(this.Current__SentenceWord);

			foreach (BabebiDataSet.SentenceWordRow sentenceWord in this.Current__Sentence.GetSentenceWordRows())
			{
				if (sentenceWord.Index > removedIndex)
				{
					sentenceWord.Index = Convert.ToInt16(sentenceWord.Index - Convert.ToInt16(1));
				}
			}

			Word.Compute_Sentence__String(this.Current__Sentence);
		}

		private void button__Book__Word__Up__Click(object sender, EventArgs e)
		{
			short currentIndex	= this.Current__SentenceWord.Index;
			if (currentIndex == 0)
			{	
				return;
			}

			short priorIndex	= Convert.ToInt16(currentIndex - Convert.ToInt16(1));

			BabebiDataSet.SentenceWordRow priorSentenceWord 
				= this.DataSet.SentenceWord
				.FindBySentenceIdIndex
				(
					this.Current__SentenceWord.SentenceId, 
					priorIndex
				);
			
			priorSentenceWord.Index = -1;
			this.Current__SentenceWord.Index = priorIndex;
			priorSentenceWord.Index = currentIndex;

			this.Current__SentenceWord
				= this.DataSet.SentenceWord
				.FindBySentenceIdIndex
				(
					this.Current__SentenceWord.SentenceId, 
					priorIndex
				);

			Word.Compute_Sentence__String(this.Current__Sentence);

			DataRow guiDataRow = this.guiTable__SentenceWord.Find(this.Current__SentenceWord.Index);
			FocusGridRow(this.bindingSource__SentenceWord, guiDataRow);
		}

		private void button__Book__Word__Down__Click(object sender, EventArgs e)
		{
			short currentIndex	= this.Current__SentenceWord.Index;

			if (currentIndex == Convert.ToInt16(this.Current__Sentence.GetBookSentenceRows().Length - 1) )
			{	
				return;
			}

			short nextIndex	= Convert.ToInt16(currentIndex + Convert.ToInt16(1));

			BabebiDataSet.SentenceWordRow nextSentenceWord 
				= this.DataSet.SentenceWord
				.FindBySentenceIdIndex
				(
					this.Current__SentenceWord.SentenceId, 
					nextIndex
				);
			
			nextSentenceWord.Index = -1;
			this.Current__SentenceWord.Index = nextIndex;
			nextSentenceWord.Index = currentIndex;

			this.Current__SentenceWord
				= this.DataSet.SentenceWord
				.FindBySentenceIdIndex
				(
					this.Current__SentenceWord.SentenceId, 
					nextIndex
				);

			Word.Compute_Sentence__String(this.Current__Sentence);

			DataRow guiDataRow = this.guiTable__SentenceWord.Find(this.Current__SentenceWord.Index);
			FocusGridRow(this.bindingSource__SentenceWord, guiDataRow);
		}

		private void button__Book__Word__Link__Click(object sender, EventArgs e)
		{
			if (this.Current__SentenceWord == null || this.Current__Sentence_LanguageLanguageWord == null)
			{
				return;
			}

			BabebiDataSet.SentenceWord_LanguageWordRow sentenceWord_LanguageWord
				= this.DataSet.SentenceWord_LanguageWord
				.FindBySentenceIdLanguageCodeSentenceWordIndexSentence_LanguageLanguageWordIndex
				(
					this.Current__SentenceWord.SentenceId,
					this.Current__Language.Code,
					this.Current__SentenceWord.Index,
					this.Current__Sentence_LanguageLanguageWord.Index
				);

			if (sentenceWord_LanguageWord != null)
			{
				MessageBox.Show
				(
					"SLW Index = '" + this.Current__Sentence_LanguageLanguageWord.Index.ToString() + "'\n\n" + 
					"and\n\n" +
					"S W Index = '" + this.Current__SentenceWord.Index.ToString() + "'\n\n" + 
					"are already linked together.",
					"Already linked",
					MessageBoxButtons.OK,
					MessageBoxIcon.Information
				);

				return; 
			}

			BabebiDataSet.Word_LanguageWordRow word_LanguageWord
				= this.DataSet.Word_LanguageWord
				.FindByWordIdLanguageCodeLanguageWordString
				(
					this.Current__SentenceWord.WordId,
					this.Current__Language.Code,
					this.Current__Sentence_LanguageLanguageWord.LanguageWordString
				);

			if (word_LanguageWord == null)
			{
				BabebiDataSet.Word_LanguageRow word_Language
					= this.DataSet.Word_Language
					.FindByWordIdLanguageCode
					(
						this.Current__SentenceWord.WordId,
						this.Current__Language.Code
					);
				
				DialogResult dialogResult
					= MessageBox.Show
					(
						"The following link between 'Word' and 'Language Word' is missing:\n\n" + 
						"Word Id = '" + this.Current__SentenceWord.WordId.ToString() + "'\n" +
						"Word Unique Key String = '" + this.Current__SentenceWord.WordRow.UniqueKeyString + "'\n" +
						"Word Meaning = '" + word_Language.Meaning + "'\n" +
						"Currency Code = '" + this.Current__Sentence_LanguageLanguageWord.LanguageCode + "'\n" + 
						"Language Word String = '" + this.Current__Sentence_LanguageLanguageWord.LanguageWordString + "'\n\n" +
						"Do you want to create it ?",
						"Word_LanguageWord is missing",
						MessageBoxButtons.YesNo,
						MessageBoxIcon.Question
					);

				if (dialogResult == DialogResult.Yes)
				{
					word_LanguageWord
						= this.DataSet.Word_LanguageWord
						.AddWord_LanguageWordRow
						(
							this.Current__SentenceWord.WordId,
							this.Current__Language.Code,
							this.Current__Sentence_LanguageLanguageWord.LanguageWordString
						);
				}
				else
				{
					return;
				}
			}

			this.Current__SentenceWord_LanguageWord
				= this.DataSet.SentenceWord_LanguageWord
				.AddSentenceWord_LanguageWordRow
				(
					this.Current__SentenceWord.SentenceId,
					this.Current__Language.Code,
					this.Current__SentenceWord.Index,
					this.Current__Sentence_LanguageLanguageWord.Index,
					this.Current__SentenceWord.WordId,
					this.Current__Sentence_LanguageLanguageWord.LanguageWordString
				);
		}

		private void button__Book__Word__Unlink__Click(object sender, EventArgs e)
		{

		}

		#endregion	buttons
	}
}