﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		#region		functions

		internal void ComboBox__InsertionIndex__SelectedIndexChanged
		(
			ComboBox_WEM comboBox_WEM__InsertionIndex,
			short parentUniqueKeyStringLength,
		ref short selected__InsertionIndex
		)
		{
			selected__InsertionIndex = MainForm.Convert__ComboBoxSelectedItem__into__InsertionIndex( comboBox_WEM__InsertionIndex.Get() );

			if
			(
				selected__InsertionIndex != 32
				&&
				selected__InsertionIndex > parentUniqueKeyStringLength
			)
			{
				string errorMessage 
					= "The selected 'Insertion Index' (" + comboBox_WEM__InsertionIndex.Get() 
					+ ") is too high because the length of String of the parent Word or Pattern is only " 
					+ parentUniqueKeyStringLength.ToString() 
					+ ".";
					
				comboBox_WEM__InsertionIndex.SetError(errorMessage, "Too high value");
			}
			else
			{
				comboBox_WEM__InsertionIndex.ClearError();
			}
		}

		internal bool Is_a__a_OR_e__e_OR_o__o
		(
			string		parentWordString, 
			string		letterClusterString,
			short		selected__InsertionIndex,
			TextBox_WEM textBox_WEM__UniqueKeyString
		)
		{
			bool a__a_OR_e__e_OR_o__o = false;
			if (selected__InsertionIndex > 0 && selected__InsertionIndex < 32)
			{
				string lastChar_of_beginning = parentWordString.Substring(selected__InsertionIndex - 1, 1);

				string firstChar_of_Cluster = letterClusterString.Substring(0, 1);

				if
				(
					(lastChar_of_beginning == "a" && firstChar_of_Cluster == "a")
					||
					(lastChar_of_beginning == "e" && firstChar_of_Cluster == "e")
					||
					(lastChar_of_beginning == "o" && firstChar_of_Cluster == "o")
				)
				{
					textBox_WEM__UniqueKeyString.Set_with_null_and_error
					(
						"The end of the first part can not end by the same vowel {a, e, o} as the same vowel starting the 'letter cluster'.",
						"...a_a... , ...e_e... , ...o_o..."
					);

					textBox_WEM__UniqueKeyString.ShowMessageBox();

					a__a_OR_e__e_OR_o__o = true;
				}
			}

			return a__a_OR_e__e_OR_o__o;
		}

		internal bool ByInsertion__Check_Erros_Before_Computing_UniqueKeyString
		(
			string		parentString, 
			string		letterClusterString,
			short		selected__InsertionIndex,
			TextBox_WEM	textBox_WEM__UniqueKeyString
		)
		{
			bool hasError = false;

			#region		trapping of any error about a__a_OR_e__e_OR_o__o
			if
			(
				this.Is_a__a_OR_e__e_OR_o__o
				(
					parentString,
					letterClusterString,
					selected__InsertionIndex,
					textBox_WEM__UniqueKeyString
				)
			)
			{
				hasError = true;
			}
			#endregion	trapping of any error about a__a_OR_e__e_OR_o__o
			#region		trapping of any error about parentWordString.Length + letterClusterString.Length > 32

			if (parentString.Length + letterClusterString.Length > 32)
			{
				string errorMessage
					= "The sum of the lenghts of:\n"
					+ "   - the parent Word String\n"
					+ "   - the Letter Cluster String\n"
					+ "is bigger than 32, which would produce a too long Word (max. lenght is 32-char).";

				textBox_WEM__UniqueKeyString.Set_with_null_and_error(errorMessage, "Too long");

				textBox_WEM__UniqueKeyString.ShowMessageBox();

				hasError = true;
			}

			#endregion	trapping of any error about parentWordString.Length + letterClusterString.Length > 32
			return hasError;
		}

		#endregion	functions
	}
}