﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		internal BabebiDataSet.LetterClusterRow build__LetterCluster
		(
			List<BabebiDataSet.LetterRow> letterList
		)
		{
			BabebiDataSet.LetterClusterRow letterCluster;

			#region		find the next Id of the LetterCluster

			int letterClusterId = -1;
			foreach (BabebiDataSet.LetterClusterRow anyLetterCluster in this.DataSet.LetterCluster)
			{
				if (anyLetterCluster.RowState == DataRowState.Deleted)
				{
					continue;
				}

				if (anyLetterCluster.Id > letterClusterId)
				{
					letterClusterId = anyLetterCluster.Id;
				}
			}
			letterClusterId++;

			#endregion	find the next Id of the LetterCluster

			/// build the letterClusterString from the letters.
			string letterClusterString = "";
			foreach (BabebiDataSet.LetterRow letter in letterList)
			{
				letterClusterString += letter.String;
			}

			/// create the required LetterCluster and associate it to the letterCluster.
			letterCluster
				= this.DataSet.LetterCluster
				.AddLetterClusterRow
				(
					letterClusterId,
					letterClusterString
				);

			/// create the required child LetterClusterLetter rows.
			short rank = -1; /// 0-based because not visible by the user.
			foreach (BabebiDataSet.LetterRow letter in letterList)
			{
				rank++;

				BabebiDataSet.LetterClusterLetterRow newLetterClusterLetter
					= this.DataSet.LetterClusterLetter
					.AddLetterClusterLetterRow
					(
						letterCluster,
						rank,
						letter
					);
			}

			return letterCluster;
		}

		internal BabebiDataSet.LetterOrSymbolClusterRow build__LetterOrSymbolCluster
		(
			List<BabebiDataSet.LetterOrSymbolRow> letterOrSymbolList
		)
		{
			BabebiDataSet.LetterOrSymbolClusterRow letterOrSymbolCluster;

			#region		find the next Id of the LetterOrSymbolCluster

			int letterOrSymbolClusterId = -1;
			foreach (BabebiDataSet.LetterOrSymbolClusterRow anyLetterOrSymbolCluster in this.DataSet.LetterOrSymbolCluster)
			{
				if (anyLetterOrSymbolCluster.RowState == DataRowState.Deleted)
				{
					continue;
				}

				if (anyLetterOrSymbolCluster.Id > letterOrSymbolClusterId)
				{
					letterOrSymbolClusterId = anyLetterOrSymbolCluster.Id;
				}
			}
			letterOrSymbolClusterId++;

			#endregion	find the next Id of the LetterOrSymbolCluster

			/// build the letterClusterString from the letters.
			string letterOrSymbolClusterString = "";
			foreach (BabebiDataSet.LetterOrSymbolRow letterOrSymbol in letterOrSymbolList)
			{
				letterOrSymbolClusterString += letterOrSymbol.String;
			}

			/// create the required LetterCluster and associate it to the letterCluster.
			letterOrSymbolCluster
				= this.DataSet.LetterOrSymbolCluster
				.AddLetterOrSymbolClusterRow
				(
					letterOrSymbolClusterId,
					letterOrSymbolClusterString
				);

			/// create the required child LetterClusterLetter rows.
			short rank = -1; /// 0-based because not visible by the user.
			foreach (BabebiDataSet.LetterOrSymbolRow letterOrSymbol in letterOrSymbolList)
			{
				rank++;

				BabebiDataSet.LetterOrSymbolClusterLetterOrSymbolRow newLetterOrSymbolClusterLetterOrSymbol
					= this.DataSet.LetterOrSymbolClusterLetterOrSymbol
					.AddLetterOrSymbolClusterLetterOrSymbolRow
					(
						letterOrSymbolCluster,
						rank,
						letterOrSymbol
					);
			}

			return letterOrSymbolCluster;
		}

		internal void Set_LetterCluster_and_remove_prior_if_not_used_by_other
		(
			BabebiDataSet.LetterClusterRow		selected__LetterCluster,
			BabebiDataSet.WordByInsertionRow	current__WordByInsertion
		)
		{
			if (selected__LetterCluster != current__WordByInsertion.LetterClusterRow)
			{
				#region		where the prior LetterCluster is prepared to be deleted if it is not used by any other ParrentByInsertion

				/// on fait la photo de l'ancien LetterCluster avant d'assigner 
				/// le nouveau (en vue d'un eventuel deleting si pas utilisé par d'autres).
				BabebiDataSet.LetterClusterRow letterCluster__toBeDeleted;
				if 
				(
					current__WordByInsertion.LetterClusterRow.GetWordByInsertionRows().Length == 1
					&&
					current__WordByInsertion.LetterClusterRow.GetDerivatingRows().Length == 0
				)
				{
					letterCluster__toBeDeleted = this.Current__WordByInsertion__of__Current__Word.LetterClusterRow; /// toujours l'ancien parent LetterCluster
				}
				else
				{
					letterCluster__toBeDeleted = null;
				}

				#endregion	where the prior LetterCluster is prepared to be deleted if it is not used by any other ParrentByInsertion

				/// on assigne enfin the nouveau LetterCluster
				current__WordByInsertion.LetterClusterRow
					= selected__LetterCluster;

				#region		where the prior LetterCluster is deleted if it is not used by any other WordByInsertion

				if (letterCluster__toBeDeleted != null)
				{
					this.DataSet.LetterCluster.RemoveLetterClusterRow(letterCluster__toBeDeleted);

					/// cascade deleting on the child LetterClusterLetters.
				}

				#endregion	where the prior LetterCluster is deleted if it is not used by any other WordByInsertion
			}
		}


		internal void Set_LetterOrSymbolCluster_and_remove_prior_if_not_used_by_other
		(
			BabebiDataSet.LetterOrSymbolClusterRow	selected__LetterOrSymbolCluster,
			BabebiDataSet.PatternByInsertionRow		current__PatternByInsertion
		)
		{
			if (selected__LetterOrSymbolCluster != current__PatternByInsertion.LetterOrSymbolClusterRow)
			{
				#region		where the prior LetterOrSymbolCluster is prepared to be deleted if it is not used by any other ParrentByInsertion

				/// on fait la photo de l'ancien LetterOrSymbolCluster avant d'assigner 
				/// le nouveau (en vue d'un eventuel deleting si pas utilisé par d'autres).
				BabebiDataSet.LetterOrSymbolClusterRow letterOrSymbolCluster__toBeDeleted;
				if (current__PatternByInsertion.LetterOrSymbolClusterRow.GetPatternByInsertionRows().Length == 1)
				{
					letterOrSymbolCluster__toBeDeleted = current__PatternByInsertion.LetterOrSymbolClusterRow; /// toujours l'ancien parent LetterCluster
				}
				else
				{
					letterOrSymbolCluster__toBeDeleted = null;
				}

				#endregion	where the prior LetterOrSymbolCluster is prepared to be deleted if it is not used by any other ParrentByInsertion

				/// on assigne enfin the nouveau LetterCluster
				current__PatternByInsertion.LetterOrSymbolClusterRow
					= selected__LetterOrSymbolCluster;

				#region		where the prior LetterOrSymbolCluster is deleted if it is not used by any other PatternByInsertion

				if (letterOrSymbolCluster__toBeDeleted != null)
				{
					this.DataSet.LetterOrSymbolCluster.RemoveLetterOrSymbolClusterRow(letterOrSymbolCluster__toBeDeleted);

					/// cascade deleting on the child LetterClusterLetters.
				}

				#endregion	where the prior LetterOrSymbolCluster is deleted if it is not used by any other PatternByInsertion
			}
		}

	}
}