﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private ToolStripButton		toolStrip__Word__Update					;
		private ToolStripSeparator	toolStrip__Word__Separator__1			;
		private ToolStripButton		toolStrip__Word__Delete					;
		private ToolStripSeparator	toolStrip__Word__Separator__2			;
		private ToolStripButton		toolStrip__Word__Add__WordDerivated		;
		private ToolStripButton		toolStrip__Word__Add__WordByInsertion	;
		private ToolStripButton		toolStrip__Word__Add__PatternByInsertion;
		private ToolStripSeparator	toolStrip__Word__Separator__3			;
		private ToolStripButton		toolStrip__Word__Refresh				;

		private ToolStripButton		toolStrip__Pattern__Update					;
		private ToolStripSeparator	toolStrip__Pattern__Separator__1			;
		private ToolStripButton		toolStrip__Pattern__Delete					;
		private ToolStripSeparator	toolStrip__Pattern__Separator__2			;
		private ToolStripButton		toolStrip__Pattern__Add__WordFromPattern	;
		private ToolStripButton		toolStrip__Pattern__Add__PatternFromPattern	;
		private ToolStripButton		toolStrip__Pattern__Add__PatternByInsertion	;
		private ToolStripSeparator	toolStrip__Pattern__Separator__3			;
		private ToolStripButton		toolStrip__Pattern__Refresh					;

		private void contextMenuStrip__Opening(object sender, CancelEventArgs e)
		{
			this.contextMenuStrip.Items.Clear();

			if (this.tabControl__Main.SelectedTab != this.tabPage__Hierarchy)
			{
				return;
			}

			TreeViewNodeTag treeViewNodeTag = (TreeViewNodeTag)(this.treeView__Hierarchy.SelectedNode.Tag);

			if		(treeViewNodeTag is TreeViewNodeTag__WordOrPattern)
			{
				if		(treeViewNodeTag.WordOrPattern.SubscriberCode == MainForm.SubscriberCode_Word)
				{
					this.toolStrip__Word__Update = new ToolStripButton("Update");
					this.toolStrip__Word__Separator__1 = new ToolStripSeparator();
					this.toolStrip__Word__Delete = new ToolStripButton("Delete");
					this.toolStrip__Word__Separator__2 = new ToolStripSeparator();
					this.toolStrip__Word__Add__WordDerivated = new ToolStripButton("Add a new child 'Word (Derivated)'");
					this.toolStrip__Word__Add__WordByInsertion = new ToolStripButton("Add a new child 'Word (By insertion)'");
					this.toolStrip__Word__Add__PatternByInsertion = new ToolStripButton("Add a new child 'Pattern (By insertion)'");

					this.toolStrip__Word__Update.Click += ToolStrip______Update__Click;
					this.toolStrip__Word__Delete.Click += ToolStrip__Word__Delete__Click;
					this.toolStrip__Word__Add__WordDerivated.Click += ToolStrip__Word__Add__WordDerivated__Click;
					this.toolStrip__Word__Add__WordByInsertion.Click += ToolStrip__Word__Add__WordByInsertion__Click;
					this.toolStrip__Word__Add__PatternByInsertion.Click += ToolStrip__Word__Add__PatternByInsertion__Click;

					this.contextMenuStrip.Items.AddRange
					(
						new ToolStripItem[]
						{
						this.toolStrip__Word__Update                    ,
						this.toolStrip__Word__Separator__1              ,
						this.toolStrip__Word__Delete                    ,
						this.toolStrip__Word__Separator__2              ,
						this.toolStrip__Word__Add__WordDerivated        ,
						this.toolStrip__Word__Add__WordByInsertion      ,
						this.toolStrip__Word__Add__PatternByInsertion   
						}
					);
				}
				else if (treeViewNodeTag.WordOrPattern.SubscriberCode == MainForm.SubscriberCode_Pattern)
				{
					this.toolStrip__Pattern__Update = new ToolStripButton("Update");
					this.toolStrip__Pattern__Separator__1 = new ToolStripSeparator();
					this.toolStrip__Pattern__Delete = new ToolStripButton("Delete");
					this.toolStrip__Pattern__Separator__2 = new ToolStripSeparator();
					this.toolStrip__Pattern__Add__WordFromPattern = new ToolStripButton("Add a new child 'Word (From Pattern)'");
					this.toolStrip__Pattern__Add__PatternFromPattern = new ToolStripButton("Add a new child 'Pattern (From Pattern)'");
					this.toolStrip__Pattern__Add__PatternByInsertion = new ToolStripButton("Add a new child 'Pattern (By insertion)'");

					this.toolStrip__Pattern__Update.Click += ToolStrip______Update__Click;
					this.toolStrip__Pattern__Delete.Click += ToolStrip__Pattern__Delete__Click;
					this.toolStrip__Pattern__Add__WordFromPattern.Click += ToolStrip__Pattern__Add__WordFromPattern__Click;
					this.toolStrip__Pattern__Add__PatternFromPattern.Click += ToolStrip__Pattern__Add__PatternFromPattern__Click;
					this.toolStrip__Pattern__Add__PatternByInsertion.Click += ToolStrip__Pattern__Add__PatternByInsertion__Click;

					this.contextMenuStrip.Items.AddRange
					(
						new ToolStripItem[]
						{
						this.toolStrip__Pattern__Update                 ,
						this.toolStrip__Pattern__Separator__1           ,
						this.toolStrip__Pattern__Delete                 ,
						this.toolStrip__Pattern__Separator__2           ,
						this.toolStrip__Pattern__Add__WordFromPattern   ,
						this.toolStrip__Pattern__Add__PatternFromPattern,
						this.toolStrip__Pattern__Add__PatternByInsertion
						}
					);
				}
				else
				{
					throw new NotImplementedException(treeViewNodeTag.WordOrPattern.SubscriberCode);
				}
			}
			else if (treeViewNodeTag is TreeViewNodeTag__Folder treeViewNodeTag__Folder)
			{ 
				string childSubscriberCode	= treeViewNodeTag__Folder.SubscriberCode;
				string childModeCode		= treeViewNodeTag__Folder.ModeCode;

				if		(treeViewNodeTag.WordOrPattern.SubscriberCode == MainForm.SubscriberCode_Word)
				{
					if		(childSubscriberCode == MainForm.SubscriberCode_Word)
					{
						if (childModeCode == MainForm.ModeCode_Derivated)
						{
							this.toolStrip__Word__Add__WordDerivated = new ToolStripButton("Add a new child 'Word (Derivated)'");

							this.toolStrip__Word__Add__WordDerivated.Click += ToolStrip__Word__Add__WordDerivated__Click;

							this.contextMenuStrip.Items.AddRange
							(
								new ToolStripItem[]
								{
								this.toolStrip__Word__Add__WordDerivated
								}
							);
						}
						else if (childModeCode == MainForm.ModeCode_ByInsertion)
						{
							this.toolStrip__Word__Add__WordByInsertion = new ToolStripButton("Add a new child 'Word (By insertion)'");

							this.toolStrip__Word__Add__WordByInsertion.Click += ToolStrip__Word__Add__WordByInsertion__Click;

							this.contextMenuStrip.Items.AddRange
							(
								new ToolStripItem[]
								{
								this.toolStrip__Word__Add__WordByInsertion	
								}
							);
						}
						else
						{
							return;
						}
					}
					else if (childSubscriberCode == MainForm.SubscriberCode_Pattern)
					{
						if (childModeCode == MainForm.ModeCode_ByInsertion)
						{
							this.toolStrip__Word__Add__PatternByInsertion = new ToolStripButton("Add a new child 'Pattern (By insertion)'");

							this.toolStrip__Word__Add__PatternByInsertion.Click += ToolStrip__Word__Add__PatternByInsertion__Click;

							this.contextMenuStrip.Items.AddRange
							(
								new ToolStripItem[]
								{
								this.toolStrip__Word__Add__PatternByInsertion
								}
							);
						}
						else
						{
							return;
						}
					}
					else
					{
						throw new NotImplementedException(childSubscriberCode);
					}
				}
				else if (treeViewNodeTag.WordOrPattern.SubscriberCode == MainForm.SubscriberCode_Pattern)
				{
					if (childSubscriberCode == MainForm.SubscriberCode_Word)
					{
						if (childModeCode == MainForm.ModeCode_FromPattern)
						{
							this.toolStrip__Pattern__Add__WordFromPattern = new ToolStripButton("Add a new child 'Word (From Pattern)'");

							this.toolStrip__Pattern__Add__WordFromPattern.Click += ToolStrip__Pattern__Add__WordFromPattern__Click;

							this.contextMenuStrip.Items.AddRange
							(
								new ToolStripItem[]
								{
								this.toolStrip__Pattern__Add__WordFromPattern
								}
							);
						}
						else
						{
							return;
						}
					}
					else if (childSubscriberCode == MainForm.SubscriberCode_Pattern)
					{
						if (childModeCode == MainForm.ModeCode_FromPattern)
						{
							this.toolStrip__Pattern__Add__PatternFromPattern = new ToolStripButton("Add a new child 'Pattern (From Pattern)'");

							this.toolStrip__Pattern__Add__PatternFromPattern.Click += ToolStrip__Pattern__Add__PatternFromPattern__Click;

							this.contextMenuStrip.Items.AddRange
							(
								new ToolStripItem[]
								{
								this.toolStrip__Pattern__Add__PatternFromPattern
								}
							);
						}
						else if (childModeCode == MainForm.ModeCode_ByInsertion)
						{
							this.toolStrip__Pattern__Add__PatternByInsertion = new ToolStripButton("Add a new child 'Pattern (By insertion)'");

							this.toolStrip__Pattern__Add__PatternByInsertion.Click += ToolStrip__Pattern__Add__PatternByInsertion__Click;

							this.contextMenuStrip.Items.AddRange
							(
								new ToolStripItem[]
								{
								this.toolStrip__Pattern__Add__PatternByInsertion
								}
							);
						}
						else
						{
							return;
						}
					}
					else
					{
						throw new NotImplementedException(childSubscriberCode);
					}
				}
				else
				{
					throw new NotImplementedException(treeViewNodeTag.WordOrPattern.SubscriberCode);
				}
			}

			e.Cancel = false;
		}

		private BabebiDataSet.WordOrPatternRow contextMenuStrip__getParent(BabebiDataSet.WordOrPatternRow childWordOrPattern)
		{
			if (childWordOrPattern.SubscriberCode == MainForm.SubscriberCode_Word)
			{
				BabebiDataSet.WordRow word = this.DataSet.Word.FindById(childWordOrPattern.SubscriberId);

				switch (word.ModeCode)
				{
					case MainForm.ModeCode_FromPattern:
					{
						BabebiDataSet.WordFromPatternRow wordFromPattern = this.DataSet.WordFromPattern.FindById(word.Id);

						return wordFromPattern.FromPatternRowParent.PatternRow.WordOrPatternRowParent;
					}
					case MainForm.ModeCode_ByInsertion:
					{
						BabebiDataSet.WordByInsertionRow wordByInsertion = this.DataSet.WordByInsertion.FindById(word.Id);
						
						return wordByInsertion.WordRowByWordByInsertion__Word__Origin.WordOrPatternRowParent;
					}
					case MainForm.ModeCode_Derivated:
					{
						BabebiDataSet.WordDerivatedRow wordDerivated = this.DataSet.WordDerivated.FindById(word.Id);

						return wordDerivated.WordDerivatingRowParent.WordRowParent.WordOrPatternRowParent;
					}
					case MainForm.ModeCode_Concatenated:
					{
						return null;
					}
					default:
					{
						throw new NotImplementedException(word.ModeCode);
					}
				}
			}
			else if (childWordOrPattern.SubscriberCode == MainForm.SubscriberCode_Pattern)
			{
				BabebiDataSet.PatternRow pattern = this.DataSet.Pattern.FindById(childWordOrPattern.SubscriberId);

				switch (pattern.ModeCode)
				{
					case MainForm.ModeCode_ExNihilo:
					{
						return null;
					}
					case MainForm.ModeCode_FromPattern:
					{
						BabebiDataSet.PatternFromPatternRow patternFromPattern = this.DataSet.PatternFromPattern.FindById(pattern.Id);

						return patternFromPattern.FromPatternRowParent.PatternRow.WordOrPatternRowParent;
					}
					case MainForm.ModeCode_ByInsertion:
					{
						BabebiDataSet.PatternByInsertionRow patternByInsertion = this.DataSet.PatternByInsertion.FindById(pattern.Id);
							
						return patternByInsertion.WordOrPatternRowParent;
					}
					default:
					{
						throw new NotImplementedException(pattern.ModeCode);
					}
				}
			}
			else
			{
				throw new NotImplementedException(childWordOrPattern.SubscriberCode);
			}
		}

		private void ToolStrip______Update__Click(object sender, EventArgs e)
		{
			TreeViewNodeTag treeViewNodeTag = (TreeViewNodeTag)(this.treeView__Hierarchy.SelectedNode.Tag);

			BabebiDataSet.WordOrPatternRow wordOrPatternRow = treeViewNodeTag.WordOrPattern;

			/// current => child

			BabebiDataSet.WordOrPatternRow		childWordOrPattern		= null;

			BabebiDataSet.WordRow				childWord				= null;
			BabebiDataSet.Word_LanguageRow		childWord_Language		= null;

			BabebiDataSet.PatternRow			childPattern			= null;
			BabebiDataSet.Pattern_LanguageRow	childPattern_Language	= null;

			if (wordOrPatternRow.SubscriberCode == MainForm.SubscriberCode_Word)
			{
				childWordOrPattern	= this.Current__WordOrPattern__of__Word;
				childWord			= this.Current__Word;
				childWord_Language	= this.Current__Word_Language;
			}
			else
			{
				childWordOrPattern		= this.Current__WordOrPattern__of__Pattern;
				childPattern			= this.Current__Pattern;
				childPattern_Language	= this.Current__Pattern_Language;
			}

			BabebiDataSet.WordOrPatternRow parentWordOrPattern = this.contextMenuStrip__getParent(childWordOrPattern);

			if (parentWordOrPattern == null)
			{
				if (childWordOrPattern.SubscriberCode == MainForm.SubscriberCode_Word)
				{
					MessageBox.Show("The selected Word is a 'Word (Concatenated)' that cannot be updated from this TreeView (it has several parents...).");
				}
				else if (childWordOrPattern.SubscriberCode == MainForm.SubscriberCode_Pattern)
				{
					MessageBox.Show("The selected Pattern is a 'Pattern (Ex-nihilo)' that cannot be updated from this TreeView.");
				}
				else
				{
					throw new NotImplementedException(childWordOrPattern.SubscriberCode);
				}

				return;
			}
			
			/// parent => current
			this.treeView__Hierarchy__find__row__and__row_Language(parentWordOrPattern);

			if		(parentWordOrPattern.SubscriberCode == MainForm.SubscriberCode_Word)
			{
				if (childWordOrPattern.SubscriberCode == MainForm.SubscriberCode_Word)
				{
					if		(childWord.ModeCode == MainForm.ModeCode_Derivated)
					{
						this.Current__WordDerivated__of__WordDerivating = this.DataSet.WordDerivated.FindById(childWord.Id);
						this.Current__Word__of__WordDerivated__of__WordDerivating = childWord;
						this.Current__WordOrPattern__of__WordDerivated__of__WordDerivating = childWordOrPattern;
						this.Current__Word_Language__of__WordDerivated__of__WordDerivating = childWord_Language;

						Form__WordDerivated__of__WordDerivating__CreateUpdate form = new Form__WordDerivated__of__WordDerivating__CreateUpdate(this, false);

						form.ShowDialog();
					}
					else if (childWord.ModeCode == MainForm.ModeCode_ByInsertion)
					{
						this.Current__WordByInsertion__of__Current__Word = this.DataSet.WordByInsertion.FindById(childWord.Id);
						this.Current__Word__of__WordByInsertion__of__Current__Word = childWord;
						this.Current__WordOrPattern__of__WordByInsertion__of__Current__Word = childWordOrPattern;
						this.Current__Word_Language__of__WordByInsertion__of__Current__Word = childWord_Language;

						Form__WordByInsertion__of__Current__Word__CreateUpdate form = new Form__WordByInsertion__of__Current__Word__CreateUpdate(this, false);

						form.ShowDialog();
					}
					else
					{
						throw new Exception(childWord.ModeCode);
					}
				}
				else if (childWordOrPattern.SubscriberCode == MainForm.SubscriberCode_Pattern)
				{
					if (childPattern.ModeCode == MainForm.ModeCode_ByInsertion)
					{
						this.Current__PatternByInsertion__of__Current__Word							= this.DataSet.PatternByInsertion.FindById(childPattern.Id);
						this.Current__Pattern__of__PatternByInsertion__of__Current__Word			= childPattern;
						this.Current__WordOrPattern__of__PatternByInsertion__of__Current__Word		= childWordOrPattern;
						this.Current__Pattern_Language__of__PatternByInsertion__of__Current__Word	= childPattern_Language;

						Form__PatternByInsertion__of__Current__Word__CreateUpdate form = new Form__PatternByInsertion__of__Current__Word__CreateUpdate(this, false);

						form.ShowDialog();
					}
					else
					{
						throw new Exception(childPattern.ModeCode);
					}
				}
				else
				{ 
					throw new NotImplementedException(childWordOrPattern.SubscriberCode);
				}
			}
			else if (parentWordOrPattern.SubscriberCode == MainForm.SubscriberCode_Pattern)
			{ 
				if		(childWordOrPattern.SubscriberCode == MainForm.SubscriberCode_Word		)
				{
					if		(childWord.ModeCode == MainForm.ModeCode_FromPattern)
					{
						this.Current__WordFromPattern__of__Current__Pattern = this.DataSet.WordFromPattern.FindById(childWord.Id);
						this.Current__Word__of__WordFromPattern__of__Current__Pattern			= childWord;
						this.Current__Word_Language__of__WordFromPattern__of__Current__Pattern	= childWord_Language;
						this.Current__FromPattern__of__WordFromPattern__of__Current__Pattern	= this.Current__WordFromPattern__of__Current__Pattern.FromPatternRowParent;
						this.Current__WordOrPattern__of__WordFromPattern__of__Current__Pattern	= childWordOrPattern;

						Form__WordFromPattern__of__Current__Pattern__CreateUpdate form = new Form__WordFromPattern__of__Current__Pattern__CreateUpdate(this, false);

						form.ShowDialog();
					}
					else
					{
						throw new Exception(childWord.ModeCode);
					}
				}
				else if (childWordOrPattern.SubscriberCode == MainForm.SubscriberCode_Pattern	)
				{
					if		(childPattern.ModeCode == MainForm.ModeCode_FromPattern)
					{
						this.Current__PatternFromPattern__of__Current__Pattern							= this.DataSet.PatternFromPattern.FindById(childPattern.Id);
						this.Current__Pattern__of__PatternFromPattern__of__Current__Pattern				= childPattern;
						this.Current__Pattern_Language__of__PatternFromPattern__of__Current__Pattern	= childPattern_Language;
						this.Current__FromPattern__of__PatternFromPattern__of__Current__Pattern			= this.Current__PatternFromPattern__of__Current__Pattern.FromPatternRowParent;
						this.Current__WordOrPattern__of__PatternFromPattern__of__Current__Pattern		= childWordOrPattern;

						Form__PatternFromPattern__of__Current__Pattern__CreateUpdate form = new Form__PatternFromPattern__of__Current__Pattern__CreateUpdate(this, false);

						form.ShowDialog();
					}
					else if (childPattern.ModeCode == MainForm.ModeCode_ByInsertion)
					{
						this.Current__PatternByInsertion__of__Current__Pattern							= this.DataSet.PatternByInsertion.FindById(childPattern.Id);
						this.Current__Pattern__of__PatternByInsertion__of__Current__Pattern				= childPattern;
						this.Current__WordOrPattern__of__PatternByInsertion__of__Current__Pattern		= childWordOrPattern;
						this.Current__Pattern_Language__of__PatternByInsertion__of__Current__Pattern	= childPattern_Language;

						Form__PatternByInsertion__of__Current__Pattern__CreateUpdate form = new Form__PatternByInsertion__of__Current__Pattern__CreateUpdate(this, false);

						form.ShowDialog();
					}
					else
					{
						throw new Exception(childWord.ModeCode);
					}
				}
				else
				{ 
					throw new NotImplementedException(childWordOrPattern.SubscriberCode);
				}
			}
			else
			{ 
				throw new NotImplementedException(parentWordOrPattern.SubscriberCode);
			}

			this.ToolStrip__Refresh__SelectedTreeNode();
		}

		private void ToolStrip__Word__Delete__Click(object sender, EventArgs e)
		{
			throw new NotImplementedException();
		}
		private void ToolStrip__Word__Add__WordDerivated__Click(object sender, EventArgs e)
		{
			this.tabControl__Word__Children.SelectedTab = this.tabPage__Word__ChildWords__Derivated;

			this.button__WordDerivated__of__WordDerivating__Create__Click(null, null);

			this.ToolStrip__Refresh__SelectedTreeNode();
		}
		private void ToolStrip__Word__Add__WordByInsertion__Click(object sender, EventArgs e)
		{
			this.tabControl__Word__Children.SelectedTab = this.tabPage__Word__ChildWords__ByInsertion;

			this.button__WordByInsertion__of__Current__Word__Create__Click(null, null);

			this.ToolStrip__Refresh__SelectedTreeNode();
		}
		private void ToolStrip__Word__Add__PatternByInsertion__Click(object sender, EventArgs e)
		{
			this.tabControl__Word__Children.SelectedTab = this.tabPage__Word__ChildPatterns_ByInsertion;

			this.button__PatternByInsertion__of__Current__Word__Create__Click(null, null);

			this.ToolStrip__Refresh__SelectedTreeNode();
		}

		private void ToolStrip__Pattern__Delete__Click(object sender, EventArgs e)
		{
			throw new NotImplementedException();
		}
		private void ToolStrip__Pattern__Add__WordFromPattern__Click(object sender, EventArgs e)
		{
			this.tabControl__Pattern__Children.SelectedTab = this.tabPage__Pattern__Children__WordFromPattern;

			this.button__Pattern__Children__WordFromPattern__Create__Click(null, null);

			this.ToolStrip__Refresh__SelectedTreeNode();
		}
		private void ToolStrip__Pattern__Add__PatternFromPattern__Click(object sender, EventArgs e)
		{
			this.tabControl__Pattern__Children.SelectedTab = this.tabPage__Pattern__Children__PatternFromPattern;

			this.button__Pattern__Children__PatternFromPattern__Create__Click(null, null);

			this.ToolStrip__Refresh__SelectedTreeNode();
		}
		private void ToolStrip__Pattern__Add__PatternByInsertion__Click(object sender, EventArgs e)
		{
			this.tabControl__Pattern__Children.SelectedTab = this.tabPage__Pattern__Children__PatternByInsertion;

			this.button__PatternByInsertion__of__Current__Pattern__Create__Click(null, null);

			this.ToolStrip__Refresh__SelectedTreeNode();
		}

		private void ToolStrip__Refresh__SelectedTreeNode()
		{
			TreeViewNodeTag treeViewNodeTag = (TreeViewNodeTag)(this.treeView__Hierarchy.SelectedNode.Tag);

			if		(treeViewNodeTag is TreeViewNodeTag__WordOrPattern treeViewNodeTag__WordOrPattern)
			{
				/// foto
				BabebiDataSet.WordOrPatternRow selectedWordOrPattern = treeViewNodeTag__WordOrPattern.WordOrPattern;

				TreeNode parentTreeNode = this.treeView__Hierarchy.SelectedNode.Parent;

				this.treeView__Hierarchy__AfterSelect(parentTreeNode);

				TreeNode selectedTreeNode = null;
				foreach (TreeNode childTreeNode in parentTreeNode.Nodes)
				{
					TreeViewNodeTag childTreeViewNodeTag = (TreeViewNodeTag)(childTreeNode.Tag);

					if
					(
						childTreeViewNodeTag.WordOrPattern.SubscriberCode == treeViewNodeTag.WordOrPattern.SubscriberCode
						&&
						childTreeViewNodeTag.WordOrPattern.SubscriberId == treeViewNodeTag.WordOrPattern.SubscriberId
					)
					{
						selectedTreeNode = childTreeNode;
						break;
					}
				}

				if (selectedTreeNode != null)
				{
					this.treeView__Hierarchy.SelectedNode = selectedTreeNode;
					this.treeView__Hierarchy.SelectedNode.EnsureVisible();  //scroll if necessary
					this.treeView__Hierarchy.Focus();
				}
			}
			else if (treeViewNodeTag is TreeViewNodeTag__Folder treeViewNodeTag__Folder)
			{
				treeViewNodeTag__Folder.RefreshChildren();

				this.treeView__Hierarchy__AfterSelect(this.treeView__Hierarchy.SelectedNode);
			}
			else
			{
				throw new NotImplementedException(treeViewNodeTag.GetType().ToString());
			}
		}

	}
}