﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void button__DerivatedWordType__Create_Click(object sender, EventArgs e)
		{
			Form__DerivatedWordType__CreateUpdate form__derivatedWordType_Create = new Form__DerivatedWordType__CreateUpdate(this, true);

			form__derivatedWordType_Create.ShowDialog(this);
		}

		private void button__DerivatedWordType__Update_Click(object sender, EventArgs e)
		{
			Form__DerivatedWordType__CreateUpdate form__derivatedWordType_Update = new Form__DerivatedWordType__CreateUpdate(this, false);

			form__derivatedWordType_Update.ShowDialog(this);
		}

		private void button__DerivatedWordType__Delete_Click(object sender, EventArgs e)
		{
			if (this.Current__DerivatedWordType == null)
			{
				MessageBox.Show("There is no 'Derivated Word Type' to delete.", "Empty", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return; 
			}

			int length = this.Current__DerivatedWordType.GetDerivatingWordType_DerivatedWordTypeRows().Length;
			if (length > 0)
			{
				MessageBox.Show
				(
					"Deleting is not possible because the 'Derivated Word Type' is linked to " +
					length.ToString() +
					" 'Derivating Word Type(s)'.",
					"Already linked", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);
				return; 
			}

			DialogResult dialogResult 
				= MessageBox.Show
				(
					"Do you really want to delete the 'Derivated Word Type' : [" + 
					this.Current__DerivatedWordType_Language.Name +
					"].",
					"Deleting", 
					MessageBoxButtons.YesNo, 
					MessageBoxIcon.Question
				);
			if (dialogResult == DialogResult.No)
			{
				return;
			}

			this.DataSet.DerivatedWordType.RemoveDerivatedWordTypeRow(this.Current__DerivatedWordType);
		}

		private void filter__DerivatedWordType_Language()
		{
			this.bindingSource__DerivatedWordType_Language.Filter = this.filteringExpression__Language;
		}

		private void bindingSource__DerivatedWordType_Language_CurrentChanged(object sender, EventArgs e)
		{
			if (this.DoNotTriggerCurrentChangedEvent)
			{
				return;
			}

			this.Current__DerivatedWordType_Language 
				= 
				(BabebiDataSet.DerivatedWordType_LanguageRow)
				(
					(
						(DataRowView)
						(this.bindingSource__DerivatedWordType_Language.Current)
					)
					.Row
				);

			this.Current__DerivatedWordType = this.Current__DerivatedWordType_Language.DerivatedWordTypeRowParent;

			this.BindingSource__DerivatingWordType_DerivatedWordType.Filter = "DerivatedWordTypeId = '" + this.Current__DerivatedWordType.Id.ToString() + "'";
		}
	}
}
