﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void button__Derivating__Create_Click(object sender, EventArgs e)
		{
			Form__Derivating__CreateUpdate form__derivating_Create = new Form__Derivating__CreateUpdate(this, true);

			form__derivating_Create.ShowDialog(this);
		}

		private void button__Derivating__Update_Click(object sender, EventArgs e)
		{
			if (this.Current__Derivating_Language != null)
			{
				Form__Derivating__CreateUpdate form__derivating__Update = new Form__Derivating__CreateUpdate(this, false);

				form__derivating__Update.ShowDialog(this);
			}
		}

		private void button__Derivating__Delete_Click(object sender, EventArgs e)
		{
			if (this.Current__Derivating == null)
			{
				MessageBox.Show("There is no 'Word Derivating' to delete.", "Empty", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return; 
			}

			/*	a remplacer quand il y aura de disponible des enfants
			int length = this.Current__Derivating.GetDerivatingWordType_DerivatedWordTypeRows().Length;
			if (length > 0)
			{
				MessageBox.Show
				(
					"Deleting is not possible because the 'Derivating Word Type' is linked to " +
					length.ToString() +
					" 'Derivated Word Type(s)'.",
					"Already linked", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);
				return; 
			}
			*/

			DialogResult dialogResult 
				= MessageBox.Show
				(
					"Do you really want to delete the 'Word Derivating' : [" + 
					this.Current__Derivating_Language.Name +
					"].",
					"Deleting", 
					MessageBoxButtons.YesNo, 
					MessageBoxIcon.Question
				);
			if (dialogResult == DialogResult.No)
			{
				return;
			}

			BabebiDataSet.DerivatingRow  derivating = this.Current__Derivating;

			this.DataSet.Derivating.RemoveDerivatingRow(derivating);
		}

		private void filter__Derivating_Language()
		{
			if
			(
				this.Current__Language != null
				&&
				this.filteringExpression__DerivatingWordType_DerivatedWordType != null
			)
			{
				this.bindingSource__Derivating_Language.Filter
					= "LanguageCode = '"
					+ this.Current__Language.Code 
					+ "' AND "
					+ this.filteringExpression__DerivatingWordType_DerivatedWordType;

				

				if (this.bindingSource__Derivating_Language.List.Count == 0)
				{
					this.Current__Derivating = null;
					this.Current__Derivating_Language = null;
				}
			}
		}
		
		private void bindingSource__Derivating_Language__CurrentChanged(object sender, EventArgs e)
		{
			if (this.DoNotTriggerCurrentChangedEvent)
			{
				return;
			}

			if (this.bindingSource__Derivating_Language.Current != null)
			{
				this.Current__Derivating_Language
					=
					(BabebiDataSet.Derivating_LanguageRow)
					(((DataRowView)(this.bindingSource__Derivating_Language.Current)).Row);

				this.Current__Derivating = this.Current__Derivating_Language.DerivatingRowParent;
			}
		}
	}
}
