﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void button__DerivatingWordType__Create__Click(object sender, EventArgs e)
		{
			Form__DerivatingWordType__CreateUpdate form__derivatingWordType_Create = new Form__DerivatingWordType__CreateUpdate(this, true);

			form__derivatingWordType_Create.ShowDialog(this);
		}

		private void button__DerivatingWordType__Update__Click(object sender, EventArgs e)
		{
			Form__DerivatingWordType__CreateUpdate form__derivatingWordType__Update = new Form__DerivatingWordType__CreateUpdate(this, false);

			form__derivatingWordType__Update.ShowDialog(this);
		}

		private void button__DerivatingWordType__Delete_Click(object sender, EventArgs e)
		{
			if (this.Current__DerivatingWordType == null)
			{
				MessageBox.Show("There is no 'Derivating Word Type' to delete.", "Empty", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return; 
			}

			int length = this.Current__DerivatingWordType.GetDerivatingWordType_DerivatedWordTypeRows().Length;
			if (length > 0)
			{
				MessageBox.Show
				(
					"Deleting is not possible because the 'Derivating Word Type' is linked to " +
					length.ToString() +
					" 'Derivated Word Type(s)'.",
					"Already linked", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);
				return; 
			}

			DialogResult dialogResult 
				= MessageBox.Show
				(
					"Do you really want to delete the 'Derivating Word Type' : [" + 
					this.Current__DerivatingWordType_Language.Name +
					"].",
					"Deleting", 
					MessageBoxButtons.YesNo, 
					MessageBoxIcon.Question
				);
			if (dialogResult == DialogResult.No)
			{
				return;
			}

			this.DataSet.DerivatingWordType.RemoveDerivatingWordTypeRow(this.Current__DerivatingWordType);
		}

		private void filter__DerivatingWordType_Language()
		{
			this.bindingSource__DerivatingWordType_Language.Filter = this.filteringExpression__Language;
		}

		private void bindingSource__DerivatingWordType_Language__CurrentChanged(object sender, EventArgs e)
		{
			if (this.DoNotTriggerCurrentChangedEvent)
			{
				return;
			}

			this.Current__DerivatingWordType_Language 
				= 
				(BabebiDataSet.DerivatingWordType_LanguageRow)
				(
					(
						(DataRowView)
						(this.bindingSource__DerivatingWordType_Language.Current)
					)
					.Row
				);

			this.Current__DerivatingWordType = this.Current__DerivatingWordType_Language.DerivatingWordTypeRowParent;

			if (this.BindingSource__DerivatingWordType_DerivatedWordType != null)
			{
				this.BindingSource__DerivatingWordType_DerivatedWordType.Filter
					= "DerivatingWordTypeId = '" + this.Current__DerivatingWordType.Id.ToString() + "'";
			}
		}
	}
}
