﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private string filteringExpression__DerivatingWordType_DerivatedWordType = null;

		private void button__DerivatingWordType_DerivatedWordType__Create_Click(object sender, EventArgs e)
		{
			if (this.Current__DerivatingWordType == null)
			{
				MessageBox.Show
				(
					"You have to select a 'Derivating Word Type' first.", 
					"No selected 'Derivating Word Type'", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Information
				);
				return;
			}
			if (this.Current__DerivatedWordType == null)
			{
				MessageBox.Show
				(
					"You have to select a 'Derivated Word Type' first.", 
					"No selected 'Derivated Word Type'", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Information
				);
				return;
			}

			BabebiDataSet.DerivatingWordType_DerivatedWordTypeRow derivatingWordType_derivatedWordType
				= this.DataSet.DerivatingWordType_DerivatedWordType
				.FindByDerivatingWordTypeIdDerivatedWordTypeId
				(
					this.Current__DerivatingWordType.Id, 
					this.Current__DerivatedWordType.Id
				);

			if (derivatingWordType_derivatedWordType != null)
			{
				MessageBox.Show
				(
					"The selected link between '" +
					this.Current__DerivatingWordType_Language.Name + 
					"' and '" + 
					this.Current__DerivatedWordType_Language.Name + 
					") is already existing.\n This Create command aborts.",
					"Already existing link", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);

				return;
			}

			Form__DerivatingWordType_DerivatedWordType__CreateDelete form
				= new Form__DerivatingWordType_DerivatedWordType__CreateDelete(this, true);

			form.ShowDialog(this);
		}

		private void button_DerivatingWordType_DerivatedWordType__Delete__Click(object sender, EventArgs e)
		{
			if (this.Current__DerivatingWordType_DerivatedWordType == null || this.Current__DerivatingWordType_DerivatedWordType.RowState == DataRowState.Detached)
			{
				MessageBox.Show("There is no selected link to delete.", "No selection", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			#region		has child Derivatings?

			int length = this.Current__DerivatingWordType_DerivatedWordType.GetDerivatingRows().Length;
			if (length > 0)
			{
				MessageBox.Show
				(
					"Deleting is not possible because this ('Derivating Word Type' x 'Derivated Word Type') is the parent of " +
					length.ToString() +
					" 'Derivating(s)'.",
					"Has child Derivating(s)",
					MessageBoxButtons.OK,
					MessageBoxIcon.Error
				);
				return;
			}

			#endregion	has child Derivatings?

			Form__DerivatingWordType_DerivatedWordType__CreateDelete form
				= new Form__DerivatingWordType_DerivatedWordType__CreateDelete(this, false);
			
			form.ShowDialog(this);
		}

		private void bindingSource__DerivatingWordType_DerivatedWordType__CurrentChanged(object sender, EventArgs e)
		{
			if (this.DoNotTriggerCurrentChangedEvent)
			{
				return;
			}

			if (this.BindingSource__DerivatingWordType_DerivatedWordType.Current == null)
			{
				this.Current__DerivatingWordType_DerivatedWordType = null;
				return;
			}

			DataRow guiDataRow 
				= 
				(
					(DataRowView)
					(this.BindingSource__DerivatingWordType_DerivatedWordType.Current)
				).Row;

			if (guiDataRow == null)
			{
				return;
			}

			this.Current__DerivatingWordType_DerivatedWordType 
				= this.DataSet.DerivatingWordType_DerivatedWordType
				.FindByDerivatingWordTypeIdDerivatedWordTypeId
				(
					this.guiTable__DerivatingWordType_DerivatedWordType.GetValue__DerivatingWordTypeId(guiDataRow),
					this.guiTable__DerivatingWordType_DerivatedWordType.GetValue__DerivatedWordTypeId(guiDataRow)
				);

			this.filteringExpression__DerivatingWordType_DerivatedWordType
				= "DerivatingWordTypeId = '"
				+ this.Current__DerivatingWordType_DerivatedWordType.DerivatingWordTypeId
				+ "' AND DerivatedWordTypeId = '"
				+ this.Current__DerivatingWordType_DerivatedWordType.DerivatedWordTypeId 
				+ "'";

			this.filter__Derivating_Language();
		}

		private void GuiTable__DerivatingWordType_DerivatedWordType__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			if (this.DoNotTriggerCurrentChangedEvent)
			{
				return;
			}

			if (e.Row.RowState == DataRowState.Detached || e.Row.RowState == DataRowState.Deleted)
			{
				return;
			}

			if (e.Row.RowState == DataRowState.Added)
			{
				#region		Current__DerivatingWordType_Language

				short derivatingWordTypeId 
					= this.guiTable__DerivatingWordType_DerivatedWordType
					.GetValue__DerivatingWordTypeId(e.Row);

				if (derivatingWordTypeId != this.Current__DerivatingWordType.Id)
				{
					this.Current__DerivatingWordType_Language 
						= this.DataSet.DerivatingWordType_Language
						.FindByDerivatingWordTypeIdLanguageCode
						(
							derivatingWordTypeId, 
							this.Current__Language.Code
						);

					this.Current__DerivatingWordType
						= this.Current__DerivatingWordType_Language
						.DerivatingWordTypeRowParent;

					
					MainForm.FocusGridRow
					(
						this.bindingSource__DerivatingWordType_Language,
						this.Current__DerivatingWordType_Language
					);
				}

				#endregion	Current__DerivatingWordType_Language
				#region		Current__DerivatedWordType_Language
					
				short derivatedWordTypeId 
					= this.guiTable__DerivatingWordType_DerivatedWordType
					.GetValue__DerivatedWordTypeId(e.Row);

				if (derivatedWordTypeId != this.Current__DerivatedWordType.Id)
				{
					this.Current__DerivatedWordType_Language 
						= this.DataSet.DerivatedWordType_Language
						.FindByDerivatedWordTypeIdLanguageCode
						(
							derivatedWordTypeId,
							this.Current__Language.Code
						);

					this.Current__DerivatedWordType
						= this.Current__DerivatedWordType_Language
						.DerivatedWordTypeRowParent;

					
					MainForm.FocusGridRow
					(
						this.bindingSource__DerivatedWordType_Language,
						this.Current__DerivatedWordType_Language
					);
				}

				#endregion	Current__DerivatedWordType_Language

			}
		}
	}
}
