﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void treeView__Hierarchy__find__row__and__row_Language(BabebiDataSet.WordOrPatternRow wordOrPattern)
		{ 
			if (wordOrPattern.SubscriberCode == MainForm.SubscriberCode_Word)
			{
				this.Current__WordOrPattern__of__Word		= wordOrPattern;
				this.Current__Word							= this.DataSet.Word.FindById(this.Current__WordOrPattern__of__Word.SubscriberId);
				this.Current__Word_Language					= this.DataSet.Word_Language.FindByWordIdLanguageCode(this.Current__Word.Id, this.Current__Language.Code);

				this.populate__Word();
			}
			else if (wordOrPattern.SubscriberCode == MainForm.SubscriberCode_Pattern)
			{
				this.Current__WordOrPattern__of__Pattern	= wordOrPattern;
				this.Current__Pattern						= this.DataSet.Pattern.FindById(this.Current__WordOrPattern__of__Pattern.SubscriberId);
				this.Current__Pattern_Language				= this.DataSet.Pattern_Language.FindByPatternIdLanguageCode(this.Current__Pattern.Id, this.Current__Language.Code);

				this.populate__Pattern();
			}
			else
			{ 
				throw new NotImplementedException(wordOrPattern.SubscriberCode);
			}
		}
		
		private void treeView__Hierarchy__AfterSelect(object sender, TreeViewEventArgs e)
		{
			this.treeView__Hierarchy__AfterSelect(e.Node);
		}
		private void treeView__Hierarchy__AfterSelect(TreeNode treeNode)
		{
			treeNode.Nodes.Clear();

			/// on récupère le tag du tree view node clické.
			TreeViewNodeTag treeViewNodeTag = (TreeViewNodeTag)( treeNode.Tag );

			#region		where the prior Pattern or Word TabPage is synchronized.

			this.treeView__Hierarchy__find__row__and__row_Language(treeViewNodeTag.WordOrPattern);

			#endregion	where the prior Pattern or Word TabPage is synchronized.
			#region		where the TreeView is built.

			List<ThreeControlLine> threeControlLines = new List<ThreeControlLine>();

			/// on construit ses enfants.
			TreeViewNodeTag[] childTreeViewNodeTags = treeViewNodeTag.GetChildren();

			int lineId = -1;
			foreach (TreeViewNodeTag childTreeViewNodeTag in childTreeViewNodeTags)
			{ 
				lineId++;

				TreeNode childTreeNode = new TreeNode( childTreeViewNodeTag.GetLabel() );

				childTreeNode.Tag = childTreeViewNodeTag;

				treeNode.Nodes.Add(childTreeNode);

				if (childTreeViewNodeTag is TreeViewNodeTag__WordOrPattern childTreeViewNodeTag__WordOrPattern)
				{
					short guiHorizontalShift = 0;
					if (childTreeViewNodeTag__WordOrPattern is TreeViewNodeTag__WordFromPattern childTreeViewNodeTag__WordFromPattern)
					{
						guiHorizontalShift
							= childTreeViewNodeTag__WordFromPattern
							.WordFromPattern
							.FromPatternRowParent
							.GuiHorizontalShift;
					}
					else if (childTreeViewNodeTag__WordOrPattern is TreeViewNodeTag__PatternFromPattern childTreeViewNodeTag__PatternFromPattern)
					{ 
						guiHorizontalShift
							= childTreeViewNodeTag__PatternFromPattern
							.PatternFromPattern
							.FromPatternRowParent
							.GuiHorizontalShift;
					}

					ThreeControlLine threeControlLine = new ThreeControlLine
						(
							this.splitContainer__Hierarchy.Panel2,
							lineId,
							childTreeViewNodeTag__WordOrPattern.GetBuildingString(),
							childTreeViewNodeTag__WordOrPattern.GetUniqueKeyString(),
							childTreeViewNodeTag__WordOrPattern.GetMeaning(),
							guiHorizontalShift
						);
					
					threeControlLines.Add(threeControlLine);
					///this.hierarchyLines.Add(threeControlLine);
				}
			}

			#region		le panel 2 

			if (threeControlLines.Count > 0)
			{
				this.treeView__Hierarchy__Clear_____HierarchyPanelFromTextBoxes();

				this.hierarchyLines = threeControlLines;

				this.treeView__Hierarchy__populate__HierarchyPanelWithTextBoxes();
			}
			else
			{
				TreeNode parentTreeNode = treeNode.Parent;

				TreeViewNodeTag parentTreeViewNodeTag = (TreeViewNodeTag)( parentTreeNode.Tag );

				childTreeViewNodeTags = parentTreeViewNodeTag.GetChildren();

				lineId = -1;
				foreach (TreeViewNodeTag childTreeViewNodeTag in childTreeViewNodeTags)
				{ 
					lineId++;

					if (childTreeViewNodeTag is TreeViewNodeTag__WordOrPattern childTreeViewNodeTag__WordOrPattern)
					{
						short guiHorizontalShift = 0;
						if (childTreeViewNodeTag__WordOrPattern is TreeViewNodeTag__WordFromPattern childTreeViewNodeTag__WordFromPattern)
						{
							guiHorizontalShift
								= childTreeViewNodeTag__WordFromPattern
								.WordFromPattern
								.FromPatternRowParent
								.GuiHorizontalShift;
						}
						else if (childTreeViewNodeTag__WordOrPattern is TreeViewNodeTag__PatternFromPattern childTreeViewNodeTag__PatternFromPattern)
						{ 
							guiHorizontalShift
								= childTreeViewNodeTag__PatternFromPattern
								.PatternFromPattern
								.FromPatternRowParent
								.GuiHorizontalShift;
						}

						ThreeControlLine threeControlLine = new ThreeControlLine
							(
								this.splitContainer__Hierarchy.Panel2,
								lineId,
								childTreeViewNodeTag__WordOrPattern.GetBuildingString(),
								childTreeViewNodeTag__WordOrPattern.GetUniqueKeyString(),
								childTreeViewNodeTag__WordOrPattern.GetMeaning(),
								guiHorizontalShift
							);
					
						threeControlLines.Add(threeControlLine);
					}
				}

				this.treeView__Hierarchy__Clear_____HierarchyPanelFromTextBoxes();

				this.hierarchyLines = threeControlLines;

				this.treeView__Hierarchy__populate__HierarchyPanelWithTextBoxes();
			}

			#endregion	le panel 2

			#endregion	where the TreeView is built.
		}


		private List<ThreeControlLine> hierarchyLines = new List<ThreeControlLine>();

		private void treeView__Hierarchy__Clear_____HierarchyPanelFromTextBoxes()
		{
			this.tabControl__Main.SuspendLayout();
			this.tabPage__Hierarchy.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.splitContainer__Hierarchy)).BeginInit();
			this.splitContainer__Hierarchy.Panel1.SuspendLayout();
			this.splitContainer__Hierarchy.Panel2.SuspendLayout();
			this.splitContainer__Hierarchy.SuspendLayout();
			this.SuspendLayout();

			foreach (ThreeControlLine hierarchyLine in this.hierarchyLines)
			{
				hierarchyLine.Remove_TextBoxes();
			}

			foreach (ThreeControlLine hierarchyLine in this.hierarchyLines)
			{
				hierarchyLine.Dispose();
			}

			this.hierarchyLines.Clear();

			bool resumeLayoutArgument = false;

			this.ResumeLayout(resumeLayoutArgument);
			this.tabPage__Hierarchy.ResumeLayout(resumeLayoutArgument);
			this.splitContainer__Hierarchy.Panel1.ResumeLayout(resumeLayoutArgument);
			this.splitContainer__Hierarchy.Panel2.ResumeLayout(resumeLayoutArgument);
			this.splitContainer__Hierarchy.Panel2.PerformLayout();
			((System.ComponentModel.ISupportInitialize)(this.splitContainer__Hierarchy)).EndInit();
			this.splitContainer__Hierarchy.ResumeLayout(resumeLayoutArgument);
		}

		private void treeView__Hierarchy__populate__HierarchyPanelWithTextBoxes()
		{
			this.SuspendLayout();
			this.tabControl__Main.SuspendLayout();
			this.tabPage__Hierarchy.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.splitContainer__Hierarchy)).BeginInit();
			this.splitContainer__Hierarchy.Panel1.SuspendLayout();
			this.splitContainer__Hierarchy.Panel2.SuspendLayout();
			this.splitContainer__Hierarchy.SuspendLayout();

			foreach (ThreeControlLine hierarchyLine in this.hierarchyLines)
			{
				hierarchyLine.New_TextBoxes();
			}

			foreach (ThreeControlLine hierarchyLine in this.hierarchyLines)
			{
				hierarchyLine.Define_TextBoxes();
			}

			foreach (ThreeControlLine hierarchyLine in this.hierarchyLines)
			{
				hierarchyLine.Add_TextBoxes();
			}

			bool resumeLayoutArgument = false;

			this.ResumeLayout(resumeLayoutArgument);
			this.tabPage__Hierarchy.ResumeLayout(resumeLayoutArgument);
			this.splitContainer__Hierarchy.Panel1.ResumeLayout(resumeLayoutArgument);
			this.splitContainer__Hierarchy.Panel2.ResumeLayout(resumeLayoutArgument);
			this.splitContainer__Hierarchy.Panel2.PerformLayout();
			((System.ComponentModel.ISupportInitialize)(this.splitContainer__Hierarchy)).EndInit();
			this.splitContainer__Hierarchy.ResumeLayout(resumeLayoutArgument);
		}
	}

	internal class ThreeControlLine : IDisposable
	{
		#region		(controls)

		internal SplitterPanel SplitterPanel;

		internal TextBox TextBox__BuildingString;
		internal TextBox TextBox__UniqueKeyString;
		internal TextBox TextBox__Meaning;

		#endregion	(controls)
		#region		(data)

		/// <summary>
		/// 0-based.
		/// </summary>
		internal int LineId;

		internal string Value__BuildingString;
		internal string Value__UniqueKeyString;
		internal string Value__Meaning;

		internal short GuiHorizontalIndex;

		#endregion	(data)
		#region		(design constants)

		private int panelWidth
		{
			get { return this.SplitterPanel.Width; }
		}
		private int panelWidthDividedBy5
		{
			get { return this.SplitterPanel.Width / 5; }
		}

		#endregion	(design constants)


		internal ThreeControlLine
		(
			SplitterPanel splitterPanel, 
			int lineId, 
			string buildingString, 
			string uniqueKeyString, 
			string meaning, 
			short guiHorizontalIndex
		)
		{
			this.SplitterPanel = splitterPanel;

			this.LineId = lineId;

			this.Value__BuildingString	= buildingString;
			this.Value__UniqueKeyString	= uniqueKeyString;
			this.Value__Meaning			= meaning;

			this.GuiHorizontalIndex = guiHorizontalIndex;
		}

		internal void New_TextBoxes()
		{
			this.TextBox__BuildingString	= new TextBox();
			this.TextBox__UniqueKeyString	= new TextBox();
			this.TextBox__Meaning			= new TextBox();

			this.TextBox__BuildingString	.Visible = false;
			this.TextBox__UniqueKeyString	.Visible = false;
			this.TextBox__Meaning			.Visible = false;

			this.TextBox__BuildingString	.SuspendLayout();
			this.TextBox__UniqueKeyString	.SuspendLayout();
			this.TextBox__Meaning			.SuspendLayout();
		}

		internal void Add_TextBoxes()
		{
			this.SplitterPanel.Controls.Add(this.TextBox__BuildingString);
			this.SplitterPanel.Controls.Add(this.TextBox__UniqueKeyString);
			this.SplitterPanel.Controls.Add(this.TextBox__Meaning);
		}

		internal void Remove_TextBoxes()
		{
			this.SplitterPanel.Controls.Remove(this.TextBox__BuildingString);
			this.SplitterPanel.Controls.Remove(this.TextBox__UniqueKeyString);
			this.SplitterPanel.Controls.Remove(this.TextBox__Meaning);
		}

		internal void Define_TextBoxes()
		{
			String endOfControlName = "__" + this.LineId.ToString();

			int tabIndex_of_the_line = 3 * this.LineId;

			int y = 12 + 30 * this.LineId;

			int x__BuildingString;
			int w__BuildingString;

			int x__UniqueKeyString;
			int w__UniqueKeyString;

			int x__Meaning;
			int w__Meaning;			

			/// 10 + 600 + 10 + 300 + 10 + FILL + 10.

			x__BuildingString =							   10 + this.GuiHorizontalIndex * 30;
			w__BuildingString = this.panelWidthDividedBy5 * 2 - this.GuiHorizontalIndex * 30 - 10 - 5;

			x__UniqueKeyString = this.panelWidthDividedBy5 * 2  + 5;
			w__UniqueKeyString = this.panelWidthDividedBy5 - 10 ;

			x__Meaning = this.panelWidthDividedBy5 * 3 + 5;
			w__Meaning = this.panelWidthDividedBy5 * 2 - 5 - 10;

			#region		BuildingString

			this.TextBox__BuildingString.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.875F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.TextBox__BuildingString.Location = new System.Drawing.Point(x__BuildingString, y);
			this.TextBox__BuildingString.Name = "textBox__Hierarchy__BuildingString" + endOfControlName;
			this.TextBox__BuildingString.ReadOnly = true;
			this.TextBox__BuildingString.Size = new System.Drawing.Size(w__BuildingString, 23);
			this.TextBox__BuildingString.TabIndex = tabIndex_of_the_line;
			this.TextBox__BuildingString.TextAlign = System.Windows.Forms.HorizontalAlignment.Left;
			this.TextBox__BuildingString.Text = this.Value__BuildingString;

			#endregion	BuildingString
			#region		UniqueKeyString

			tabIndex_of_the_line++;

			this.TextBox__UniqueKeyString.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.875F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.TextBox__UniqueKeyString.ForeColor = System.Drawing.Color.Blue;
			this.TextBox__UniqueKeyString.Location = new System.Drawing.Point(x__UniqueKeyString, y);
			this.TextBox__UniqueKeyString.Name = "textBox__Hierarchy__String" + endOfControlName;
			this.TextBox__UniqueKeyString.ReadOnly = true;
			this.TextBox__UniqueKeyString.Size = new System.Drawing.Size(w__UniqueKeyString, 23);
			this.TextBox__UniqueKeyString.TabIndex = tabIndex_of_the_line;
			this.TextBox__UniqueKeyString.Text = this.Value__UniqueKeyString;
			this.TextBox__UniqueKeyString.TextAlign = HorizontalAlignment.Right;

			#endregion	UniqueKeyString
			#region		Meaning

			tabIndex_of_the_line++;

			this.TextBox__Meaning.Location = new System.Drawing.Point(x__Meaning, y);
			this.TextBox__Meaning.Name = "textBox__Hierarchy__Meaning" + endOfControlName;
			this.TextBox__Meaning.ReadOnly = true;
			this.TextBox__Meaning.Size = new System.Drawing.Size(w__Meaning, 23);
			this.TextBox__Meaning.TabIndex = tabIndex_of_the_line;
			this.TextBox__Meaning.Text = this.Value__Meaning;

			#endregion	Meaning

			bool resumeLayoutArgument = false;

			this.TextBox__BuildingString	.ResumeLayout(resumeLayoutArgument);
			this.TextBox__UniqueKeyString	.ResumeLayout(resumeLayoutArgument);
			this.TextBox__Meaning			.ResumeLayout(resumeLayoutArgument);

			this.TextBox__BuildingString	.Visible = true;
			this.TextBox__UniqueKeyString	.Visible = true;
			this.TextBox__Meaning			.Visible = true;

		}

		public void Dispose()
		{
			this.SplitterPanel = null;

			this.LineId = -1;

			this.Value__BuildingString	= null;
			this.Value__UniqueKeyString	= null;
			this.Value__Meaning			= null;

			this.GuiHorizontalIndex = -1;

			if (this.TextBox__BuildingString != null)
			{
				this.TextBox__BuildingString.Dispose();
			}
			if (this.TextBox__UniqueKeyString != null)
			{
				this.TextBox__UniqueKeyString.Dispose();
			}
			if (this.TextBox__Meaning != null)
			{
				this.TextBox__Meaning.Dispose();
			}

			this.TextBox__BuildingString	= null;
			this.TextBox__UniqueKeyString	= null;
			this.TextBox__Meaning			= null;
		}
	}
}