﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void button__LanguageWord__Find__Click(object sender, EventArgs e)
		{
			Form__LanguageWord__Find form__languageWord__Find = new Form__LanguageWord__Find(this);

			DialogResult dialogResult = form__languageWord__Find.ShowDialog(this);

			if (dialogResult == DialogResult.OK)
			{
				this.textBox__LanguageWord__String.Text = this.Current__LanguageWord.String;

				this.filter__Word_LanguageWord__of__LanguageWord();
			}
		}

		private void button__LanguageWord__Create__Click(object sender, EventArgs e)
		{
			Form__LanguageWord__Create form__languageWord__Create = new Form__LanguageWord__Create(this);

			if (form__languageWord__Create.ShowDialog(this) == DialogResult.OK)
			{
				this.populate__LanguageWord();
			}
		}

		private void button__LanguageWord__Update__Click(object sender, EventArgs e)
		{
			if (this.Current__LanguageWord != null)
			{
				Form__LanguageWord__Update form__languageWord__Update = new Form__LanguageWord__Update(this);

				if (form__languageWord__Update.ShowDialog(this) == DialogResult.OK)
				{
					this.textBox__LanguageWord__String.Text = this.Current__LanguageWord.String;

					this.filter__Word_LanguageWord__of__LanguageWord();
				}
			}
		}

		private void button__LanguageWord__Delete__Click(object sender, EventArgs e)
		{
			if (this.Current__LanguageWord == null || this.Current__LanguageWord.RowState == DataRowState.Deleted  || this.Current__LanguageWord.RowState == DataRowState.Detached)
			{
				MessageBox.Show("There is no 'Language Word' to delete.", "Empty", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return; 
			}

			BabebiDataSet.Word_LanguageWordRow[] word_LanguageWords = this.Current__LanguageWord.GetWord_LanguageWordRows();

			int length = word_LanguageWords.Length;
			if (length > 0)
			{
				BabebiDataSet.Word_LanguageWordRow word_LanguageWord = word_LanguageWords.First();

				string errorMessage;
				if (length == 1)
				{
					errorMessage 
						= "Deleting is not possible because this 'Language Word' is linked to the Word : " 
						+ word_LanguageWord.Word_LanguageRowParent.WordUniqueKeyString + "'.";
				}
				else
				{ 
					errorMessage 
						= "Deleting is not possible because this 'Language Word' is linked to several Words including : " 
						+ word_LanguageWord.Word_LanguageRowParent.WordUniqueKeyString + "'.";
				}

				MessageBox.Show
				(
					errorMessage,
					"Already linked",
					MessageBoxButtons.OK,
					MessageBoxIcon.Error
				);

				return; 
			}

			DialogResult dialogResult 
				= MessageBox.Show
				(
					"Do you really want to delete the 'Language Word' : [" + 
					this.Current__LanguageWord.String +
					"].",
					"Deleting", 
					MessageBoxButtons.YesNo, 
					MessageBoxIcon.Question
				);
			if (dialogResult == DialogResult.No)
			{
				return;
			}

			this.DataSet.LanguageWord.RemoveLanguageWordRow(this.Current__LanguageWord);

			this.textBox__LanguageWord__String.Text = null;
		}

		private void filter__LanguageWord()
		{
			if (this.Current__Language != null)
			{
				if (this.Current__LanguageWord != null)
				{
					string priorLanguageCode		= this.Current__LanguageWord.LanguageCode;
					string priorLanguageWordString	= this.Current__LanguageWord.String;

					BabebiDataSet.LanguageWordRow hypotheticalLanguageWord = null;
					if (!priorLanguageWordString.StartsWith("**"))
					{
						string hypotheticalLanguageWordString = "**" + priorLanguageCode + "**" + priorLanguageWordString;

						hypotheticalLanguageWord
							= this.DataSet.LanguageWord
							.FindByLanguageCodeString
							(
								this.Current__Language.Code,
								hypotheticalLanguageWordString
							);
					}
					else if (hypotheticalLanguageWord == null)
					{
						hypotheticalLanguageWord
							= this.DataSet.LanguageWord
							.FindByLanguageCodeString
							(
								this.Current__Language.Code,
								priorLanguageWordString
							);

						if (hypotheticalLanguageWord == null)
						{
							string item_LanguageCode = priorLanguageWordString.Substring(2, 2);
							string item_LanguageWordString = priorLanguageWordString.Substring(6);

							if (this.Current__Language.Code == item_LanguageCode)
							{
								hypotheticalLanguageWord
								= this.DataSet.LanguageWord
								.FindByLanguageCodeString
								(
									this.Current__Language.Code,
									item_LanguageWordString
								);
							}
						}
					}
					else if (hypotheticalLanguageWord == null)
					{
						BabebiDataSet.Word_LanguageWordRow[] word_languageWords = this.Current__LanguageWord.GetWord_LanguageWordRows();

						if (word_languageWords.Length == 1)
						{
							BabebiDataSet.WordRow word 
								= ((BabebiDataSet.Word_LanguageWordRow)(word_languageWords[0])).Word_LanguageRowParent.WordRowParent;

							BabebiDataSet.Word_LanguageRow hypotheticalWord_Language
								= this.DataSet.Word_Language
								.FindByWordIdLanguageCode
								(
									word.Id,
									this.Current__Language.Code
								);

							if (hypotheticalWord_Language != null)	// il n'a pas été éffacé...
							{
								// réutilsation
								word_languageWords = hypotheticalWord_Language.GetWord_LanguageWordRows();

								if (word_languageWords.Length == 1)
								{
									// surement pas trop mauvais...
									hypotheticalLanguageWord = word_languageWords[0].LanguageWordRowParent;
								}
							}
						}
					}

					if (hypotheticalLanguageWord != null)
					{
						this.Current__LanguageWord = hypotheticalLanguageWord;

						this.textBox__LanguageWord__String.Text = this.Current__LanguageWord.String;
					}
					else
					{
						this.Current__LanguageWord = null;

						this.textBox__LanguageWord__String.Text = null;
					}
				}
				this.filter__Word_LanguageWord__of__LanguageWord();
			}
			else
			{
				/// tout doit déjà être propre.
			}
		}

		private void populate__LanguageWord()
		{
			if (this.Current__LanguageWord != null)
			{
				this.textBox__LanguageWord__String.Text = this.Current__LanguageWord.String;
			}
			else
			{ 
				this.textBox__LanguageWord__String.Text = null;
			}

			this.filter__Word_LanguageWord__of__LanguageWord();
		}
	}
}
/*
  		private void bindingSource__LanguageWord__CurrentChanged(object sender, EventArgs e)
		{
			if (this.DoNotTriggerCurrentChangedEvent)
			{
				return;
			}

			if (this.bindingSource__Word_Language.Current != null)
			{
				this.Current__Word_Language
					=
					(BabebiDataSet.Word_LanguageRow)
					(((DataRowView)(this.bindingSource__Word_Language.Current)).Row);

				this.Current__Word = this.Current__Word_Language.WordRowParent;
			}
		}
*/