﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void remove__PatternByInsertion()
		{
			///	Where we delete or not the parent LetterOrSymbolCluster.
			if (this.Current__PatternByInsertion.LetterOrSymbolClusterRow.GetPatternByInsertionRows().Length == 1)
			{
				/// Le LetterOrSymbolCluster parent n'est utilisé que pour cet PatternByInsertion qui doit disparaitre
				/// => il faut le supprimer. MAIS... à cause du DeleteCascade la row PatternByInsertion va disparaitre
				/// dès que l'on va supprimer la row parente LetterOrSymbolCluster. 
				/// 
				/// Les rows-enfants LetterOrSymbolClusterLetterOrSymbol vont aussi être délétées par cascade.

				this.DataSet.LetterOrSymbolCluster.RemoveLetterOrSymbolClusterRow(this.Current__PatternByInsertion.LetterOrSymbolClusterRow);
			}
			else
			{
				/// on ne supprime donc que la row du Mode ByInsertion.

				this.DataSet.PatternByInsertion.RemovePatternByInsertionRow(this.Current__PatternByInsertion);
			}

			this.Current__Pattern.ModeCode = MainForm.ModeCode_NotDefined;

			this.Populate__PatternByInsertion(PopulatingType.Cleaning);
		}

		internal void Populate__PatternByInsertion(PopulatingType populatingType)
		{
			if (populatingType == PopulatingType.Cleaning)
			{
				this.Current__PatternByInsertion								= null;
				this.Current__WordOrPattern__of__PatternByInsertion__Parent		= null;
				this.Current__Pattern__of__PatternByInsertion__Parent			= null;		/// si Pattern
				this.Current__Pattern_Language__of__PatternByInsertion__Parent	= null;		/// si Pattern
				this.Current__Word__of__PatternByInsertion__Parent				= null;		/// si Word
				this.Current__Word_Language__of__PatternByInsertion__Parent		= null;		/// si Word
 
				this.textBox__Pattern__ByInsertion__ParentSubscriberName		.Text = null;
				this.textBox__Pattern__ByInsertion__ParentUniqueKeyString		.Text = null;
				this.textBox__Pattern__ByInsertion__ParentMeaning				.Text = null;
				this.textBox__Pattern__ByInsertion__ParentId					.Text = null;
				this.textBox__Pattern__ByInsertion__InsertionIndex				.Text = null;
				this.textBox__Pattern__ByInsertion__LetterOrSymbolClusterString	.Text = null;
			}
			else
			{
				string parentUniqueKeyString;
				string parentMeaning;

				if (populatingType == PopulatingType.FindingRowsAndSettingFields)
				{
					this.Current__PatternByInsertion
						= this.DataSet.PatternByInsertion
						.FindById(this.Current__Pattern.Id);

					this.Current__WordOrPattern__of__PatternByInsertion__Parent
						= this.Current__PatternByInsertion
						.WordOrPatternRowParent;

					this.GetWordOrPatternPackage
					(
						this.Current__WordOrPattern__of__PatternByInsertion__Parent.SubscriberCode,
						this.Current__WordOrPattern__of__PatternByInsertion__Parent.SubscriberId,
						out parentUniqueKeyString,
						out parentMeaning,
						ref this.Current__WordOrPattern__of__PatternByInsertion__Parent,
						ref this.Current__Pattern__of__PatternByInsertion__Parent,
						ref this.Current__Pattern_Language__of__PatternByInsertion__Parent,
						ref this.Current__Word__of__PatternByInsertion__Parent,
						ref this.Current__Word_Language__of__PatternByInsertion__Parent,
						false, false, true
					);
				}
				else
				{ 
					/// appeler juste pour les 2 outs.
					this.GetWordOrPatternPackage
					(
						this.Current__WordOrPattern__of__PatternByInsertion__Parent.SubscriberCode,
						this.Current__WordOrPattern__of__PatternByInsertion__Parent.SubscriberId,
						out parentUniqueKeyString,
						out parentMeaning,
						ref this.Current__WordOrPattern__of__PatternByInsertion__Parent,
						ref this.Current__Pattern__of__PatternByInsertion__Parent,
						ref this.Current__Pattern_Language__of__PatternByInsertion__Parent,
						ref this.Current__Word__of__PatternByInsertion__Parent,
						ref this.Current__Word_Language__of__PatternByInsertion__Parent,
						false, false, true
					);
				}

				string parentIdString;
				string parentSubscriberName;
				string insertionIndexString;
				string letterOrSymbolClusterString;

				parentIdString 
					= this.Current__WordOrPattern__of__PatternByInsertion__Parent.SubscriberId
					.ToString();

				parentSubscriberName 
					= MainForm.Convert__Code__into__ComboBoxSelectedItem__WordOrPattern
					(this.Current__WordOrPattern__of__PatternByInsertion__Parent.SubscriberCode);

				insertionIndexString
					= Convert__InsertionIndex__into__ComboBoxSelectedItem
					(
						this.Current__PatternByInsertion.InsertionIndex
					);
				
				letterOrSymbolClusterString 
					= this.Current__PatternByInsertion
					.LetterOrSymbolClusterRow
					.String;

				this.textBox__Pattern__ByInsertion__ParentSubscriberName		.Text = parentSubscriberName;
				this.textBox__Pattern__ByInsertion__ParentId					.Text = parentIdString;
				this.textBox__Pattern__ByInsertion__ParentUniqueKeyString		.Text = parentUniqueKeyString;
				this.textBox__Pattern__ByInsertion__ParentMeaning				.Text = parentMeaning;
				this.textBox__Pattern__ByInsertion__InsertionIndex				.Text = insertionIndexString;
				this.textBox__Pattern__ByInsertion__LetterOrSymbolClusterString	.Text = letterOrSymbolClusterString;
			}
		}

		private void button__Pattern__ByInsertion__CreateUpdate__Click(object sender, EventArgs e)
		{
			this.button__Pattern__ByInsertion__CreateUpdate__Click();
		}
		private void button__Pattern__ByInsertion__CreateUpdate__Click()
		{
			Form__PatternByInsertion__CreateUpdate form = new Form__PatternByInsertion__CreateUpdate(this);

			if (form.ShowDialog() == DialogResult.Cancel)
			{
				this.populate__Pattern();

				return;
			}
		}

		private void button__Pattern__ByInsertion__FocusParent__Click(object sender, EventArgs e)
		{
			string subsriberName = (string)(this.textBox__Pattern__ByInsertion__ParentSubscriberName.Text);

			switch (subsriberName)
			{
				case MainForm.SubscriberName_Pattern:
				{
					this.Current__WordOrPattern__of__Pattern	= this.Current__WordOrPattern__of__PatternByInsertion__Parent;
					this.Current__Pattern						= this.Current__Pattern__of__PatternByInsertion__Parent;
					this.Current__Pattern_Language				= this.Current__Pattern_Language__of__PatternByInsertion__Parent;

					this.populate__Pattern();

					break;
				}
				case MainForm.SubscriberName_Word:
				{
					this.Current__WordOrPattern__of__Word	= this.Current__WordOrPattern__of__PatternByInsertion__Parent;
					this.Current__Word						= this.Current__Word__of__PatternByInsertion__Parent;
					this.Current__Word_Language				= this.Current__Word_Language__of__PatternByInsertion__Parent;

					this.populate__Word();

					this.tabControl__Main.SelectedTab = this.tabPage__Word;

					break;
				}
				default:
				{
					throw new NotImplementedException();
				}
			}
		}

		private void button__Pattern__ByInsertion__Restore__Click(object sender, EventArgs e)
		{
		//	this.populate__Pattern__ByInsertion();
		}

		#region		functions

		internal void textBox__LetterOrSymbolClusterString__TextChanged
		(
			TextBox_WEM								textBox_WEM__LetterOrSymbolClusterString,
		ref BabebiDataSet.LetterOrSymbolClusterRow	selected__LetterOrSymbolCluster,
			List<BabebiDataSet.LetterOrSymbolRow>	letterOrSymbolList
		)
		{
			string letterOrSymbolClusterString = textBox_WEM__LetterOrSymbolClusterString.Text();

			if (string.IsNullOrEmpty(letterOrSymbolClusterString))
			{
				textBox_WEM__LetterOrSymbolClusterString
				.SetError
				(
					"The 'Letter or Symbol Cluster' string can not be empty.",
					"Empty 'Letter or Symbol Cluster'"
				);

				return;
			}

			letterOrSymbolList.Clear();

			DataRow[] letterOrSymbolClusterldataRows 
				= this.DataSet.LetterOrSymbolCluster
				.Select("String = '" + letterOrSymbolClusterString + "'");

			if (letterOrSymbolClusterldataRows.Length == 0)
			{
				/// check if the LetterCluster string only contains valid Letters
				string errorCharString
					= this.Split_a_string_into_LetterOrSymbols
					(
						letterOrSymbolClusterString,
						letterOrSymbolList
					);

				if (errorCharString != null)
				{
					textBox_WEM__LetterOrSymbolClusterString
					.SetError
					(
						"The 'Letter Cluster' string contains an invalid character = '" + errorCharString + "'.",
						"Invalid character"
					);
				}
				else
				{
					selected__LetterOrSymbolCluster = null;    /// it will be created while click the UPDATE button.

					/// et dans ce cas on aura besoin de la LetterList.

					textBox_WEM__LetterOrSymbolClusterString.ClearError();
				}
			}
			else if (letterOrSymbolClusterldataRows.Length == 1)
			{
				selected__LetterOrSymbolCluster 
					= 
					(BabebiDataSet.LetterOrSymbolClusterRow)
					(letterOrSymbolClusterldataRows[0]);

				/// Dans ce cas on n'aura pas besoin de la LetterList.

				textBox_WEM__LetterOrSymbolClusterString.ClearError();
			}
			else
			{
				throw new Exception(letterOrSymbolClusterldataRows.Length.ToString());
			}

		}

		#endregion	functions

	}
}