﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		/// utilisés (en bas) dans le tableau des PatternByInsertions du current Word (choisi en haut à gauche)
		internal BabebiDataSet.WordOrPatternRow			Current__WordOrPattern__of__PatternByInsertion__of__Current__Pattern = null;
		internal BabebiDataSet.PatternRow				Current__Pattern__of__PatternByInsertion__of__Current__Pattern = null;
		internal BabebiDataSet.PatternByInsertionRow	Current__PatternByInsertion__of__Current__Pattern = null;
		internal BabebiDataSet.Pattern_LanguageRow		Current__Pattern_Language__of__PatternByInsertion__of__Current__Pattern = null;

		private void bindingSource__PatternByInsertion__of__Current__Pattern__CurrentChanged(object sender, EventArgs e)
		{
			if (this.BindingSource__PatternByInsertion__of__Current__Pattern.Current != null)
			{
				DataRow guiDataRow
					=
					(
						(DataRowView)
						(this.BindingSource__PatternByInsertion__of__Current__Pattern.Current)
					).Row;
				
				int patternId 
					= this.guiTable__PatternByInsertion__of__Current__Pattern
					.GetValue__Id(guiDataRow);

				this.Current__PatternByInsertion__of__Current__Pattern
					= this.DataSet.PatternByInsertion
					.FindById(patternId);

				this.Current__Pattern__of__PatternByInsertion__of__Current__Pattern
					= this.Current__PatternByInsertion__of__Current__Pattern
					.PatternRowParent;

				this.Current__WordOrPattern__of__PatternByInsertion__of__Current__Pattern
					= this.Current__Pattern__of__PatternByInsertion__of__Current__Pattern
					.WordOrPatternRowParent;

				this.Current__Pattern_Language__of__PatternByInsertion__of__Current__Pattern
					= this.DataSet
					.Pattern_Language
					.FindByPatternIdLanguageCode
					(
						this.Current__Pattern__of__PatternByInsertion__of__Current__Pattern.Id,
						this.Current__Language.Code
					);

				this.button__PatternByInsertion__of__Current__Pattern__Update.Visible = true;
				this.button__PatternByInsertion__of__Current__Pattern__Focus.Visible = true;
				this.button__PatternByInsertion__of__Current__Pattern__Delete.Visible = true;
			}
			else
			{ 
				this.Current__PatternByInsertion__of__Current__Pattern = null;
				this.Current__Pattern__of__PatternByInsertion__of__Current__Pattern = null;
				this.Current__WordOrPattern__of__PatternByInsertion__of__Current__Pattern = null;
				this.Current__Pattern_Language__of__PatternByInsertion__of__Current__Pattern = null;

				this.button__PatternByInsertion__of__Current__Pattern__Update.Visible = false;
				this.button__PatternByInsertion__of__Current__Pattern__Focus.Visible = false;
				this.button__PatternByInsertion__of__Current__Pattern__Delete.Visible = false;
			}
		}

		private void populate__PatternByInsertion__of__Current__Pattern()
		{
			bool? has1RowAtLeast = this.guiTable__PatternByInsertion__of__Current__Pattern.Populate();

			if (has1RowAtLeast.HasValue && has1RowAtLeast.Value)
			{
				this.button__PatternByInsertion__of__Current__Pattern__Update.Visible = true;
				this.button__PatternByInsertion__of__Current__Pattern__Focus.Visible = true;
				this.button__PatternByInsertion__of__Current__Pattern__Delete.Visible = true;
			}
			else if (has1RowAtLeast.HasValue && !has1RowAtLeast.Value)
			{
				this.button__PatternByInsertion__of__Current__Pattern__Update.Visible = false;
				this.button__PatternByInsertion__of__Current__Pattern__Focus.Visible = false;
				this.button__PatternByInsertion__of__Current__Pattern__Delete.Visible = false;
			}
			else
			{
				/// on ne touche à rien car l'état est mal géré...
			}
			
		}

		private void button__PatternByInsertion__of__Current__Pattern__Create__Click(object sender, EventArgs e)
		{
			Form__PatternByInsertion__of__Current__Pattern__CreateUpdate form 
				= new Form__PatternByInsertion__of__Current__Pattern__CreateUpdate(this, true);

			DialogResult dialogResult = form.ShowDialog();

			if (dialogResult == DialogResult.OK)
			{
				DataRow focusedGuiDataRow
					= this.guiTable__PatternByInsertion__of__Current__Pattern
					.Find(this.Current__PatternByInsertion__of__Current__Pattern.Id);

				FocusGridRow(this.BindingSource__PatternByInsertion__of__Current__Pattern, focusedGuiDataRow);
			}

		}

		private void button__PatternByInsertion__of__Current__Pattern__Update__Click(object sender, EventArgs e)
		{
			Form__PatternByInsertion__of__Current__Pattern__CreateUpdate form 
				= new Form__PatternByInsertion__of__Current__Pattern__CreateUpdate(this, false);

			form.ShowDialog();
		}

		private void button__PatternByInsertion__of__Current__Pattern__Delete__Click(object sender, EventArgs e)
		{
			if (this.Current__PatternByInsertion__of__Current__Pattern == null)
			{
				MessageBox.Show("There is no 'Pattern (By insertion)' to delete.", "Empty", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return; 
			}

			DialogResult dialogResult 
				= MessageBox.Show
				(
					"Do you really want to delete the 'Pattern (By insertion)' (" + 
					this.Current__PatternByInsertion__of__Current__Pattern.PatternRowParent.UniqueKeyString +
					") ?",
					"Deleting", 
					MessageBoxButtons.YesNo, 
					MessageBoxIcon.Question
				);
			if (dialogResult == DialogResult.No)
			{
				return;
			}

			this.DeletePattern(this.Current__PatternByInsertion__of__Current__Pattern.PatternRowParent);
		}

		private void button__PatternByInsertion__of__Current__Pattern__Focus__Click(object sender, EventArgs e)
		{
			if (this.Current__PatternByInsertion__of__Current__Pattern == null)
			{
				return;
			}

			this.Current__Pattern = this.Current__PatternByInsertion__of__Current__Pattern.PatternRowParent;
			this.Current__WordOrPattern__of__Pattern = this.Current__Pattern.WordOrPatternRowParent;
			this.Current__Pattern_Language 
				= this.DataSet.Pattern_Language
				.FindByPatternIdLanguageCode
				(
					this.Current__Pattern.Id,
					this.Current__Language.Code
				);

			this.populate__Pattern();
		}
	}
}