﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		/// utilisés (en bas) dans le tableau des PatternByInsertions du current Word (choisi en haut à gauche)
		internal BabebiDataSet.WordOrPatternRow			Current__WordOrPattern__of__PatternByInsertion__of__Current__Word = null;
		internal BabebiDataSet.PatternRow				Current__Pattern__of__PatternByInsertion__of__Current__Word = null;
		internal BabebiDataSet.PatternByInsertionRow	Current__PatternByInsertion__of__Current__Word = null;
		internal BabebiDataSet.Pattern_LanguageRow		Current__Pattern_Language__of__PatternByInsertion__of__Current__Word = null;

		private void bindingSource__PatternByInsertion__of__Current__Word__CurrentChanged(object sender, EventArgs e)
		{
			if (this.BindingSource__PatternByInsertion__of__Current__Word.Current != null)
			{
				DataRow guiDataRow
					=
					(
						(DataRowView)
						(this.BindingSource__PatternByInsertion__of__Current__Word.Current)
					).Row;
				
				int patternId 
					= this.guiTable__PatternByInsertion__of__Current__Word
					.GetValue__Id(guiDataRow);

				this.Current__PatternByInsertion__of__Current__Word
					= this.DataSet.PatternByInsertion
					.FindById(patternId);

				this.Current__Pattern__of__PatternByInsertion__of__Current__Word
					= this.Current__PatternByInsertion__of__Current__Word
					.PatternRowParent;

				this.Current__WordOrPattern__of__PatternByInsertion__of__Current__Word
					= this.Current__Pattern__of__PatternByInsertion__of__Current__Word
					.WordOrPatternRowParent;

				this.Current__Pattern_Language__of__PatternByInsertion__of__Current__Word
					= this.DataSet
					.Pattern_Language
					.FindByPatternIdLanguageCode
					(
						this.Current__Pattern__of__PatternByInsertion__of__Current__Word.Id,
						this.Current__Language.Code
					);

				this.button__PatternByInsertion__of__Current__Word__Update.Visible = true;
				this.button__PatternByInsertion__of__Current__Word__Focus.Visible = true;
				this.button__PatternByInsertion__of__Current__Word__Delete.Visible = true;
			}
			else
			{ 
				this.Current__PatternByInsertion__of__Current__Word = null;
				this.Current__Pattern__of__PatternByInsertion__of__Current__Word = null;
				this.Current__WordOrPattern__of__PatternByInsertion__of__Current__Word = null;
				this.Current__Pattern_Language__of__PatternByInsertion__of__Current__Word = null;

				this.button__PatternByInsertion__of__Current__Word__Update.Visible = false;
				this.button__PatternByInsertion__of__Current__Word__Focus.Visible = false;
				this.button__PatternByInsertion__of__Current__Word__Delete.Visible = false;
			}
		}

		private void populate__PatternByInsertion__of__Current__Word()
		{
			bool? has1RowAtLeast = this.guiTable__PatternByInsertion__of__Current__Word.Populate();

			if (has1RowAtLeast.HasValue && has1RowAtLeast.Value)
			{
				this.button__PatternByInsertion__of__Current__Word__Update.Visible = true;
				this.button__PatternByInsertion__of__Current__Word__Focus.Visible = true;
				this.button__PatternByInsertion__of__Current__Word__Delete.Visible = true;
			}
			else if (has1RowAtLeast.HasValue && !has1RowAtLeast.Value)
			{
				this.button__PatternByInsertion__of__Current__Word__Update.Visible = false;
				this.button__PatternByInsertion__of__Current__Word__Focus.Visible = false;
				this.button__PatternByInsertion__of__Current__Word__Delete.Visible = false;
			}
			else
			{
				/// on ne touche à rien car l'état est mal géré...
			}
			
		}

		private void button__PatternByInsertion__of__Current__Word__Create__Click(object sender, EventArgs e)
		{
			Form__PatternByInsertion__of__Current__Word__CreateUpdate form = new Form__PatternByInsertion__of__Current__Word__CreateUpdate(this, true);

			DialogResult dialogResult = form.ShowDialog();

			if (dialogResult == DialogResult.OK)
			{
				DataRow focusedGuiDataRow
					= this.guiTable__PatternByInsertion__of__Current__Word
					.Find(this.Current__PatternByInsertion__of__Current__Word.Id);

				FocusGridRow(this.BindingSource__PatternByInsertion__of__Current__Word, focusedGuiDataRow);
			}

		}

		private void button__PatternByInsertion__of__Current__Word__Update__Click(object sender, EventArgs e)
		{
			Form__PatternByInsertion__of__Current__Word__CreateUpdate form = new Form__PatternByInsertion__of__Current__Word__CreateUpdate(this, false);

			form.ShowDialog();
		}

		private void button__PatternByInsertion__of__Current__Word__Delete__Click(object sender, EventArgs e)
		{
			if (this.Current__PatternByInsertion__of__Current__Word == null)
			{
				MessageBox.Show("There is no 'Pattern (By insertion)' to delete.", "Empty", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return; 
			}

			DialogResult dialogResult 
				= MessageBox.Show
				(
					"Do you really want to delete the 'Pattern (By insertion)' (" + 
					this.Current__PatternByInsertion__of__Current__Word.PatternRowParent.UniqueKeyString +
					") ?",
					"Deleting", 
					MessageBoxButtons.YesNo, 
					MessageBoxIcon.Question
				);
			if (dialogResult == DialogResult.No)
			{
				return;
			}

			this.DeletePattern(this.Current__PatternByInsertion__of__Current__Word.PatternRowParent);
		}

		private void button__PatternByInsertion__of__Current__Word__Focus__Click(object sender, EventArgs e)
		{
			if (this.Current__PatternByInsertion__of__Current__Word == null)
			{
				return;
			}

			this.Current__Pattern = this.Current__PatternByInsertion__of__Current__Word.PatternRowParent;
			this.Current__WordOrPattern__of__Pattern = this.Current__Pattern.WordOrPatternRowParent;
			this.Current__Pattern_Language 
				= this.DataSet.Pattern_Language
				.FindByPatternIdLanguageCode
				(
					this.Current__Pattern.Id,
					this.Current__Language.Code
				);

			this.populate__Pattern();

			this.tabControl__Main.SelectedTab = this.tabPage__Pattern;
		}
	}
}