﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void remove__PatternFromPattern()
		{
			/// tactique : on va supprimer la 11P row FromPattern pour que cela cascade sur... tout :
			///    - PatternFromPattern,
			///    - les rows-enfants FromPatternLetters.

			this.DataSet.FromPattern.RemoveFromPatternRow(this.Current__FromPattern__of__PatternFromPattern);

			this.Current__Pattern.ModeCode = MainForm.ModeCode_NotDefined;

			this.populate__PatternFromPattern(PopulatingType.Cleaning);
		}

		private void populate__PatternFromPattern(PopulatingType populatingType)
		{
			if (populatingType == PopulatingType.Cleaning)
			{
				this.Current__PatternFromPattern								= null;
				this.Current__FromPattern__of__PatternFromPattern				= null;
				this.Current__Pattern__of__PatternFromPattern__Parent			= null;
				this.Current__Pattern_Language__of__PatternFromPattern__Parent	= null;

				this.textBox__Pattern__FromPattern__PatternString.Text		= null;
				this.textBox__Pattern__FromPattern__PatternId.Text			= null;
				this.textBox__Pattern__FromPattern__PatternMeaning.Text		= null;
				this.textBox__Pattern__FromPattern__GuiHorizontalShift.Text	= null;

				this.bindingSource__FromPatternLetter__of__Pattern.Filter = "FALSE";
			}
			else 
			{
				if (populatingType == PopulatingType.FindingRowsAndSettingFields)
				{
					this.Current__PatternFromPattern
						= this.DataSet.PatternFromPattern
						.FindById(this.Current__Pattern.Id);

					this.Current__FromPattern__of__PatternFromPattern 
						= this.Current__PatternFromPattern.FromPatternRowParent;

					this.Current__Pattern__of__PatternFromPattern__Parent
						= this.Current__FromPattern__of__PatternFromPattern
						.PatternRow;

					this.Current__Pattern_Language__of__PatternFromPattern__Parent
						= this.DataSet.Pattern_Language
						.FindByPatternIdLanguageCode
						(
							this.Current__Pattern__of__PatternFromPattern__Parent.Id,
							this.Current__Language.Code
						);
				}

				/// Fields
				this.textBox__Pattern__FromPattern__PatternString.Text
					= this.Current__Pattern__of__PatternFromPattern__Parent.UniqueKeyString;

				this.textBox__Pattern__FromPattern__PatternId.Text
					= this.Current__Pattern__of__PatternFromPattern__Parent.Id.ToString();

				this.textBox__Pattern__FromPattern__PatternMeaning.Text
					= this.Current__Pattern_Language__of__PatternFromPattern__Parent.Meaning;

				this.textBox__Pattern__FromPattern__GuiHorizontalShift.Text
					= this.Current__FromPattern__of__PatternFromPattern.GuiHorizontalShift.ToString();
				
				/// DataGridView
				this.bindingSource__FromPatternLetter__of__Pattern.Filter
					= "FromPatternSubscriberCode = '"
					+ this.Current__FromPattern__of__PatternFromPattern.SubscriberCode
					+ "' AND FromPatternSubscriberId = '"
					+ this.Current__FromPattern__of__PatternFromPattern.SubscriberId
					+ "'";
			}
		}

		#region		button events

		private void button__Pattern__FromPattern__CreateUpdate__Click(object sender, EventArgs e)
		{
			this.button__Pattern__FromPattern__CreateUpdate__Click();
		}
		private void button__Pattern__FromPattern__CreateUpdate__Click()
		{
			Form__PatternFromPattern__CreateUpdate form = new Form__PatternFromPattern__CreateUpdate(this);

			if (form.ShowDialog() == DialogResult.Cancel)
			{
				this.populate__Pattern();
			}
			else
			{
				this.populate__PatternFromPattern(PopulatingType.FindingRowsAndSettingFields);
			}
		}

		private List<int> button__Pattern__FromPattern__PriorNext_Click(out int number_of_patterns, ref Dictionary<int, BabebiDataSet.PatternRow> patternIds__patterns)
		{
			BabebiDataSet.FromPatternRow[] fromPatterns
				=
				(BabebiDataSet.FromPatternRow[])
				(
					this.Current__Pattern__of__PatternFromPattern__Parent
					.GetFromPatternRows()
				);

			List<string> letterList_of_current = null;

			Dictionary<List<string>, int> letterLists__PatternIds = new Dictionary<List<string>, int>();

			patternIds__patterns = new Dictionary<int, BabebiDataSet.PatternRow>();
			
			number_of_patterns = 0;

			foreach (BabebiDataSet.FromPatternRow fromPattern in fromPatterns)
			{
				BabebiDataSet.PatternRow pattern;
				if (fromPattern.SubscriberCode == MainForm.SubscriberCode_Word)
				{
					continue;
				}
				else if (fromPattern.SubscriberCode == MainForm.SubscriberCode_Pattern)
				{
					number_of_patterns++;

					pattern = this.DataSet.Pattern.FindById(fromPattern.SubscriberId);
				}
				else
				{
					throw new Exception(fromPattern.SubscriberCode);
				}

				BabebiDataSet.FromPatternLetterRow[] fromPatternLetters
					= fromPattern.GetFromPatternLetterRows();

				List<string> letterList = new List<string>();
				foreach (BabebiDataSet.FromPatternLetterRow fromPatternLetter in fromPatternLetters)
				{
					letterList.Add(fromPatternLetter.LetterString);
				}
				letterLists__PatternIds	.Add(letterList, pattern.Id);
				patternIds__patterns	.Add(pattern.Id, pattern);

				if (letterList_of_current == null && pattern.Id == this.Current__Pattern.Id)
				{
					letterList_of_current = letterList;
				}
			}

			return this.getSortedListKeyedByLetterList(letterLists__PatternIds);			
		}
		private void button__Pattern__FromPattern__Prior_Click(object sender, EventArgs e)
		{
			Dictionary<int, BabebiDataSet.PatternRow> patternIds__patterns = new Dictionary<int, BabebiDataSet.PatternRow>();

			List<int> sortedPatternIds = this.button__Pattern__FromPattern__PriorNext_Click(out int number_of_patterns, ref patternIds__patterns);

			BabebiDataSet.PatternRow priorPattern = null;
			foreach (int patternId in sortedPatternIds)
			{
				if (patternId != this.Current__Pattern.Id)
				{
					priorPattern = patternIds__patterns[patternId];
				}
				else 
				{
					break;
				}
			}
			if (priorPattern == null)
			{ 
				priorPattern = patternIds__patterns[sortedPatternIds[number_of_patterns - 1]]; /// si Current premier, alors Next dernier.
			}

			this.Current__Pattern = priorPattern;
			
			this.Current__Pattern_Language 
				= this.DataSet.Pattern_Language
				.FindByPatternIdLanguageCode
				(
					this.Current__Pattern.Id,
					this.Current__Language.Code
				);

			this.populate__Pattern();
		}
		private void button__Pattern__FromPattern__Next_Click(object sender, EventArgs e)
		{
			Dictionary<int, BabebiDataSet.PatternRow> patternIds__patterns = new Dictionary<int, BabebiDataSet.PatternRow>();

			List<int> sortedPatternIds = this.button__Pattern__FromPattern__PriorNext_Click(out int number_of_patterns, ref patternIds__patterns);

			bool foundCurrent = false;
			BabebiDataSet.PatternRow nextPattern = null;
			foreach (int patternId in sortedPatternIds)
			{
				if (!foundCurrent && patternId == this.Current__Pattern.Id)
				{
					foundCurrent = true;
				}
				else if (foundCurrent)
				{
					nextPattern = patternIds__patterns[patternId];

					break;
				}
			}
			if (nextPattern == null)
			{ 
				nextPattern = patternIds__patterns[sortedPatternIds[0]]; /// si Current dernier, alors Next premier.
			}

			this.Current__Pattern = nextPattern;
			
			this.Current__Pattern_Language 
				= this.DataSet.Pattern_Language
				.FindByPatternIdLanguageCode
				(
					this.Current__Pattern.Id,
					this.Current__Language.Code
				);

			this.populate__Pattern();
		}

		private void button__Pattern__FromPattern__FOCUS_Pattern_Click(object sender, EventArgs e)
		{
			this.Current__Pattern = this.Current__Pattern__of__PatternFromPattern__Parent;
			
			this.Current__Pattern_Language 
				= this.DataSet.Pattern_Language
				.FindByPatternIdLanguageCode
				(
					this.Current__Pattern.Id,
					this.Current__Language.Code
				);

			this.populate__Pattern();
		}

		#endregion	button events
		#region		functions

		internal static void Button__PatternFromPattern__FromPatternLetter__Delete__Click
		(
			TextBox textBox__FocusedRank,
			TextBox textBox__FocusedLetter,
			ComboBox comboBox__SelectedLetter,
			SortedDictionary<short, Letter> ranks__letters,
			DataTable guiTable__FromPatternLetter
		)
		{
			if (string.IsNullOrEmpty(textBox__FocusedRank.Text))
			{
				return;
			}

			short rank__DELETED = Convert.ToInt16(textBox__FocusedRank.Text);

			ranks__letters.Remove(rank__DELETED);	

			DataRow focusedDataRow = guiTable__FromPatternLetter.Rows.Find(rank__DELETED);
			guiTable__FromPatternLetter.Rows.Remove(focusedDataRow);

			if (guiTable__FromPatternLetter.Rows.Count == 0)
			{
				comboBox__SelectedLetter	.Items.Clear();
				textBox__FocusedRank		.Text	= null;
				textBox__FocusedLetter		.Text	= null;
			}
		}

		internal void PatternFromPattern
		(
			int									pattern__Id,
			BabebiDataSet.PatternRow			pattern__PARENT,
			short								guiHorizontalShift,
			SortedDictionary<short, Letter>		ranks__letters,
		out BabebiDataSet.FromPatternRow		current__FromPattern,
		out BabebiDataSet.PatternFromPatternRow	current__PatternFromPattern
		)
		{
			/// FromPattern + FromPatternLetters first.
			this.FromPattern__Create
			(
				MainForm.SubscriberCode_Pattern,
				pattern__Id,
				pattern__PARENT,
				guiHorizontalShift,
				ranks__letters,
				out BabebiDataSet.FromPatternRow	current__FromPattern_
			);
			current__FromPattern = current__FromPattern_;

			current__PatternFromPattern
				= this.DataSet.PatternFromPattern
				.AddPatternFromPatternRow
				(
					pattern__Id,
					MainForm.ModeCode_FromPattern,
					MainForm.SubscriberCode_Pattern
				);
		}

		#endregion	functions
	}
}