﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void display__no__Word()
		{
			MainForm.ShowSelectedTabPageInTabControl
			(
				this.tabControl__Word__Extension, 
				null,
				this.tabPage__Word__Extension__FromPattern,
				this.tabPage__Word__Extension__ByInsertion,
				this.tabPage__Word__Extension__Derivated,
				this.tabPage__Word__Extension__Concatenated
			);
		}		

		private void populate__Word()
		{
			if 
			(
				this.Current__WordOrPattern__of__Word == null
				||
				this.Current__WordOrPattern__of__Word.RowState == DataRowState.Detached
				||
				this.Current__WordOrPattern__of__Word.SubscriberId != this.Current__Word.Id
			)
			{ 
				this.Current__WordOrPattern__of__Word = this.Current__Word.WordOrPatternRowParent;
			}

			this.textBox__Word__Id.Text								= this.Current__Word.Id.ToString();
			this.textBox__Word__String.Text							= this.Current__Word.UniqueKeyString;
			this.textBox__Word_Language__Meaning.Text				= this.Current__Word_Language.Meaning;
			this.textBox__Word_Language__WordType_LanguageName.Text	= this.Current__Word_Language.WordType_LanguageRowParent.Name;

			string priorModeCode;
			switch (this.comboBox__Word__Extension.SelectedItem)
			{
				case  MainForm.ModeName_NotDefined		: priorModeCode = MainForm.ModeCode_NotDefined	; break;
				case  MainForm.ModeName_FromPattern		: priorModeCode = MainForm.ModeCode_FromPattern	; break;
				case  MainForm.ModeName_ByInsertion		: priorModeCode = MainForm.ModeCode_ByInsertion	; break;
				case  MainForm.ModeName_Derivated		: priorModeCode = MainForm.ModeCode_Derivated	; break;
				case  MainForm.ModeName_Concatenated	: priorModeCode = MainForm.ModeCode_Concatenated; break;
				default									: priorModeCode = null ; break;
			}

			switch (this.Current__Word.ModeCode)
			{
				case MainForm.ModeCode_NotDefined	: this.comboBox__Word__Extension.SelectedItem = MainForm.ModeName_NotDefined	; break; 
				case MainForm.ModeCode_FromPattern	: this.comboBox__Word__Extension.SelectedItem = MainForm.ModeName_FromPattern	; break; 
				case MainForm.ModeCode_ByInsertion	: this.comboBox__Word__Extension.SelectedItem = MainForm.ModeName_ByInsertion	; break; 
				case MainForm.ModeCode_Derivated	: this.comboBox__Word__Extension.SelectedItem = MainForm.ModeName_Derivated		; break; 
				case MainForm.ModeCode_Concatenated	: this.comboBox__Word__Extension.SelectedItem = MainForm.ModeName_Concatenated	; break; 
				default  : { throw new Exception(this.Current__Word.ModeCode); }
			}

			/// si le ModeCode est toujours le même alors il faut "déclencher" l'event a la main.
			if (this.Current__Word.ModeCode == priorModeCode)
			{ 
				this.comboBox__Word__Extension__SelectedIndexChanged();
			}

			#region		WordByInsertion  children

			this.populate__WordByInsertion__of__Current__Word();

			#endregion	WordByInsertion children
			#region		PatternByInsertion  children

			this.populate__PatternByInsertion__of__Current__Word();

			#endregion	PatternByInsertion children
			#region		Derivated children

			this.Current__WordDerivating = this.DataSet.WordDerivating.FindByWordId(this.Current__Word.Id);

			this.populate__WordDerivating();

			#endregion	Derivated children
			#region		Concatenated children

			this.populate__WordConcatenating(this.Current__Word.GetWordConcatenatedComponentRows());

			#endregion	Concatenated children

			#region		focus also on the first associated LanguageWord

			this.filter__Word_LanguageWord__of__Word();

			BabebiDataSet.Word_LanguageWordRow[] word_languageWords 
				= this.Current__Word_Language.GetWord_LanguageWordRows();

			if (word_languageWords.Length > 0)
			{
				this.Current__LanguageWord = word_languageWords[0].LanguageWordRowParent;
			}
			else
			{
				this.Current__LanguageWord = null;
			}

			this.populate__LanguageWord();

			#endregion	focus also on the first associated LanguageWord
		}

		internal void RemovePriorWordExtensionIfAny()
		{
			if (!string.IsNullOrEmpty(this.Current__Word.ModeCode))
			{
				switch (this.Current__Word.ModeCode)
				{
					case MainForm.ModeCode_FromPattern:
					{
						this.remove__WordFromPattern();

						break;
					}
					case MainForm.ModeCode_ByInsertion:
					{
						this.remove__WordByInsertion();

						break;
					}
					case MainForm.ModeCode_Derivated:
					{
						this.remove__WordDerivated();

						break;
					}
					case MainForm.ModeCode_Concatenated:
					{
						this.remove__WordConcatenated();

						break;
					}
					default:
					{

						throw new Exception(this.Current__Word.ModeCode);
					}
				}
			}
			else
			{
				/// cela doit provenir du fait que la combo n'était pas selectionnée
				/// => on passe donc de l'état gazeux à l'état '(not defined)'.
			}
		}

		internal bool DeleteWord(BabebiDataSet.WordRow word)
		{
			#region		delete THE intrinsically-associated LanguageWord, if any.

			foreach (BabebiDataSet.LanguageRow language in this.DataSet.Language)
			{
				BabebiDataSet.Word_LanguageRow word_language 
					= this.DataSet.Word_Language
					.FindByWordIdLanguageCode
					(
						word.Id,
						language.Code
					);

				BabebiDataSet.Word_LanguageWordRow[] word_LanguageWords 
					= word_language.GetWord_LanguageWordRows();

				foreach (BabebiDataSet.Word_LanguageWordRow word_LanguageWord in word_LanguageWords.ToArray())
				{
					int i = word_LanguageWord.LanguageWordRowParent.GetWord_LanguageWordRows().Length;
					if (i == 1)
					{
						this.DataSet.LanguageWord.RemoveLanguageWordRow(word_LanguageWord.LanguageWordRowParent);
					}
				}

				#region	(ancienne version qui n'était pas assez efficace)
				/*
				if (word_LanguageWords.Length == 1)
				{
					BabebiDataSet.Word_LanguageWordRow word_LanguageWord = word_LanguageWords[0];

					if (word_LanguageWord.LanguageWordRowParent.GetWord_LanguageWordRows().Length == 1)
					{
						this.DataSet.LanguageWord.RemoveLanguageWordRow(word_LanguageWord.LanguageWordRowParent);
					}
				}
				*/
				#endregion	(ancienne version qui n'était pas assez efficace)
			}

			if (this.Current__LanguageWord == null || this.Current__LanguageWord.RowState == DataRowState.Detached)
			{
				this.textBox__LanguageWord__String.Text = null;
			}

			#endregion	delete THE intrinsically-associated LanguageWord, if any.
			#region		check if the associated WordOrPattern is the parent of some Pattern-ByInsertion.

			BabebiDataSet.PatternByInsertionRow[] patternByInsertions
				= word.WordOrPatternRowParent.GetPatternByInsertionRows();

			if (patternByInsertions.Length > 0)
			{
				string patternByInsertionWordIds = "";
				string patternByInsertionUniquekeyStrings = "";
				string patternByInsertionMeanings = "";

				bool firstDone = false;
				foreach (BabebiDataSet.PatternByInsertionRow patternByInsertion in patternByInsertions)
				{
					BabebiDataSet.Pattern_LanguageRow pattern_Language
						= this.DataSet.Pattern_Language
						.FindByPatternIdLanguageCode
						(	
							patternByInsertion.Id, 
							this.Current__Language.Code
						);

					if (!firstDone)
					{
						patternByInsertionWordIds			+= pattern_Language.PatternId.ToString();
						patternByInsertionUniquekeyStrings	+= pattern_Language.PatternRow.UniqueKeyString;
						patternByInsertionMeanings			+= pattern_Language.Meaning;

						firstDone = true;
					}
					else
					{ 
						patternByInsertionWordIds			+= ", " + pattern_Language.PatternId.ToString();
						patternByInsertionUniquekeyStrings	+= ", " + pattern_Language.PatternRow.UniqueKeyString;
						patternByInsertionMeanings			+= ", '" + pattern_Language.Meaning + "'";
					}
				}

				MessageBox.Show
				(
					"This DELETE command aborts because this Word cannot be deleted due to the fact that it is still the parent of " +
					patternByInsertions.Length.ToString() +
					" 'Patterns (By insertion)', the Ids, 'Unique Key String's, and Meanings of which are :\n\n" +
					"   - Ids = { " + patternByInsertionWordIds + " },\n\n" +
					"   - UKSs = { " + patternByInsertionUniquekeyStrings + " },\n\n" +
					"   - Meanings = { " + patternByInsertionMeanings + " }.", 
					"Has child Patterns (By Insertion).", 
					MessageBoxButtons.OK,	
					MessageBoxIcon.Error
				);
				return false;				
			}

			#endregion	check if the associated WordOrPattern is the parent of some Pattern-ByInsertion.
			#region		check if this Word is the parent/origin of some Words-ByInsertion.

			BabebiDataSet.WordByInsertionRow[] wordByInsertions
				= word.GetWordByInsertionRowsByWordByInsertion__Word__Origin();

			if (wordByInsertions.Length > 0)
			{
				string wordByInsertionWordIds = "";
				string wordByInsertionUniquekeyStrings = "";
				string wordByInsertionMeanings = "";

				bool firstDone = false;
				foreach (BabebiDataSet.WordByInsertionRow wordByInsertion in wordByInsertions)
				{
					BabebiDataSet.Word_LanguageRow word_Language
						= this.DataSet.Word_Language
						.FindByWordIdLanguageCode
						(	
							wordByInsertion.Id, 
							this.Current__Language.Code
						);

					if (!firstDone)
					{
						wordByInsertionWordIds			+= word_Language.WordId.ToString();
						wordByInsertionUniquekeyStrings	+= word_Language.WordUniqueKeyString;	/// c'est une Expression... que j'ai oubliée de faire dans Pattern.
						wordByInsertionMeanings			+= word_Language.Meaning;

						firstDone = true;
					}
					else
					{ 
						wordByInsertionWordIds			+= ", " + word_Language.WordId.ToString();
						wordByInsertionUniquekeyStrings	+= ", " + word_Language.WordUniqueKeyString;
						wordByInsertionMeanings			+= ", '" + word_Language.Meaning + "'";
					}
				}

				MessageBox.Show
				(
					"This DELETE command aborts because this Word cannot be deleted due to the fact that it is still the parent of " +
					wordByInsertions.Length.ToString() +
					" 'Words (By insertion)', the Ids, 'Unique Key String's, and Meanings of which are :\n\n" +
					"   - Ids = { " + wordByInsertionWordIds + " },\n\n" +
					"   - UKSs = { " + wordByInsertionUniquekeyStrings + " },\n\n" +
					"   - Meanings = { " + wordByInsertionMeanings + " }.", 
					"Has child Words (By Insertion).", 
					MessageBoxButtons.OK,	
					MessageBoxIcon.Error
				);
				return false;				
			}

			#endregion	check if this Word is the parent/origin of some Words-ByInsertion.
			#region		check if this Word is WordDerivating WITH child WordDerivateds.

			if (word.HasDerivating)
			{
				BabebiDataSet.WordDerivatingRow wordDerivating
					= this.DataSet.WordDerivating
					.FindByWordId(word.Id);

				BabebiDataSet.WordDerivatedRow[] wordDerivateds
					= wordDerivating
					.GetWordDerivatedRows();

				if (wordDerivateds.Length > 0)
				{
					string wordDerivatedWordIds = "";
					string wordDerivatedUniquekeyStrings = "";
					string wordDerivatedMeanings = "";

					bool firstDone = false;
					foreach (BabebiDataSet.WordDerivatedRow wordDerivated in wordDerivateds)
					{
						BabebiDataSet.Word_LanguageRow word_Language
							= this.DataSet.Word_Language
							.FindByWordIdLanguageCode
							(	
								wordDerivated.Id, 
								this.Current__Language.Code
							);

						if (!firstDone)
						{
							wordDerivatedWordIds			+= word_Language.WordId.ToString();
							wordDerivatedUniquekeyStrings	+= word_Language.WordUniqueKeyString;	/// c'est une Expression... que j'ai oubliée de faire dans Pattern.
							wordDerivatedMeanings			+= word_Language.Meaning;

							firstDone = true;
						}
						else
						{ 
							wordDerivatedWordIds			+= ", " + word_Language.WordId.ToString();
							wordDerivatedUniquekeyStrings	+= ", " + word_Language.WordUniqueKeyString;
							wordDerivatedMeanings			+= ", '" + word_Language.Meaning + "'";
						}
					}

					MessageBox.Show
					(
						"This DELETE command aborts because this Word cannot be deleted due to the fact that it is still the parent of " +
						wordDerivateds.Length.ToString() +
						" 'Words (Derivated)', the Ids, 'Unique Key String's, and Meanings of which are :\n\n" +
						"   - Ids = { " + wordDerivatedWordIds + " },\n\n" +
						"   - UKSs = { " + wordDerivatedUniquekeyStrings + " },\n\n" +
						"   - Meanings = { " + wordDerivatedMeanings + " }.", 
						"Has child Words (By Insertion).", 
						MessageBoxButtons.OK,	
						MessageBoxIcon.Error
					);
					return false;				
				}
			}

			#endregion	check if this Word is WordDerivating WITH child WordDerivateds.
			#region		if Word is a 'Word-By insertion', then Delete its Letter Cluster, if it is its only user.

			if (word.ModeCode == MainForm.ModeCode_ByInsertion)
			{
				BabebiDataSet.WordByInsertionRow wordByInsertion
					= this.DataSet.WordByInsertion
					.FindById(word.Id);

				if 
				(
					wordByInsertion.LetterClusterRow.GetWordByInsertionRows().Length == 1
					&&
					wordByInsertion.LetterClusterRow.GetDerivatingRows().Length == 0
				)
				{
					this.DataSet.LetterCluster.RemoveLetterClusterRow(wordByInsertion.LetterClusterRow);
				}
			}

			#endregion	if Word is a 'Word-By insertion', then Delete its Letter Cluster, if it is its only user.
			#region		if Word is a 'Word-From Pattern', then Delete its 11P FromPattern row.

			if (word.ModeCode == MainForm.ModeCode_FromPattern)
			{
				BabebiDataSet.WordFromPatternRow wordFromPattern
					= this.DataSet.WordFromPattern
					.FindById(word.Id);

					this.DataSet.FromPattern.RemoveFromPatternRow(wordFromPattern.FromPatternRowParent);
			}

			#endregion	if Word is a 'Word-From Pattern', then Delete its 11P FromPattern row.

			this.DataSet.WordOrPattern.RemoveWordOrPatternRow(word.WordOrPatternRowParent); 

			return true;
		}

		#region		events

		private void button__Word__Find_Click(object sender, EventArgs e)
		{
			Form__Word__Find form__word__Find = new Form__Word__Find(this);

			if (form__word__Find.ShowDialog(this) == DialogResult.OK)
			{
				this.comboBox__Word__Extension.Enabled = true;

				this.populate__Word();
			}
		}

		private void button__Word__FindById__Click(object sender, EventArgs e)
		{
			Form__Word__FindById form = new Form__Word__FindById(this);

			if (form.ShowDialog() == DialogResult.Cancel)
			{
				return;
			}

			this.comboBox__Word__Extension.Enabled = true;

			this.populate__Word();
		}

		private void button__Word__Create__Click(object sender, EventArgs e)
		{
			Form__Word__CreateUpdate form = new Form__Word__CreateUpdate(this, true);

			if (form.ShowDialog(this) == DialogResult.OK)
			{
				this.comboBox__Word__Extension.Enabled = true;

				this.populate__Word();

				if (this.Current__LanguageWord != null)
				{
					this.textBox__LanguageWord__String.Text = this.Current__LanguageWord.String;

					this.filter__Word_LanguageWord__of__LanguageWord();
				}
			}
		}

		private void button__Word__Update__Click(object sender, EventArgs e)
		{
			if (this.Current__Word_Language != null)
			{
				Form__Word__CreateUpdate form = new Form__Word__CreateUpdate(this, false);

				if (form.ShowDialog(this) == DialogResult.OK)
				{
					this.populate__Word();
				}
			}
		}

		private void button__Word__Delete__Click(object sender, EventArgs e)
		{
			if (this.Current__Word == null)
			{
				MessageBox.Show("There is no 'Word' to delete.", "Empty", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return; 
			}

			DialogResult dialogResult 
				= MessageBox.Show
				(
					"Do you really want to delete the 'Word' : [" + 
					this.Current__Word.UniqueKeyString +
					"] that means : '" +
					this.Current__Word_Language.Meaning +
					"'.",
					"Deleting", 
					MessageBoxButtons.YesNo, 
					MessageBoxIcon.Question
				);
			if (dialogResult == DialogResult.No)
			{
				return;
			}

			if (this.DeleteWord(this.Current__Word))
			{
				this.comboBox__Word__Extension.SelectedIndex = 0;

				this.textBox__Word__Id.Text = null;
				this.textBox__Word__String.Text = null;
				this.textBox__Word_Language__WordType_LanguageName.Text = null;
				this.textBox__Word_Language__Meaning.Text = null;

				this.Current__Word = null;
				this.Current__Word_Language = null;

				this.comboBox__Word__Extension.Enabled = false;
			}
		}

		private void filter__Word_Language()
		{
			if (this.Current__Language != null)
			{
				if (this.Current__Word_Language != null)
				{
					int wordId = this.Current__Word_Language.WordId;

					this.Current__Word_Language 
						= this.DataSet.Word_Language
						.FindByWordIdLanguageCode
						(
							wordId,
							this.Current__Language.Code
						);

					this.textBox__Word_Language__Meaning				.Text = this.Current__Word_Language.Meaning;
					this.textBox__Word_Language__WordType_LanguageName	.Text = this.Current__Word_Language.WordType_LanguageRowParent.Name;
				}
			}
			else
			{
				if (this.Current__Word_Language != null)
				{
					this.textBox__Word_Language__Meaning				.Text = null;
					this.textBox__Word_Language__WordType_LanguageName	.Text = null;
				}
			}
		}
		
		private void comboBox__Word__Extension__SelectedIndexChanged()
		{
			string modeName = (string)this.comboBox__Word__Extension.SelectedItem;

			switch (modeName)
			{
				case MainForm.ModeName_NotDefined :
				{
					MainForm.ShowSelectedTabPageInTabControl
					(
						this.tabControl__Word__Extension, 
						null, 
						this.tabPage__Word__Extension__FromPattern,
						this.tabPage__Word__Extension__ByInsertion,
						this.tabPage__Word__Extension__Derivated,
						this.tabPage__Word__Extension__Concatenated
					);

					if (this.Current__Word != null && this.Current__Word.RowState != DataRowState.Deleted && this.Current__Word.RowState != DataRowState.Detached )
					{
						/// cleaning if the currently displayed Extension is not the one of current Word.
						if (this.Current__WordFromPattern != null && this.Current__WordFromPattern.Id != this.Current__Word.Id)
						{
							this.populate__WordFromPattern(PopulatingType.Cleaning);
						}
						else if (this.Current__WordByInsertion != null && this.Current__WordByInsertion.Id != this.Current__Word.Id)
						{
							this.populate__WordByInsertion(PopulatingType.Cleaning);
						}
						else if (this.Current__WordDerivated != null && this.Current__WordDerivated.Id != this.Current__Word.Id)
						{
							this.populate__WordDerivated(PopulatingType.Cleaning);
						}
						else if (this.Current__WordConcatenated != null && this.Current__WordConcatenated.Id != this.Current__Word.Id)
						{
							this.populate__WordConcatenated(PopulatingType.Cleaning);
						}

						/// removing of the currently displayed Extension because it belongs to the current Word.
						if (this.Current__WordFromPattern != null && this.Current__WordFromPattern.Id == this.Current__Word.Id)
						{
							this.remove__WordFromPattern();
						}
						else if (this.Current__WordByInsertion != null && this.Current__WordByInsertion.Id == this.Current__Word.Id)
						{
							this.remove__WordByInsertion();
						}
						else if (this.Current__WordDerivated != null && this.Current__WordDerivated.RowState != DataRowState.Detached && this.Current__WordDerivated.Id == this.Current__Word.Id)
						{
							this.remove__WordDerivated();
						}
						else if (this.Current__WordConcatenated != null && this.Current__WordConcatenated.Id == this.Current__Word.Id)
						{
							this.remove__WordConcatenated();
						}
					}
					else
					{
						this.populate__WordFromPattern(PopulatingType.Cleaning);
						this.populate__WordByInsertion(PopulatingType.Cleaning);
						this.populate__WordDerivated(PopulatingType.Cleaning);
						this.populate__WordConcatenated(PopulatingType.Cleaning);
					}
					break;
				}
				case MainForm.ModeName_FromPattern :
				{
					MainForm.ShowSelectedTabPageInTabControl
					(
						this.tabControl__Word__Extension, 
						this.tabPage__Word__Extension__FromPattern,
						this.tabPage__Word__Extension__ByInsertion,
						this.tabPage__Word__Extension__Derivated,
						this.tabPage__Word__Extension__Concatenated
					);

					if (this.Current__Word.ModeCode != ModeCode_FromPattern)
					{
						this.button__WordFromPattern__CreateUpdate__Click();
					}
					else
					{
						this.populate__WordFromPattern(PopulatingType.FindingRowsAndSettingFields);
					}

					break;
				}
				case MainForm.ModeName_ByInsertion :
				{
					MainForm.ShowSelectedTabPageInTabControl
					(
						this.tabControl__Word__Extension, 
						this.tabPage__Word__Extension__ByInsertion,
						this.tabPage__Word__Extension__FromPattern,
						this.tabPage__Word__Extension__Derivated,
						this.tabPage__Word__Extension__Concatenated
					);

					if (this.Current__Word.ModeCode != ModeCode_ByInsertion)
					{
						this.button__WordByInsertion__CreateUpdate__Click();
					}
					else
					{ 
						this.populate__WordByInsertion(PopulatingType.FindingRowsAndSettingFields);
					}

					break;
				}
				case MainForm.ModeName_Derivated :
				{
					MainForm.ShowSelectedTabPageInTabControl
					(
						this.tabControl__Word__Extension, 
						this.tabPage__Word__Extension__Derivated,
						this.tabPage__Word__Extension__FromPattern,
						this.tabPage__Word__Extension__ByInsertion,
						this.tabPage__Word__Extension__Concatenated
					);
				
					if (this.Current__Word.ModeCode != ModeCode_Derivated)
					{
						this.button__WordDerivated__CreateUpdate__Click(true);
					}
					else
					{ 
						this.populate__WordDerivated(PopulatingType.FindingRowsAndSettingFields);
					}

					break;
				}
				case MainForm.ModeName_Concatenated :
				{
					MainForm.ShowSelectedTabPageInTabControl
					(
						this.tabControl__Word__Extension, 
						this.tabPage__Word__Extension__Concatenated,
						this.tabPage__Word__Extension__FromPattern,
						this.tabPage__Word__Extension__ByInsertion,
						this.tabPage__Word__Extension__Derivated
					);

					/// ici c'est différent pour (un peu) la même raison que pour Pattern ExNihilo :
					/// dès que ce mode est choisi avec la combo on crée la row-extension immédiatement 
					/// car elle ne contient aucune information : elle est juste parente des links vers
					/// les subWords.

					if 
					(
						this.Current__Word.ModeCode != MainForm.ModeCode_NotDefined 
						&& 
						this.Current__Word.ModeCode != MainForm.ModeCode_Concatenated
					)
					{
						this.RemovePriorWordExtensionIfAny();
					}

					/// Soyons clair : l'argument 'PopulatingType.SettingFieldsOnly' ne veut rien dire dans ce cas.
					/// Il est juste passer pour ne pas être 'PopulatingType.Cleaning' qui nettoie tout. En 
					/// pratique : soit WordConcatenated existe et on le trouve ; soit on le crée.

					this.populate__WordConcatenated(PopulatingType.SettingFieldsOnly);  

					break;
				}
			}
		}
		private void comboBox__Word__Extension__SelectedIndexChanged(object sender, EventArgs e)
		{
			this.comboBox__Word__Extension__SelectedIndexChanged();
		}

		private void button__Word_________Click(bool trueForNext__falseForPrior, short? wordTypeId = null)
		{
			int current__Word__Id;
			if (this.Current__Word != null)
			{
				current__Word__Id = this.Current__Word.Id;
			}
			else
			{ 
				current__Word__Id = 0;
			}

			bool b;
			if (!wordTypeId.HasValue)
			{
				b = true;
			}
			else
			{
				b = false;
			}

			BabebiDataSet.WordRow ____Word = null;
			do
			{
				if (trueForNext__falseForPrior)
				{
					current__Word__Id++;
				}
				else
				{ 
					current__Word__Id--;
				}

				if (current__Word__Id > 10000 || current__Word__Id < 1)
				{
					break;
				}

				____Word = this.DataSet.Word.FindById(current__Word__Id);

				if (wordTypeId.HasValue && ____Word != null)
				{
					if (____Word.WordTypeId == wordTypeId.Value)
					{
						b = true;
					}
					else
					{ 
						b = false;
					}
				}

			}
			while(____Word == null || !b );
			 
			if (current__Word__Id > 10000 || current__Word__Id < 1)
			{
				return;
			}

			this.Current__Word = ____Word;

			this.Current__WordOrPattern__of__Word = this.Current__Word.WordOrPatternRowParent;

			this.Current__Word_Language 
				= this.DataSet.Word_Language
				.FindByWordIdLanguageCode
				(
					this.Current__Word.Id,
					this.Current__Language.Code
				);

			this.populate__Word();
		}
		private void button__Word__Next___Click(object sender, EventArgs e)
		{
			this.button__Word_________Click(true);
		}
		private void button__Word__Next__SameWordType__Click(object sender, EventArgs e)
		{
			short? current__word__WordTypeId;
			if (this.Current__Word != null)
			{
				current__word__WordTypeId = this.Current__Word.WordTypeId;
			}
			else
			{ 
				current__word__WordTypeId = null;
			}

			this.button__Word_________Click(true, current__word__WordTypeId);
		}
		private void button__Word__Prior__Click(object sender, EventArgs e)
		{
			this.button__Word_________Click(false);
		}
		private void button__Word__Prior__SameWordType__Click(object sender, EventArgs e)
		{
			short? current__word__WordTypeId;
			if (this.Current__Word != null)
			{
				current__word__WordTypeId = this.Current__Word.WordTypeId;
			}
			else
			{ 
				current__word__WordTypeId = null;
			}

			this.button__Word_________Click(false, current__word__WordTypeId);
		}

		#endregion	events

		#region		functions

		/// next Word Id
		internal int WordId__Next()
		{
			return this.Word_Pattern__Id__Next(true);
		}

		/// Id
		internal void Word__Id__TextChanged(TextBox_WEM textBox_WEM__Id, ref int wordId)
		{
			if (textBox_WEM__Id != null)
			{
				this.Word_Pattern__Id__TextChanged(true, textBox_WEM__Id, ref wordId);
			}

			#region		(version typée)
			/*
			string wordIdString = textBox__WordId.Text;

			/// empty?
			if (string.IsNullOrEmpty(wordIdString))
			{
				Error__Configure(label__WordId, textBox__WordId, true, current__WordIdString);

				wordId = -1;

				return new Error("The value of the 'Word Id' cannot be empty.", "Word Id required");
			}

			/// the user should have copy/paste shit in the Word Id...
			if (!int.TryParse(wordIdString, out wordId))
			{
				Error__Configure(label__WordId, textBox__WordId, true, current__WordIdString);

				wordId = -1;   /// parce qu'il passe à 0 avec le TryParse(...)

				return new Error("The value of the 'Word Id' not a valid Integer.", "Not an integer");
			}

			bool the_Id_is_already_associated_to_an_existing_Word;

			BabebiDataSet.WordRow alreadyExistingWord 
				= this.DataSet.Word.FindById(wordId);

			if (alreadyExistingWord != null)
			{
				if (current__WordIdString == null)
				{
					the_Id_is_already_associated_to_an_existing_Word = true;
				}
				else
				{
					if (current__WordIdString != wordIdString)
					{
						the_Id_is_already_associated_to_an_existing_Word = true;
					}
					else
					{
						the_Id_is_already_associated_to_an_existing_Word = false;
					}
				}
			}
			else
			{
				the_Id_is_already_associated_to_an_existing_Word = false;
			}

			if (the_Id_is_already_associated_to_an_existing_Word)
			{
				Error__Configure(label__WordId, textBox__WordId, true, current__WordIdString);

				BabebiDataSet.Word_LanguageRow alreadyExistingWord_Language
				= this.DataSet.Word_Language
				.FindByWordIdLanguageCode
				(
					wordId,
					this.Current__Language.Code
				);

				string errorMessage =
					"The Word Id (" +
					wordIdString +
					") is not valid because it is already associated to the existing Word : '" +
					alreadyExistingWord.UniqueKeyString +
					"' that means : '" +
					alreadyExistingWord_Language.Meaning +
					"'.";
				
				wordId = -1;

				return new Error(errorMessage, "Word Id already existing");
			}

			Error__Configure(label__WordId, textBox__WordId, false, current__WordIdString);

			return new Error();

			*/
			#endregion	(version typée)
		}

		/// UniqueKeyString
		internal void Word__UniqueKeyString__TextChanged(TextBox_WEM textBox_WEM__UniqueKeyString)
		{
			if (textBox_WEM__UniqueKeyString != null)
			{
				this.Word_Pattern__UniqueKeyString__TextChanged(true, textBox_WEM__UniqueKeyString);
			}

			#region		(version typée)
			/*
			string wordUniqueKeyString = textBox__WordUniqueKeyString.Text;

			/// empty?
			if (string.IsNullOrEmpty(wordUniqueKeyString))
			{
				Error__Configure(label__WordUniqueKeyString, textBox__WordUniqueKeyString, true, current__WordUniqueKeyString);

				return new Error
					(
						"The value of the 'Word String' cannot be empty.",
						"Word String required"
					);
			}

			bool the_UniqueKeyString_is_already_associated_to_an_existing_Word;

			BabebiDataSet.WordRow[] alreadyExistingWords 
				= 
				(BabebiDataSet.WordRow[])
				(this.DataSet.Word.Select("UniqueKeyString = '" + wordUniqueKeyString + "'"));
			
			BabebiDataSet.WordRow alreadyExistingWord;

			if (alreadyExistingWords.Length == 1)
			{
				alreadyExistingWord = alreadyExistingWords[0];

				if (current__WordUniqueKeyString == null)
				{
					the_UniqueKeyString_is_already_associated_to_an_existing_Word = true;
				}
				else
				{
					if (current__WordUniqueKeyString != wordUniqueKeyString)
					{
						the_UniqueKeyString_is_already_associated_to_an_existing_Word = true;
					}
					else
					{
						the_UniqueKeyString_is_already_associated_to_an_existing_Word = false;
					}
				}
			}
			else
			{
				alreadyExistingWord = null;

				the_UniqueKeyString_is_already_associated_to_an_existing_Word = false;
			}

			if (the_UniqueKeyString_is_already_associated_to_an_existing_Word)
			{
				Error__Configure(label__WordUniqueKeyString, textBox__WordUniqueKeyString, true, current__WordUniqueKeyString);

				BabebiDataSet.Word_LanguageRow alreadyExistingWord_Language
				= this.DataSet.Word_Language
				.FindByWordIdLanguageCode
				(
					alreadyExistingWord.Id,
					this.Current__Language.Code
				);

				string errorMessage =
					"The Word String (" +
					wordUniqueKeyString +
					") is not valid because it is already associated to the existing Word : '" +
					alreadyExistingWord.UniqueKeyString +
					"' that means : '" +
					alreadyExistingWord_Language.Meaning +
					"'.";

				return new Error
					(
						errorMessage,
						"Word String already existing"
					);
			}

			Error__Configure(label__WordUniqueKeyString, textBox__WordUniqueKeyString, false, current__WordUniqueKeyString);

			return new Error();
			*/
			#endregion	(version typée)
		}

		/// Meaning
		internal void Word__Meaning__TextChanged(TextBox_WEM textBox_WEM__Meaning)
		{
			if (textBox_WEM__Meaning != null)
			{
				this.Word_Pattern__Meaning__TextChanged(true, textBox_WEM__Meaning);
			}

			#region		(version typée)
			/*
			string wordMeaning = textBox__WordMeaning.Text;

			/// empty?
			if (string.IsNullOrEmpty(wordMeaning))
			{
				Error__Configure(label__WordMeaning, textBox__WordMeaning, true, current__WordMeaning);

				return new Error
					(
						"The value of the 'Word Meaning' cannot be empty.",
						"Word Meaning required"
					);
			}

			bool the_Meaning_is_already_associated_to_an_existing_Word;
			
			string filteringExpression 
				= "LanguageCode = '" + this.Current__Language.Code + "' AND Meaning = '" + wordMeaning.Replace("'", "''") + "'";  

			BabebiDataSet.Word_LanguageRow[] alreadyExistingWord_Languages 
				= 
				(BabebiDataSet.Word_LanguageRow[])
				(this.DataSet.Word_Language.Select(filteringExpression));
			
			BabebiDataSet.Word_LanguageRow alreadyExistingWord_Language;

			if (alreadyExistingWord_Languages.Length == 1)
			{
				alreadyExistingWord_Language = alreadyExistingWord_Languages[0];

				if (current__WordMeaning == null)
				{
					the_Meaning_is_already_associated_to_an_existing_Word = true;
				}
				else
				{
					if (current__WordMeaning != wordMeaning)
					{
						the_Meaning_is_already_associated_to_an_existing_Word = true;
					}
					else
					{
						the_Meaning_is_already_associated_to_an_existing_Word = false;
					}
				}
			}
			else
			{
				alreadyExistingWord_Language = null;

				the_Meaning_is_already_associated_to_an_existing_Word = false;
			}

			if (the_Meaning_is_already_associated_to_an_existing_Word)
			{
				Error__Configure(label__WordMeaning, textBox__WordMeaning, true, current__WordMeaning);

				BabebiDataSet.WordRow alreadyExistingWord = alreadyExistingWord_Language.WordRowParent;

				string errorMessage =
					"The Word Meaning (" +
					wordMeaning +
					") is not valid because it is already associated to the existing Word : '" +
					alreadyExistingWord.UniqueKeyString +
					"' [Id = " + alreadyExistingWord.Id.ToString() + "].";

				return new Error
					(
						errorMessage,
						"Word Meaning already existing"
					);
			}

			Error__Configure(label__WordMeaning, textBox__WordMeaning, false, current__WordMeaning);

			return new Error();

			*/
			#endregion	(version typée)
		}

		/// WordType
		internal void Word__WordType__SelectedIndexChanged(ComboBox_WEM comboBox_WEM__WordType, ref BabebiDataSet.WordType_LanguageRow selected__WordType_Language)
		{
			if (comboBox_WEM__WordType != null)
			{
				selected__WordType_Language = (BabebiDataSet.WordType_LanguageRow)(comboBox_WEM__WordType.Row());

				comboBox_WEM__WordType.ClearError();
			}
		}

		/// create a word without extension
		internal void Create__Word
		(
			int		word__Id,
			string	word__UniqueKeyString,
			string	word_Language__Meaning,
			BabebiDataSet.WordTypeRow		wordType,
		out	BabebiDataSet.WordOrPatternRow	current__WordOrPattern__of__Word,
		out	BabebiDataSet.WordRow			current__Word,					
		out	BabebiDataSet.Word_LanguageRow	current__Word_Language,			
		out	BabebiDataSet.LanguageWordRow	current__LanguageWord,
			string modeCode = MainForm.ModeCode_NotDefined
		)
		{
			this.Create__Word_Pattern
			(
				true,
				word__Id,
				word__UniqueKeyString,
				word_Language__Meaning,
				wordType,
			out	DataRow	current__WordOrPattern__of__Word_,
			out	DataRow	current__Word_,					
			out	DataRow	current__Word_Language_,			
				modeCode
			);

			current__WordOrPattern__of__Word = (BabebiDataSet.WordOrPatternRow	)current__WordOrPattern__of__Word_	;
			current__Word					 = (BabebiDataSet.WordRow			)current__Word_						;					
			current__Word_Language			 = (BabebiDataSet.Word_LanguageRow	)current__Word_Language_			;

			#region		(version typée)
			/*
			#region		creating of single rows

			current__WordOrPattern__of__Word
				= this.DataSet.WordOrPattern
				.AddWordOrPatternRow
				(
					MainForm.SubscriberCode_Word,
					word__Id
				);

			current__Word
				= this.DataSet.Word.AddWordRow
				(
					word__Id,
					word__UniqueKeyString,
					wordType,
					modeCode,
					false,
					MainForm.SubscriberCode_Word
				);
			
			#endregion	creating of single rows
			#region		the Word_Language links

			current__Word_Language = null;	/// pour que le 'out' marche...

			foreach (BabebiDataSet.LanguageRow language in this.DataSet.Language)
			{
				BabebiDataSet.Word_LanguageRow word_Language
					= this.DataSet.Word_Language
					.AddWord_LanguageRow
					(
						word__Id,
						language,
						wordType.Id,
						(language == this.Current__Language ? "" : "**" + this.Current__Language.Code + "**") + word_Language__Meaning
					);

				if (language == this.Current__Language)
				{
					current__Word_Language = word_Language;
				}
			}

			#endregion	the Word_Language links
			*/
			#endregion	(version typée)

			/// specifique à Word comparé à Pattern
			#region		create LanguageWords from the provided Meaning

			current__LanguageWord = null;
			foreach (BabebiDataSet.LanguageRow language in this.DataSet.Language)
			{
				if (language == this.Current__Language)
				{
					MeaningParser meaningParser = new MeaningParser(this, word_Language__Meaning);

					bool successful = meaningParser.Parse();

					if (!successful)
					{
						MessageBox.Show(meaningParser.ErrorMessage, "Error about Meaning", MessageBoxButtons.OK, MessageBoxIcon.Error);

						return;
					}
					else
					{
						foreach (string languageWordString in meaningParser.LanguageWordStrings)
						{
							BabebiDataSet.LanguageWordRow languageWord
								= this.DataSet.LanguageWord
								.FindByLanguageCodeString
								(
									this.Current__Language.Code,
									languageWordString
								);

							if (languageWord == null)
							{
								languageWord
								= this.DataSet.LanguageWord
								.AddLanguageWordRow
								(
									this.Current__Language,
									languageWordString
								);
							}

							if (current__LanguageWord == null)
							{
								current__LanguageWord = languageWord;
							}

							BabebiDataSet.Word_LanguageWordRow word_LanguageWord
								= this.DataSet.Word_LanguageWord
								.FindByWordIdLanguageCodeLanguageWordString
								(
									word__Id,
									this.Current__Language.Code,
									languageWordString
								);

							if (word_LanguageWord == null)
							{
								word_LanguageWord
								= this.DataSet.Word_LanguageWord
								.AddWord_LanguageWordRow
								(
									word__Id,
									this.Current__Language.Code,
									languageWordString
								);
							}

						}
					}
				}
				else /// (language != this.Current__Language)
				{	
					/// on ne rajoute pas de LWs pour les autres languages.
				}
			}
			
			#endregion	create a LanguageWord from the provided Meaning
		}

		/// Update a word without extension
		internal void Update__Word
		(
			int		word__Id,
			string	word__UniqueKeyString,
			string	word_Language__Meaning,
			BabebiDataSet.WordTypeRow		wordType,
			BabebiDataSet.WordOrPatternRow	current__WordOrPattern,	/// indispensable pour pouvoir updater l'Id...					
			BabebiDataSet.WordRow			current__Word,					
			BabebiDataSet.Word_LanguageRow	current__Word_Language,
		out BabebiDataSet.LanguageWordRow	current__LanguageWord
		)
		{
			this.Update__Word_Pattern
			(
				true,
				word__Id,
				word__UniqueKeyString,
				word_Language__Meaning,
				wordType,
				current__WordOrPattern,	
				current__Word,					
				current__Word_Language,
			out BabebiDataSet.LanguageWordRow	current__LanguageWord_
			);

			current__LanguageWord = current__LanguageWord_;

			#region		(version typée)
			/*
			if (current__WordOrPattern.SubscriberId != word__Id)
			{ 
				current__WordOrPattern.SubscriberId = word__Id;
			}
			
			if (current__Word.UniqueKeyString != word__UniqueKeyString)
			{ 
				Word.SetUniqueKeyString(current__Word, word__UniqueKeyString);
			}
			if (current__Word.WordTypeRow != wordType)
			{ 
				current__Word.WordTypeRow = wordType;
			}

			current__LanguageWord = null;

			foreach (BabebiDataSet.Word_LanguageRow word_Language in current__Word.GetWord_LanguageRows())
			{
				if (word_Language.LanguageRow == this.Current__Language)
				{
					/// alors word_Language == current__Word_Language

					if (current__Word_Language.Meaning != word_Language__Meaning)
					{ 
						current__Word_Language.Meaning = word_Language__Meaning;

						foreach (BabebiDataSet.Word_LanguageWordRow word_LanguageWord in current__Word_Language.GetWord_LanguageWordRows().ToArray())
						{
							if (word_LanguageWord.LanguageWordRowParent.GetWord_LanguageWordRows().Length == 1)
							{
								this.DataSet.LanguageWord.RemoveLanguageWordRow(word_LanguageWord.LanguageWordRowParent);
							}
							else
							{ 
								this.DataSet.Word_LanguageWord.RemoveWord_LanguageWordRow(word_LanguageWord);
							}
						}

						/// et on reconstruit tout.
						current__LanguageWord 
							= this.Create__LanguageWords__from_Meaning_for_the_current_language
							(
								word__Id, 
								word__UniqueKeyString,	/// used only in the error message, if any
								word_Language__Meaning
							);
					}
				}
				else
				{
					if (word_Language.Meaning.StartsWith("**"))
					{
						string priorLanguageWordString 
							= this.adapt_LanguageWordString_for_the_other_languages
							(
								word_Language.Meaning.Substring(6)
							);

						word_Language.Meaning = "**" + this.Current__Language.Code + "**" + word_Language__Meaning;

						BabebiDataSet.LanguageWordRow languageWord 
							= this.DataSet.LanguageWord
							.FindByLanguageCodeString
							(
								word_Language.LanguageRow.Code,
								priorLanguageWordString
							);

						if (languageWord != null)
						{
							string newLanguageWordString
								= this.adapt_LanguageWordString_for_the_other_languages
								(
									word_Language__Meaning
								);


							languageWord.String = newLanguageWordString;
						}
					}
					else
					{
						/// on n'y touche pas car ce n'est plus une valeur 'automatique' mais bien une valeur saisie.
					}
				}
			}
			*/
			#endregion	(version typée)
		}

		private string adapt_LanguageWordString_for_the_other_languages(string meaning__CLEAN)
		{
			string languageWordString = "**" + this.Current__Language.Code + "**" + meaning__CLEAN;

			if (languageWordString.Length > 32)
			{
				languageWordString = languageWordString.Substring(0, 29) + "...";
			}

			return languageWordString;
		}

		/// ICI !!!
		#region		// l'endroit surper compliqué où l'on crée (ou non) les LanguageWords à partir du Meaning.
		/*
		internal List<string> SubStrings__becoming_languageWords;

		internal BabebiDataSet.LanguageWordRow Create__LanguageWords__from_Meaning_for_the_current_language
		(
			int		word__Id, 
			string	word__UniqueKeystring__used_in_error_messages_only,
			string	word_language__meaning
		)
		{
			if (string.IsNullOrEmpty(word_language__meaning) || word_language__meaning.StartsWith("**"))
			{
				return null;		/// on ne travaille que sur d'authentique meanings.
			}

			BabebiDataSet.LanguageWordRow returnedLanguageWord = null;

			bool ask_Yes_or_No_for_creating__ALL = true;

			BabebiDataSet.LanguageRow currentLanguage = this.Current__Language;
			string currentLanguageCode = currentLanguage.Code;

			word_language__meaning = word_language__meaning.Trim();

			#region		remove last parenthesis if any

			char lastChar;
			int indexOfOpeningParenthesis;

			lastChar = word_language__meaning[word_language__meaning.Length - 1];
			if (lastChar == ')')
			{
				indexOfOpeningParenthesis = word_language__meaning.Length - 2;
				while(indexOfOpeningParenthesis > -1 && word_language__meaning[indexOfOpeningParenthesis] != '(' )
				{
					indexOfOpeningParenthesis--;
				}

				/// survive to an error of missing (...
				if (indexOfOpeningParenthesis == -1)
				{
					indexOfOpeningParenthesis = word_language__meaning.Length;
				}

				if (indexOfOpeningParenthesis == 0)		/// => meaning = '(...)'
				{ 
					return null;
				}

				word_language__meaning = word_language__meaning.Substring(0, indexOfOpeningParenthesis - 1);	/// car il y a un blank avant la parenthèse.
			}

			#endregion	remove last parenthesis if any

			string[] subMeanings = word_language__meaning.Split( new string[]{ "," }, StringSplitOptions.RemoveEmptyEntries);

			int subMeaningIndex = -1;
			foreach (string subMeaning_ in subMeanings)
			{ 
				subMeaningIndex++;

				string subMeaning = subMeaning_.Trim();

				subMeaning = subMeaning.Replace("l'", "");
				subMeaning = subMeaning.Replace("s'", "");

				#region		remove last parenthesis if any

				lastChar = subMeaning[subMeaning.Length - 1];

				if (lastChar == ']' || lastChar == ')')
				{
					char searchedBackChar = (lastChar == ']' ? '[' : '(');

					indexOfOpeningParenthesis = subMeaning.Length - 2;
					while (subMeaning[indexOfOpeningParenthesis] != searchedBackChar)
					{
						indexOfOpeningParenthesis--;
					}

					subMeaning = subMeaning.Substring(0, indexOfOpeningParenthesis - 1);    /// car il y a un blank avant la parenthèse.
				}

				#endregion	remove last parenthesis if any

				#region		if required, create a Language Word as a whole.

				BabebiDataSet.LanguageWordRow languageWord
					= this.DataSet.LanguageWord
					.FindByLanguageCodeString
					(
						currentLanguageCode,
						subMeaning
					);
				
				bool ask_Yes_or_No_for_link_creating = true;
				if (languageWord == null)
				{
					DialogResult dialogResult = DialogResult.Cancel;		/// valeur sans importance.
					if (ask_Yes_or_No_for_creating__ALL)
					{
						MessageBoxIcon messageBoxIcon;
						if (subMeaning.Split(' ').Length > 1)
						{
							messageBoxIcon = MessageBoxIcon.Error;
						}
						else
						{ 
							messageBoxIcon = MessageBoxIcon.Question;
						}

						dialogResult
							= MessageBox.Show
							(
								"Do you want to create the new Language Word : \n\n'" + subMeaning + "'\n\n?'",
								"CLICK ON Cancel TO NOT BEEN ASKED ANYMORE",
								MessageBoxButtons.YesNoCancel,
								messageBoxIcon
							);
						if (dialogResult == DialogResult.Cancel)
						{
							ask_Yes_or_No_for_creating__ALL = false;
						}
					}

					if
					(
						! ask_Yes_or_No_for_creating__ALL 
						|| 
						dialogResult == DialogResult.Yes
					)
					{
						if (subMeaning.Length > 32)
						{
							MessageBox.Show
							(
								"The proposed Meaning has more than 32 characters, which is not allowed. No 'Language Word' will be created.",
								subMeaning.Length .ToString(),
								MessageBoxButtons.OK,
								MessageBoxIcon.Error
							);

							return null;
						}

						languageWord
							= this.DataSet.LanguageWord
							.AddLanguageWordRow
							(
								currentLanguage,
								subMeaning
							);

							ask_Yes_or_No_for_link_creating = false;
					}
				}

				if (returnedLanguageWord == null && languageWord != null)
				{
					returnedLanguageWord = languageWord;
				}

				if (languageWord != null)
				{
					BabebiDataSet.Word_LanguageWordRow word_languageWord
						= this.DataSet.Word_LanguageWord
						.FindByWordIdLanguageCodeLanguageWordString
						(
							word__Id,
							currentLanguageCode,
							subMeaning
						);

					if (word_languageWord == null)
					{
						DialogResult dialogResult = DialogResult.Cancel; /// la valeur d'initialisation obligatoire n'a pas d'importance.
						if (ask_Yes_or_No_for_creating__ALL && ask_Yes_or_No_for_link_creating)
						{
							dialogResult =
								MessageBox.Show
								(
									"Do you want to create a link between :\n\n" +
									"   - the language word = '" + subMeaning + "',\n\n" +
									"     and\n\n" +
									"   - the babebi word   = '" + word__UniqueKeystring__used_in_error_messages_only + "' ?\n\n" +
									"Its meaning of this Word is : '" + word_language__meaning + "'.",
									"To Language Word Linking",
									MessageBoxButtons.YesNo,
									MessageBoxIcon.Question
								);
							if (dialogResult == DialogResult.Cancel)
							{
								ask_Yes_or_No_for_creating__ALL = false;
							}
						}

						if
						(	
							! ask_Yes_or_No_for_creating__ALL
							||
							! ask_Yes_or_No_for_link_creating
							||
							dialogResult == DialogResult.Yes
						)
						{
							this.DataSet.Word_LanguageWord
								.AddWord_LanguageWordRow
								(
									word__Id,
									currentLanguageCode,
									subMeaning
								);
						}
					}
				}

				#endregion	if required, create a Language Word as a whole.
				#region		replace "d'V" par "de V" in the text.

				subMeaning = subMeaning.Replace("d'a", "de a");
				subMeaning = subMeaning.Replace("d'à", "de à");
				subMeaning = subMeaning.Replace("d'â", "de â");
				subMeaning = subMeaning.Replace("d'ä", "de ä");

				subMeaning = subMeaning.Replace("d'e", "de e");
				subMeaning = subMeaning.Replace("d'é", "de é");
				subMeaning = subMeaning.Replace("d'è", "de è");
				subMeaning = subMeaning.Replace("d'ê", "de ê");
				subMeaning = subMeaning.Replace("d'ë", "de ë");

				subMeaning = subMeaning.Replace("d'i", "de i");
				subMeaning = subMeaning.Replace("d'î", "de î");
				subMeaning = subMeaning.Replace("d'ï", "de ï");

				subMeaning = subMeaning.Replace("d'o", "de o");
				subMeaning = subMeaning.Replace("d'ô", "de ô");
				subMeaning = subMeaning.Replace("d'ö", "de ö");

				subMeaning = subMeaning.Replace("d'u", "de u");
				subMeaning = subMeaning.Replace("d'ù", "de ù");

				subMeaning = subMeaning.Replace("d'y", "de y");

				#endregion	replace "d'V" par "de V" in the text.

				string[] subMeaningSubStrings = subMeaning.Split(' ');

				if (subMeaningSubStrings.Length == 1)
				{ 
					continue;
				}

				this.SubStrings__becoming_languageWords	= new List<string>();
				Form__SubStrings form__SubStrings = new Form__SubStrings(this, subMeaningSubStrings);
				DialogResult dialogResult__Form__SubStrings = form__SubStrings.ShowDialog();
				if (dialogResult__Form__SubStrings == DialogResult.Cancel)
				{ 
					continue;
				}
				subMeaningSubStrings = this.SubStrings__becoming_languageWords.ToArray();

				foreach (string subMeaningSubString in subMeaningSubStrings.ToArray())
				{
					languageWord
						= this.DataSet.LanguageWord
						.FindByLanguageCodeString
						(
							currentLanguageCode,
							subMeaningSubString
						);

					/// toujours false dans cette nouvelle version car on VEUT lier les mots choisis dans la forme SubStrings.
					ask_Yes_or_No_for_link_creating = false;

					if (languageWord == null)
					{
						languageWord
							= this.DataSet.LanguageWord
							.AddLanguageWordRow
							(
								currentLanguage,
								subMeaningSubString
							);
					}

					#region		(ancienne version chiante)
					
					//ask_Yes_or_No_for_link_creating = true;
					//if (languageWord == null)
					//{
					//	DialogResult dialogResult = DialogResult.Cancel; /// initialisation obligatoire sans importance.
					//	if (ask_Yes_or_No_for_creating__ALL)
					//	{
					//		dialogResult =
					//			MessageBox.Show
					//			(
					//				"Do you want to create the new Language Word :\n\n'" + subMeaningSubString + "'\n\n?'",
					//				"New Language Word ?",
					//				MessageBoxButtons.YesNo,
					//				MessageBoxIcon.Question
					//			);
					//		if (dialogResult == DialogResult.Cancel)
					//		{
					//			ask_Yes_or_No_for_creating__ALL = false;
					//		}
					//	}

					//	if
					//	(
					//		!ask_Yes_or_No_for_creating__ALL
					//		||
					//		dialogResult == DialogResult.Yes
					//	)
					//	{
					//		languageWord
					//			= this.DataSet.LanguageWord
					//			.AddLanguageWordRow
					//			(
					//				currentLanguage,
					//				subMeaningSubString
					//			);

					//		ask_Yes_or_No_for_link_creating = false;
					//	}
					//}
					
					#endregion	(ancienne version chiante)

					if (returnedLanguageWord == null && languageWord != null)
					{
						returnedLanguageWord = languageWord;
					}

					if (languageWord != null)
					{
						BabebiDataSet.Word_LanguageWordRow word_languageWord
							= this.DataSet.Word_LanguageWord
							.FindByWordIdLanguageCodeLanguageWordString
							(
								word__Id,
								currentLanguageCode,
								subMeaningSubString
							);
						
						if (word_languageWord == null)
						{
							DialogResult dialogResult = DialogResult.Cancel;	 /// initialisation obligatoire avec une valeur sans importance.
							if (ask_Yes_or_No_for_creating__ALL && ask_Yes_or_No_for_link_creating)
							{
								dialogResult =
									MessageBox.Show
									(
										"Do you want to create a link between :\n\n" +
										"   - the language word = '" + subMeaningSubString + "',\n\n" +
										"     and\n\n" +
										"   - the babebi word   = '" + word__UniqueKeystring__used_in_error_messages_only + "'\n\n\n?" +
										"Its meaning of this Word is : '" + word_language__meaning + "'.",
										"To Language Word Linking",
										MessageBoxButtons.YesNo,
										MessageBoxIcon.Question
									);
								if (dialogResult == DialogResult.Cancel)
								{
									ask_Yes_or_No_for_creating__ALL = false;
								}
							}

							if
							(
								! ask_Yes_or_No_for_creating__ALL
								||
								! ask_Yes_or_No_for_link_creating
								||
								dialogResult == DialogResult.Yes
							)
							{
								this.DataSet.Word_LanguageWord
									.AddWord_LanguageWordRow
									(
										word__Id,
										currentLanguageCode,
										subMeaningSubString
									);
							}
						}
					}
				}
			}

			return returnedLanguageWord;
		}
		*/
		#endregion	// l'endroit surper compliqué où l'on crée (ou non) les LanguageWords à partir du Meaning.

		internal void Ctor__CreateUpdate__Word
		(
			Form form,
			Button button__CreateUpdate,
			Button button__Clone,
			string modeName,
			Label label__Word__Id,
			Label label__Word__UniqueKeyString,
			Label label__Word_Language__Meaning,
			Label label__WordType_LanguageName,
			TextBox textBox__Word__Id,
			TextBox textBox__Word__UniqueKeyString,
			TextBox textBox__Word_Language__Meaning,
			ComboBox comboBox__WordType_LanguageName,
			bool isUniqueKeyStringComputed,
		out	TextBox_WEM textBox_WEM__Word__Id,
		out	TextBox_WEM textBox_WEM__Word__UniqueKeyString,
		out	TextBox_WEM textBox_WEM__Word_Language__Meaning,
		out	ComboBox_WEM comboBox_WEM__WordType_LanguageName,
			bool trueForCreate__falseForUpdate,
		ref int	word__Id,
		ref BabebiDataSet.WordType_LanguageRow selected__WordType_Language,
			BabebiDataSet.WordRow			current__Word,					
			BabebiDataSet.Word_LanguageRow	current__Word_Language
		)
		{
			this.Ctor__CreateUpdate__Word_Pattern
			(
				true,
				form,
				button__CreateUpdate,
				button__Clone,
				modeName,
				label__Word__Id,
				label__Word__UniqueKeyString,
				label__Word_Language__Meaning,
				label__WordType_LanguageName,
				textBox__Word__Id,
				textBox__Word__UniqueKeyString,
				textBox__Word_Language__Meaning,
				comboBox__WordType_LanguageName,
				isUniqueKeyStringComputed,
			out	TextBox_WEM textBox_WEM__Word__Id_,
			out	TextBox_WEM textBox_WEM__Word__UniqueKeyString_,
			out	TextBox_WEM textBox_WEM__Word_Language__Meaning_,
			out	ComboBox_WEM comboBox_WEM__WordType_LanguageName_,
				trueForCreate__falseForUpdate,
			ref word__Id,
			ref selected__WordType_Language,
				current__Word,					
				current__Word_Language
			);
			textBox_WEM__Word__Id				= textBox_WEM__Word__Id_				;
			textBox_WEM__Word__UniqueKeyString	= textBox_WEM__Word__UniqueKeyString_	;
			textBox_WEM__Word_Language__Meaning	= textBox_WEM__Word_Language__Meaning_	;
			comboBox_WEM__WordType_LanguageName	= comboBox_WEM__WordType_LanguageName_	;

			#region		(version typée)
			/*
			if (trueForCreate__falseForUpdate)
			{
				form.Text = "Create a new 'Word" + (modeName == MainForm.ModeName_NotDefined ? "" : " (" + modeName + ") ") + "' :";
				button__CreateUpdate.Text = "CREATE";

				if (current__Word == null)
				{
					button__Clone.Visible = false;	/// car on ne peut pas cloner si current__Word == null.
				}

				#region		Id

				word__Id = this.WordId__Next();

				textBox__Word__Id.Text = word__Id.ToString();

				#endregion	Id
				#region		WordType

				List<WordTypeComboBoxItem> wordTypeComboBoxItems = WordTypeComboBoxItem.BuildWordTypeComboBoxItems(this.Current__Language);
				comboBox__WordType_LanguageName.Items.AddRange(wordTypeComboBoxItems.ToArray());

				#endregion	WordType
			}
			else
			{
				form.Text = "Update an existing 'Word" + (modeName == MainForm.ModeName_NotDefined ? "" : " (" + modeName + ") ") + "' :";
				button__CreateUpdate.Text = "UPDATE";
				button__Clone.Visible = false;

				textBox__Word__Id				.Text = current__Word.Id.ToString();

				if (textBox__Word__UniqueKeyString != null)
				{
					/// la UniqueKeyString n'est pas un champ calculé.
					textBox__Word__UniqueKeyString.Text = current__Word.UniqueKeyString;
				}
				textBox__Word_Language__Meaning	.Text = current__Word_Language.Meaning;

				#region		comboBox__WordType_LanguageName

				WordTypeComboBoxItem focusedWordTypeComboBoxItem;
				List<WordTypeComboBoxItem> wordTypeComboBoxItems 
					= WordTypeComboBoxItem
					.BuildWordTypeComboBoxItems
					(
						this.Current__Language, 
						current__Word_Language.WordType_LanguageRowParent,
					out focusedWordTypeComboBoxItem
					);

				comboBox__WordType_LanguageName.Items.AddRange(wordTypeComboBoxItems.ToArray());

				if (focusedWordTypeComboBoxItem != null)
				{
					comboBox__WordType_LanguageName.SelectedItem = focusedWordTypeComboBoxItem;
				}

				#endregion	comboBox__WordType_LanguageName				
			}
			*/
			#endregion	(version typée)
		}

		internal void Clone__Word
		(
			TextBox textBox__Word__UniqueKeyString,
			TextBox textBox__Word_Language__Meaning,
			ComboBox comboBox__WordType_LanguageName,
			bool isUniqueKeyStringComputed,
			BabebiDataSet.WordRow			current__Word,					
			BabebiDataSet.Word_LanguageRow	current__Word_Language
		)
		{
			this.Clone__Word_Pattern
			(
				true,
				textBox__Word__UniqueKeyString,
				textBox__Word_Language__Meaning,
				comboBox__WordType_LanguageName,
				isUniqueKeyStringComputed,
				current__Word,
				current__Word_Language
			);

			#region		(version typée)
			/*
			if (textBox__Word__UniqueKeyString != null)
			{
				/// UniqueKeyField n'est donc pas un champ calculé.
				textBox__Word__UniqueKeyString.Text = current__Word.UniqueKeyString + "babebi";
			}
			textBox__Word_Language__Meaning	.Text = current__Word_Language.Meaning  + "undeuxtrois";

			WordTypeComboBoxItem focusedWordTypeComboBoxItem 
				= new WordTypeComboBoxItem(current__Word_Language.WordType_LanguageRowParent);
			comboBox__WordType_LanguageName.SelectedItem = focusedWordTypeComboBoxItem;
			*/
			#endregion	(version typée)
		}

		#endregion	functions

		#region		search a Word methods

		/// <summary>
		/// return true if only 1.
		/// return false if N with 1 matching.
		/// return null if N with no matching.
		/// </summary>
		internal bool? textBox__Word__UniqueKeyString__TextChanged
		(
			TextBox								textBox__Word__UniqueKeyString	,
			TextBox								textBox__Word__Meaning			,
			DataTable							guiTable__Word					,
			string								hide_this_Word__UniqueKeyString	,
		out BabebiDataSet.WordRow			selected__Word, 
		out BabebiDataSet.Word_LanguageRow	selected__Word_Language
		)
		{
			bool? b_ = this.textBox__Search__UniqueKeyString__TextChanged
				(
					true,
					textBox__Word__UniqueKeyString	,
					textBox__Word__Meaning			,
					guiTable__Word					,
					hide_this_Word__UniqueKeyString	,
				out DataRow	selected__DataRow_, 
				out DataRow	selected__DataRow_Language_
				);

			if (b_.HasValue)
			{
				selected__Word			= (BabebiDataSet.WordRow			)selected__DataRow_;
				selected__Word_Language	= (BabebiDataSet.Word_LanguageRow)selected__DataRow_Language_;
			}
			else
			{ 
				selected__Word = null;
				selected__Word_Language = null;
			}

			return b_;
		}

		/// <summary>
		/// return true if only 1.
		/// return false if N with 1 matching.
		/// return null if N with no matching.
		/// </summary>
		internal bool? textBox__Word__Meaning__TextChanged
		(
			TextBox							textBox__Word__UniqueKeyString,
			TextBox							textBox__Word__Meaning,
			DataTable						guiTable__Word,
		out BabebiDataSet.WordRow			selected__Word, 
		out BabebiDataSet.Word_LanguageRow	selected__Word_Language
		)
		{
			bool? b_ = this.textBox__Search__Meaning__TextChanged
				(
					true,
					textBox__Word__UniqueKeyString		,
					textBox__Word__Meaning				,
					guiTable__Word						,
				out DataRow	selected__DataRow_			, 
				out DataRow	selected__DataRow_Language_ 
				);

			if (b_.HasValue)
			{
				selected__Word			= (BabebiDataSet.WordRow			)selected__DataRow_;
				selected__Word_Language	= (BabebiDataSet.Word_LanguageRow	)selected__DataRow_Language_;
			}
			else
			{ 
				selected__Word = null;
				selected__Word_Language = null;
			}

			return b_;
		}

		#endregion	search a Word methods
	}
}