﻿ using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void remove__WordByInsertion()
		{
			///	Where we delete or not the parent LetterCluster.
			if 
			(
				this.Current__WordByInsertion.LetterClusterRow.GetWordByInsertionRows().Length == 1
				&&
				this.Current__WordByInsertion.LetterClusterRow.GetDerivatingRows().Length == 0
			)
			{
				/// Le LetterOrSymbolCluster parent n'est utilisé que pour cet PatternByInsertion qui doit disparaitre
				/// => il faut le supprimer. MAIS... à cause du DeleteCascade la row WordByInsertion va disparaitre
				/// dès que l'on va supprimer la row parente LetterCluster. 
				/// 
				/// Les rows-enfants LetterOrSymbolClusterLetterOrSymbol vont aussi être délétées par cascade.

				this.DataSet.LetterCluster.RemoveLetterClusterRow(this.Current__WordByInsertion.LetterClusterRow);
			}
			else
			{
				/// on ne supprime donc que la row du Mode ByInsertion.

				this.DataSet.WordByInsertion.RemoveWordByInsertionRow(this.Current__WordByInsertion);
			}

			this.Current__Word.ModeCode = MainForm.ModeCode_NotDefined;

			this.populate__WordByInsertion(PopulatingType.Cleaning);
		}

		internal void populate__WordByInsertion(PopulatingType populatingType)
		{
			/// les Current__#(ByInsertion) rows.
			if (populatingType == PopulatingType.Cleaning)
			{
				this.Current__WordByInsertion = null;

				this.Current__Word__of__WordByInsertion__Parent = null;
				this.Current__Word_Language__of__WordByInsertion__Parent = null;

				this.Current__LetterCluster__of__WordByInsertion = null;

			}
			else if (populatingType == PopulatingType.FindingRowsAndSettingFields)
			{
				this.Current__WordByInsertion
					= this.DataSet.WordByInsertion.FindById(this.Current__Word.Id);

				this.Current__Word__of__WordByInsertion__Parent
					= this.Current__WordByInsertion.WordRowByWordByInsertion__Word__Origin;

				this.Current__Word_Language__of__WordByInsertion__Parent
					= this.DataSet.Word_Language
					.FindByWordIdLanguageCode
					(
						this.Current__Word__of__WordByInsertion__Parent.Id,
						this.Current__Language.Code
					);

				this.Current__LetterCluster__of__WordByInsertion
					= this.Current__WordByInsertion.LetterClusterRow;
			}

			/// les textBoxes.
			if (populatingType == PopulatingType.Cleaning)
			{
				this.textBox__Word__ByInsertion__ParentWordString	.Text	= null;
				this.textBox__Word__ByInsertion__ParentWordId		.Text	= null;
				this.textBox__Word__ByInsertion__ParentWordMeaning	.Text	= null;
				this.textBox__Word__ByInsertion__InsertionIndex		.Text	= null;
				this.textBox__Word__ByInsertion__LetterClusterString.Text	= null;
				this.button__Word__ByInsertion__CreateUpdate.Text = "CREATE";
			}
			else
			{
				this.textBox__Word__ByInsertion__ParentWordString	.Text = this.Current__Word__of__WordByInsertion__Parent.UniqueKeyString;
				this.textBox__Word__ByInsertion__ParentWordId		.Text = this.Current__Word__of__WordByInsertion__Parent.Id.ToString();
				this.textBox__Word__ByInsertion__ParentWordMeaning	.Text = this.Current__Word_Language__of__WordByInsertion__Parent.Meaning;
				this.textBox__Word__ByInsertion__InsertionIndex		.Text = this.Current__WordByInsertion.InsertionIndex.ToString();
				this.textBox__Word__ByInsertion__LetterClusterString.Text = this.Current__LetterCluster__of__WordByInsertion.String;
				this.button__Word__ByInsertion__CreateUpdate.Text = "UPDATE";
			}
		}

		private void button__WordByInsertion__CreateUpdate__Click()
		{
			Form__WordByInsertion__CreateUpdate form = new Form__WordByInsertion__CreateUpdate(this);

			if (form.ShowDialog() == DialogResult.Cancel)
			{
				this.populate__Word();

				return;
			}
		}
		private void button__WordByInsertion__CreateUpdate__Click(object sender, EventArgs e)
		{
			this.button__WordByInsertion__CreateUpdate__Click();
		}

		private void button__WordByInsertion__FocusWordParent__Click(object sender, EventArgs e)
		{
			this.Current__Word			= this.Current__Word__of__WordByInsertion__Parent; 
			this.Current__Word_Language = this.Current__Word_Language__of__WordByInsertion__Parent; 

			this.populate__Word();

			this.populate__LanguageWord();
		}

		#region		functions

		internal void textBox__LetterClusterString__TextChanged
		(
			TextBox_WEM textBox_WEM__LetterClusterString,
		ref BabebiDataSet.LetterClusterRow selected__LetterCluster,
			List<BabebiDataSet.LetterRow> letterList
		)
		{
			string letterClusterString = textBox_WEM__LetterClusterString.Text();

			if (string.IsNullOrEmpty(letterClusterString))
			{
				textBox_WEM__LetterClusterString
				.SetError
				(
					"The 'Letter Cluster' string can not be empty.",
					"Empty 'Letter Cluster'"
				);

				return;
			}

			letterList.Clear();

			DataRow[] letterClusterldataRows = this.DataSet.LetterCluster.Select("String = '" + letterClusterString + "'");

			if (letterClusterldataRows.Length == 0)
			{
				/// check if the LetterCluster string only contains valid Letters
				string errorCharString
					= this.Split_a_string_into_Letters
					(
						letterClusterString,
						letterList
					);

				if (errorCharString != null)
				{
					textBox_WEM__LetterClusterString
					.SetError
					(
						"The 'Letter Cluster' string contains an invalid character = '" + errorCharString + "'.",
						"Invalid character"
					);
				}
				else
				{
					selected__LetterCluster = null;    /// it will be created while click the UPDATE button.

					/// et dans ce cas on aura besoin de la LetterList.

					textBox_WEM__LetterClusterString.ClearError();
				}
			}
			else if (letterClusterldataRows.Length == 1)
			{
				selected__LetterCluster = (BabebiDataSet.LetterClusterRow)(letterClusterldataRows[0]);

				/// Dans ce cas on n'aura pas besoin de la LetterList.

				textBox_WEM__LetterClusterString.ClearError();
			}
			else
			{
				throw new Exception(letterClusterldataRows.Length.ToString());
			}

		}

		#endregion	functions
	}
}