﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		/// utilisés (en bas) dans le tableau des WordByInsertions du current Word (choisi en haut à gauche)
		internal BabebiDataSet.WordOrPatternRow		Current__WordOrPattern__of__WordByInsertion__of__Current__Word = null;
		internal BabebiDataSet.WordRow				Current__Word__of__WordByInsertion__of__Current__Word = null;
		internal BabebiDataSet.WordByInsertionRow	Current__WordByInsertion__of__Current__Word = null;
		internal BabebiDataSet.Word_LanguageRow		Current__Word_Language__of__WordByInsertion__of__Current__Word = null;

		private void bindingSource__WordByInsertion__of__Current__Word__CurrentChanged(object sender, EventArgs e)
		{
			if (this.BindingSource__WordByInsertion__of__Current__Word.Current != null)
			{
				DataRow guiDataRow
					=
					(
						(DataRowView)
						(this.BindingSource__WordByInsertion__of__Current__Word.Current)
					).Row;
				
				int wordId 
					= this.guiTable__WordByInsertion__of__Current__Word
					.GetValue__Id(guiDataRow);

				this.Current__WordByInsertion__of__Current__Word
					= this.DataSet.WordByInsertion
					.FindById(wordId);

				this.Current__Word__of__WordByInsertion__of__Current__Word
					= this.Current__WordByInsertion__of__Current__Word
					.WordRowParentByWordByInsertion__Word;

				this.Current__WordOrPattern__of__WordByInsertion__of__Current__Word
					= this.Current__Word__of__WordByInsertion__of__Current__Word
					.WordOrPatternRowParent;

				this.Current__Word_Language__of__WordByInsertion__of__Current__Word
					= this.DataSet
					.Word_Language
					.FindByWordIdLanguageCode
					(
						this.Current__Word__of__WordByInsertion__of__Current__Word.Id,
						this.Current__Language.Code
					);

				this.button__WordByInsertion__of__Current__Word__Update.Visible = true;
				this.button__WordByInsertion__of__Current__Word__Focus.Visible = true;
				this.button__WordByInsertion__of__Current__Word__Delete.Visible = true;
			}
			else
			{ 
				this.Current__WordByInsertion__of__Current__Word = null;
				this.Current__Word__of__WordByInsertion__of__Current__Word = null;
				this.Current__WordOrPattern__of__WordByInsertion__of__Current__Word = null;
				this.Current__Word_Language__of__WordByInsertion__of__Current__Word = null;

				this.button__WordByInsertion__of__Current__Word__Update.Visible = false;
				this.button__WordByInsertion__of__Current__Word__Focus.Visible = false;
				this.button__WordByInsertion__of__Current__Word__Delete.Visible = false;
			}
		}

		private void populate__WordByInsertion__of__Current__Word()
		{
			bool? has1RowAtLeast = this.guiTable__WordByInsertion__of__Current__Word.Populate();

			if (has1RowAtLeast.HasValue && has1RowAtLeast.Value)
			{
				this.button__WordByInsertion__of__Current__Word__Update.Visible = true;
				this.button__WordByInsertion__of__Current__Word__Focus.Visible = true;
				this.button__WordByInsertion__of__Current__Word__Delete.Visible = true;
			}
			else if (has1RowAtLeast.HasValue && !has1RowAtLeast.Value)
			{
				this.button__WordByInsertion__of__Current__Word__Update.Visible = false;
				this.button__WordByInsertion__of__Current__Word__Focus.Visible = false;
				this.button__WordByInsertion__of__Current__Word__Delete.Visible = false;
			}
			else
			{
				/// on ne touche à rien car l'état est mal géré...
			}
			
		}

		private void button__WordByInsertion__of__Current__Word__Create__Click(object sender, EventArgs e)
		{
			Form__WordByInsertion__of__Current__Word__CreateUpdate form = new Form__WordByInsertion__of__Current__Word__CreateUpdate(this, true);

			if (form.ShowDialog() == DialogResult.Cancel)
			{
				return;
			}

			DataRow focusedGuiDataRow 
				= this.guiTable__WordByInsertion__of__Current__Word
				.Find(this.Current__WordByInsertion__of__Current__Word.Id);

			FocusGridRow(this.BindingSource__WordByInsertion__of__Current__Word, focusedGuiDataRow);

		}

		private void button__WordByInsertion__of__Current__Word__Update_Click(object sender, EventArgs e)
		{
			Form__WordByInsertion__of__Current__Word__CreateUpdate form = new Form__WordByInsertion__of__Current__Word__CreateUpdate(this, false);

			form.ShowDialog();
		}

		private void button__WordByInsertion__of__Current__Word__Delete__Click(object sender, EventArgs e)
		{
			if (this.Current__WordByInsertion__of__Current__Word == null)
			{
				MessageBox.Show("There is no 'Word (By insertion)' to delete.", "Empty", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return; 
			}

			DialogResult dialogResult 
				= MessageBox.Show
				(
					"Do you really want to delete the 'Word (By insertion)' (" + 
					this.Current__WordByInsertion__of__Current__Word.WordRowParentByWordByInsertion__Word.UniqueKeyString +
					") ?",
					"Deleting", 
					MessageBoxButtons.YesNo, 
					MessageBoxIcon.Question
				);
			if (dialogResult == DialogResult.No)
			{
				return;
			}

			this.DeleteWord(this.Current__WordByInsertion__of__Current__Word.WordRowParentByWordByInsertion__Word);
		}

		private void button__WordByInsertion__of__Current__Word__Focus_Click(object sender, EventArgs e)
		{
			if (this.Current__WordByInsertion__of__Current__Word == null)
			{
				return;
			}

			this.Current__Word = this.Current__WordByInsertion__of__Current__Word.WordRowParentByWordByInsertion__Word;

			this.Current__Word_Language 
				= this.DataSet.Word_Language
				.FindByWordIdLanguageCode
				(
					this.Current__Word.Id,
					this.Current__Language.Code
				);

			this.populate__Word();
		}
	}
}