﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void remove__WordDerivated()
		{
			///	the parent Word is never removed (it is not like Letter or Symbol Clusters...).
				
			this.DataSet.WordDerivated.RemoveWordDerivatedRow(this.Current__WordDerivated);
			
			this.Current__Word.ModeCode = MainForm.ModeCode_NotDefined;

			this.populate__WordDerivated(PopulatingType.Cleaning);
		}

		internal void populate__WordDerivated(PopulatingType populatingType)
		{
			/// les Current__#(Derivated) rows.
			if (populatingType == PopulatingType.Cleaning)
			{
				this.Current__WordDerivated											= null;
				this.Current__WordDerivating__of__WordDerivated						= null;
				this.Current__Word__of__WordDerivating__of__WordDerivated			= null;
				this.Current__Word_Language__of__WordDerivating__of__WordDerivated	= null;
				this.Current__DerivatedWordType_Language__of__WordDerivated			= null;
				this.Current__Derivating_Language__of__WordDerivated				= null;
			}
			else if (populatingType == PopulatingType.FindingRowsAndSettingFields)
			{

				this.Current__WordDerivated
					= this.DataSet.WordDerivated
					.FindById(this.Current__Word.Id);

				this.Current__WordDerivating__of__WordDerivated						
					= this.Current__WordDerivated.WordDerivatingRowParent;

				this.Current__Word__of__WordDerivating__of__WordDerivated
					= this.Current__WordDerivating__of__WordDerivated.WordRowParent;

				this.Current__Word_Language__of__WordDerivating__of__WordDerivated
					= this.DataSet.Word_Language
					.FindByWordIdLanguageCode
					(
						this.Current__Word__of__WordDerivating__of__WordDerivated.Id,
						this.Current__Language.Code
					);

				this.Current__DerivatedWordType_Language__of__WordDerivated
					= this.DataSet.DerivatedWordType_Language
					.FindByDerivatedWordTypeIdLanguageCode
					(
						this.Current__WordDerivated.DerivatingRowParent.DerivatingWordType_DerivatedWordTypeRowParent.DerivatedWordTypeRow.Id, /// chaud...
						this.Current__Language.Code
					);

				this.Current__Derivating_Language__of__WordDerivated
					= this.DataSet.Derivating_Language
					.FindByDerivatingIdLanguageCode
					(
						this.Current__WordDerivated.DerivatingRowParent.Id, /// chaud...
						this.Current__Language.Code
					);
			}

			/// les textBoxes.
			if (populatingType == PopulatingType.Cleaning)
			{
				this.textBox__WordDerivated__WordDerivating__WordString				.Text = null;
				this.textBox__WordDerivated__WordDerivating__Word_LanguageMeaning	.Text = null;
				this.textBox__WordDerivated__DerivatedWordType						.Text = null;
				this.textBox__WordDerivated__Derivating								.Text = null;		

				this.button__Word__ByInsertion__CreateUpdate.Text = "CREATE";
			}
			else
			{
				this.textBox__WordDerivated__WordDerivating__WordString				.Text = this.Current__Word__of__WordDerivating__of__WordDerivated.UniqueKeyString;
				this.textBox__WordDerivated__WordDerivating__Word_LanguageMeaning	.Text = this.Current__Word_Language__of__WordDerivating__of__WordDerivated.Meaning;
				this.textBox__WordDerivated__DerivatedWordType						.Text = this.Current__DerivatedWordType_Language__of__WordDerivated.Name;
				this.textBox__WordDerivated__Derivating								.Text = this.Current__Derivating_Language__of__WordDerivated.Name;		

				this.button__Word__ByInsertion__CreateUpdate.Text = "UPDATE";
			}
		}

		private void button__WordDerivated__CreateUpdate__Click(bool trueForCreate__falseForUpdate)
		{
			Form__WordDerivated__CreateUpdate form = new Form__WordDerivated__CreateUpdate(this);

			if (trueForCreate__falseForUpdate)
			{
				if (form.ShowDialog() == DialogResult.Cancel)
				{
					this.populate__Word();

					return;
				}
			}
			else
			{
				form.Show();
			}
		}
		private void button__WordDerivated__CreateUpdate__Click(object sender, EventArgs e)
		{
			this.button__WordDerivated__CreateUpdate__Click(false);
		}

		private void button__WordDerivated__FocusWordDerivating__Click(object sender, EventArgs e)
		{
			this.Current__Word = this.Current__WordDerivated.WordDerivatingRowParent.WordRowParent;
			this.Current__Word_Language 
				= 
				(BabebiDataSet.Word_LanguageRow)
				(this.DataRow__Language(this.Current__Word));

			this.populate__Word();
		}

		private void button__WordDerivated__PriorDerivated_Click(object sender, EventArgs e)
		{
			BabebiDataSet.WordDerivatedRow priorDerivated = this.button__WordDerivated___Derivated_Click_(true);

			this.Current__Word			= priorDerivated.WordRowParent;
			this.Current__Word_Language	= (BabebiDataSet.Word_LanguageRow)(this.DataRow__Language(this.Current__Word));
			this.Current__WordDerivated	= priorDerivated;

		//	this.populate__Word();
		//	this.populate__WordDerivated();
		}
		private void button__WordDerivated__NextDerivated_Click(object sender, EventArgs e)
		{
			BabebiDataSet.WordDerivatedRow nextDerivated = this.button__WordDerivated___Derivated_Click_(false);

			this.Current__Word			= nextDerivated.WordRowParent;
			this.Current__Word_Language	= (BabebiDataSet.Word_LanguageRow)(this.DataRow__Language(this.Current__Word));
			this.Current__WordDerivated	= nextDerivated;

		//	this.populate__Word();
		//	this.populate__WordDerivated();
		}
		private BabebiDataSet.WordDerivatedRow button__WordDerivated___Derivated_Click_(bool trueToPrior__falseForNext)
		{
			BabebiDataSet.WordDerivatedRow[] wordDerivatedRows = this.Current__WordDerivated.WordDerivatingRowParent.GetWordDerivatedRows();

			SortedDictionary<string, BabebiDataSet.WordDerivatedRow> dico = new SortedDictionary<string, BabebiDataSet.WordDerivatedRow>();

			foreach (BabebiDataSet.WordDerivatedRow wordDerivated in wordDerivatedRows)
			{
				dico.Add(wordDerivated.DerivatingRowParent.LetterClusterString, wordDerivated); 
			}


			string currentKey = this.Current__WordDerivated.DerivatingRowParent.LetterClusterString;
			int indexOfCurrent = -1;
			foreach (KeyValuePair<string, BabebiDataSet.WordDerivatedRow> key__value in dico)
			{
				indexOfCurrent++;

				if (key__value.Key == currentKey)
				{
					break;
				}
			}

			if (trueToPrior__falseForNext)
			{
				if (indexOfCurrent == 0)
				{
					return dico.ElementAt(dico.Count - 1).Value;
				}
				else
				{
					return dico.ElementAt(indexOfCurrent - 1).Value;
				}
			}
			else
			{
				if (indexOfCurrent == dico.Count - 1)
				{
					return dico.ElementAt(0).Value;
				}
				else
				{
					return dico.ElementAt(indexOfCurrent + 1).Value;
				}
			}
		}
	}
}