﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		/// utilisés (en bas) dans le tableau des WordDerivateds du WordDerivating (choisi en haut à gauche)

	//	public int DataGridView__WordDerivated__of__WordDerivating__CurrentWordId = -1;

		internal BabebiDataSet.WordOrPatternRow					Current__WordOrPattern__of__WordDerivated__of__WordDerivating = null;
		internal BabebiDataSet.WordRow							Current__Word__of__WordDerivated__of__WordDerivating = null;
		internal BabebiDataSet.Word_LanguageRow					Current__Word_Language__of__WordDerivated__of__WordDerivating = null;
		internal BabebiDataSet.WordDerivatedRow					Current__WordDerivated__of__WordDerivating = null;

		private void bindingSource__WordDerivated__of__WordDerivating__CurrentChanged(object sender, EventArgs e)
		{
			if (this.BindingSource__WordDerivated__of__WordDerivating.Current != null)
			{
				DataRow guiDataRow
					=
					(
						(DataRowView)
						(this.BindingSource__WordDerivated__of__WordDerivating.Current)
					).Row;

				#region		(ancienne version)

			//	int wordId = this.guiTable__WordDerivated__of__WordDerivating.GetValue__WordId(guiDataRow);
			//	this.DataGridView__WordDerivated__of__WordDerivating__CurrentWordId = wordId;

				#endregion	(ancienne version)

				int wordId = this.guiTable__WordDerivated__of__WordDerivating.GetValue__Id(guiDataRow);

			//	this.guiTable__WordDerivated__of__WordDerivating.Set__Current__Id(wordId);

				this.Current__WordDerivated__of__WordDerivating
					= this.DataSet.WordDerivated
					.FindById(wordId);

				this.Current__Word__of__WordDerivated__of__WordDerivating
					= this.Current__WordDerivated__of__WordDerivating.WordRowParent;

				this.Current__WordOrPattern__of__WordDerivated__of__WordDerivating
					= this.Current__Word__of__WordDerivated__of__WordDerivating
					.WordOrPatternRowParent;

				this.Current__Word_Language__of__WordDerivated__of__WordDerivating
					= this.DataSet
					.Word_Language
					.FindByWordIdLanguageCode
					(
						this.Current__WordDerivated__of__WordDerivating.Id,
						this.Current__Language.Code
					);

				this.button__WordDerivated__of__WordDerivating__Update.Visible = true;
				this.button__WordDerivated__of__WordDerivating__Focus.Visible = true;
				this.button__WordDerivated__of__WordDerivating__Delete.Visible = true;
			}
			else
			{ 
			//	this.guiTable__WordDerivated__of__WordDerivating.Set__Current__Id(-1);

				this.Current__WordDerivated__of__WordDerivating = null;
				this.Current__Word__of__WordDerivated__of__WordDerivating = null;
				this.Current__WordOrPattern__of__WordDerivated__of__WordDerivating = null;
				this.Current__Word_Language__of__WordDerivated__of__WordDerivating = null;

				this.button__WordDerivated__of__WordDerivating__Update.Visible = false;
				this.button__WordDerivated__of__WordDerivating__Focus.Visible = false;
				this.button__WordDerivated__of__WordDerivating__Delete.Visible = false;
			}
		}


		private void button__WordDerivated__of__WordDerivating__Create__Click(object sender, EventArgs e)
		{
			if (this.Current__WordDerivating == null)
			{
				BabebiDataSet.DerivatingWordTypeRow[] DerivatingWordTypes = this.Current__Word.WordTypeRow.GetDerivatingWordTypeRows();
				if (DerivatingWordTypes.Length == 1)
				{
					this.Current__WordDerivating
						= this.DataSet.WordDerivating
						.AddWordDerivatingRow
						(
							this.Current__Word.Id, 
							this.Current__Word.WordTypeId, 
							DerivatingWordTypes[0].Id
						);

					this.Current__Word.HasDerivating = true;

					this.populate__WordDerivating();
				}
				else
				{
					MessageBox.Show
					(
						"No Word Derivating extension has been appended to this Word yet.\n" +
						"You have to click on the button on the top-right of the current Tab Page.",
						"Missing Word Derivating",
						MessageBoxButtons.OK,
						MessageBoxIcon.Information
					);

					return;
				}
			}

			this.Current__WordDerivated__of__WordDerivating = null;

			Form__WordDerivated__of__WordDerivating__CreateUpdate form = new Form__WordDerivated__of__WordDerivating__CreateUpdate(this, true);

			if (form.ShowDialog() == DialogResult.Cancel)
			{
				return;
			}

			DataRow focusedGuiDataRow 
				= this.guiTable__WordDerivated__of__WordDerivating
				.Find(this.Current__WordDerivated__of__WordDerivating.Id);

			FocusGridRow(this.BindingSource__WordDerivated__of__WordDerivating, focusedGuiDataRow);

			/*
				#region		focus on the newly created row.

				int rowIndex = this.mainForm.BindingSource__WordDerivated__of__WordDerivating.Find("WordId", this.word__Id);

				this.mainForm.DataGridView__WordDerivated__of__WordDerivating.CurrentCell 
					= this.mainForm.DataGridView__WordDerivated__of__WordDerivating.Rows[rowIndex].Cells[0];

				#endregion	focus on the newly created row.
			*/
		}

		private void button__WordDerivated__of__WordDerivating__Update__Click(object sender, EventArgs e)
		{
			Form__WordDerivated__of__WordDerivating__CreateUpdate form = new Form__WordDerivated__of__WordDerivating__CreateUpdate(this, false);

			form.ShowDialog();
		}

		private void button__WordDerivated__of__WordDerivating__Delete__Click(object sender, EventArgs e)
		{
			if (this.Current__WordDerivated__of__WordDerivating == null)
			{
				MessageBox.Show("There is no 'Word (Derivated)' to delete.", "Empty", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return; 
			}

			DialogResult dialogResult 
				= MessageBox.Show
				(
					"Do you really want to delete the 'Word' (" + 
					this.Current__WordDerivated__of__WordDerivating.WordRowParent.UniqueKeyString +
					") ?",
					"Deleting", 
					MessageBoxButtons.YesNo, 
					MessageBoxIcon.Question
				);
			if (dialogResult == DialogResult.No)
			{
				return;
			}

			this.DeleteWord(this.Current__WordDerivated__of__WordDerivating.WordRowParent);
		}

		private void button__WordDerivated__of__WordDerivating__Focus__Click(object sender, EventArgs e)
		{
			if (this.Current__WordDerivated__of__WordDerivating == null)
			{
				return;
			}

			this.Current__Word = this.Current__WordDerivated__of__WordDerivating.WordRowParent;
			this.Current__WordOrPattern__of__Word = this.Current__Word.WordOrPatternRowParent;
			this.Current__Word_Language = (BabebiDataSet.Word_LanguageRow)(this.DataRow__Language(this.Current__Word));

			BabebiDataSet.Word_LanguageWordRow[] word_languageWords =	this.Current__Word_Language.GetWord_LanguageWordRows();

			if (word_languageWords.Length > 0)
			{
				this.Current__LanguageWord = word_languageWords[0].LanguageWordRowParent;
			}
			else
			{
				this.Current__LanguageWord = null;
			}

			this.populate__Word();
		}
	}
}