﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{

		internal BabebiDataSet.WordDerivatingRow				Current__WordDerivating = null;
		internal BabebiDataSet.DerivatingWordType_LanguageRow	Current__DerivatingWordType_Language__of__WordDerivating = null;


		private void button__WordDerivating__Append__Click(object sender, EventArgs e)
		{
			Form__WordDerivating__Append form = new Form__WordDerivating__Append(this);

			if (! form.IsClosed && form.ShowDialog() != DialogResult.OK)
			{
				return;
			} 

			this.populate__WordDerivating();
		}

		private void button__WordDerivating__Remove__Click(object sender, EventArgs e)
		{
			int numberOfChildren = this.Current__WordDerivating.GetWordDerivatedRows().Length;

			if (numberOfChildren != 0)
			{
				MessageBox.Show
				(
					"This 'Derivating' can not be removed because it is already linked to " +
					numberOfChildren.ToString() +
					" 'Derivated Word(s)'.", 
					"Already linked", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Information
				);
				return;
			}

			this.DataSet.WordDerivating.RemoveWordDerivatingRow(this.Current__WordDerivating);
			this.Current__WordDerivating = null;

			this.Current__Word.HasDerivating = false;

			this.populate__WordDerivating();
		}

		private void button__WordDerivating__Update__Click(object sender, EventArgs e)
		{
			Form__WordDerivating__Update form = new Form__WordDerivating__Update(this);

			if (form.IsClosed)
			{
				return;
			}

			if (form.ShowDialog() != DialogResult.OK)
			{
				return;
			}

			this.populate__WordDerivating();
		}

		private void populate__WordDerivating()
		{
			if (this.Current__WordDerivating != null)
			{
				this.button__WordDerivating__Append.Enabled = false;
				this.button__WordDerivating__Remove.Enabled = true;

				this.Current__DerivatingWordType_Language__of__WordDerivating
					= 
					(BabebiDataSet.DerivatingWordType_LanguageRow)
					(
						this.DataRow__Language
						(
							this.Current__WordDerivating.DerivatingWordTypeRowParent
						)
					);

				this.textBox__WordDerivating__DerivatingWordType.Text 
					= this.Current__DerivatingWordType_Language__of__WordDerivating.Name;
			}
			else
			{
				this.button__WordDerivating__Append.Enabled = true;
				this.button__WordDerivating__Remove.Enabled = false;

				this.Current__DerivatingWordType_Language__of__WordDerivating = null;
				this.textBox__WordDerivating__DerivatingWordType.Text = null;
			}

			bool? has1RowAtLeast = this.guiTable__WordDerivated__of__WordDerivating.Populate();

			if (has1RowAtLeast.HasValue && has1RowAtLeast.Value)
			{
				this.button__WordDerivated__of__WordDerivating__Update.Visible = true;
				this.button__WordDerivated__of__WordDerivating__Focus.Visible = true;
				this.button__WordDerivated__of__WordDerivating__Delete.Visible = true;
			}
			else if (has1RowAtLeast.HasValue && !has1RowAtLeast.Value)
			{
				this.button__WordDerivated__of__WordDerivating__Update.Visible = false;
				this.button__WordDerivated__of__WordDerivating__Focus.Visible = false;
				this.button__WordDerivated__of__WordDerivating__Delete.Visible = false;
			}
			else
			{
				/// on ne touche à rien car l'état est mal géré...
			}
		}
	}
}