﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		/// utilisés dans la DGV des childrens du Pattern courant (en bas de Pattern)
		public BabebiDataSet.WordFromPatternRow		Current__WordFromPattern__of__Current__Pattern						= null;
		public BabebiDataSet.FromPatternRow			Current__FromPattern__of__WordFromPattern__of__Current__Pattern		= null;
		public BabebiDataSet.WordRow				Current__Word__of__WordFromPattern__of__Current__Pattern			= null;
		public BabebiDataSet.Word_LanguageRow		Current__Word_Language__of__WordFromPattern__of__Current__Pattern	= null;
		public BabebiDataSet.WordOrPatternRow		Current__WordOrPattern__of__WordFromPattern__of__Current__Pattern	= null;

		private void bindingSource__WordFromPattern__of__Current__Pattern__CurrentChanged(object sender, EventArgs e)
		{
			if (this.BindingSource__WordFromPattern__of__Current__Pattern.Current != null)
			{
				DataRow guiDataRow
					=
					(
						(DataRowView)
						(this.BindingSource__WordFromPattern__of__Current__Pattern.Current)
					).Row;

				if (guiDataRow.RowState == DataRowState.Detached)
				{
					return;
				}

				int wordId = this.guiTable__WordFromPattern__of__Current__Pattern.GetValue__Id(guiDataRow);

				this.Current__WordFromPattern__of__Current__Pattern						
					= this.DataSet.WordFromPattern
					.FindById(wordId);

				      this.Current__Word__of__WordFromPattern__of__Current__Pattern			
					= this.Current__WordFromPattern__of__Current__Pattern.WordRowParent;

				this.Current__Word_Language__of__WordFromPattern__of__Current__Pattern
					= this.DataSet.Word_Language
					.FindByWordIdLanguageCode
					(
						wordId,
						this.Current__Language.Code
					);

				this.Current__FromPattern__of__WordFromPattern__of__Current__Pattern	
					= this.Current__WordFromPattern__of__Current__Pattern.FromPatternRowParent;

				this.Current__WordOrPattern__of__WordFromPattern__of__Current__Pattern
					= this.Current__Word__of__WordFromPattern__of__Current__Pattern.WordOrPatternRowParent;

				this.button__Pattern__Children__WordFromPattern__Update.Visible = true;
				this.button__Pattern__Children__WordFromPattern__Focus.Visible	= true;
				this.button__Pattern__Children__WordFromPattern__Delete.Visible = true;
			}
			else
			{ 
				this.Current__WordFromPattern__of__Current__Pattern						= null;
				this.Current__Word__of__WordFromPattern__of__Current__Pattern			= null;
				this.Current__Word_Language__of__WordFromPattern__of__Current__Pattern	= null;
				this.Current__FromPattern__of__WordFromPattern__of__Current__Pattern	= null;
				this.Current__WordOrPattern__of__WordFromPattern__of__Current__Pattern	= null;

				this.button__Pattern__Children__WordFromPattern__Update	.Visible = false;
				this.button__Pattern__Children__WordFromPattern__Focus	.Visible = false;
				this.button__Pattern__Children__WordFromPattern__Delete	.Visible = false;
			}
		}

		private void button__Pattern__Children__WordFromPattern__Create__Click(object sender, EventArgs e)
		{
			Form__WordFromPattern__of__Current__Pattern__CreateUpdate form = new Form__WordFromPattern__of__Current__Pattern__CreateUpdate(this, true);

			if (form.ShowDialog() == DialogResult.Cancel)
			{
				return;
			}

			DataRow focusedGuiDataRow 
				= this.guiTable__WordFromPattern__of__Current__Pattern
				.Find(this.Current__WordFromPattern__of__Current__Pattern.Id);

			FocusGridRow(this.BindingSource__WordFromPattern__of__Current__Pattern, focusedGuiDataRow);
		}

		private void button__Pattern__Children__WordFromPattern__Update__Click(object sender, EventArgs e)
		{
			Form__WordFromPattern__of__Current__Pattern__CreateUpdate form = new Form__WordFromPattern__of__Current__Pattern__CreateUpdate(this, false);

			form.ShowDialog();
		}

		private void button__Pattern__Children__WordFromPattern__Delete__Click(object sender, EventArgs e)
		{
			if (this.Current__WordFromPattern__of__Current__Pattern == null)
			{
				MessageBox.Show("There is no 'Word (From Pattern)' to delete.", "Empty", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return; 
			}

			DialogResult dialogResult 
				= MessageBox.Show
				(
					"Do you really want to delete the 'Word' (" + 
					this.Current__WordFromPattern__of__Current__Pattern.WordRowParent.UniqueKeyString +
					") ?",
					"Deleting", 
					MessageBoxButtons.YesNo, 
					MessageBoxIcon.Question
				);
			if (dialogResult == DialogResult.No)
			{
				return;
			}

			this.DeleteWord(this.Current__WordFromPattern__of__Current__Pattern.WordRowParent);
		}

		private void button__Pattern__Children__WordFromPattern__Focus__Click(object sender, EventArgs e)
		{
			if (this.Current__WordFromPattern__of__Current__Pattern == null)
			{
				return;
			}

			this.Current__Word = this.Current__WordFromPattern__of__Current__Pattern.WordRowParent;

			this.Current__Word_Language = (BabebiDataSet.Word_LanguageRow)(this.DataRow__Language(this.Current__Word));

			BabebiDataSet.Word_LanguageWordRow[] word_languageWords =	this.Current__Word_Language.GetWord_LanguageWordRows();

			if (word_languageWords.Length > 0)
			{
				this.Current__LanguageWord = word_languageWords[0].LanguageWordRowParent;
			}
			else
			{
				this.Current__LanguageWord = null;
			}

			this.populate__Word();

			this.tabControl__Main.SelectedTab = this.tabPage__Word;
		}
	}
}