﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void button__WordType__Create__Click(object sender, EventArgs e)
		{
			Form__WordType__Create form__WordType_Create = new Form__WordType__Create(this);

			if (form__WordType_Create.ShowDialog(this) != DialogResult.OK)
			{
				return;
			}

			MainForm.FocusGridRow(this.bindingSource__WordType_Language, this.Current__WordType_Language);
		}

		private void button__WordType__Update__Click(object sender, EventArgs e)
		{
			
			Form__WordType__Update form__WordType__Update = new Form__WordType__Update(this);

			form__WordType__Update.ShowDialog(this);
			
		}

		private void button__WordType__Delete_Click(object sender, EventArgs e)
		{
			if (this.Current__WordType == null)
			{
				MessageBox.Show("There is no 'Word Type' to delete.", "Empty", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return; 
			}

			int length;

			length = this.Current__WordType.GetDerivatingWordTypeRows().Length;
			if (length > 0)
			{
				MessageBox.Show
				(
					"Deleting is not possible because the 'Word Type' is linked to " +
					length.ToString() +
					" 'Derivating Word Type(s)'.",
					"Already linked", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);
				return; 
			}

			length = this.Current__WordType.GetDerivatedWordTypeRows().Length;
			if (length > 0)
			{
				MessageBox.Show
				(
					"Deleting is not possible because the 'Word Type' is linked to " +
					length.ToString() +
					" 'Derivated Word Type(s)'.",
					"Already linked", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);
				return; 
			}

			length = this.Current__WordType.GetWordRows().Length;
			if (length > 0)
			{
				MessageBox.Show
				(
					"Deleting is not possible because the 'Word Type' is linked to " +
					length.ToString() +
					" 'Word(s)'.",
					"Already linked", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);
				return; 
			}

			DialogResult dialogResult 
				= MessageBox.Show
				(
					"Do you really want to delete the 'Word Type' : [" + 
					this.Current__WordType_Language.Name +
					"].",
					"Deleting", 
					MessageBoxButtons.YesNo, 
					MessageBoxIcon.Question
				);
			if (dialogResult == DialogResult.No)
			{
				return;
			}

			this.DataSet.WordType.RemoveWordTypeRow(this.Current__WordType);
		}

		private void filter__WordType_Language()
		{
			this.bindingSource__WordType_Language.Filter = this.filteringExpression__Language;
		}

		private void bindingSource__WordType_Language__CurrentChanged(object sender, EventArgs e)
		{
			if (this.DoNotTriggerCurrentChangedEvent)
			{
				return;
			}

			this.Current__WordType_Language 
				= (BabebiDataSet.WordType_LanguageRow)(((DataRowView)(this.bindingSource__WordType_Language.Current)).Row);

			this.Current__WordType = this.Current__WordType_Language.WordTypeRow;
		}
	}
}