﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void button__Word_LanguageWord__Create__Click(object sender, EventArgs e)
		{
			if (this.Current__Word == null)
			{
				MessageBox.Show("A Word must be selected.","Missing value", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}
			if (this.Current__LanguageWord == null)
			{
				MessageBox.Show("A 'Language Word' must be selected.","Missing value", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			BabebiDataSet.Word_LanguageWordRow existingWord_LanguageWord
				= this.DataSet.Word_LanguageWord
				.FindByWordIdLanguageCodeLanguageWordString
				(
					this.Current__Word.Id,
					this.Current__LanguageWord.LanguageCode,
					this.Current__LanguageWord.String
				);
			if (existingWord_LanguageWord != null)
			{
				MessageBox.Show
				(
					"There is already a existing link between the 'Word' (" +
					this.Current__Word.UniqueKeyString +
					") and the 'Language Word' (" +
					this.Current__LanguageWord.String + 
					").",
					"Already existing", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);
				return;
			}

			Form__Word_LanguageWord__Create form = new Form__Word_LanguageWord__Create(this);

			if (form.ShowDialog() != DialogResult.OK)
			{
				return;
			}

			
			MainForm.FocusGridRow(this.bindingSource__Word_LanguageWord__of__Word			, this.Current__Word_LanguageWord__of__Word			);
			MainForm.FocusGridRow(this.bindingSource__Word_LanguageWord__of__LanguageWord	, this.Current__Word_LanguageWord__of__LanguageWord	);
		}

		private void button__Word_LanguageWord__Delete__Click(object sender, EventArgs e)
		{
			if (this.Current__Word == null)
			{
				MessageBox.Show("A Word must be selected.","Missing value", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}
			if (this.Current__LanguageWord == null || this.Current__LanguageWord.RowState == DataRowState.Detached)
			{
				MessageBox.Show("A 'Language Word' must be selected.","Missing value", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			BabebiDataSet.Word_LanguageWordRow word_languageWord
				= this.DataSet.Word_LanguageWord
				.FindByWordIdLanguageCodeLanguageWordString
				(
					this.Current__Word.Id,
					this.Current__LanguageWord.LanguageCode,
					this.Current__LanguageWord.String
				);
			if (word_languageWord == null)
			{
				MessageBox.Show
				(
					"There is no existing link between the 'Word' (" +
					this.Current__Word.UniqueKeyString +
					") and the 'Language Word' (" +
					this.Current__LanguageWord.String + 
					").",
					"Nothing to delete", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);
				return;
			}

			DialogResult dialogResult
				= MessageBox.Show
				(
					"Do you want to remove the link between the 'Word' (" +
					this.Current__Word.UniqueKeyString +
					") and the 'Language Word' (" +
					this.Current__LanguageWord.String + 
					") ?",
					"Delete ?", 
					MessageBoxButtons.YesNo, 
					MessageBoxIcon.Question
				);

			if (dialogResult == DialogResult.No)
			{
				return;
			}

		//	if ( ! word_languageWord.LanguageWordString.StartsWith("**"))	/// super bizarre... toujours vrai 
		//	{
			string impliedLanguageWordString = "**" + word_languageWord.LanguageCode + "**" + word_languageWord.LanguageWordString;

			foreach (BabebiDataSet.LanguageRow language in this.DataSet.Language)
			{
				if (language == this.Current__Language)
				{
					continue;
				}

				BabebiDataSet.Word_LanguageWordRow candidateWord_LanguageWord
					= this.DataSet.Word_LanguageWord
					.FindByWordIdLanguageCodeLanguageWordString
					(
						word_languageWord.WordId,
						language.Code,
						impliedLanguageWordString
					);

				if (candidateWord_LanguageWord != null)
				{
					this.DataSet.Word_LanguageWord.RemoveWord_LanguageWordRow(candidateWord_LanguageWord);

					//DataSet theDataSet = this.DataSet.GetChanges(DataRowState.Deleted);

					//bool b = this.DataSet.HasChanges(DataRowState.Detached);

					//this.DataSet.Word_LanguageWord.EndInit();


					//this.bindingSource__Word_LanguageWord__of__LanguageWord.EndEdit();
					//this.bindingSource__Word_LanguageWord__of__Word.EndEdit();
				}
			}
		//	}


			this.DataSet.Word_LanguageWord.RemoveWord_LanguageWordRow(word_languageWord);
		}

		private void Word_LanguageWord_RowDeleted(object sender, DataRowChangeEventArgs e)
		{
			throw new NotImplementedException();
		}
	}
}