﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class MainForm : Form
	{
		private void button__System__CheckLanguageWords__Click(object sender, EventArgs e)
		{
			BabebiDataSet.LanguageRow language__fr;
			BabebiDataSet.LanguageRow language__en;
			
			language__fr = this.DataSet.Language.FindByCode("fr");
			language__en = this.DataSet.Language.FindByCode("en");

			int count;

			count = 0;
			foreach (BabebiDataSet.LanguageWordRow languageWord in this.DataSet.LanguageWord)
			{
				if (languageWord.LanguageRow != language__fr)
				{
					continue;
				}

				string languageWordString__en = "**fr**" + languageWord.String;

				BabebiDataSet.LanguageWordRow theOtherLanguageWord
					= this.DataSet.LanguageWord.FindByLanguageCodeString(language__en.Code, languageWordString__en);

				if (theOtherLanguageWord == null)
				{
					foreach (BabebiDataSet.Word_LanguageWordRow word_LanguageWord in languageWord.GetWord_LanguageWordRows())
					{ 
						BabebiDataSet.Word_LanguageRow theOtherWord_Language
							= this.DataSet.Word_Language
							.FindByWordIdLanguageCode
							(
								word_LanguageWord.WordId,
								language__en.Code
							);

						if (theOtherWord_Language.GetWord_LanguageWordRows().Length == 0)
						{ 
							count++;

							MessageBox.Show("'fr' side : " + count.ToString() + " => " + languageWordString__en);

						}
					}
				}
			}
			MessageBox.Show("fr sans en = " + count.ToString());

			count = 0;
			foreach (BabebiDataSet.LanguageWordRow languageWord in this.DataSet.LanguageWord)
			{
				if (languageWord.LanguageRow != language__en)
				{
					continue;
				}

				string languageWordString__fr = languageWord.String.Remove(0, 6);

				BabebiDataSet.LanguageWordRow theOtherLanguageWord
					= this.DataSet.LanguageWord.FindByLanguageCodeString(language__fr.Code, languageWordString__fr);

				if (theOtherLanguageWord == null)
				{
					foreach (BabebiDataSet.Word_LanguageWordRow word_LanguageWord in languageWord.GetWord_LanguageWordRows())
					{ 
						BabebiDataSet.Word_LanguageRow theOtherWord_Language
							= this.DataSet.Word_Language
							.FindByWordIdLanguageCode
							(
								word_LanguageWord.WordId,
								language__en.Code
							);

						if (theOtherWord_Language.GetWord_LanguageWordRows().Length == 0)
						{ 
							count++;

							MessageBox.Show("'en' side : " + count.ToString() + " => " + languageWordString__fr);

						}
					}

					
				}
			}
			MessageBox.Show("en sans fr = " + count.ToString());

			count = 0;
			foreach (BabebiDataSet.LanguageWordRow languageWord in this.DataSet.LanguageWord.ToArray())
			{
				if (languageWord.RowState == DataRowState.Deleted)
				{
					continue;
				}
				if (languageWord.GetWord_LanguageWordRows().Length == 0)
				{
				//	MessageBox.Show("'" + languageWord.String + "' est dans le gaz.");

					string languageWordString__en = "**fr**" + languageWord.String;

					DialogResult dialogResult = MessageBox.Show(languageWord.String, "KILL?", MessageBoxButtons.YesNo, MessageBoxIcon.Question);

					if (dialogResult == DialogResult.Yes)
					{
						languageWord.Delete();

						BabebiDataSet.LanguageWordRow theOtherLanguageWord
							= this.DataSet.LanguageWord
							.FindByLanguageCodeString
							(
								language__en.Code, 
								languageWordString__en
							);

						if (theOtherLanguageWord != null)
						{
							theOtherLanguageWord.Delete();
						}
					}
					else
					{
						count++;
					}

				//	return;
				}
			}
				
			MessageBox.Show("reliés à aucun Word = " + count.ToString());

		}

		private void button__System__SaveDataSetToXML__Click(object sender, EventArgs e)
		{
			this.DoNotTriggerCurrentChangedEvent = true;

			this.DataSet.AcceptChanges();

			this.DataSet.WriteXml(this.currentXmlFilesDirectoryFullName + "\\BabebiDataSet_" + DateTime.Now.ToString("yyyy_MM_dd_HHmmss") + ".xml");

			this.DoNotTriggerCurrentChangedEvent = false;
		}

		private void button__System__WordCounts__Click(object sender, EventArgs e)
		{
			int wordCount			= this.DataSet.Word.Count;

			int wordDerivatedCount	= this.DataSet.WordDerivated.Count;

			MessageBox.Show
			(
				"Number of Words = " + wordCount.ToString() + "\n\n" + 
				"Number of 'Words (Derivated)' = " + wordDerivatedCount.ToString()  + "\n\n" +
				"Number of \"concepts\" = " + (wordCount - wordDerivatedCount).ToString()
				, 
				"Counts"
			);

		}

		private void button__System__LaChasseAuxZombies_Click(object sender, EventArgs e)
		{
			foreach (BabebiDataSet.WordFromPatternRow wordFromPattern in this.DataSet.WordFromPattern)
			{
				if (wordFromPattern.RowState != DataRowState.Deleted && wordFromPattern.ModeCode != MainForm.ModeCode_FromPattern)
				{
					DialogResult dialogResult = MessageBox.Show
					(
						"Zombie found = " + wordFromPattern.WordRowParent.UniqueKeyString + " (" + wordFromPattern.WordRowParent.Id.ToString() + ").\n\n" +
						"Do you want to kill it ?", 
						"Word (From Pattern)",
						MessageBoxButtons.YesNo,
						MessageBoxIcon.Question
					);

					if (dialogResult == DialogResult.Yes)
					{
						this.DataSet.FromPattern.RemoveFromPatternRow(wordFromPattern.FromPatternRowParent);

						MessageBox.Show("Zombie kiling done.", "Word (From Pattern)");
					}
				}
			}
			foreach (BabebiDataSet.WordByInsertionRow wordByInsertion in this.DataSet.WordByInsertion)
			{
				if (wordByInsertion.ModeCode != MainForm.ModeCode_ByInsertion)
				{
					MessageBox.Show(wordByInsertion.WordRowParentByWordByInsertion__Word.UniqueKeyString + " : " + wordByInsertion.WordRowParentByWordByInsertion__Word.Id.ToString(), "Word (By insertion)");
				}
			}
			foreach (BabebiDataSet.WordDerivatedRow wordDerivated in this.DataSet.WordDerivated)
			{
				if (wordDerivated.ModeCode != MainForm.ModeCode_Derivated)
				{
					MessageBox.Show(wordDerivated.WordRowParent.UniqueKeyString + " : " + wordDerivated.WordRowParent.Id.ToString(), "Word (Derivated)");
				}
			}
			foreach (BabebiDataSet.WordConcatenatedRow wordConcatenated in this.DataSet.WordConcatenated)
			{
				if (wordConcatenated.ModeCode != MainForm.ModeCode_Concatenated)
				{
					MessageBox.Show(wordConcatenated.WordRowParent.UniqueKeyString + " : " + wordConcatenated.WordRowParent.Id.ToString(), "Word (Concatenated)");
				}
			}
			foreach (BabebiDataSet.PatternFromPatternRow patternFromPattern in this.DataSet.PatternFromPattern)
			{
				if (patternFromPattern.ModeCode != MainForm.ModeCode_FromPattern)
				{
					MessageBox.Show(patternFromPattern.PatternRowParent.UniqueKeyString + " : " + patternFromPattern.PatternRowParent.Id.ToString(), "Pattern (From Pattern)");
				}
			}
			foreach (BabebiDataSet.PatternByInsertionRow patternByInsertion in this.DataSet.PatternByInsertion)
			{
				if (patternByInsertion.ModeCode != MainForm.ModeCode_ByInsertion)
				{
					MessageBox.Show(patternByInsertion.PatternRowParent.UniqueKeyString + " : " + patternByInsertion.PatternRowParent.Id.ToString(), "Pattern (By insertion)");
				}
			}

			foreach (BabebiDataSet.WordRow word in this.DataSet.Word)
			{
				switch (word.ModeCode)
				{
					case MainForm.ModeCode_FromPattern:
					{
						BabebiDataSet.WordFromPatternRow wordFromPattern = this.DataSet.WordFromPattern.FindById(word.Id);

						if (wordFromPattern == null)
						{
							MessageBox.Show(word.Id.ToString(), "WordFromPattern");
						}

						break;
					}
					case MainForm.ModeCode_ByInsertion:
					{
						BabebiDataSet.WordByInsertionRow wordByInsertion = this.DataSet.WordByInsertion.FindById(word.Id);

						if (wordByInsertion == null)
						{
							MessageBox.Show(word.Id.ToString(), "WordByInsertion");
						}

						break;
					}
					case MainForm.ModeCode_Derivated:
					{
						BabebiDataSet.WordDerivatedRow wordDerivated = this.DataSet.WordDerivated.FindById(word.Id);

						if (wordDerivated== null)
						{
							MessageBox.Show(word.Id.ToString(), "WordDerivated");
						}

						break;
					}
					case MainForm.ModeCode_Concatenated:
					{
						BabebiDataSet.WordConcatenatedRow wordConcatenated = this.DataSet.WordConcatenated.FindById(word.Id);

						if (wordConcatenated== null)
						{
							MessageBox.Show(word.Id.ToString(), "WordConcatenated");
						}

						break;
					}
					case MainForm.ModeCode_NotDefined:
					{
						MessageBox.Show(word.Id.ToString(), "WordNotDefined");

						break;
					}
				}
			}

			foreach (BabebiDataSet.PatternRow pattern in this.DataSet.Pattern)
			{
				switch (pattern.ModeCode)
				{
					case MainForm.ModeCode_FromPattern:
					{
						BabebiDataSet.PatternFromPatternRow patternFromPattern = this.DataSet.PatternFromPattern.FindById(pattern.Id);

						if (patternFromPattern == null)
						{
							MessageBox.Show(pattern.Id.ToString(), "PatternFromPattern");
						}

						break;
					}
					case MainForm.ModeCode_ByInsertion:
					{
						BabebiDataSet.PatternByInsertionRow patternByInsertion = this.DataSet.PatternByInsertion.FindById(pattern.Id);

						if (patternByInsertion == null)
						{
							MessageBox.Show(pattern.Id.ToString(), "PatternByInsertion");
						}

						break;
					}
					case MainForm.ModeCode_NotDefined:
					{
						MessageBox.Show(pattern.Id.ToString(), "PatternNotDefined");

						break;
					}
				}
			}


			MessageBox.Show("Done", "End of the zombie hunting.");
		}

		private void button__System__Searching_Derivating_Click(object sender, EventArgs e)
		{
			BabebiDataSet.DerivatingRow derivating__79 = this.DataSet.Derivating.FindById(79);
			foreach (BabebiDataSet.WordDerivatedRow wordDerivated in derivating__79.GetWordDerivatedRows())
			{ 
				BabebiDataSet.Word_LanguageRow word_Language 
					= this.DataSet.Word_Language
					.FindByWordIdLanguageCode
					(wordDerivated.Id, this.Current__Language.Code);

				MessageBox.Show
				(	
					wordDerivated.WordRowParent.Id.ToString() + "\n" +
					wordDerivated.WordRowParent.UniqueKeyString + "\n" +
					word_Language.Meaning,
					"79"
				);
			}
			BabebiDataSet.DerivatingRow derivating__80 = this.DataSet.Derivating.FindById(80);
			foreach (BabebiDataSet.WordDerivatedRow wordDerivated in derivating__80.GetWordDerivatedRows())
			{ 
				BabebiDataSet.Word_LanguageRow word_Language 
					= this.DataSet.Word_Language
					.FindByWordIdLanguageCode
					(wordDerivated.Id, this.Current__Language.Code);

				MessageBox.Show
				(	
					wordDerivated.WordRowParent.Id.ToString() + "\n" +
					wordDerivated.WordRowParent.UniqueKeyString + "\n" +
					word_Language.Meaning,
					"80"
				);
			}
		}

		private void button__System__Test_Click(object sender, EventArgs e)
		{
			MeaningParser meaningParser	= new MeaningParser(this, "le fait de devenir gros");

			Form__SubStrings form__SubStrings 
				= new Form__SubStrings
				(
					meaningParser, 
					new string[] { "le", "fait", "de", "devenir", "gros" }
				);

			DialogResult dialogResult = form__SubStrings.ShowDialog();
			if (dialogResult == DialogResult.Cancel)
			{ 
				return;
			}
		}

		private void button__System__Compute__WordConcatenateds__UniqueKeyStrings_Click(object sender, EventArgs e)
		{
			foreach (BabebiDataSet.WordConcatenatedRow wordConcatenated in this.DataSet.WordConcatenated)
			{
				string wordConcatenated__UniqueKeyString = WordConcatenated.Compute_UniqueKeyString(wordConcatenated);

				if (wordConcatenated.WordRowParent.UniqueKeyString != wordConcatenated__UniqueKeyString)
				{
					Word.SetUniqueKeyString(wordConcatenated.WordRowParent, wordConcatenated__UniqueKeyString);
				}
			}
		}

		private void button__System__ModifyingDerivating_Click__Show_Id(short derivatingId, short? derivatingId__new = null)
		{
			BabebiDataSet.DerivatingRow derivating = this.DataSet.Derivating.FindById(derivatingId);

			BabebiDataSet.DerivatingRow derivating__new = null;
			if (derivatingId__new.HasValue)
			{
				derivating__new = this.DataSet.Derivating.FindById(derivatingId__new.Value);
			}

			int		count__		= 0;
			string	string__	= "";

			foreach (BabebiDataSet.WordDerivatedRow wordDerivated in derivating.GetWordDerivatedRows())
			{
				string uks_origin = wordDerivated.WordDerivatingRowParent.WordRowParent.UniqueKeyString;

				count__++;

				string__ += (string__ == "" ? "" : ", ")+ uks_origin;

				if (derivatingId__new.HasValue)
				{
					wordDerivated.DerivatingRowParent = derivating__new;
				}

				wordDerivated.WordRowParent.UniqueKeyString = uks_origin + wordDerivated.DerivatingRowParent.LetterClusterString;
			}
			MessageBox.Show(string__, derivatingId.ToString() + " = " + count__.ToString());	
		}

		private void button__System__ModifyingDerivating_Click(object sender, EventArgs e)
		{
			int count__consonants	= 0;
			int count__vowels		= 0;
			int count__				= 0;
			string string__vowels		= "";
			string string__consonants	= "";
			string string__				= "";

			#region		1051
			/*
			BabebiDataSet.DerivatingRow derivating__1051 = this.DataSet.Derivating.FindById(1051);
			MessageBox.Show(derivating__1051.GetWordDerivatedRows().Length.ToString(), "1051 : " + derivating__1051.GetWordDerivatedRows().First().WordRowParent.Id.ToString());
			*/
			#endregion	1051
			#region		1052
			/*
			BabebiDataSet.DerivatingRow derivating__1051 = this.DataSet.Derivating.FindById(1051);
			MessageBox.Show(derivating__1051.GetWordDerivatedRows().Length.ToString(), "1051 : " + derivating__1051.GetWordDerivatedRows().First().WordRowParent.Id.ToString());

			BabebiDataSet.DerivatingRow derivating__1052 = this.DataSet.Derivating.FindById(1052);
			MessageBox.Show(derivating__1052.GetWordDerivatedRows().Length.ToString(), "1052");
			foreach (BabebiDataSet.WordDerivatedRow wordDerivated in derivating__1052.GetWordDerivatedRows())
			{
				string uks_origin = wordDerivated.WordDerivatingRowParent.WordRowParent.UniqueKeyString;

				BabebiDataSet.LetterRow lastPlaceConsonant 
					= Word.Compute_UniqueKeyString__find_consonant_at_last_place
					(
						this.DataSet, 
						uks_origin,
				out int dueToDoubleCharConsonant
					);

				if (lastPlaceConsonant == null)
				{
					count__vowels++;

					string__vowels += (string__vowels == "" ? "" : ", ")+ uks_origin;

				///	wordDerivated.WordRowParent.UniqueKeyString = uks_origin + "wuu";
				}
				else
				{ 
					count__consonants++;

					wordDerivated.DerivatingRowParent = derivating__1051;

				///	wordDerivated.WordRowParent.UniqueKeyString = uks_origin + "uu";
				}
			}

		///	derivating__1051.LetterClusterId = 174;
		///	derivating__1052.LetterClusterId = 175;

			MessageBox.Show
			(
				"count__vowels = " + count__vowels.ToString() + "\n\n" +
				"count__consonants = " + count__consonants.ToString() + "\n\n" + 
				string__vowels, 
				"1052"
			);
			*/
			#endregion	1052

			#region		2027

			//	BabebiDataSet.DerivatingRow derivating__2027 = this.DataSet.Derivating.FindById(2027);
			//	MessageBox.Show(derivating__2027.GetWordDerivatedRows().Length.ToString(), "2027 : " + derivating__2027.Name);

			#endregion	2027
			#region		2028
			/*
			BabebiDataSet.DerivatingRow derivating__2028 = this.DataSet.Derivating.FindById(2028);
			MessageBox.Show(derivating__2028.GetWordDerivatedRows().Length.ToString(), "2028 : " + derivating__2028.Name);
			count__consonants	= 0;
			count__vowels	= 0;
			string__vowels		= "";
			string__consonants	= "";
			foreach (BabebiDataSet.WordDerivatedRow wordDerivated in derivating__2028.GetWordDerivatedRows())
			{
				string uks_origin = wordDerivated.WordDerivatingRowParent.WordRowParent.UniqueKeyString;

				BabebiDataSet.LetterRow lastPlaceConsonant 
					= Word.Compute_UniqueKeyString__find_consonant_at_last_place
					(
						this.DataSet, 
						uks_origin,
				out int dueToDoubleCharConsonant
					);

				if (lastPlaceConsonant == null)
				{
					count__vowels++;

					string__vowels += (string__vowels == "" ? "" : ", ")+ uks_origin;

				///	wordDerivated.WordRowParent.UniqueKeyString = uks_origin + "wuu";
				}
				else
				{ 
					count__consonants++;

					string__consonants += (string__consonants == "" ? "" : ", ")+ uks_origin;

				///	wordDerivated.DerivatingRowParent = derivating__2027;

				///	wordDerivated.WordRowParent.UniqueKeyString = uks_origin + "a";
				}
			}

			MessageBox.Show
			(
				"count__vowels = " + count__vowels.ToString() + "\n\n" +
				"count__consonants = " + count__consonants.ToString() + "\n\n" + 
				"count__vowels = " + string__vowels + "\n\n" + 
				"count__consonants = " + string__consonants, 
				derivating__2028.Id.ToString()
			);
			*/
			#endregion	2028

			#region		2029
			/*
			count__		= 0;
			string__	= "";
			BabebiDataSet.DerivatingRow derivating__2029 = this.DataSet.Derivating.FindById(2029);
			foreach (BabebiDataSet.WordDerivatedRow wordDerivated in derivating__2029.GetWordDerivatedRows())
			{
				string uks_origin = wordDerivated.WordDerivatingRowParent.WordRowParent.UniqueKeyString;

				count__++;

				string__ += (string__ == "" ? "" : ", ")+ uks_origin;
			}
			MessageBox.Show(string__, "2029 : " + count__.ToString());
			*/
			#endregion	2029
			#region		2030
			/*
			count__		= 0;
			string__	= "";
			BabebiDataSet.DerivatingRow derivating__2030 = this.DataSet.Derivating.FindById(2030);
			foreach (BabebiDataSet.WordDerivatedRow wordDerivated in derivating__2030.GetWordDerivatedRows())
			{
				string uks_origin = wordDerivated.WordDerivatingRowParent.WordRowParent.UniqueKeyString;

				count__++;

				string__ += (string__ == "" ? "" : ", ")+ uks_origin;
			}
			MessageBox.Show(string__, "2030 : " + count__.ToString());
			*/
			#endregion	2030

			//	button__System__ModifyingDerivating_Click__Show_Id(1040);
			//	button__System__ModifyingDerivating_Click__Show_Id(1041);
			//	button__System__ModifyingDerivating_Click__Show_Id(1042);
			//	button__System__ModifyingDerivating_Click__Show_Id(1043);
			//	button__System__ModifyingDerivating_Click__Show_Id(1044);

			button__System__ModifyingDerivating_Click__Show_Id(2017, 1040);
			button__System__ModifyingDerivating_Click__Show_Id(2018, 1041);
			button__System__ModifyingDerivating_Click__Show_Id(2019, 1042);
			button__System__ModifyingDerivating_Click__Show_Id(2020, 1043);
			button__System__ModifyingDerivating_Click__Show_Id(2021, 1044);
		}

		private void button__System__MigrateWordsDerivated_Click(object sender, EventArgs e)
		{
			/*
			short prior = 1055;
			short next  = 1054;

			BabebiDataSet.DerivatingRow derivating = this.DataSet.Derivating.FindById(prior);

			BabebiDataSet.WordDerivatedRow[] wordDerivateds = derivating.GetWordDerivatedRows();

			foreach (BabebiDataSet.WordDerivatedRow wordDerivatedRow in wordDerivateds)
			{
				wordDerivatedRow.DerivatingId = next;

				WordDerivated wordDerivated = new WordDerivated(wordDerivatedRow);

				if (wordDerivated.ComputeAndTryToSetUniqueKeyString())
				{
					wordDerivated.PropagateToChildren();
				}
			}
			*/
		}

		private void button__System__1800__Click(object sender, EventArgs e)
		{
			#region		read XML

			System.IO.DirectoryInfo directoryInfo = new System.IO.DirectoryInfo("..\\..\\The1800s");

			if (!directoryInfo.Exists)
			{
				throw new ApplicationException("Unable to find the 'The1800s' directory associated to the path: '" + directoryInfo.FullName + "'.");
			}

			string currentXmlFilesDirectoryFullName__The1800s = directoryInfo.FullName;

			System.IO.FileInfo[] fileInfos = directoryInfo.GetFiles("The1800s_*.xml");

			if (fileInfos.Length == 0)
			{
				throw new ApplicationException("The 'Xmls' directory (" + directoryInfo.FullName + ") does not contain any file.");
			}

			List<string> fileNames = new List<string>();
			foreach (System.IO.FileInfo fileInfo in fileInfos)
			{
				fileNames.Add(fileInfo.FullName);
			}
			fileNames.Sort();

			string lastXmlFileFullName = fileNames.Last();

			System.Data.DataSet dataSet = new DataSet("The1800DataSet");

			System.Data.DataTable dataTable = dataSet.Tables.Add("LanguageWord");

			System.Data.DataColumn 
			dataColumn__String = dataTable.Columns.Add("String", typeof(string));
			dataColumn__String.AllowDBNull = false;
			dataColumn__String.MaxLength = 32;
			dataColumn__String.ColumnMapping = MappingType.Attribute;

			System.Data.DataColumn 
			dataColumn__Type = dataTable.Columns.Add("Type", typeof(string));
			dataColumn__Type.AllowDBNull = false;
			dataColumn__Type.MaxLength = 16;
			dataColumn__Type.ColumnMapping = MappingType.Attribute;

			System.Data.DataColumn 
			dataColumn__Found = dataTable.Columns.Add("Found", typeof(bool));
			dataColumn__Found.AllowDBNull = false;
			dataColumn__Found.DefaultValue = false;
			dataColumn__Found.ColumnMapping = MappingType.Attribute;

			dataSet.ReadXml(lastXmlFileFullName);
			dataSet.AcceptChanges();

			#endregion	read XML

			int count = 0;
			int count__nom			= 0;
			int count__verbe		= 0;
			int count__adjectif		= 0;
			int count__adverbe		= 0;
			int count__preposition	= 0;

			int count__found				= 0;
			int count__found__nom			= 0;
			int count__found__verbe			= 0;
			int count__found__adjectif		= 0;
			int count__found__adverbe		= 0;
			int count__found__preposition	= 0;

			foreach (DataRow dataRow in dataTable.Rows)
			{
				count++;

				string string_ = dataRow.Field<string>(dataColumn__String);

				BabebiDataSet.LanguageWordRow languageWord = this.DataSet.LanguageWord.FindByLanguageCodeString("fr", string_);

				int i;
				if (languageWord == null)
				{
					i = 0;

					MessageBox.Show(string_);
					
					return;
				}
				else
				{ 
					i = 1;
				}

				count__found += i; 

				string type = dataRow.Field<string>(dataColumn__Type);

				switch (type)
				{
					case "nom"			:  count__nom			++; count__found__nom			+= i; break;
					case "verbe"		:  count__verbe			++; count__found__verbe			+= i; break;
					case "adjectif"		:  count__adjectif		++; count__found__adjectif		+= i; break;
					case "adverbe"		:  count__adverbe		++; count__found__adverbe		+= i; break;
					case "préposition"	:  count__preposition	++; count__found__preposition	+= i; break;
					default: throw new Exception(type);
				}
			}

			MessageBox.Show
			(
				"noms = 			"+  count__nom			+ "  >>  " + count__found__nom			+ "\n" +
				"verbes = 			"+  count__verbe		+ "  >>  " + count__found__verbe		+ "\n" +
				"adjectifs = 		"+  count__adjectif		+ "  >>  " + count__found__adjectif	+ "\n" +
				"adverbes = 		"+  count__adverbe		+ "  >>  " + count__found__adverbe		+ "\n" +
				"prépositions = 	"+  count__preposition	+ "  >>  " + count__found__preposition	,
				count.ToString() + "  >>  " + count__found.ToString()
			);

			#region		write XML

			if (dataSet.HasChanges())
			{
				DialogResult dialogResult = MessageBox.Show("Do you want to save your modification about the 1800s ?", "Save or not ?", MessageBoxButtons.YesNoCancel);

				if (dialogResult == DialogResult.Cancel)
				{
					return;
				}
				else if (dialogResult == DialogResult.Yes)
				{
					dataSet.AcceptChanges();

					dataSet.WriteXml(currentXmlFilesDirectoryFullName__The1800s + "\\The1800s_" + DateTime.Now.ToString("yyyy_MM_dd_HHmmss") + ".xml");
				}
				else if (dialogResult == DialogResult.No)
				{
				}
				else
				{
					throw new Exception();
				}
			}

			#endregion	write XML
		}
	}
}
