﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Babebi4
{
	internal class WordTypeComboBoxItem
	{
		public BabebiDataSet.WordType_LanguageRow Row;

		public WordTypeComboBoxItem(BabebiDataSet.WordType_LanguageRow row)
		{
			this.Row = row;
		}

		public override string ToString()
		{
			return this.Row.Name;
		}

		public override bool Equals(object obj)
		{
			if (obj == null || ! (obj is WordTypeComboBoxItem) )
			{
				return false;
			}
			return this.Row == ((WordTypeComboBoxItem)obj).Row;
		}

		public override int GetHashCode()
		{
			return this.Row.GetHashCode();
		}

		public static List<WordTypeComboBoxItem> BuildWordTypeComboBoxItems
		(
			BabebiDataSet.LanguageRow						currentLanguage,
			BabebiDataSet.WordType_LanguageRow		currentWordType_Language, 
		out WordTypeComboBoxItem					focusedWordTypeComboBoxItem
		)
		{
			List<WordTypeComboBoxItem> WordTypeComboBoxItems = new List<WordTypeComboBoxItem>();
			focusedWordTypeComboBoxItem = null;
			foreach 
			(
				BabebiDataSet.WordType_LanguageRow wordType_language 
				in 
				currentLanguage.GetWordType_LanguageRows()
			)
			{
				WordTypeComboBoxItem WordTypeComboBoxItem = new WordTypeComboBoxItem(wordType_language);
				WordTypeComboBoxItems.Add(WordTypeComboBoxItem);

				if (currentWordType_Language != null && currentWordType_Language == wordType_language)
				{
					focusedWordTypeComboBoxItem = WordTypeComboBoxItem;
				}
			}

			return WordTypeComboBoxItems;
		}
		public static List<WordTypeComboBoxItem> BuildWordTypeComboBoxItems
		(
			BabebiDataSet.LanguageRow	currentLanguage
		)
		{
			List<WordTypeComboBoxItem> WordTypeComboBoxItems 
				= new List<WordTypeComboBoxItem>();
			foreach 
			(
				BabebiDataSet.WordType_LanguageRow WordType_language 
				in 
				currentLanguage.GetWordType_LanguageRows()
			)
			{
				WordTypeComboBoxItem WordTypeComboBoxItem = new WordTypeComboBoxItem(WordType_language);
				WordTypeComboBoxItems.Add(WordTypeComboBoxItem);
			}

			return WordTypeComboBoxItems;
		}
	}

	internal class DerivatingWordTypeComboBoxItem
	{
		public BabebiDataSet.DerivatingWordType_LanguageRow Row;

		public DerivatingWordTypeComboBoxItem(BabebiDataSet.DerivatingWordType_LanguageRow row)
		{
			this.Row = row;
		}

		public override string ToString()
		{
			return this.Row.Name;
		}

		public override bool Equals(object obj)
		{
			if (obj == null || ! (obj is DerivatingWordTypeComboBoxItem) )
			{
				return false;
			}
			return this.Row == ((DerivatingWordTypeComboBoxItem)obj).Row;
		}

		public override int GetHashCode()
		{
			return this.Row.GetHashCode();
		}

		public static List<DerivatingWordTypeComboBoxItem> BuildDerivatingWordTypeComboBoxItems
		(
			BabebiDataSet.LanguageRow						currentLanguage,
			BabebiDataSet.DerivatingWordType_LanguageRow	currentDerivatingWordType_Language, 
		out DerivatingWordTypeComboBoxItem					focusedDerivatingWordTypeComboBoxItem
		)
		{
			List<DerivatingWordTypeComboBoxItem> derivatingWordTypeComboBoxItems = new List<DerivatingWordTypeComboBoxItem>();
			focusedDerivatingWordTypeComboBoxItem = null;
			foreach 
			(
				BabebiDataSet.DerivatingWordType_LanguageRow derivatingWordType_language 
				in 
				currentLanguage.GetDerivatingWordType_LanguageRows()
			)
			{
				DerivatingWordTypeComboBoxItem derivatingWordTypeComboBoxItem = new DerivatingWordTypeComboBoxItem(derivatingWordType_language);
				derivatingWordTypeComboBoxItems.Add(derivatingWordTypeComboBoxItem);

				if (currentDerivatingWordType_Language != null && currentDerivatingWordType_Language == derivatingWordType_language)
				{
					focusedDerivatingWordTypeComboBoxItem = derivatingWordTypeComboBoxItem;
				}
			}

			return derivatingWordTypeComboBoxItems;
		}
		public static List<DerivatingWordTypeComboBoxItem> BuildDerivatingWordTypeComboBoxItems
		(
			BabebiDataSet.LanguageRow	currentLanguage
		)
		{
			List<DerivatingWordTypeComboBoxItem> derivatingWordTypeComboBoxItems 
				= new List<DerivatingWordTypeComboBoxItem>();
			foreach 
			(
				BabebiDataSet.DerivatingWordType_LanguageRow derivatingWordType_language 
				in 
				currentLanguage.GetDerivatingWordType_LanguageRows()
			)
			{
				DerivatingWordTypeComboBoxItem derivatingWordTypeComboBoxItem = new DerivatingWordTypeComboBoxItem(derivatingWordType_language);
				derivatingWordTypeComboBoxItems.Add(derivatingWordTypeComboBoxItem);
			}

			return derivatingWordTypeComboBoxItems;
		}
	}

	internal class DerivatedWordTypeComboBoxItem
	{
		public BabebiDataSet.DerivatedWordType_LanguageRow Row;

		public DerivatedWordTypeComboBoxItem(BabebiDataSet.DerivatedWordType_LanguageRow row)
		{
			this.Row = row;
		}

		public override string ToString()
		{
			return this.Row.Name;
		}

		internal static List<DerivatedWordTypeComboBoxItem>  BuildDerivatedWordTypeComboBoxItems
		(
			BabebiDataSet.DerivatingWordType_LanguageRow	selected__DerivatingWordType_Language,
		ref BabebiDataSet.DerivatedWordType_LanguageRow		selected__DerivatedWordType_Language,
		out	DerivatedWordTypeComboBoxItem					selectedDerivatedWordTypeComboBoxItem
		)
		{
			selectedDerivatedWordTypeComboBoxItem = null;

			List<DerivatedWordTypeComboBoxItem> derivatedWordTypeComboBoxItems 
				= new List<DerivatedWordTypeComboBoxItem>();

			if (selected__DerivatingWordType_Language == null)
			{
				return derivatedWordTypeComboBoxItems;
			}

			int count = 0;
			foreach
			(
				BabebiDataSet.DerivatingWordType_DerivatedWordTypeRow derivatingWordType_derivatedWordType
				in
				selected__DerivatingWordType_Language.DerivatingWordTypeRowParent.GetDerivatingWordType_DerivatedWordTypeRows()
			)
			{
				count++;

				BabebiDataSet babebiDataSet = (BabebiDataSet)(selected__DerivatingWordType_Language.Table.DataSet);

				BabebiDataSet.DerivatedWordType_LanguageRow derivatedWordType_language
					= babebiDataSet
					.DerivatedWordType_Language
					.FindByDerivatedWordTypeIdLanguageCode
					(
						derivatingWordType_derivatedWordType.DerivatedWordTypeId,
						selected__DerivatingWordType_Language.LanguageCode
					);

				DerivatedWordTypeComboBoxItem derivatedWordTypeComboBoxItem
					= new DerivatedWordTypeComboBoxItem(derivatedWordType_language);

				derivatedWordTypeComboBoxItems.Add(derivatedWordTypeComboBoxItem);

				if (selected__DerivatedWordType_Language != null && selected__DerivatedWordType_Language == derivatedWordType_language)
				{
					selectedDerivatedWordTypeComboBoxItem = derivatedWordTypeComboBoxItem;
				}
			}
			if (count == 1)
			{
				selectedDerivatedWordTypeComboBoxItem = derivatedWordTypeComboBoxItems[0];

				selected__DerivatedWordType_Language = selectedDerivatedWordTypeComboBoxItem.Row;
			}
			
			return derivatedWordTypeComboBoxItems;
		}


	}

	internal class DerivatingComboBoxItem
	{
		public BabebiDataSet.Derivating_LanguageRow Row;

		public DerivatingComboBoxItem(BabebiDataSet.Derivating_LanguageRow row)
		{
			this.Row = row;
		}

		public override string ToString()
		{
			return this.Row.Name;
		}

		public override bool Equals(object obj)
		{
			if (obj == null || ! (obj is DerivatingComboBoxItem) )
			{
				return false;
			}
			return this.Row == ((DerivatingComboBoxItem)obj).Row;
		}

		public override int GetHashCode()
		{
			return this.Row.GetHashCode();
		}
	}
}
