﻿using System.Drawing;
using System.Windows.Forms;
using System.Data;

namespace Babebi4
{
	internal abstract class Control_WEM
	{
		protected	Label	label;

		internal bool	HasError	{ get; private set;}
		internal string Message		{ get; private set;}
		internal string Header		{ get; private set;}
		internal string Reference	{ get; private set;}

		protected Control_WEM(Label	label, bool hasError, string message, string header, string reference)
		{
			this.label		= label;

			this.HasError	= hasError;	
			this.Message	= message;	
			this.Header		= header;	
			this.Reference	= reference;
		}

		internal void ShowMessageBox()
		{
			if (this.HasError)
			{ 
				MessageBox.Show
				(
					this.Message,
					this.Header,
					MessageBoxButtons.OK,
					MessageBoxIcon.Error
				);
			}
		}

		internal void ClearError()
		{ 
			this.HasError	= false;	
			this.Message	= null;	
			this.Header		= null;	

			this.colorize();
		}
		internal void SetError(string message, string header)
		{ 
			this.HasError	= true;	
			this.Message	= message;	
			this.Header		= header;
			
			this.colorize();
		}

		protected virtual	void	colorize()
		{
			if (this.HasError)
			{
				label.ForeColor = Color.Red;
			}
			else
			{
				string currentValue = this.getCurrentValue();

				if (this.Reference == null || currentValue == null || currentValue == this.Reference)
				{
					label.ForeColor = Color.Black;
				}
				else
				{ 
					label.ForeColor = Color.Blue;
				}
			}	
		}
		protected abstract	string	getCurrentValue();
	}

	internal class NoControl_WEM : Control_WEM
	{
		internal NoControl_WEM(string initialMessage, string initialHeader) : base(null, true, initialMessage, initialHeader, null)
		{
		}
		internal NoControl_WEM(string reference = null) : base(null, false, null, null, reference)
		{
		}

		protected override void		colorize()
		{
		}
		protected override string	getCurrentValue()
		{	
			return null;
		}
	}

	internal class TextBox_WEM : Control_WEM
	{
		private	TextBox textBox;

		internal TextBox_WEM(Label	label, TextBox textBox, string initialMessage, string initialHeader, string reference = null) : base(label, true, initialMessage, initialHeader, reference)
		{
			this.textBox	= textBox;
		}
		internal TextBox_WEM(Label	label, TextBox textBox, string reference = null) : base(label, false, null, null, reference)
		{
			this.textBox	= textBox;
		}

		protected override void		colorize()
		{
			base.colorize();

			if (this.HasError)
			{
				textBox.ForeColor = Color.Red;
			}
			else
			{
				if (this.Reference == null || textBox.Text == this.Reference)
				{
					textBox.BackColor = Color.White;
					textBox.ForeColor = Color.Black;
				}
				else
				{ 
					textBox.BackColor = Color.White;
					textBox.ForeColor = Color.Blue;
				}
			}	
		}
		protected override string	getCurrentValue()
		{	
			return this.textBox.Text;
		}

		internal string Text()
		{
			return this.getCurrentValue();
		}

		internal void	Set_with_no_error(string textBox__Text)
		{
			this.textBox.Text = textBox__Text;

			this.ClearError();
		}
		internal void	Set_with_null_and_error(string message, string header)
		{
			this.textBox.Text = null;

			this.SetError(message, header);
		}
	}

	internal class ComboBox_WEM : Control_WEM
	{
		private	ComboBox comboBox;

		internal ComboBox_WEM(Label	label, ComboBox comboBox, string initialMessage, string initialHeader, string reference = null) : base(label, true, initialMessage, initialHeader, reference)
		{
			this.comboBox	= comboBox;
		}
		internal ComboBox_WEM(Label	label, ComboBox comboBox, string reference = null) : base(label, false, null, null, reference)
		{
			this.comboBox	= comboBox;
		}

		protected override void colorize()
		{
			base.colorize();

			if (this.HasError)
			{
				comboBox.ForeColor = Color.Red;
			}
			else
			{
				if (this.Reference == null || comboBox.Text == this.Reference)
				{
					comboBox.BackColor = Color.White;
					comboBox.ForeColor = Color.Black;
				}
				else
				{ 
					comboBox.BackColor = Color.White;
					comboBox.ForeColor = Color.Blue;
				}
			}	
		}

		protected override string getCurrentValue()
		{
			if (this.comboBox.SelectedItem is string valueString)
			{
				return valueString;
			}
			else if (this.comboBox.SelectedItem is short valueShort)
			{
				return valueShort.ToString();
			}
			else if (this.comboBox.SelectedItem is int valueInt)
			{
				return valueInt.ToString();
			}
			if (this.comboBox.SelectedItem is WordTypeComboBoxItem wordTypeComboBoxItem)
			{
				return wordTypeComboBoxItem.Row.Name;
			}
			if (this.comboBox.SelectedItem is DerivatingWordTypeComboBoxItem derivatingWordTypeComboBoxItem)
			{
				return derivatingWordTypeComboBoxItem.Row.Name;
			}
			if (this.comboBox.SelectedItem is DerivatedWordTypeComboBoxItem derivatedWordTypeComboBoxItem)
			{
				return derivatedWordTypeComboBoxItem.Row.Name;
			}
			if (this.comboBox.SelectedItem is DerivatingComboBoxItem derivatingComboBoxItem)
			{
				return derivatingComboBoxItem.Row.Name;
			}
			else
			{ 
				throw new System.Exception(this.comboBox.SelectedItem.ToString());
			}
		}

		internal string Get()
		{
			return this.getCurrentValue();
		}

		internal DataRow Row()
		{
			if (this.comboBox.SelectedItem is WordTypeComboBoxItem wordTypeComboBoxItem)
			{
				return wordTypeComboBoxItem.Row;
			}
			if (this.comboBox.SelectedItem is DerivatingWordTypeComboBoxItem derivatingWordTypeComboBoxItem)
			{
				return derivatingWordTypeComboBoxItem.Row;
			}
			if (this.comboBox.SelectedItem is DerivatedWordTypeComboBoxItem derivatedWordTypeComboBoxItem)
			{
				return derivatedWordTypeComboBoxItem.Row;
			}
			if (this.comboBox.SelectedItem is DerivatingComboBoxItem derivatingComboBoxItem)
			{
				return derivatingComboBoxItem.Row;
			}
			else
			{ 
				throw new System.Exception(this.comboBox.SelectedItem.ToString());
			}
		}
	}
}
