﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Babebi4
{
	/// the way it must be used :
	///
	///	LetterIndexer externalLetterIndexer = new LetterIndexer(0, ref this.letterTypeCodes, ref this.vowels, ref this.consonants);
	///
	///	do
	///	{ 
	///		List<string> letters = externalLetterIndexer.GetLetterList();
	///	}
	///	while(externalLetterIndexer.Next());

	internal class RussianLetterIndexer
	{
		private int						depthIndex;
		private string[]				letterTypeCodes;
		private string[]				vowels;
		private string[]				consonants;

		private bool					trueForVowel__falseForConsonant;
		private int						lettersLenght;

		private	int						letterIndex;
		private RussianLetterIndexer			letterIndexer;

		private string					letter
		{
			get
			{
				if(this.trueForVowel__falseForConsonant)
				{
					return this.vowels[this.letterIndex];
				}
				else
				{
					return this.consonants[this.letterIndex];
				}
			}
		}

		internal RussianLetterIndexer(int depthIndex, string[] letterTypeCodes, string[] vowels, string[] consonants)
		{
			this.depthIndex			= depthIndex;
			this.letterTypeCodes	= letterTypeCodes;
			this.vowels				= vowels;
			this.consonants			= consonants;

			switch (this.letterTypeCodes[this.depthIndex])
			{
				case MainForm.TypeCode_Vowel:
				{
					this.trueForVowel__falseForConsonant = true;
					this.lettersLenght = this.vowels.Length;

					break;
				}
				case MainForm.TypeCode_Consonant:
				{
					this.trueForVowel__falseForConsonant = false;
					this.lettersLenght = this.consonants.Length;

					break;
				}
				default : throw new Exception(this.letterTypeCodes[this.depthIndex]);
			}

			if (this.depthIndex < this.letterTypeCodes.Length - 1)
			{
				this.letterIndexer = new RussianLetterIndexer(this.depthIndex + 1, this.letterTypeCodes, this.vowels, this.consonants);
			}
			else
			{ 
				this.letterIndexer = null;
			}

			this.letterIndex = 0;	
		}

		/// <summary>
		/// returns false when the bottom of the letter has been reached.
		/// </summary>
		internal	bool Next()
		{
			if (this.letterIndexer == null)
			{
				return this.next();
			}
			else
			{
				if (this.letterIndexer.Next())
				{
					return true;
				}
				else
				{
					return this.next();
				}
			}
		}
		private		bool next()
		{ 
			this.letterIndex++;

			if (this.letterIndex == this.lettersLenght)
			{
				this.letterIndex = 0;

				return false;
			}
			else
			{
				return true;
			}
		}

		internal List<string>	GetLetterList()
		{
			List<string> letterList;

			if (this.letterIndexer == null)
			{
				letterList = new List<string>();

				letterList.Add(this.letter);

			}
			else
			{
				letterList = this.letterIndexer.GetLetterList();

				letterList.Insert(0, this.letter);
			}

			return letterList;
		}
		internal string			GetString_of_sharp_separated_letters()
		{
			if (this.letterIndexer == null)
			{
				return this.letter;
			}
			else
			{
				return this.letter + "#" + this.letterIndexer.GetString_of_sharp_separated_letters();

			}
		}
	}
}
