﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__DerivatedWordType__CreateUpdate : Form
	{
		private MainForm mainForm;
		private bool trueForCreate__falseForUpdate;

		private BabebiDataSet.DerivatedWordTypeDataTable			table__DerivatedWordType			{ get { return this.mainForm.DataSet.DerivatedWordType; } }
		private BabebiDataSet.DerivatedWordType_LanguageDataTable	table__DerivatedWordType_Language	{ get { return this.mainForm.DataSet.DerivatedWordType_Language; } }
		
		private short derivatedWordTypeId;

		private BabebiDataSet.LanguageRow current__Language
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}
		private string currentLanguageCode
		{
			get
			{
				return this.mainForm.Current__Language.Code;
			}
		}

		private BabebiDataSet.DerivatedWordTypeRow current__DerivatedWordType
		{
			get { return	this.mainForm.Current__DerivatedWordType; }
			set { 			this.mainForm.Current__DerivatedWordType = value; }
		}
		private BabebiDataSet.DerivatedWordType_LanguageRow current__DerivatedWordType_Language
		{
			get { return	this.mainForm.Current__DerivatedWordType_Language; }
			set { 			this.mainForm.Current__DerivatedWordType_Language = value; }
		}

		private bool dontTriggerEvent = false;

		private bool hasError__DerivatedWordTypeId_ = false;
		private bool hasError__DerivatedWordTypeId
		{
			get { return this.hasError__DerivatedWordTypeId_; }
			set
			{
				this.hasError__DerivatedWordTypeId_ = value;

				if (this.hasError__DerivatedWordTypeId_)
				{
					this.label__DerivatedWordTypeId.ForeColor = Color.Red;
					this.textBox__DerivatedWordTypeId.BackColor = Color.White;
					this.textBox__DerivatedWordTypeId.ForeColor = Color.Red;
				}
				else
				{
					this.label__DerivatedWordTypeId.ForeColor = Color.Black;
					this.textBox__DerivatedWordTypeId.BackColor = Color.White;
					this.textBox__DerivatedWordTypeId.ForeColor = Color.Black;
				}
			}
		}

		#region		ctors

		public Form__DerivatedWordType__CreateUpdate(MainForm mainForm, bool trueForCreate__falseForUpdate) : this()
		{
			this.mainForm = mainForm;
			this.trueForCreate__falseForUpdate = trueForCreate__falseForUpdate;

			if (this.trueForCreate__falseForUpdate)
			{
				this.button__CreateUpdate.Text = "CREATE";
				this.Text = "Create a new 'Derivated Word Type' :";

				#region	DerivatedWordTypeId

				this.derivatedWordTypeId = this.table__DerivatedWordType.Max(derivatedWordTypeRow => derivatedWordTypeRow.Id);

				this.derivatedWordTypeId++;

				this.textBox__DerivatedWordTypeId.Text = this.derivatedWordTypeId.ToString();

				#endregion	DerivatedWordTypeId

				this.textBox__Name.Text						= this.current__DerivatedWordType_Language.Name + "###";
				this.textBox__DerivatedWordTypeName.Text	= this.current__DerivatedWordType.Name			+ "###";;
			}
			else
			{ 
				this.button__CreateUpdate.Text = "UPDATE";
				this.Text = "Update an existing 'Derivated Word Type' :";

				#region	DerivatedWordTypeId

				this.derivatedWordTypeId = this.current__DerivatedWordType.Id;				
				this.textBox__DerivatedWordTypeId.Text = this.derivatedWordTypeId.ToString();

				#region		must be Read-Only if existing Derivatings (due to double-sided-update-cascades)

				bool canCascade = true;
				foreach 
				(
					BabebiDataSet.DerivatingWordType_DerivatedWordTypeRow derivatingWordType_derivatedWordType 
					in 
					this.current__DerivatedWordType.GetDerivatingWordType_DerivatedWordTypeRows()
				)
				{
					if (derivatingWordType_derivatedWordType.GetDerivatingRows().Length > 0)
					{
						canCascade = false;
						break;
					}
				}
				this.textBox__DerivatedWordTypeId.ReadOnly = !canCascade;

				#endregion	must be Read-Only if existing Derivatings (due to double-sided-update-cascades)

				#endregion	DerivatedWordTypeId

				this.textBox__Name.Text = this.current__DerivatedWordType_Language.Name;
				this.textBox__DerivatedWordTypeName.Text = this.current__DerivatedWordType.Name;
			}

			#region		comboBox__WordType_LanguageName

			if (this.current__DerivatedWordType_Language != null)
			{
				/// either an Update or a cloning.
				WordTypeComboBoxItem focusedWordTypeComboBoxItem;
				List<WordTypeComboBoxItem> wordTypeComboBoxItems 
					= WordTypeComboBoxItem
					.BuildWordTypeComboBoxItems
					(
						this.current__Language, 
						this.current__DerivatedWordType_Language.WordType_LanguageRowParent,
					out focusedWordTypeComboBoxItem
					);
				this.comboBox__WordType_LanguageName.Items.AddRange(wordTypeComboBoxItems.ToArray());
				if (focusedWordTypeComboBoxItem != null)
				{
					this.comboBox__WordType_LanguageName.SelectedItem = focusedWordTypeComboBoxItem;
				}
			}
			else
			{ 
				/// a create without cloning.
				List<WordTypeComboBoxItem> wordTypeComboBoxItems 
					= WordTypeComboBoxItem.BuildWordTypeComboBoxItems(this.current__Language);
				this.comboBox__WordType_LanguageName.Items.AddRange(wordTypeComboBoxItems.ToArray());
			}

			#endregion	comboBox__WordType_LanguageName
		}

		public Form__DerivatedWordType__CreateUpdate()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void textBox__DerivatedWordTypeId__KeyPress(object sender, KeyPressEventArgs e)
		{
			if (this.dontTriggerEvent)
			{
				return;
			}

			MainForm.Integer__KeyPress(e);
		}
		private void textBox__DerivatedWordTypeId__Leave(object sender, EventArgs e)
		{
			if (this.dontTriggerEvent)
			{
				return;
			}

			string derivatedWordTypeId = this.textBox__DerivatedWordTypeId.Text;

			if (string.IsNullOrEmpty(derivatedWordTypeId))
			{
				this.hasError__DerivatedWordTypeId = true;

				MessageBox.Show
				(
					"The value of the 'Derivating Word Type Id' cannot be let undefined.", 
					"Derivating Id required", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);

				return;
			}

			this.derivatedWordTypeId = short.Parse(derivatedWordTypeId);    /// validé par le KeyPress comme étant un nombre => go : pas de TryParse(...).

			if (this.current__DerivatedWordType == null || this.derivatedWordTypeId != this.current__DerivatedWordType.Id)
			{
				BabebiDataSet.DerivatedWordTypeRow alreadyExistingDerivatedWordType
					= this.table__DerivatedWordType
					.FindById(this.derivatedWordTypeId);

				if (alreadyExistingDerivatedWordType != null)
				{
					BabebiDataSet.DerivatedWordType_LanguageRow alreadyExistingDerivatedWordType_Language
						= this.table__DerivatedWordType_Language
						.FindByDerivatedWordTypeIdLanguageCode
						(
							this.derivatedWordTypeId,
							this.currentLanguageCode
						);

					this.hasError__DerivatedWordTypeId = true;

					MessageBox.Show
					(
						"This 'Derivated Word Type Id' is already associated to the existing 'Derivated Word Type' defined by:\n\n'" +
						"   - Name [" + this.currentLanguageCode + "] = '" + 
						alreadyExistingDerivatedWordType_Language.Name + "'.",
						"Derivated Word Type Id already exising",
						MessageBoxButtons.OK,
						MessageBoxIcon.Error
					);

					return;
				}
				else
				{
					this.hasError__DerivatedWordTypeId = false;
				}
			}
			else
			{ 
				this.hasError__DerivatedWordTypeId = false;
			}
		}

		private void button__CreateUpdate__Click(object sender, EventArgs e)
		{
			if (this.hasError__DerivatedWordTypeId)
			{
				MessageBox.Show
				(
					"There is an error about the 'Derivated Word Type Id'. This command can not be performed.",
					"Error on Derivated Word Type Id", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);

				return;
			}

			string name						= this.textBox__Name.Text;
			if ( ! MainForm.UserEntryChecking(this.table__DerivatedWordType_Language.NameColumn	, name						)) { return; }

			string derivatedWordTypeName	= this.textBox__DerivatedWordTypeName.Text;
			if (string.IsNullOrEmpty(derivatedWordTypeName) || derivatedWordTypeName == "..." || derivatedWordTypeName.StartsWith("**"))
			{
				derivatedWordTypeName = "**" + this.current__Language.Code + "**" + name;
			}
			if ( ! MainForm.UserEntryChecking(this.table__DerivatedWordType			.NameColumn	, derivatedWordTypeName	)) { return; }

			if (this.comboBox__WordType_LanguageName.SelectedItem == null)
			{
				MessageBox.Show("A 'Type' is required.","Missing value", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}
			BabebiDataSet.WordType_LanguageRow selectedWordType_Language
				= 
				(
					(WordTypeComboBoxItem)
					(this.comboBox__WordType_LanguageName.SelectedItem)
				).Row;

			if (this.trueForCreate__falseForUpdate)
			{
				this.current__DerivatedWordType
					= this.table__DerivatedWordType.AddDerivatedWordTypeRow
					(
						this.derivatedWordTypeId,
						derivatedWordTypeName,
						selectedWordType_Language.WordTypeRow
					);

				#region		build DerivatedWordType_Language dataRows

				foreach (BabebiDataSet.LanguageRow language in this.mainForm.DataSet.Language)
				{
					if (language.Code == this.mainForm.Current__Language.Code)
					{
						this.current__DerivatedWordType_Language
							= this.mainForm.DataSet.DerivatedWordType_Language
								.AddDerivatedWordType_LanguageRow
								(
									this.mainForm.Current__DerivatedWordType.Id,
									language,
									name,
									selectedWordType_Language.WordTypeId
								);
					}
					else
					{
						this.mainForm.DataSet.DerivatedWordType_Language
							.AddDerivatedWordType_LanguageRow
							(
								this.mainForm.Current__DerivatedWordType.Id,
								language,
								"**" + this.current__Language.Code + "**" + name,
								selectedWordType_Language.WordTypeId
								);
					}
				}

				#endregion	build DerivatedWordType_Language dataRows
				#region		focus the newly-created row in the gui.

				int rowIndex = -1;
				foreach
				(
					DataGridViewRow dataGridViewRow
					in
					this.mainForm.dataGridView__DerivatedWordType_Language.Rows
				)
				{
					rowIndex++;

					short id = (short)(dataGridViewRow.Cells[0].Value);

					if (id == this.mainForm.Current__DerivatedWordType_Language.DerivatedWordTypeId)
					{
						break;
					}
				}
				this.mainForm.dataGridView__DerivatedWordType_Language.CurrentCell
					= this.mainForm.dataGridView__DerivatedWordType_Language.Rows[rowIndex].Cells[0];

				#endregion	focus the newly-created row in the gui.
			}
			else
			{
				this.current__DerivatedWordType.Id = this.derivatedWordTypeId;

				this.current__DerivatedWordType.Name = derivatedWordTypeName;

				this.current__DerivatedWordType.WordTypeRow = selectedWordType_Language.WordTypeRow;

				this.current__DerivatedWordType_Language.Name = name;
				
				#region		update DerivatedWordType_Language dataRows

				foreach 
				(
					BabebiDataSet.DerivatedWordType_LanguageRow derivatedWordType_Language
					in
					this.current__DerivatedWordType.GetDerivatedWordType_LanguageRows()
				)
				{
					if (derivatedWordType_Language.LanguageCode == this.currentLanguageCode)
					{
						continue;	/// the update if any has been performed above.
					}

					if (derivatedWordType_Language.Name.StartsWith("**"))
					{
						derivatedWordType_Language.Name = "**" + this.currentLanguageCode + "**" + name;
					}
				}

				#endregion	update DerivatedWordType_Language dataRows
			}

			this.Close();
		}
	}
}
