﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__DerivatingWordType_DerivatedWordType__CreateDelete : Form
	{
		private MainForm mainForm;
		private bool trueForCreate__falseForDelete;

		private string currentLanguageCode { get { return this.mainForm.Current__Language.Code; } }

		private BabebiDataSet.DerivatingWordType_DerivatedWordTypeDataTable		table__DerivatingWordType_DerivatedWordType 
		{ 
			get 
			{ 
				return this.mainForm.DataSet.DerivatingWordType_DerivatedWordType; 
			} 
		}
		private BabebiDataSet.DerivatingWordType_LanguageDataTable				table__DerivatingWordType_Language
		{ 
			get 
			{ 
				return this.mainForm.DataSet.DerivatingWordType_Language; 
			} 
		}
		private BabebiDataSet.DerivatedWordType_LanguageDataTable				table__DerivatedWordType_Language 
		{ 
			get 
			{ 
				return this.mainForm.DataSet.DerivatedWordType_Language; 
			} 
		}

		private BabebiDataSet.DerivatingWordType_DerivatedWordTypeRow	current__DerivatingWordType_DerivatedWordType
		{
			get { return this.mainForm.Current__DerivatingWordType_DerivatedWordType;	}
			set { this.mainForm.Current__DerivatingWordType_DerivatedWordType = value;	}
		}
		private BabebiDataSet.DerivatingWordTypeRow						current__DerivatingWordType
		{
			get { return this.mainForm.Current__DerivatingWordType;	}
		}
		private BabebiDataSet.DerivatingWordType_LanguageRow			current__DerivatingWordType_Language
		{
			get { return this.mainForm.Current__DerivatingWordType_Language;	}
		}
		private BabebiDataSet.DerivatedWordTypeRow						current__DerivatedWordType
		{
			get { return this.mainForm.Current__DerivatedWordType;	}
		}
		private BabebiDataSet.DerivatedWordType_LanguageRow				current__DerivatedWordType_Language
		{
			get { return this.mainForm.Current__DerivatedWordType_Language;	}
		}

		#region		ctors

		public Form__DerivatingWordType_DerivatedWordType__CreateDelete(MainForm mainForm, bool trueForCreate__falseForDelete) : this()
		{
			this.mainForm = mainForm;
			this.trueForCreate__falseForDelete = trueForCreate__falseForDelete;

			if (this.trueForCreate__falseForDelete)
			{
				this.Text = "Create a new link betwen a 'Derivating Word Type' and a 'Derivated word Type' : ";
				this.button__CreateDelete.Text = "CREATE";

				this.textBox__WordType__of__DerivatingWordType	.Text = this.current__DerivatingWordType_Language.WordType_LanguageName;
				this.textBox__DerivatingWordType				.Text = this.current__DerivatingWordType_Language.Name;

				this.textBox__WordType__of__DerivatedWordType	.Text = this.current__DerivatedWordType_Language.WordType_LanguageName;
				this.textBox__DerivatedWordType					.Text = this.current__DerivatedWordType_Language.Name;
			}
			else
			{
				this.Text = "DELETE an existing link betwen a 'Derivating Word Type' and a 'Derivated word Type' : ";
				this.button__CreateDelete.Text = "DELETE";

				if (this.current__DerivatingWordType_DerivatedWordType == null)
				{
					MessageBox.Show("You have to select a link between a 'Derivating Word Type' and a 'Derivated Word Type' first.", "No link selected", MessageBoxButtons.OK, MessageBoxIcon.Information);
				}
				else
				{ 
					BabebiDataSet.DerivatingWordType_LanguageRow	derivatingWordType_Language
						= this.table__DerivatingWordType_Language
						.FindByDerivatingWordTypeIdLanguageCode
						(
							this.current__DerivatingWordType_DerivatedWordType.DerivatingWordTypeId,
							this.currentLanguageCode
						);

					BabebiDataSet.DerivatedWordType_LanguageRow		derivatedWordType_Language
						= this.table__DerivatedWordType_Language
						.FindByDerivatedWordTypeIdLanguageCode
						(
							this.current__DerivatingWordType_DerivatedWordType.DerivatedWordTypeId,
							this.currentLanguageCode
						);
					
					this.textBox__WordType__of__DerivatingWordType	.Text = derivatingWordType_Language.WordType_LanguageName;
					this.textBox__DerivatingWordType				.Text = derivatingWordType_Language.Name;
					this.textBox__WordType__of__DerivatedWordType	.Text = derivatedWordType_Language.WordType_LanguageName;
					this.textBox__DerivatedWordType					.Text = derivatedWordType_Language.Name;
				}
			}
		}

		public Form__DerivatingWordType_DerivatedWordType__CreateDelete()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void button__CreateDelete__Click(object sender, EventArgs e)
		{
			if (this.trueForCreate__falseForDelete)
			{
				this.current__DerivatingWordType_DerivatedWordType
					= this.table__DerivatingWordType_DerivatedWordType
					.AddDerivatingWordType_DerivatedWordTypeRow
					(
						this.current__DerivatingWordType, 
						this.current__DerivatedWordType
					);

				#region		focus the newly-created guiRow

				string cnDingWT	= "dataGridViewTextBoxColumn__DerivatingWordType_DerivatedWordType__DerivatingWordTypeId";
				string cnDedWT	= "dataGridViewTextBoxColumn__DerivatingWordType_DerivatedWordType__DerivatedWordTypeId";

				int rowIndex = -1;
				foreach (DataGridViewRow dataGridViewRow in this.mainForm.dataGridView__DerivatingWordType_DerivatedWordType.Rows)
				{
					rowIndex++;
					if
					(
						(short)(dataGridViewRow.Cells[cnDingWT].Value) == this.current__DerivatingWordType_DerivatedWordType.DerivatingWordTypeId
						&&
						(short)(dataGridViewRow.Cells[cnDedWT].Value) == this.current__DerivatingWordType_DerivatedWordType.DerivatedWordTypeId

					)
					{ 
						break;
					}
				}

				this.mainForm.dataGridView__DerivatingWordType_DerivatedWordType.CurrentCell
					= this.mainForm.dataGridView__DerivatingWordType_DerivatedWordType
					.Rows[rowIndex]
					.Cells["dataGridViewTextBoxColumn__DerivatingWordType_DerivatedWordType__DerivatingWordType_LanguageName"];

				#endregion	focus the newly-created guiRow
			}
			else
			{ 
				DialogResult dialogResult
					= MessageBox.Show
					(
						"Do you really want to delete the link between :\n\n" + 
						"   - '" + this.textBox__DerivatingWordType	.Text + "' \n" + 
						"      and\n" +
						"   - '" + this.textBox__DerivatedWordType	.Text + "' ?",
						"DELETE ?",
						MessageBoxButtons.YesNo,
						MessageBoxIcon.Question
					);

				if (dialogResult == DialogResult.No)
				{
					return;
				}

				this.table__DerivatingWordType_DerivatedWordType
				.RemoveDerivatingWordType_DerivatedWordTypeRow
				(
					this.current__DerivatingWordType_DerivatedWordType
				);
			}

			this.Close();
		}
	}
}
