﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__DerivatingWordType__CreateUpdate : Form
	{
		private MainForm mainForm;
		private bool trueForCreate__falseForUpdate;

		private BabebiDataSet.DerivatingWordTypeDataTable			table__DerivatingWordType			{ get { return this.mainForm.DataSet.DerivatingWordType; } }
		private BabebiDataSet.DerivatingWordType_LanguageDataTable	table__DerivatingWordType_Language	{ get { return this.mainForm.DataSet.DerivatingWordType_Language; } }
		
		private short derivatingWordTypeId;

		private BabebiDataSet.LanguageRow current__Language
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}
		private string currentLanguageCode
		{
			get
			{
				return this.mainForm.Current__Language.Code;
			}
		}

		private BabebiDataSet.DerivatingWordTypeRow current__DerivatingWordType
		{
			get { return	this.mainForm.Current__DerivatingWordType; }
			set { 			this.mainForm.Current__DerivatingWordType = value; }
		}
		private BabebiDataSet.DerivatingWordType_LanguageRow current__DerivatingWordType_Language
		{
			get { return	this.mainForm.Current__DerivatingWordType_Language; }
			set { 			this.mainForm.Current__DerivatingWordType_Language = value; }
		}

		private bool dontTriggerEvent = false;

		private bool hasError__DerivatingWordTypeId_ = false;
		private bool hasError__DerivatingWordTypeId
		{
			get { return this.hasError__DerivatingWordTypeId_; }
			set
			{
				this.hasError__DerivatingWordTypeId_ = value;

				if (this.hasError__DerivatingWordTypeId_)
				{
					this.label__DerivatingWordTypeId.ForeColor = Color.Red;
					this.textBox__DerivatingWordTypeId.BackColor = Color.White;
					this.textBox__DerivatingWordTypeId.ForeColor = Color.Red;
				}
				else
				{
					this.label__DerivatingWordTypeId.ForeColor = Color.Black;
					this.textBox__DerivatingWordTypeId.BackColor = Color.White;
					this.textBox__DerivatingWordTypeId.ForeColor = Color.Black;
				}
			}
		}

		#region		ctors

		public Form__DerivatingWordType__CreateUpdate(MainForm mainForm, bool trueForCreate__falseForUpdate) : this()
		{
			this.mainForm = mainForm;
			this.trueForCreate__falseForUpdate = trueForCreate__falseForUpdate;

			if (this.trueForCreate__falseForUpdate)
			{
				this.button__CreateUpdate.Text = "CREATE";
				this.Text = "Create a new 'Derivating Word Type' :";

				#region	DerivatingWordTypeId

				this.derivatingWordTypeId = this.table__DerivatingWordType.Max(derivatingWordTypeRow => derivatingWordTypeRow.Id);

				this.derivatingWordTypeId++;

				this.textBox__DerivatingWordTypeId.Text = this.derivatingWordTypeId.ToString();

				#endregion	DerivatingWordTypeId

				this.textBox__Name.Text						= this.current__DerivatingWordType_Language.Name + "###";
				this.textBox__DerivatingWordTypeName.Text	= this.current__DerivatingWordType.Name			+ "###";;
			}
			else
			{ 
				this.button__CreateUpdate.Text = "UPDATE";
				this.Text = "Update an existing 'Derivating Word Type' :";

				#region	DerivatingWordTypeId

				this.derivatingWordTypeId = this.current__DerivatingWordType.Id;				
				this.textBox__DerivatingWordTypeId.Text = this.derivatingWordTypeId.ToString();

				#region		must be Read-Only if existing Derivatings (due to double-sided-update-cascades)

				bool canCascade = true;
				foreach 
				(
					BabebiDataSet.DerivatingWordType_DerivatedWordTypeRow derivatingWordType_derivatedWordType 
					in 
					this.current__DerivatingWordType.GetDerivatingWordType_DerivatedWordTypeRows()
				)
				{
					if (derivatingWordType_derivatedWordType.GetDerivatingRows().Length > 0)
					{
						canCascade = false;
						break;
					}
				}
				this.textBox__DerivatingWordTypeId.ReadOnly = !canCascade;

				#endregion	must be Read-Only if existing Derivatings (due to double-sided-update-cascades)

				#endregion	DerivatingWordTypeId

				this.textBox__Name.Text = this.current__DerivatingWordType_Language.Name;
				this.textBox__DerivatingWordTypeName.Text = this.current__DerivatingWordType.Name;
			}

			#region		comboBox__WordType_LanguageName

			if (this.current__DerivatingWordType_Language != null)
			{
				/// either an Update or a cloning.
				WordTypeComboBoxItem focusedWordTypeComboBoxItem;
				List<WordTypeComboBoxItem> wordTypeComboBoxItems 
					= WordTypeComboBoxItem
					.BuildWordTypeComboBoxItems
					(
						this.current__Language, 
						this.current__DerivatingWordType_Language.WordType_LanguageRowParent,
					out focusedWordTypeComboBoxItem
					);
				this.comboBox__WordType_LanguageName.Items.AddRange(wordTypeComboBoxItems.ToArray());
				if (focusedWordTypeComboBoxItem != null)
				{
					this.comboBox__WordType_LanguageName.SelectedItem = focusedWordTypeComboBoxItem;
				}
			}
			else
			{ 
				/// a create without cloning.
				List<WordTypeComboBoxItem> wordTypeComboBoxItems 
					= WordTypeComboBoxItem.BuildWordTypeComboBoxItems(this.current__Language);
				this.comboBox__WordType_LanguageName.Items.AddRange(wordTypeComboBoxItems.ToArray());
			}

			#endregion	comboBox__WordType_LanguageName
		}

		public Form__DerivatingWordType__CreateUpdate()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void textBox__DerivatingWordTypeId__KeyPress(object sender, KeyPressEventArgs e)
		{
			if (this.dontTriggerEvent)
			{
				return;
			}

			MainForm.Integer__KeyPress(e);
		}
		private void textBox__DerivatingWordTypeId__Leave(object sender, EventArgs e)
		{
			if (this.dontTriggerEvent)
			{
				return;
			}

			string derivatingWordTypeId = this.textBox__DerivatingWordTypeId.Text;

			if (string.IsNullOrEmpty(derivatingWordTypeId))
			{
				this.hasError__DerivatingWordTypeId = true;

				MessageBox.Show
				(
					"The value of the 'Derivating Word Type Id' cannot be let undefined.", 
					"Derivating Id required", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);

				return;
			}

			this.derivatingWordTypeId = short.Parse(derivatingWordTypeId);    /// validé par le KeyPress comme étant un nombre => go : pas de TryParse(...).

			if (this.current__DerivatingWordType == null || this.derivatingWordTypeId != this.current__DerivatingWordType.Id)
			{
				BabebiDataSet.DerivatingWordTypeRow alreadyExistingDerivatingWordType
					= this.table__DerivatingWordType
					.FindById(this.derivatingWordTypeId);

				if (alreadyExistingDerivatingWordType != null)
				{
					BabebiDataSet.DerivatingWordType_LanguageRow alreadyExistingDerivatingWordType_Language
						= this.table__DerivatingWordType_Language
						.FindByDerivatingWordTypeIdLanguageCode
						(
							this.derivatingWordTypeId,
							this.currentLanguageCode
						);

					this.hasError__DerivatingWordTypeId = true;

					MessageBox.Show
					(
						"This 'Derivating Word Type Id' is already associated to the existing 'Derivating Word Type' defined by:\n\n'" +
						"   - Name [" + this.currentLanguageCode + "] = '" + 
						alreadyExistingDerivatingWordType_Language.Name + "'.",
						"Derivating Word Type Id already exising",
						MessageBoxButtons.OK,
						MessageBoxIcon.Error
					);

					return;
				}
				else
				{
					this.hasError__DerivatingWordTypeId = false;
				}
			}
			else
			{ 
				this.hasError__DerivatingWordTypeId = false;
			}
		}

		private void button__CreateUpdate__Click(object sender, EventArgs e)
		{
			if (this.hasError__DerivatingWordTypeId)
			{
				MessageBox.Show
				(
					"There is an error about the 'Derivating Word Type Id'. This command can not be performed.",
					"Error on Derivating Word Type Id", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);

				return;
			}

			string name						= this.textBox__Name.Text;
			if ( ! MainForm.UserEntryChecking(this.table__DerivatingWordType_Language.NameColumn	, name						)) { return; }

			string derivatingWordTypeName	= this.textBox__DerivatingWordTypeName.Text;
			if (string.IsNullOrEmpty(derivatingWordTypeName) || derivatingWordTypeName == "..." || derivatingWordTypeName.StartsWith("**"))
			{
				derivatingWordTypeName = "**" + this.current__Language.Code + "**" + name;
			}
			if ( ! MainForm.UserEntryChecking(this.table__DerivatingWordType			.NameColumn	, derivatingWordTypeName	)) { return; }

			if (this.comboBox__WordType_LanguageName.SelectedItem == null)
			{
				MessageBox.Show("A 'Type' is required.","Missing value", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}
			BabebiDataSet.WordType_LanguageRow selectedWordType_Language
				= 
				(
					(WordTypeComboBoxItem)
					(this.comboBox__WordType_LanguageName.SelectedItem)
				).Row;

			if (this.trueForCreate__falseForUpdate)
			{
				this.current__DerivatingWordType
					= this.table__DerivatingWordType.AddDerivatingWordTypeRow
					(
						this.derivatingWordTypeId,
						derivatingWordTypeName,
						selectedWordType_Language.WordTypeRow
					);

				#region		build DerivatingWordType_Language dataRows

				foreach (BabebiDataSet.LanguageRow language in this.mainForm.DataSet.Language)
				{
					if (language.Code == this.mainForm.Current__Language.Code)
					{
						this.current__DerivatingWordType_Language
							= this.mainForm.DataSet.DerivatingWordType_Language
								.AddDerivatingWordType_LanguageRow
								(
									this.mainForm.Current__DerivatingWordType.Id,
									language,
									name,
									selectedWordType_Language.WordTypeId
								);
					}
					else
					{
						this.mainForm.DataSet.DerivatingWordType_Language
							.AddDerivatingWordType_LanguageRow
							(
								this.mainForm.Current__DerivatingWordType.Id,
								language,
								"**" + this.current__Language.Code + "**" + name,
								selectedWordType_Language.WordTypeId
								);
					}
				}

				#endregion	build DerivatingWordType_Language dataRows
				#region		focus the newly-created row in the gui.

				int rowIndex = -1;
				foreach
				(
					DataGridViewRow dataGridViewRow
					in
					this.mainForm.dataGridView__DerivatingWordType_Language.Rows
				)
				{
					rowIndex++;

					short id = (short)(dataGridViewRow.Cells[0].Value);

					if (id == this.mainForm.Current__DerivatingWordType_Language.DerivatingWordTypeId)
					{
						break;
					}
				}
				this.mainForm.dataGridView__DerivatingWordType_Language.CurrentCell
					= this.mainForm.dataGridView__DerivatingWordType_Language.Rows[rowIndex].Cells[0];

				#endregion	focus the newly-created row in the gui.
			}
			else
			{
				this.current__DerivatingWordType.Id = this.derivatingWordTypeId;

				this.current__DerivatingWordType.Name = derivatingWordTypeName;

				this.current__DerivatingWordType.WordTypeRow = selectedWordType_Language.WordTypeRow;

				this.current__DerivatingWordType_Language.Name = name;
				
				#region		update DerivatingWordType_Language dataRows

				foreach 
				(
					BabebiDataSet.DerivatingWordType_LanguageRow derivatingWordType_Language
					in
					this.current__DerivatingWordType.GetDerivatingWordType_LanguageRows()
				)
				{
					if (derivatingWordType_Language.LanguageCode == this.currentLanguageCode)
					{
						continue;	/// the update if any has been performed above.
					}

					if (derivatingWordType_Language.Name.StartsWith("**"))
					{
						derivatingWordType_Language.Name = "**" + this.currentLanguageCode + "**" + name;
					}
				}

				#endregion	update DerivatingWordType_Language dataRows
			}

			this.Close();
		}
	}
}
