﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__LanguageWord__Create : Form
	{
		private MainForm mainForm;

		private BabebiDataSet.LanguageWordDataTable			table__LanguageWord;
		private BabebiDataSet.Word_LanguageWordDataTable	table__Word_LanguageWord;

		private string currentLanguageCode
		{
			get { return this.mainForm.Current__Language.Code; }
		}

		#region		ctors

		public Form__LanguageWord__Create(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;

			this.table__LanguageWord		= this.mainForm.DataSet.LanguageWord;
			this.table__Word_LanguageWord	= this.mainForm.DataSet.Word_LanguageWord;

			if (this.mainForm.Current__LanguageWord == null)
			{
				return;
			}

			if
			(
				this.mainForm.Current__LanguageWord.RowState == DataRowState.Detached
				||
				this.mainForm.Current__LanguageWord.RowState == DataRowState.Detached
			)
			{
				return;
			}

			this.textBox__LanguageWord__String.Text = this.mainForm.Current__LanguageWord.String;
		}

		public Form__LanguageWord__Create()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void button__Create__Click(object sender, EventArgs e)
		{
			string languageWord__string		= this.textBox__LanguageWord__String.Text;

			if (!MainForm.UserEntryChecking(this.table__LanguageWord.StringColumn, languageWord__string, this.currentLanguageCode))
			{
				return;
			}

			#region		build LanguageWord dataRows

			BabebiDataSet.LanguageWordRow		theLanguageWord			= null;
			BabebiDataSet.Word_LanguageWordRow	theWord_LanguageWord	= null;


			foreach (BabebiDataSet.LanguageRow language in this.mainForm.DataSet.Language)
			{
				string languageWordString = 
						(
							language == this.mainForm.Current__Language 
							? 
							languageWord__string
							: 
							"**" + this.currentLanguageCode + "**" + languageWord__string
						);

				BabebiDataSet.LanguageWordRow languageWord
					= this.table__LanguageWord
					.FindByLanguageCodeString
					(
						language.Code,
						languageWordString					
					);

				if (languageWord == null)
				{ 
					languageWord
						= this.table__LanguageWord
						.AddLanguageWordRow
						(
							language,
							languageWordString					
						);
				}


				if (languageWord.LanguageCode == this.currentLanguageCode)
				{
					theLanguageWord		 = languageWord;
				}

				#region		linked to the current Word?

				if (this.mainForm.Current__Word != null && this.checkBox__LanguageWord__LinkToCurrentWord.Checked)
				{
					BabebiDataSet.Word_LanguageWordRow word_languageWord 
						= this.table__Word_LanguageWord
						.FindByWordIdLanguageCodeLanguageWordString
						(
							this.mainForm.Current__Word.Id, 
							language.Code, 
							languageWord.String
						);

					if (word_languageWord == null)
					{
						word_languageWord
							= this.table__Word_LanguageWord
							.AddWord_LanguageWordRow
							(
								this.mainForm.Current__Word.Id,
								language.Code,
								languageWord.String
							);
					}

					if (languageWord.LanguageCode == this.currentLanguageCode)
					{
						theWord_LanguageWord = word_languageWord;
					}
				}

				#endregion	linked to the current Word?
			}

			#endregion	build LanguageWord dataRows

			this.mainForm.Current__LanguageWord							= theLanguageWord;

			if (this.mainForm.Current__Word != null && this.checkBox__LanguageWord__LinkToCurrentWord.Checked)
			{
				this.mainForm.Current__Word_LanguageWord__of__Word = theWord_LanguageWord;
				this.mainForm.Current__Word_LanguageWord__of__LanguageWord = theWord_LanguageWord;
			}

			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
