﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__LanguageWord__Find : Form
	{
		private MainForm mainForm;

		private BabebiDataSet.LanguageWordDataTable			table__LanguageWord;
		private BabebiDataSet.Word_LanguageWordDataTable	table__Word_LanguageWord;

		private DataSet			guiDataSet;
		private DataTable		guiTable__LanguageWord;
		private DataColumn		guiColumn__LanguageWord__String;
		private BindingSource	bindingSource__LanguageWord;

		private BabebiDataSet.LanguageWordRow	selected__LanguageWord	= null;

		#region		ctors

		public Form__LanguageWord__Find(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;

			this.table__LanguageWord		= this.mainForm.DataSet.LanguageWord;
			this.table__Word_LanguageWord	= this.mainForm.DataSet.Word_LanguageWord;

			this.guiDataSet = new DataSet("GuiDataSet");

			this.guiDataSet.CaseSensitive = true;

			this.guiTable__LanguageWord				= this.guiDataSet.Tables.Add("LanguageWord");

			this.guiColumn__LanguageWord__String	= this.guiTable__LanguageWord.Columns.Add("String"	, typeof(string));

			this.guiTable__LanguageWord.PrimaryKey = new DataColumn[] { this.guiColumn__LanguageWord__String };

			this.bindingSource__LanguageWord = new BindingSource(this.guiDataSet, this.guiTable__LanguageWord.TableName);

			this.dataGridView_LanguageWord.DataSource = this.bindingSource__LanguageWord;

			this.bindingSource__LanguageWord.CurrentChanged += BindingSource__LanguageWord__CurrentChanged;

			this.button__OK.Enabled = false;
		}

		public Form__LanguageWord__Find()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void button__OK__Click(object sender, EventArgs e)
		{
			if (!this.button__OK.Enabled)
			{
				return;
			}

			if (this.selected__LanguageWord == null)
			{
				MessageBox.Show
				(
					"A 'Language Word' must be selected.",
					"Missing value", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);
				return;
			}

			this.mainForm.Current__LanguageWord = this.selected__LanguageWord;

			this.DialogResult = DialogResult.OK;

			this.Close();
		}

		private bool doNotSearch = false;

		private void textBox__LanguageWord__String__TextChanged(object sender, EventArgs e)
		{
			if (this.doNotSearch)
			{
				return;
			}

			string languageWordString = this.textBox__LanguageWord__String.Text;

			this.guiTable__LanguageWord.Clear();

			if (string.IsNullOrEmpty(languageWordString))
			{
				this.selected__LanguageWord = null;
				this.button__OK.Enabled = false;

				return;
			}

			DataRow[] selectedLanguageWords 
				= this.table__LanguageWord
				.Select
				(
					"LanguageCode = '" + this.mainForm.Current__Language.Code + "' AND " +
					"String LIKE '*" + languageWordString.Replace("'", "''") + "*'"
				);

			if (selectedLanguageWords.Length == 0)
			{
				this.selected__LanguageWord = null;

				this.button__OK.Enabled = false;
			}
			else if (selectedLanguageWords.Length == 1)
			{
				this.selected__LanguageWord = (BabebiDataSet.LanguageWordRow)(selectedLanguageWords[0]);

				this.doNotSearch = true;
				this.textBox__LanguageWord__String.Text = this.selected__LanguageWord.String;
				this.doNotSearch = false;

				this.button__OK.Enabled = true;
			}
			else
			{
				List<string> selectedLanguageWordStrings = new List<string>();
				foreach (BabebiDataSet.LanguageWordRow selectedLanguageWord in selectedLanguageWords)
				{
					selectedLanguageWordStrings.Add(selectedLanguageWord.String);
				}
				selectedLanguageWordStrings.Sort();


				int rowIndex = -1;
				int matchingRowIndex = -1;
				DataRow matchingGuiDataRow = null;
				foreach (string selectedLanguageWordString in selectedLanguageWordStrings)
				{
					rowIndex++;

					DataRow newDataRow 
						= this.guiTable__LanguageWord
						.Rows
						.Add
						(
							selectedLanguageWordString
						);

					if (matchingGuiDataRow == null && selectedLanguageWordString == languageWordString)
					{
						matchingGuiDataRow = newDataRow;
						matchingRowIndex = rowIndex;
					}
				}

				if (matchingGuiDataRow != null)
				{
					this.dataGridView_LanguageWord.CurrentCell = this.dataGridView_LanguageWord.Rows[matchingRowIndex].Cells[0];
					this.populateLanguageWord(matchingGuiDataRow);
				}
			}
		}

		private void BindingSource__LanguageWord__CurrentChanged(object sender, EventArgs e)
		{
			if (this.dataGridView_LanguageWord.Focused)
			{
				this.populateLanguageWord(((DataRowView)(this.bindingSource__LanguageWord.Current)).Row);
			}
		}

		private void populateLanguageWord(DataRow selectedGuiDataRow)
		{
			this.selected__LanguageWord 
				= this.table__LanguageWord
				.FindByLanguageCodeString
				(
					this.mainForm.Current__Language.Code,
					(string)(selectedGuiDataRow["String"])
				);

			this.doNotSearch = true;
			this.textBox__LanguageWord__String.Text = this.selected__LanguageWord.String;
			this.doNotSearch = false;

			this.button__OK.Enabled = true;
		}

		private void dataGridView_LanguageWord_MouseDoubleClick(object sender, MouseEventArgs e)
		{
			this.button__OK__Click(null, null);
		}

		private void button1_Click(object sender, EventArgs e)
		{
			if (!this.button__OK.Enabled)
			{
				return;
			}

			if (this.selected__LanguageWord == null)
			{
				MessageBox.Show
				(
					"A 'Language Word' must be selected.",
					"Missing value", 
					MessageBoxButtons.OK, 
					MessageBoxIcon.Error
				);
				return;
			}

			this.mainForm.Current__LanguageWord = this.selected__LanguageWord;

			if (this.mainForm.Current__Word != null)
			{
				foreach (BabebiDataSet.LanguageRow language in this.mainForm.DataSet.Language)
				{
					BabebiDataSet.LanguageWordRow languageWord;
					if (language == this.mainForm.Current__Language)
					{
						languageWord = this.selected__LanguageWord;
					}
					else
					{
						string impliedLanguageWordString = "**" + this.selected__LanguageWord.LanguageCode + "**" + this.selected__LanguageWord.String;

						languageWord = this.table__LanguageWord.FindByLanguageCodeString(language.Code, impliedLanguageWordString);

						if (languageWord == null)
						{
							continue;
						}
					}

					BabebiDataSet.Word_LanguageWordRow word_languageWord = this.table__Word_LanguageWord.AddWord_LanguageWordRow(this.mainForm.Current__Word.Id, language.Code, languageWord.String);
				}
			}


			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
