﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__LanguageWord__Update : Form
	{
		private MainForm mainForm;

		private BabebiDataSet.LanguageWordDataTable table__LanguageWord;
		private string currentLanguageCode
		{
			get { return this.mainForm.Current__Language.Code; }
		}

		#region		ctors

		public Form__LanguageWord__Update(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;

			this.table__LanguageWord			= this.mainForm.DataSet.LanguageWord;

			this.textBox__LanguageWord__String.Text = this.mainForm.Current__LanguageWord.String;
		}

		public Form__LanguageWord__Update()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void button__Update__Click(object sender, EventArgs e)
		{
			string newLanguageWordstring		= this.textBox__LanguageWord__String.Text;

			if (newLanguageWordstring == this.mainForm.Current__LanguageWord.String)
			{
				MessageBox.Show("The value has not been changed.", "No change", MessageBoxButtons.OK, MessageBoxIcon.Information);
			}

			if (!MainForm.UserEntryChecking(this.table__LanguageWord.StringColumn, newLanguageWordstring, this.currentLanguageCode))
			{
				return;
			}

			#region		update the LanguageWord dataRows

			string oldLanguageWordString = this.mainForm.Current__LanguageWord.String;

			if (!oldLanguageWordString.StartsWith("**"))
			{
				string subOldLanguageWordString	= "**" + this.currentLanguageCode + "**" + oldLanguageWordString;
				string subNewLanguageWordString	= "**" + this.currentLanguageCode + "**" + newLanguageWordstring;

				foreach (BabebiDataSet.LanguageRow language in this.mainForm.DataSet.Language)
				{
					if (language.Code == this.currentLanguageCode)
					{
						continue;
					}

					BabebiDataSet.LanguageWordRow subLanguageWord
						= this.mainForm.DataSet.LanguageWord
						.FindByLanguageCodeString
						(
							language.Code,
							subOldLanguageWordString
						);

					if (subLanguageWord != null)
					{
						subLanguageWord.String = subNewLanguageWordString;
					}
				}
			}

			this.mainForm.Current__LanguageWord.String = newLanguageWordstring;

			#endregion	build LanguageWord dataRows

			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
