﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__PatternByInsertion__CreateUpdate : Form
	{
		private MainForm		mainForm;
		private BabebiDataSet	dataSet;

		private bool trueForCreate__falseForUpdate
		{
			get
			{
				if (this.current__PatternByInsertion == null)
				{
					return true;
				}
				else
				{ 
					if (this.current__PatternByInsertion.Id != this.current__Pattern.Id)
					{
						return true;
					}
					else
					{ 
						return false;
					}
				}
			}
		}

		#region		shortcuts about tables

		private BabebiDataSet.PatternByInsertionDataTable					table__PatternByInsertion					;
		private BabebiDataSet.WordOrPatternDataTable						table__WordOrPattern						;
		private BabebiDataSet.PatternDataTable								table__Pattern								;
		private BabebiDataSet.Pattern_LanguageDataTable						table__Pattern_Language						;
		private BabebiDataSet.WordDataTable									table__Word									;
		private BabebiDataSet.Word_LanguageDataTable						table__Word_Language						;
		private BabebiDataSet.LetterOrSymbolDataTable						table__LetterOrSymbol						;
		private BabebiDataSet.LetterDataTable								table__Letter								;
		private BabebiDataSet.LetterOrSymbolClusterDataTable				table__LetterOrSymbolCluster				;
		private BabebiDataSet.LetterOrSymbolClusterLetterOrSymbolDataTable	table__LetterOrSymbolClusterLetterOrSymbol	;

		#endregion	shortcuts about tables
		#region		about the gui table (Parent)

		private DataSet guiDataSet;

		private DataTable guiTable__Parent;

		private DataColumn guiColumn__Parent__Id;
		private DataColumn guiColumn__Parent__String;
		private DataColumn guiColumn__Parent__Meaning;

		private BindingSource bindingSource__Parent;

		#endregion	about the gui table (Parent)
		#region		current__#s

		private BabebiDataSet.PatternRow			current__Pattern
		{
			get
			{
				return this.mainForm.Current__Pattern;
			}
		}
		private BabebiDataSet.PatternByInsertionRow current__PatternByInsertion
		{
			get
			{
				return this.mainForm.Current__PatternByInsertion;
			}
			set
			{
				this.mainForm.Current__PatternByInsertion = value;
			}
		}
		private BabebiDataSet.WordOrPatternRow		current__WordOrPattern__of__PatternByInsertion__Parent
		{
			get
			{
				return this.mainForm.Current__WordOrPattern__of__PatternByInsertion__Parent;
			}
			set
			{
				this.mainForm.Current__WordOrPattern__of__PatternByInsertion__Parent = value;
			}
		}

		#endregion	current__#s
		#region	variables

		/// checking initial puis... plus rien : un jour peu-être...
		List<BabebiDataSet.LetterOrSymbolRow> letterOrSymbols__of__Pattern__UniqueKeyString;

		/// attention : ces Rows correspondent au parent du PatternByInsertion que 
		/// l'on cherche à updater (donc pas du tout au Pattern lui-même).
		private BabebiDataSet.WordOrPatternRow		selected__Parent__WordOrPattern = null;
		private BabebiDataSet.PatternRow			selected__Parent__Pattern = null;
		private BabebiDataSet.Pattern_LanguageRow	selected__Parent__Pattern_Language = null;
		private BabebiDataSet.WordRow				selected__Parent__Word = null;
		private BabebiDataSet.Word_LanguageRow		selected__Parent__Word_Language = null;

		private short selected__InsertionIndex = -1;

		/// about LetterOrSymbolCluster
		private BabebiDataSet.LetterOrSymbolClusterRow selected__LetterOrSymbolCluster = null;
		List<BabebiDataSet.LetterOrSymbolRow> letterOrSymbolList = new List<BabebiDataSet.LetterOrSymbolRow>();

		private bool dontTriggerEvent = false;

		private string selectedSubscriberCode_;

		Dictionary<short, BabebiDataSet.LetterOrSymbolRow> ranks__letterOrSymbols 
			= new Dictionary<short, BabebiDataSet.LetterOrSymbolRow>();

		#endregion	variables
		#region		error management

		private NoControl_WEM	noControl_WEM__Parent;
		private ComboBox_WEM	comboBox_WEM__InsertionIndex;
		private TextBox_WEM		textBox_WEM__LetterOrSymbolClusterString;
		private TextBox_WEM		textBox_WEM__UniqueKeyString;

		#endregion	error management
		#region		ctors

		public Form__PatternByInsertion__CreateUpdate(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;
			this.dataSet = this.mainForm.DataSet;

			#region		shortcuts about tables

			this.table__PatternByInsertion					= this.dataSet.PatternByInsertion;
			this.table__WordOrPattern						= this.dataSet.WordOrPattern;
			this.table__Pattern								= this.dataSet.Pattern;
			this.table__Pattern_Language					= this.dataSet.Pattern_Language;
			this.table__Word								= this.dataSet.Word;
			this.table__Word_Language						= this.dataSet.Word_Language;
			this.table__LetterOrSymbol						= this.dataSet.LetterOrSymbol;
			this.table__Letter								= this.dataSet.Letter;
			this.table__LetterOrSymbolCluster				= this.dataSet.LetterOrSymbolCluster;
			this.table__LetterOrSymbolClusterLetterOrSymbol	= this.dataSet.LetterOrSymbolClusterLetterOrSymbol;

			#endregion	shortcuts about tables
			#region		guiTable__Parent

			this.guiDataSet = new DataSet("GuiDataSet");

			this.guiTable__Parent = this.guiDataSet.Tables.Add("Parent");

			this.guiColumn__Parent__Id = this.guiTable__Parent.Columns.Add("Id", typeof(int));
			this.guiColumn__Parent__String = this.guiTable__Parent.Columns.Add("String", typeof(string));
			this.guiColumn__Parent__Meaning = this.guiTable__Parent.Columns.Add("Meaning", typeof(string));

			this.guiTable__Parent.PrimaryKey = new DataColumn[] { this.guiColumn__Parent__Id };

			this.bindingSource__Parent = new BindingSource(this.guiDataSet, this.guiTable__Parent.TableName);

			this.dataGridView_Parent.DataSource = this.bindingSource__Parent;

			this.bindingSource__Parent.CurrentChanged += bindingSource__Parent_CurrentChanged;

			#endregion	guiTable__Parent
			#region		error management

			this.noControl_WEM__Parent 
				= new NoControl_WEM
				(
					"The parent Word/Pattern has not been selected.", 
					"Missing parent Word/Pattern"
				);

			this.comboBox_WEM__InsertionIndex 
				= new ComboBox_WEM
				(
					this.label__InsertionIndex,
					this.comboBox__InsertionIndex,
					(
						this.trueForCreate__falseForUpdate 
						? 
						null 
						: 
						MainForm.Convert__InsertionIndex__into__ComboBoxSelectedItem(this.current__PatternByInsertion.InsertionIndex)
					)
				);

			this.textBox_WEM__LetterOrSymbolClusterString = new TextBox_WEM
			(
				this.label__LetterOrSymbolClusterString,
				this.textBox__LetterOrSymbolClusterString,
				"The 'Letter/Symbol Cluster String' is empty.", 
				"Missing 'Letter/Symbol Cluster String'",
				this.current__Pattern.UniqueKeyString	/// oui : ici, même en mode Create, le UKS existe déjà.
			);
	
			this.textBox_WEM__UniqueKeyString = new TextBox_WEM
			(
				this.label__ComputedString,
				this.textBox__ComputedString,
				"The parent Pattern has not been selected.", 
				"Missing parent Pattern",
				this.current__Pattern.UniqueKeyString	/// oui : ici, même en mode Create, le UKS existe déjà.
			);

			#endregion	error management
			#region		analyse the 'Unique Key String' of the Pattern => letterOrSymbols__of__Pattern__UniqueKeyString.

			this.letterOrSymbols__of__Pattern__UniqueKeyString = new List<BabebiDataSet.LetterOrSymbolRow>();

			string errorCharString 
				= this.mainForm.Split_a_string_into_LetterOrSymbols
				(
					this.current__Pattern.UniqueKeyString, 
					this.letterOrSymbols__of__Pattern__UniqueKeyString
				);

			if (errorCharString != null)
			{
				this.textBox_WEM__UniqueKeyString
					.SetError
					(
						"The 'Unique Key String' of the (base) Pattern contains the invalid character : '" + errorCharString + "'.\n" +
						"You have to come back to the (base) definition of this Pattern, and then, change its (Unique Key) 'String'.", 
						"Invalid Character"
					);
				this.textBox_WEM__UniqueKeyString.ShowMessageBox();

				this.button__CreateUpdate.Visible = false;

				return;
			}

			#endregion	analyse the Unique Key String of the Word => letters__of__Word__UniqueKeyString.

			if (this.trueForCreate__falseForUpdate)
			{
				#region		CREATE case

				/// pour ne plus avoir cette valeur indéterminée
				this.comboBox__InsertionIndex.SelectedIndex = 0;

				/// pourquoi pas...
				this.comboBox__Parent__Type.SelectedItem = MainForm.SubscriberName_Pattern;

				this.button__CreateUpdate.Text = "CREATE";

				#endregion	CREATE case
			}
			else
			{
				#region		UPDATE case

				this.selected__Parent__WordOrPattern	= this.mainForm.Current__WordOrPattern__of__PatternByInsertion__Parent;
				this.selected__Parent__Pattern			= this.mainForm.Current__Pattern__of__PatternByInsertion__Parent;
				this.selected__Parent__Pattern_Language	= this.mainForm.Current__Pattern_Language__of__PatternByInsertion__Parent;
				this.selected__Parent__Word				= this.mainForm.Current__Word__of__PatternByInsertion__Parent;
				this.selected__Parent__Word_Language	= this.mainForm.Current__Word_Language__of__PatternByInsertion__Parent;

				this.textBox__SelectedParent__Type		.Text = this.mainForm.textBox__Pattern__ByInsertion__ParentSubscriberName.Text;
				this.textBox__SelectedParent__String	.Text = this.mainForm.textBox__Pattern__ByInsertion__ParentUniqueKeyString.Text;
				this.textBox__SelectedParent__Meaning	.Text = this.mainForm.textBox__Pattern__ByInsertion__ParentMeaning.Text;
				this.textBox__SelectedParent__Id		.Text = this.mainForm.textBox__Pattern__ByInsertion__ParentId.Text;

				this.comboBox__Parent__Type.SelectedItem = this.textBox__SelectedParent__Type.Text;

				this.noControl_WEM__Parent.ClearError();

				this.selected__InsertionIndex				= this.mainForm.Current__PatternByInsertion.InsertionIndex;
				this.comboBox__InsertionIndex.SelectedItem	= this.mainForm.textBox__Pattern__ByInsertion__InsertionIndex.Text;

				this.selected__LetterOrSymbolCluster			= this.mainForm.Current__PatternByInsertion.LetterOrSymbolClusterRow;
				this.textBox__LetterOrSymbolClusterString.Text	= this.mainForm.textBox__Pattern__ByInsertion__LetterOrSymbolClusterString.Text;

				#endregion	UPDATE case
			}
		}

		public Form__PatternByInsertion__CreateUpdate()
		{
			InitializeComponent();
		}

		#endregion	ctors

		#region		selecting of the Parent

		private bool tryToImplyInformation(string parentWordOrPatternUniqueKeyString, string currentPatternUniqueKeyString)
		{
			int lengthDifference = currentPatternUniqueKeyString.Length - parentWordOrPatternUniqueKeyString.Length;

			if (lengthDifference < 1)
			{
				return false;
			}

			short insertionIndex = -1;	/// means : return false;
			string letterOrSymbolClusterString = null;

			if (currentPatternUniqueKeyString.StartsWith(parentWordOrPatternUniqueKeyString))
			{
				/// letterOrSymbolCluster at the end.
				insertionIndex = 32;
				letterOrSymbolClusterString = currentPatternUniqueKeyString.Substring(parentWordOrPatternUniqueKeyString.Length);
			}
			else if (currentPatternUniqueKeyString.EndsWith(parentWordOrPatternUniqueKeyString))
			{
				/// letterOrSymbolCluster at the beginning.
				insertionIndex = 0;
				letterOrSymbolClusterString = currentPatternUniqueKeyString.Remove(lengthDifference);
			}
			else
			{
				short parentWordOrPatternUniqueKeyStringLength = Convert.ToInt16(parentWordOrPatternUniqueKeyString.Length);

				insertionIndex = 0;
				int charIndex;
				for (charIndex = 0; charIndex < parentWordOrPatternUniqueKeyStringLength; charIndex++)
				{
					char thisChar = parentWordOrPatternUniqueKeyString[charIndex];

					if (charIndex < parentWordOrPatternUniqueKeyStringLength - 1)
					{
						char nextChar = parentWordOrPatternUniqueKeyString[charIndex + 1];

						string doubleCharString = new string(new char[] { thisChar, nextChar });

						BabebiDataSet.LetterOrSymbolRow doubleCharLetterOrSymbol
							= this.table__LetterOrSymbol.FindByString(doubleCharString);

						if (doubleCharLetterOrSymbol != null)
						{
							if (currentPatternUniqueKeyString.Substring(charIndex, 2) == doubleCharString)
							{
								charIndex++;

								insertionIndex++;

								continue;
							}
							else
							{
								break;
							}
						}
					}

					string monoCharString = new string(new char[] { thisChar });

					if (currentPatternUniqueKeyString.Substring(charIndex, 1) == monoCharString)
					{
						insertionIndex++;
					}
					else
					{
						break;
					}
				}

				if (insertionIndex == 0)
				{
					return false;
				}

				letterOrSymbolClusterString = currentPatternUniqueKeyString.Substring(charIndex , lengthDifference);

				string ending				= currentPatternUniqueKeyString.Substring(charIndex + lengthDifference);

				if ( ! parentWordOrPatternUniqueKeyString.EndsWith(ending))
				{
					return false;
				}
			}

			#region		set everything

			string insertionIndexString
					= MainForm.Convert__InsertionIndex__into__ComboBoxSelectedItem
					(
						insertionIndex
					);
			this.comboBox__InsertionIndex.SelectedItem = insertionIndexString;
			this.comboBox_WEM__InsertionIndex.ClearError();

			/// on doit avoir l'event textBox__LetterOrSymbolClusterString__Changed car on aura besoin des this.ranks__LetterOrWord
			this.textBox__LetterOrSymbolClusterString.Text = letterOrSymbolClusterString;
			this.textBox_WEM__LetterOrSymbolClusterString.ClearError();


			this.textBox__ComputedString.Text = this.current__Pattern.UniqueKeyString;
			this.textBox_WEM__UniqueKeyString.ClearError();

			#endregion	set everything

			return true;
		}

		#region (ancienne routine)
		/*
		private void populateParentSelectedInformation(DataRow guiWordOrPatternDataRow)
		{
			string selectedSubscriberCode = this.selectedSubscriberCode_;
			int selectedId = (int)(guiWordOrPatternDataRow["Id"]);

			this.mainForm.GetWordOrPatternPackage
			(
				selectedSubscriberCode,
				selectedId,
			out string uniqueKeyString,
			out string meaning,
			ref this.selected__Parent__WordOrPattern,
			ref this.selected__Parent__Pattern,
			ref this.selected__Parent__Pattern_Language,
			ref this.selected__Parent__Word,
			ref this.selected__Parent__Word_Language
			);

			this.textBox__SelectedParent__Type		.Text = (string)(this.comboBox__Parent__Type.SelectedItem);
			this.textBox__SelectedParent__Id		.Text = selectedId.ToString();
			this.textBox__SelectedParent__String	.Text = uniqueKeyString;
			this.textBox__SelectedParent__Meaning	.Text = meaning;

			if (! this.tryToImplyInformation(uniqueKeyString, this.current__Pattern.UniqueKeyString))
			{
				this.Compute__ComputedString();		
			}
		}
		*/
		#endregion (ancienne routine)

		private void after_parent_selecting
		(
			string selected__parent__typeName          ,
			string selected__parent__IdString          ,
			string selected__parent__uniqueKeyString   ,
			string selected__parent__meaning
		)
		{ 
			this.noControl_WEM__Parent.ClearError();

			this.textBox__SelectedParent__Type		.Text = selected__parent__typeName;
			this.textBox__SelectedParent__Id		.Text = selected__parent__IdString;
			this.textBox__SelectedParent__String	.Text = selected__parent__uniqueKeyString;
			this.textBox__SelectedParent__Meaning	.Text = selected__parent__meaning;

			if (! this.tryToImplyInformation(selected__parent__uniqueKeyString, this.current__Pattern.UniqueKeyString))
			{
				this.compute__ComputedString();		
			}
		}

		bool preventCharEntry = false;
		private void textBox__Parent__String__KeyPress(object sender, KeyPressEventArgs e)
		{
			MainForm.Searching__UniqueKeyString__KeyPress(this.preventCharEntry, e);
		}

		private void textBox__Parent__String__TextChanged(object sender, EventArgs e)
		{
			bool?	parentSelecting;

			string	selected__parent__typeName;
			string	selected__parent__IdString;
			string	selected__parent__uniqueKeyString;
			string	selected__parent__meaning;

			if (this.selectedSubscriberCode_ == MainForm.SubscriberCode_Word)
			{
				parentSelecting = this.mainForm.textBox__Word__UniqueKeyString__TextChanged
				(
					textBox__Parent__String,
					textBox__Parent__Meaning,
					guiTable__Parent,
					this.current__Pattern.UniqueKeyString,
				out BabebiDataSet.WordRow selected__Word_,
				out BabebiDataSet.Word_LanguageRow selected__Word_Language_
				);

				if (!parentSelecting.HasValue)
				{ 
					this.preventCharEntry = false;

					return;
				}

				this.preventCharEntry = parentSelecting.Value;

				this.selected__Parent__WordOrPattern	= selected__Word_.WordOrPatternRowParent;
				this.selected__Parent__Pattern			= null;
				this.selected__Parent__Pattern_Language	= null;
				this.selected__Parent__Word				= selected__Word_;
				this.selected__Parent__Word_Language	= selected__Word_Language_;

				selected__parent__typeName			= MainForm.SubscriberName_Word;
				selected__parent__IdString			= this.selected__Parent__Word.ToString();
				selected__parent__uniqueKeyString	= this.selected__Parent__Word.UniqueKeyString;
				selected__parent__meaning			= this.selected__Parent__Word_Language.Meaning;
			}
			else if (this.selectedSubscriberCode_ == MainForm.SubscriberCode_Pattern)
			{
				parentSelecting = this.mainForm.textBox__Pattern__UniqueKeyString__TextChanged
				(
					textBox__Parent__String,
					textBox__Parent__Meaning,
					guiTable__Parent,
					this.current__Pattern.UniqueKeyString,
				out BabebiDataSet.PatternRow selected__Pattern_,
				out BabebiDataSet.Pattern_LanguageRow selected__Pattern_Language_
				);
				if (!parentSelecting.HasValue)
				{ 
					this.preventCharEntry = false;

					return;
				}

				this.preventCharEntry = parentSelecting.Value;

				this.selected__Parent__WordOrPattern	= selected__Pattern_.WordOrPatternRowParent;
				this.selected__Parent__Pattern			= selected__Pattern_;
				this.selected__Parent__Pattern_Language	= selected__Pattern_Language_;
				this.selected__Parent__Word				= null;
				this.selected__Parent__Word_Language	= null;

				selected__parent__typeName			= MainForm.SubscriberName_Pattern;
				selected__parent__IdString			= this.selected__Parent__Pattern.ToString();
				selected__parent__uniqueKeyString	= this.selected__Parent__Pattern.UniqueKeyString;
				selected__parent__meaning			= this.selected__Parent__Pattern_Language.Meaning;
			}
			else
			{
				throw new NotImplementedException(this.selectedSubscriberCode_);
			}

			this.after_parent_selecting
			(
				selected__parent__typeName			,
				selected__parent__IdString			,
				selected__parent__uniqueKeyString	,
				selected__parent__meaning			
			);

			#region	(ancienne version)
			/*
			string parent__String = this.textBox__Parent__String.Text;

			if (string.IsNullOrEmpty(parent__String))
			{
				return;
			}
			this.textBox__Parent__Meaning.Text = null;

			this.guiTable__Parent.Clear();

			if (parent__String.Length < 2)
			{
				return;
			}

			string filter 
				= "UniqueKeyString LIKE '*" 
				+ parent__String 
				+ "*' AND NOT(UniqueKeyString = '" 
				+ this.current__Pattern.UniqueKeyString 
				+ "')";

			if (this.selectedSubscriberCode_ == MainForm.SubscriberCode_Pattern)
			{
				#region		Pattern

				DataRow[] selectedPatterns = this.table__Pattern.Select(filter);

				if (selectedPatterns.Length == 1)
				{
					this.selected__Parent__Pattern = (BabebiDataSet.PatternRow)(selectedPatterns[0]);

					this.mainForm.GetWordOrPatternPackage
					(
						this.selected__Parent__Pattern.SubscribingCode,
						this.selected__Parent__Pattern.Id,
					out string uniqueKeyString,
					out string meaning,
					ref this.selected__Parent__WordOrPattern,
					ref this.selected__Parent__Pattern,
					ref this.selected__Parent__Pattern_Language,
					ref this.selected__Parent__Word,
					ref this.selected__Parent__Word_Language,
					true,
					false,
					false
					);

					this.textBox__SelectedParent__Type		.Text = (string)(this.comboBox__Parent__Type.SelectedItem);
					this.textBox__SelectedParent__Id		.Text = this.selected__Parent__Pattern.Id.ToString();
					this.textBox__SelectedParent__String	.Text = uniqueKeyString;
					this.textBox__SelectedParent__Meaning	.Text = meaning;

					if (! this.tryToImplyInformation(uniqueKeyString, this.current__Pattern.UniqueKeyString))
					{
						this.Compute__ComputedString();		
					}

					// cleaning of the searching area.
					this.dontTriggerEvent = true;
					this.textBox__Parent__Meaning.Text = null;
					this.textBox__Parent__String.Text = null;
					this.dontTriggerEvent = false;
				}
				else
				{
					DataRow matchingGuiDataRow = null;

					foreach (BabebiDataSet.PatternRow selectedPattern in selectedPatterns)
					{
						BabebiDataSet.Pattern_LanguageRow selectedPattern_Language
							= this.table__Pattern_Language
							.FindByPatternIdLanguageCode
							(
								selectedPattern.Id,
								this.mainForm.Current__Language.Code
							);

						DataRow guiDataRow
							= this.guiTable__Parent
							.Rows
							.Add
							(
								selectedPattern.Id,
								selectedPattern.UniqueKeyString,
								selectedPattern_Language.Meaning
							);

						if (matchingGuiDataRow == null && selectedPattern.UniqueKeyString == parent__String)
						{
							matchingGuiDataRow = guiDataRow;
						}
					}

					if (matchingGuiDataRow != null)
					{
						this.populateParentSelectedInformation(matchingGuiDataRow);
					}
					else
					{
						this.textBox__Parent__Meaning.Text = null;
					}
				}

				#endregion	Pattern
			}
			else if (this.selectedSubscriberCode_ == MainForm.SubscriberCode_Word)
			{
				#region		Word

				DataRow[] selectedWords = this.table__Word.Select(filter);

				if (selectedWords.Length == 1)
				{
					this.selected__Parent__Word = (BabebiDataSet.WordRow)(selectedWords[0]);

					this.mainForm.GetWordOrPatternPackage
					(
						this.selected__Parent__Word.SubscribingCode,
						this.selected__Parent__Word.Id,
					out string uniqueKeyString,
					out string meaning,
					ref this.selected__Parent__WordOrPattern,
					ref this.selected__Parent__Pattern,
					ref this.selected__Parent__Pattern_Language,
					ref this.selected__Parent__Word,
					ref this.selected__Parent__Word_Language,
					true, false, false
					);

					this.textBox__SelectedParent__Type		.Text = (string)(this.comboBox__Parent__Type.SelectedItem);
					this.textBox__SelectedParent__Id		.Text = this.selected__Parent__Word.Id.ToString();
					this.textBox__SelectedParent__String	.Text = uniqueKeyString;
					this.textBox__SelectedParent__Meaning	.Text = meaning;

					if (! this.tryToImplyInformation(uniqueKeyString, this.current__Pattern.UniqueKeyString))
					{
						this.Compute__ComputedString();		
					}

					this.textBox__Parent__Meaning.Text = null;
					this.textBox__Parent__String.Text = null;
				}
				else
				{
					DataRow matchingGuiDataRow = null;

					foreach (BabebiDataSet.WordRow selectedWord in selectedWords)
					{
						BabebiDataSet.Word_LanguageRow selectedWord_Language
							= this.table__Word_Language
							.FindByWordIdLanguageCode
							(
								selectedWord.Id,
								this.mainForm.Current__Language.Code
							);

						DataRow guiDataRow
							= this.guiTable__Parent
							.Rows
							.Add
							(
								selectedWord.Id,
								selectedWord.UniqueKeyString,
								selectedWord_Language.Meaning
							);

						if (matchingGuiDataRow == null && selectedWord.UniqueKeyString == parent__String)
						{
							matchingGuiDataRow = guiDataRow;
						}
					}

					if (matchingGuiDataRow != null)
					{
						this.populateParentSelectedInformation(matchingGuiDataRow);
					}
					else
					{
						this.textBox__Parent__Meaning.Text = null;
					}
				}

				#endregion	Word
			}
			else
			{
				throw new NotImplementedException(this.selectedSubscriberCode_);
			}
			*/
			#endregion	(ancienne version)
		}

		private void textBox__Parent__Meaning__TextChanged(object sender, EventArgs e)
		{
			bool?	parentSelecting;

			string	selected__parent__typeName;
			string	selected__parent__IdString;
			string	selected__parent__uniqueKeyString;
			string	selected__parent__meaning;

			if (this.selectedSubscriberCode_ == MainForm.SubscriberCode_Word)
			{
				parentSelecting = this.mainForm.textBox__Word__Meaning__TextChanged
				(
					textBox__Parent__String,
					textBox__Parent__Meaning,
					guiTable__Parent,
				out BabebiDataSet.WordRow selected__Word_,
				out BabebiDataSet.Word_LanguageRow selected__Word_Language_
				);

				if (!parentSelecting.HasValue)
				{ 
					this.preventCharEntry = false;

					return;
				}

				this.preventCharEntry = parentSelecting.Value;

				this.selected__Parent__WordOrPattern	= selected__Word_.WordOrPatternRowParent;
				this.selected__Parent__Pattern			= null;
				this.selected__Parent__Pattern_Language	= null;
				this.selected__Parent__Word				= selected__Word_;
				this.selected__Parent__Word_Language	= selected__Word_Language_;

				selected__parent__typeName			= MainForm.SubscriberName_Word;
				selected__parent__IdString			= this.selected__Parent__Word.ToString();
				selected__parent__uniqueKeyString	= this.selected__Parent__Word.UniqueKeyString;
				selected__parent__meaning			= this.selected__Parent__Word_Language.Meaning;
			}
			else if (this.selectedSubscriberCode_ == MainForm.SubscriberCode_Pattern)
			{
				parentSelecting = this.mainForm.textBox__Pattern__Meaning__TextChanged
				(
					textBox__Parent__String,
					textBox__Parent__Meaning,
					guiTable__Parent,
				out BabebiDataSet.PatternRow selected__Pattern_,
				out BabebiDataSet.Pattern_LanguageRow selected__Pattern_Language_
				);
				if (!parentSelecting.HasValue)
				{ 
					this.preventCharEntry = false;

					return;
				}

				this.preventCharEntry = parentSelecting.Value;

				this.selected__Parent__WordOrPattern	= selected__Pattern_.WordOrPatternRowParent;
				this.selected__Parent__Pattern			= selected__Pattern_;
				this.selected__Parent__Pattern_Language	= selected__Pattern_Language_;
				this.selected__Parent__Word				= null;
				this.selected__Parent__Word_Language	= null;

				selected__parent__typeName			= MainForm.SubscriberName_Pattern;
				selected__parent__IdString			= this.selected__Parent__Pattern.ToString();
				selected__parent__uniqueKeyString	= this.selected__Parent__Pattern.UniqueKeyString;
				selected__parent__meaning			= this.selected__Parent__Pattern_Language.Meaning;
			}
			else
			{
				throw new NotImplementedException(this.selectedSubscriberCode_);
			}

			this.after_parent_selecting
			(
				selected__parent__typeName			,
				selected__parent__IdString			,
				selected__parent__uniqueKeyString	,
				selected__parent__meaning			
			);

			#region		(ancienne version)
			/*
			if (this.dontTriggerEvent)
			{
				return;
			}

			// cleaning de l'autre field de recherche car on ne cherche que d'un côté à la fois
			this.dontTriggerEvent = true;
			this.textBox__Parent__String.Text = null;
			this.dontTriggerEvent = false;


			string parent__meaning = this.textBox__Parent__Meaning.Text;

			this.guiTable__Parent.Clear();

			if (parent__meaning.Length < 2)
			{
				return;
			}

			if (this.selectedSubscriberCode_ == MainForm.SubscriberCode_Pattern)
			{
				#region		Pattern

				DataRow[] selectedPattern_Languages
					= this.table__Pattern_Language
					.Select
					(
						"LanguageCode = '" + this.mainForm.Current__Language.Code + "' AND Meaning LIKE '*" + parent__meaning + "*'"
					);

				if (selectedPattern_Languages.Length == 1)
				{
					this.selected__Parent__Pattern_Language = (BabebiDataSet.Pattern_LanguageRow)(selectedPattern_Languages[0]);

					this.selected__Parent__Pattern = this.selected__Parent__Pattern_Language.PatternRow;

					this.mainForm.GetWordOrPatternPackage
					(
						this.selected__Parent__Pattern.SubscribingCode,
						this.selected__Parent__Pattern.Id,
					out string uniqueKeyString,
					out string meaning,
					ref this.selected__Parent__WordOrPattern,
					ref this.selected__Parent__Pattern,
					ref this.selected__Parent__Pattern_Language,
					ref this.selected__Parent__Word,
					ref this.selected__Parent__Word_Language,
					true,
					true,
					false
					);

					this.textBox__SelectedParent__Type		.Text = (string)(this.comboBox__Parent__Type.SelectedItem);
					this.textBox__SelectedParent__Id		.Text = this.selected__Parent__Pattern.Id.ToString();
					this.textBox__SelectedParent__String	.Text = uniqueKeyString;
					this.textBox__SelectedParent__Meaning	.Text = meaning;

					if (! this.tryToImplyInformation(uniqueKeyString, this.current__Pattern.UniqueKeyString))
					{
						this.Compute__ComputedString();		
					}

					// cleaning of the searching area.
					this.dontTriggerEvent = true;
					this.textBox__Parent__Meaning.Text = null;
					this.textBox__Parent__String.Text = null;
					this.dontTriggerEvent = false;
				}
				else
				{
					DataRow matchingGuiDataRow = null;

					foreach (BabebiDataSet.Pattern_LanguageRow selectedPattern_Language in selectedPattern_Languages)
					{
						BabebiDataSet.PatternRow selectedPattern = selectedPattern_Language.PatternRow;

						DataRow guiDataRow
							= this.guiTable__Parent
							.Rows
							.Add
							(
								selectedPattern_Language.PatternId,
								selectedPattern.UniqueKeyString,
								selectedPattern_Language.Meaning
							);

						if (matchingGuiDataRow == null && selectedPattern_Language.Meaning == parent__meaning)
						{
							matchingGuiDataRow = guiDataRow;
						}
					}

					if (matchingGuiDataRow != null)
					{
						this.populateParentSelectedInformation(matchingGuiDataRow);
					}
					else
					{
						this.dontTriggerEvent = true;
						this.textBox__Parent__String.Text = null;
						this.dontTriggerEvent = false;
					}
				}

				#endregion		Pattern
			}
			else if (this.selectedSubscriberCode_ == MainForm.SubscriberCode_Word)
			{
				#region		Word

				DataRow[] selectedWords_Languages
					= this.table__Word_Language
					.Select
					(
						"LanguageCode = '" + this.mainForm.Current__Language.Code + "' AND Meaning LIKE '*" + parent__meaning + "*'"
					);

				if (selectedWords_Languages.Length == 1)
				{
					this.selected__Parent__Word_Language = (BabebiDataSet.Word_LanguageRow)(selectedWords_Languages[0]);

					this.selected__Parent__Word = this.selected__Parent__Word_Language.WordRowParent;

					this.mainForm.GetWordOrPatternPackage
					(
						this.selected__Parent__Word.SubscribingCode,
						this.selected__Parent__Word.Id,
					out string uniqueKeyString,
					out string meaning,
					ref this.selected__Parent__WordOrPattern,
					ref this.selected__Parent__Pattern,
					ref this.selected__Parent__Pattern_Language,
					ref this.selected__Parent__Word,
					ref this.selected__Parent__Word_Language,
					true,
					true,
					false
					);

					this.textBox__SelectedParent__Type		.Text = (string)(this.comboBox__Parent__Type.SelectedItem);
					this.textBox__SelectedParent__Id		.Text = this.selected__Parent__Word.Id.ToString();
					this.textBox__SelectedParent__String	.Text = uniqueKeyString;
					this.textBox__SelectedParent__Meaning	.Text = meaning;

					if (! this.tryToImplyInformation(uniqueKeyString, this.current__Pattern.UniqueKeyString))
					{
						this.Compute__ComputedString();		
					}

					// cleaning of the searching area.
					this.dontTriggerEvent = true;
					this.textBox__Parent__Meaning.Text = null;
					this.textBox__Parent__String.Text = null;
					this.dontTriggerEvent = false;
				}
				else
				{
					DataRow matchingGuiDataRow = null;

					foreach (BabebiDataSet.Word_LanguageRow selectedWord_Language in selectedWords_Languages)
					{
						BabebiDataSet.WordRow selectedWord = selectedWord_Language.WordRowParent;

						DataRow guiDataRow
							= this.guiTable__Parent
							.Rows
							.Add
							(
								selectedWord_Language.WordId,
								selectedWord.UniqueKeyString,
								selectedWord_Language.Meaning
							);

						if (matchingGuiDataRow == null && selectedWord_Language.Meaning == parent__meaning)
						{
							matchingGuiDataRow = guiDataRow;
						}
					}

					if (matchingGuiDataRow != null)
					{
						this.populateParentSelectedInformation(matchingGuiDataRow);
					}
					else
					{
						this.dontTriggerEvent = true;
						this.textBox__Parent__String.Text = null;
						this.dontTriggerEvent = false;
					}
				}

				#endregion	Word
			}
			else
			{
				throw new NotImplementedException();
			}
			*/
			#endregion	(ancienne version)	
		}

		private void comboBox__Parent__Type__SelectedIndexChanged(object sender, EventArgs e)
		{
			this.textBox__Parent__String.Text = null;
			this.textBox__Parent__Meaning.Text = null;

			this.guiTable__Parent.Clear();

			this.selectedSubscriberCode_
				= MainForm
				.Convert__ComboBoxSelectedItem__into__Code__WordOrPattern
				(this.comboBox__Parent__Type.SelectedItem.ToString());
		}

		private void bindingSource__Parent_CurrentChanged(object sender, EventArgs e)
		{
			if (this.dataGridView_Parent.Focused)
			{
				DataRow guiDataRow__Pattern = ((DataRowView)(this.bindingSource__Parent.Current)).Row; 
				
				int		selected__Parent__Id = (int)(guiDataRow__Pattern["Id"]);

				string	selected__parent__typeName;
				string	selected__parent__IdString;
				string	selected__parent__uniqueKeyString;
				string	selected__parent__meaning;

				if (this.selectedSubscriberCode_ == MainForm.SubscriberCode_Word)
				{
					this.selected__Parent__Pattern			= null;
					this.selected__Parent__Pattern_Language	= null;
					this.selected__Parent__Word				= this.table__Word.FindById(selected__Parent__Id);
					this.selected__Parent__Word_Language	= this.table__Word_Language.FindByWordIdLanguageCode(selected__Parent__Id, this.mainForm.Current__Language.Code);
					this.selected__Parent__WordOrPattern	= this.selected__Parent__Word.WordOrPatternRowParent;
		
					selected__parent__typeName			= MainForm.SubscriberName_Word;
					selected__parent__IdString			= this.selected__Parent__Word.ToString();
					selected__parent__uniqueKeyString	= this.selected__Parent__Word.UniqueKeyString;
					selected__parent__meaning			= this.selected__Parent__Word_Language.Meaning;
				}
				else if (this.selectedSubscriberCode_ == MainForm.SubscriberCode_Pattern)
				{
					this.selected__Parent__Pattern			= this.table__Pattern.FindById(selected__Parent__Id);
					this.selected__Parent__Pattern_Language	= this.table__Pattern_Language.FindByPatternIdLanguageCode(selected__Parent__Id, this.mainForm.Current__Language.Code);
					this.selected__Parent__Word				= null;
					this.selected__Parent__Word_Language	= null;
					this.selected__Parent__WordOrPattern	= this.selected__Parent__Pattern.WordOrPatternRowParent;

					selected__parent__typeName			= MainForm.SubscriberName_Pattern;
					selected__parent__IdString			= this.selected__Parent__Pattern.ToString();
					selected__parent__uniqueKeyString	= this.selected__Parent__Pattern.UniqueKeyString;
					selected__parent__meaning			= this.selected__Parent__Pattern_Language.Meaning;
				}
				else
				{
					throw new Exception(this.selectedSubscriberCode_);
				}

				this.after_parent_selecting
				(
					selected__parent__typeName			,
					selected__parent__IdString			,
					selected__parent__uniqueKeyString	,
					selected__parent__meaning			
				);
			}

			#region		(ancienne version)
			/*
			if (this.dataGridView_Parent.Focused)
			{
				this.populateParentSelectedInformation(((DataRowView)(this.bindingSource__Parent.Current)).Row);

				// cleaning of the searching area.
				this.dontTriggerEvent = true;
				this.textBox__Parent__Meaning.Text = null;
				this.textBox__Parent__String.Text = null;
				this.dontTriggerEvent = false;
			}
			*/
			#endregion	(ancienne version)
		}

		#endregion	selecting of the Parent

		#region		InsertionIndex & LetterOrSymbolClusterString

		private void comboBox__InsertionIndex_SelectedIndexChanged(object sender, EventArgs e)
		{
			this.mainForm.ComboBox__InsertionIndex__SelectedIndexChanged
				(
					this.comboBox_WEM__InsertionIndex,
					Convert.ToInt16( this.textBox__SelectedParent__String.Text.Length ),
				ref this.selected__InsertionIndex
				);

			this.compute__ComputedString();
		}

		private void textBox__LetterOrSymbolCluster_TextChanged(object sender, EventArgs e)
		{
			this.mainForm.textBox__LetterOrSymbolClusterString__TextChanged
			(
				this.textBox_WEM__LetterOrSymbolClusterString, 
			ref this.selected__LetterOrSymbolCluster,
				this.letterOrSymbolList
			);

			this.compute__ComputedString();

			#region		(ancienne version)
			/*
			string letterOrSymbolClusterString = this.textBox__LetterOrSymbolClusterString.Text;

			this.ranks__letterOrSymbols.Clear();

			if
			(
				this.current__PatternByInsertion != null
				&&
				letterOrSymbolClusterString == this.current__PatternByInsertion.LetterOrSymbolClusterRow.String
			)
			{
				this.selected__LetterOrSymbolCluster = this.current__PatternByInsertion.LetterOrSymbolClusterRow;

				this.textBox_WEM__LetterOrSymbolClusterString = false;
			}
			else
			{
				DataRow[] letterOrSymbolClusterldataRows = this.table__LetterOrSymbolCluster.Select("String = '" + letterOrSymbolClusterString + "'");

				if (letterOrSymbolClusterldataRows.Length == 0)
				{
					/// doesnot exit yet => is the input string valid or not?

					#region		check if the LetterOrSymbolCluster string only contains valid Letters or Symbols  

					short rank = -1;
					for (int i = 0; i < letterOrSymbolClusterString.Length; i++)
					{
						rank++;

						char thisChar = letterOrSymbolClusterString[i];

						if (i < letterOrSymbolClusterString.Length - 1)
						{
							char nextChar = letterOrSymbolClusterString[i + 1];

							string doubleLetterOrSymbolString = new string(new char[] { thisChar, nextChar });

							BabebiDataSet.LetterOrSymbolRow doubleLetterOrSymbol
								= this.table__LetterOrSymbol.FindByString(doubleLetterOrSymbolString);

							if (doubleLetterOrSymbol != null)
							{
								this.ranks__letterOrSymbols.Add(rank, doubleLetterOrSymbol);

								rank++;

								continue;
							}
						}

						string monoLetterOrSymbolString = new string(new char[] { thisChar });

						BabebiDataSet.LetterOrSymbolRow monoLetterOrSymbol
							= this.table__LetterOrSymbol.FindByString(monoLetterOrSymbolString);

						if (monoLetterOrSymbol == null)
						{
							if (!this.textBox_WEM__LetterOrSymbolClusterString)
							{
								this.textBox_WEM__LetterOrSymbolClusterString = true;
							}

							MessageBox.Show
							(
								"The 'Letter or Symbol Cluster' string contains the invalid character: '" +
								monoLetterOrSymbolString +
								"'.",
								"Invalid character",
								MessageBoxButtons.OK,
								MessageBoxIcon.Error
							);

							return;
						}
						else
						{
							ranks__letterOrSymbols.Add(rank, monoLetterOrSymbol);
						}
					}

					this.selected__LetterOrSymbolCluster = null;    /// will be created while click the UPDATE button.

					this.textBox_WEM__LetterOrSymbolClusterString = false;

					#endregion	check if the LetterOrSymbolCluster string only contains valid Letters or Symbols  

				}
				else if (letterOrSymbolClusterldataRows.Length == 1)
				{
					this.selected__LetterOrSymbolCluster = (BabebiDataSet.LetterOrSymbolClusterRow)(letterOrSymbolClusterldataRows[0]); /// will NOT be created while click the UPDATE button.
				}
				else
				{
					throw new Exception();
				}
			}

			this.compute__ComputedString();
			*/
			#endregion	(ancienne version)
		}

		#endregion	InsertionIndex & LetterOrSymbolClusterString

		public void compute__ComputedString()
		{
			#region		trapping of any error about the sources
			if
			(
				this.noControl_WEM__Parent.HasError
				||
				this.comboBox_WEM__InsertionIndex.HasError
				||
				this.textBox_WEM__LetterOrSymbolClusterString.HasError
			)
			{
				this.textBox__ComputedString.Text = null;
				
				return;
			}

			#endregion	trapping of any error about the sources
			#region		trapping about a__a ou e__e ou o__o + > 32-chars

			bool hasError = this.mainForm.ByInsertion__Check_Erros_Before_Computing_UniqueKeyString
			(
				this.textBox__SelectedParent__String.Text, 
				this.textBox__LetterOrSymbolClusterString.Text,
				this.selected__InsertionIndex,
				this.textBox_WEM__UniqueKeyString
			);
			if (hasError)
			{
				this.textBox_WEM__UniqueKeyString.Set_with_no_error(null);	/// car on ne peut juste pas encore calculer quoique ce soit.

				return;
			}

			#endregion	trapping about a__a ou e__e ou o__o + > 32-chars
			#region		the computing itself

			string computedString 
				= PatternByInsertion
				.Compute_UniqueKeyString
				(
					this.selected__Parent__WordOrPattern,
					this.selected__InsertionIndex,
					this.textBox__LetterOrSymbolClusterString.Text
				);

			this.textBox__ComputedString.Text = computedString;

			#endregion	the computing itself
			#region		unique?

			this.mainForm.Pattern__UniqueKeyString__TextChanged(this.textBox_WEM__UniqueKeyString);

			#endregion	unique?

			#region		(ancienne version) : is it the string of an already existing Pattern?
			/*
			if (computedString != this.current__Pattern.UniqueKeyString)
			{
				DataRow[] dataRows = this.table__Pattern.Select("UniqueKeyString = '" + computedString + "'");

				if (dataRows.Length == 1)
				{
					this.textBox_WEM__UniqueKeyString = true;
					MessageBox.Show
					(
						"The 'Computed String' is different from the one of the current Pattern and " +
						"it is matching with the one of an already existing Pattern (Id = " +
						(dataRows[0]["Id"]).ToString() + ")",
						"Already existing Pattern",
						MessageBoxButtons.OK,
						MessageBoxIcon.Error
					);
				}
				else
				{ 
					this.textBox_WEM__UniqueKeyString = false;
				}
			}
			else
			{ 
				this.textBox_WEM__UniqueKeyString = false;
			}
			*/
			#endregion	(ancienne version) : is it the string of an already existing Pattern?
		}

		private void button__Update__Click(object sender, EventArgs e)
		{
			#region		checking

			if (this.comboBox_WEM__InsertionIndex.HasError)
			{
				this.comboBox_WEM__InsertionIndex.ShowMessageBox();

				return;
			}
			if (this.noControl_WEM__Parent.HasError)
			{
				this.noControl_WEM__Parent.ShowMessageBox();

				return;
			}
			if (this.textBox_WEM__LetterOrSymbolClusterString.HasError)
			{
				this.textBox_WEM__LetterOrSymbolClusterString.ShowMessageBox();

				return;
			}
			if (this.textBox_WEM__UniqueKeyString.HasError)
			{
				this.textBox_WEM__UniqueKeyString.ShowMessageBox();

				return;
			}

			#endregion	checking

			/// usefull in both Create or Update modes.
			if (this.selected__LetterOrSymbolCluster == null)
			{
				this.selected__LetterOrSymbolCluster = this.mainForm.build__LetterOrSymbolCluster(this.letterOrSymbolList);
			}

			if (this.current__PatternByInsertion == null)
			{
				#region		CREATE case

				/// where the prior extension (if any) has to be removed.
				this.mainForm.RemovePriorPatternExtensionIfAny();

				this.current__Pattern.ModeCode = MainForm.ModeCode_ByInsertion;

				this.current__PatternByInsertion
					= this.table__PatternByInsertion
					.AddPatternByInsertionRow
					(
						this.current__Pattern.Id,
						this.selected__Parent__WordOrPattern.SubscriberCode,
						this.selected__Parent__WordOrPattern.SubscriberId,
						this.selected__InsertionIndex,
						this.selected__LetterOrSymbolCluster,
						MainForm.ModeCode_ByInsertion
					);

				this.current__WordOrPattern__of__PatternByInsertion__Parent = this.selected__Parent__WordOrPattern;

				this.mainForm.button__Pattern__ByInsertion__CreateUpdate.Text = "UPDATE";

				#endregion	CREATE case
			}
			else
			{
				#region	UPDATE case

				/// about parent 
				if (this.selected__Parent__WordOrPattern != this.current__WordOrPattern__of__PatternByInsertion__Parent)
				{
					this.mainForm.Current__WordOrPattern__of__PatternByInsertion__Parent	= this.selected__Parent__WordOrPattern;
					this.mainForm.Current__Pattern__of__PatternByInsertion__Parent			= this.selected__Parent__Pattern;
					this.mainForm.Current__Pattern_Language__of__PatternByInsertion__Parent = this.selected__Parent__Pattern_Language;
					this.mainForm.Current__Word__of__PatternByInsertion__Parent				= this.selected__Parent__Word;
					this.mainForm.Current__Word_Language__of__PatternByInsertion__Parent	= this.selected__Parent__Word_Language;
				}

				/// about InsertionIndex
				if ((string)(this.comboBox__InsertionIndex.SelectedItem) != this.mainForm.textBox__Pattern__ByInsertion__InsertionIndex.Text)
				{
					this.mainForm.Current__PatternByInsertion.InsertionIndex = this.selected__InsertionIndex;
				}

				/// about LetterOrSymbolCluster
				this.mainForm.Set_LetterOrSymbolCluster_and_remove_prior_if_not_used_by_other
				(	
					this.selected__LetterOrSymbolCluster,
					this.current__PatternByInsertion
				);

				#region		(ancienne version)
				/*
				if (this.selected__LetterOrSymbolCluster != this.current__PatternByInsertion.LetterOrSymbolClusterRow)
				{
					this.buildTheLetterOrSymbolCluster_IfRequired();

					#region		where the prior LetterOrSymbolCluster is prepared to be deleted if it is not used by any other PatternByInsertion

					/// on fait la photo de l'ancien LetterOrSymbolCluster avant d'assigner le nouveau (en vue d'un eventuel deleting si pas utiliser par d'autres).
					BabebiDataSet.LetterOrSymbolClusterRow letterOrSymbolCluster__toBeDeleted;
					if(this.mainForm.Current__PatternByInsertion.LetterOrSymbolClusterRow.GetPatternByInsertionRows().Length == 1)
					{
						letterOrSymbolCluster__toBeDeleted = this.mainForm.Current__PatternByInsertion.LetterOrSymbolClusterRow;	/// toujours l'ancien parent LetterOrSymbolCluster
					}
					else
					{
						letterOrSymbolCluster__toBeDeleted = null;
					}

					#endregion	where the prior LetterOrSymbolCluster is prepared to be deleted if it is not used by any other PatternByInsertion
					
					/// on assigne enfin the nouveau LetterOrSymbolCluster
					this.mainForm.Current__PatternByInsertion.LetterOrSymbolClusterRow = this.selected__LetterOrSymbolCluster;

					#region		where the prior LetterOrSymbolCluster is deleted if it is not used by any other PatternByInsertion

					if (letterOrSymbolCluster__toBeDeleted != null)
					{
						this.table__LetterOrSymbolCluster.RemoveLetterOrSymbolClusterRow(letterOrSymbolCluster__toBeDeleted);

						/// cascade deleting on the child LetterOrSymbolClusterLetterOrSymbols.
					}

					#endregion	where the prior LetterOrSymbolCluster is deleted if it is not used by any other PatternByInsertion
				}
				*/
				#endregion	(ancienne version)

				#endregion	UPDATE case
			}

			this.mainForm.Populate__PatternByInsertion(PopulatingType.SettingFieldsOnly);
			
		//	this.mainForm.textBox__Pattern__ByInsertion__ParentSubscriberName.Text			= (string)(this.comboBox__Parent__Type.SelectedItem);
		//	this.mainForm.textBox__Pattern__ByInsertion__ParentId.Text						= this.textBox__SelectedParent__Id.Text;
		//	this.mainForm.textBox__Pattern__ByInsertion__ParentUniqueKeyString.Text			= this.textBox__SelectedParent__String.Text;
		//	this.mainForm.textBox__Pattern__ByInsertion__ParentMeaning.Text					= this.textBox__SelectedParent__Meaning.Text;
		//	this.mainForm.textBox__Pattern__ByInsertion__InsertionIndex.Text				= (string)(this.comboBox__InsertionIndex.SelectedItem);
		//	this.mainForm.textBox__Pattern__ByInsertion__LetterOrSymbolClusterString.Text	= this.textBox__LetterOrSymbolClusterString.Text;
			

			/// the target !
			Pattern.SetUniqueKeyString(this.mainForm.Current__Pattern, this.textBox__ComputedString.Text);
		//	this.mainForm.Current__Pattern.UniqueKeyString = this.textBox__ComputedString.Text;

			this.mainForm.textBox__Pattern__UniqueKeyString.Text = this.textBox__ComputedString.Text;

			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
