﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__PatternFromPattern__of__Current__Pattern__CreateUpdate : Form
	{

		private MainForm							mainForm;
		private bool								trueForCreate__falseForUpdate;

		#region		short-cuts

		private BabebiDataSet						dataSet;
		private BabebiDataSet.PatternRow			current__Pattern__PARENT;
		private BabebiDataSet.Pattern_LanguageRow	current__Pattern_Language__PARENT;

		private BabebiDataSet.WordOrPatternRow		current__WordOrPattern		
		{
			get { return	this.mainForm.Current__WordOrPattern__of__PatternFromPattern__of__Current__Pattern; }
			set {			this.mainForm.Current__WordOrPattern__of__PatternFromPattern__of__Current__Pattern = value; }
		}
		private BabebiDataSet.PatternRow			current__Pattern			
		{
			get { return	this.mainForm.Current__Pattern__of__PatternFromPattern__of__Current__Pattern; }
			set {			this.mainForm.Current__Pattern__of__PatternFromPattern__of__Current__Pattern = value; }
		}
		private BabebiDataSet.Pattern_LanguageRow	current__Pattern_Language	
		{
			get { return	this.mainForm.Current__Pattern_Language__of__PatternFromPattern__of__Current__Pattern; }
			set {			this.mainForm.Current__Pattern_Language__of__PatternFromPattern__of__Current__Pattern = value; }
		}
		private BabebiDataSet.PatternFromPatternRow	current__PatternFromPattern	
		{
			get { return	this.mainForm.Current__PatternFromPattern__of__Current__Pattern; }
			set {			this.mainForm.Current__PatternFromPattern__of__Current__Pattern = value; }
		}
		private BabebiDataSet.FromPatternRow		current__FromPattern		
		{
			get { return	this.mainForm.Current__FromPattern__of__PatternFromPattern__of__Current__Pattern; }
			set {			this.mainForm.Current__FromPattern__of__PatternFromPattern__of__Current__Pattern = value; }
		}

		#endregion	short-cuts
		#region		gui table : FromPatternLetter

		private DataSet guiDataSet;

		private DataTable guiTable__FromPatternLetter;

		private DataColumn guiColumn__FromPatternLetter__Rank;
		private DataColumn guiColumn__FromPatternLetter__LetterTypeCode;
		private DataColumn guiColumn__FromPatternLetter__LetterString;

		private BindingSource bindingSource__FromPatternLetter;

		#endregion	gui table : FromPatternLetter
		#region		variables

		private int pattern__Id = -1;

		private short selected__GuiHorizontalShift = -1; 	/// means 'undefined'

		private Dictionary<short, BabebiDataSet.SymbolRow>	ranks__symbols;	/// n'a pas besoin d'être 'Sorted'Dictionary car construit dans le bon ordre. 
		private List<string>								pattern_Remaining_SubStrings;

		/// doit être 'sorted' car construit à partir des rows du DataSet qui pourraient être mal triées.
		private SortedDictionary<short, Letter> ranks__letters;

		#endregion	variables
		#region		error management

		private TextBox_WEM textBox_WEM__Id						;
		private TextBox_WEM textBox_WEM__UniqueKeyString		;
		private TextBox_WEM textBox_WEM__Meaning				;
		private ComboBox_WEM comboBox_WEM__GuiHorizontalShift	;

		#endregion	error management

		#region		ctors

		public Form__PatternFromPattern__of__Current__Pattern__CreateUpdate(MainForm mainForm, bool trueForCreate__falseForUpdate) : this()
		{
			this.mainForm						= mainForm;
			this.trueForCreate__falseForUpdate	= trueForCreate__falseForUpdate;

			#region		short-cuts

			this.dataSet = this.mainForm.DataSet;

			this.current__Pattern__PARENT			= this.mainForm.Current__Pattern;
			this.current__Pattern_Language__PARENT	= this.mainForm.Current__Pattern_Language;

			#endregion	short-cuts
			#region		guiTable__FromPatternLetter

			this.guiDataSet = new DataSet("GuiDataSet");

			this.guiTable__FromPatternLetter = this.guiDataSet.Tables.Add("FromPatternLetter");

			this.guiColumn__FromPatternLetter__Rank				= this.guiTable__FromPatternLetter.Columns.Add("Rank", typeof(short));
			this.guiColumn__FromPatternLetter__LetterTypeCode	= this.guiTable__FromPatternLetter.Columns.Add("LetterTypeCode", typeof(string));
			this.guiColumn__FromPatternLetter__LetterString		= this.guiTable__FromPatternLetter.Columns.Add("LetterString", typeof(string));

			this.guiTable__FromPatternLetter.PrimaryKey = new DataColumn[] { this.guiColumn__FromPatternLetter__Rank };

			this.bindingSource__FromPatternLetter = new BindingSource(this.guiDataSet, this.guiTable__FromPatternLetter.TableName);

			this.dataGridView__FromPatternLetter.DataSource = this.bindingSource__FromPatternLetter;

			this.bindingSource__FromPatternLetter.CurrentChanged += bindingSource__FromPatternLetter__CurrentChanged;

			#endregion	guiTable__FromPatternLetter	
			#region		(base)

			this.mainForm.Ctor__CreateUpdate__Pattern
			(
				this,														
				this.button__CreateUpdate,									
				this.button__Clone,											
				MainForm.ModeName_FromPattern,								
				this.label__Pattern__Id,									
				this.label__Pattern__ComputedString,						
				this.label__Pattern_Language__Meaning,						
				this.textBox__Pattern__Id,									
				this.textBox__Pattern__ComputedString,						
				this.textBox__Pattern_Language__Meaning,					
				false,														
			out TextBox_WEM	textBox_WEM__Pattern__Id_				,					
			out TextBox_WEM	textBox_WEM__Pattern__UniqueKeyString_	,		
			out TextBox_WEM	textBox_WEM__Pattern_Language__Meaning_	,			
				this.trueForCreate__falseForUpdate,							
			ref pattern__Id,												
				this.current__Pattern,										
				this.current__Pattern_Language
			);
			this.textBox_WEM__Id				= textBox_WEM__Pattern__Id_					;
			this.textBox_WEM__UniqueKeyString	= textBox_WEM__Pattern__UniqueKeyString_	;
			this.textBox_WEM__Meaning			= textBox_WEM__Pattern_Language__Meaning_	;
	
			#endregion	(base)
			#region		(mode)

			Pattern.Analyse__Pattern__UniqueKeyString
			(
				this.current__Pattern__PARENT,
			out List<BabebiDataSet.LetterOrSymbolRow>		letterOrSymbols_,			/// not used in this Form/case.
			out Dictionary<short, BabebiDataSet.SymbolRow>	ranks__symbols_,
			out List<string>								pattern_Remaining_SubStrings_	
			);
			this.ranks__symbols					= ranks__symbols_;
			this.pattern_Remaining_SubStrings	= pattern_Remaining_SubStrings_;

			this.comboBox_WEM__GuiHorizontalShift
				= new ComboBox_WEM
				(	
					this.label__GuiHorizontalShift,
					this.comboBox__GuiHorizontalShift,
					( this.trueForCreate__falseForUpdate ? null : this.current__PatternFromPattern.FromPatternRowParent.GuiHorizontalShift.ToString() )
				);

			if (this.trueForCreate__falseForUpdate)
			{
				#region		GuiHorizontalShift

				this.selected__GuiHorizontalShift				= 0;	/// la valeur par défaut
				this.comboBox__GuiHorizontalShift.SelectedIndex = 0;    /// c'est bien Select[INDEX] qui pointe sur "0" d'ailleurs.

				#endregion	GuiHorizontalShift

				if (!this.try_to_find_the_next_letter_combination_for_the_new_PatternFromPattern())
				{
					this.build_full_ranks__letters_from_PARENT_Pattern__UniqueKeyString();
				}
			}
			else
			{
				#region		GuiHorizontalShift

				this.selected__GuiHorizontalShift				= this.current__FromPattern.GuiHorizontalShift;
				this.comboBox__GuiHorizontalShift.SelectedItem	= this.selected__GuiHorizontalShift.ToString();

				#endregion	GuiHorizontalShift

				/// initialize ranks__letters from current FromPatternLetters
				this.ranks__letters = FromPattern_.Build__ranks__letters__from__FromPatternLetters(this.current__FromPattern); 
			}

			MainForm.FromPatternLetter__fill__dataGridView(this.ranks__letters, this.guiTable__FromPatternLetter);

			/// en effet il y a une tentative de calcul sur la 1ère row 
			/// grâce au binding mais plus sur les autres rows.
			if (this.ranks__letters.Count > 1)
			{ 
				this.compute__ComputedString();	
			}

			#endregion	(mode)
		}

		public Form__PatternFromPattern__of__Current__Pattern__CreateUpdate()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private bool try_to_find_the_next_letter_combination_for_the_new_PatternFromPattern()
		{ 
			this.ranks__letters = new SortedDictionary<short, Letter>();

			#region		try to find the next letter combination for the new PatternFromPattern

			#region		analyse the existing children.

			List<string> letterCombinationStringList = new List<string>();

			/// on examine les existing children.
			BabebiDataSet.FromPatternRow[] fromPatterns 
				= this.current__Pattern__PARENT.GetFromPatternRows();

			bool firstDone = false;
			Dictionary<short, string> ranks__lettreTypeCodes__COMMON = null;
			foreach (BabebiDataSet.FromPatternRow fromPattern in fromPatterns)
			{
				if (fromPattern.SubscriberCode != MainForm.SubscriberCode_Pattern)
				{ 
					continue;
				}

				if (!firstDone)
				{
					ranks__lettreTypeCodes__COMMON = new Dictionary<short, string>();
				}

				string letterCombinationString = "";

				BabebiDataSet.FromPatternLetterRow[] fromPatternLetters 
					= fromPattern.GetFromPatternLetterRows();

				foreach (BabebiDataSet.FromPatternLetterRow fromPatternLetter in fromPatternLetters)
				{
					if (!firstDone)
					{
						ranks__lettreTypeCodes__COMMON.Add
						(
							fromPatternLetter.Rank, 
							fromPatternLetter.LetterRowParent.TypeCode
						);
					}
					else
					{
						if 
						(
							ranks__lettreTypeCodes__COMMON != null 
							&& 
							! ranks__lettreTypeCodes__COMMON.Keys.Contains(fromPatternLetter.Rank)
						)
						{ 
							ranks__lettreTypeCodes__COMMON.Clear();

							ranks__lettreTypeCodes__COMMON = null;

							break;
						}
					}

					letterCombinationString += (letterCombinationString == "" ? "" : "#") + fromPatternLetter.LetterString;
				}

				letterCombinationStringList.Add(letterCombinationString);

				if (!firstDone)
				{
					firstDone = true;
				}
			}

			#endregion	analyse the existing children.

			if (ranks__lettreTypeCodes__COMMON == null)
			{
				letterCombinationStringList.Clear();
				letterCombinationStringList = null;

				return false;
			}
			else
			{
				#region		letterTypeCodes

				string[] letterTypeCodes = ranks__lettreTypeCodes__COMMON.Values.ToArray();

				#endregion	letterTypeCodes

				RussianLetterIndexer externalLetterIndexer
					= new RussianLetterIndexer
					(
						0,
						letterTypeCodes,
						this.mainForm.VowelStrings,
						this.mainForm.ConsonantStrings
					);

				string theLetterCombinationString = null;
				do
				{
					string candidateLetterCombinationString = externalLetterIndexer.GetString_of_sharp_separated_letters();

					if (!letterCombinationStringList.Contains(candidateLetterCombinationString))
					{
						theLetterCombinationString = candidateLetterCombinationString;

						break;
					}

				}
				while (externalLetterIndexer.Next());

				if (theLetterCombinationString == null)
				{
					this.textBox_WEM__UniqueKeyString.SetError("All the possible children have already been created.", "Full !");

					this.textBox_WEM__UniqueKeyString.ShowMessageBox();

					return false;
				}

				string[] theLetterCombination = theLetterCombinationString.Split('#');

				int letterIndex = -1;
				foreach (KeyValuePair<short, BabebiDataSet.SymbolRow> keyValuePair in this.ranks__symbols)
				{
					short rank = keyValuePair.Key;
					BabebiDataSet.SymbolRow symbol = keyValuePair.Value;

					if (!ranks__lettreTypeCodes__COMMON.ContainsKey(rank))
					{
						continue;
					}

					letterIndex++;

					Letter letter = new Letter(symbol.TypeCode, theLetterCombination[letterIndex]);

					this.ranks__letters.Add(rank, letter);
				}

				return true;
			}

			#endregion	try to find the next letter combination for the new PatternFromPattern
		}

		private void build_full_ranks__letters_from_PARENT_Pattern__UniqueKeyString()
		{ 
			foreach(KeyValuePair<short, BabebiDataSet.SymbolRow> rank__symbol in this.ranks__symbols)
			{
				short					rank	= rank__symbol.Key;
				BabebiDataSet.SymbolRow symbol	= rank__symbol.Value;

				Letter letter;
				if (symbol.TypeCode == MainForm.TypeCode_Vowel)
				{
					letter = new Letter(MainForm.TypeCode_Vowel, this.mainForm.FirstVowel.String);
				}
				else if (symbol.TypeCode == MainForm.TypeCode_Consonant)
				{
					letter = new Letter(MainForm.TypeCode_Consonant, this.mainForm.FirstConsonant.String);
				}
				else
				{
					throw new Exception(symbol.TypeCode);
				}

				this.ranks__letters.Add(rank, letter);
			}
		}

		#region		(base) events
 
		private void button__Clone__Click(object sender, EventArgs e)
		{
			this.mainForm.Clone__Pattern
			(
				null,
				this.textBox__Pattern_Language__Meaning,
				true,
				this.current__Pattern,					
				this.current__Pattern_Language
			);
		}

		#region		Pattern__Id

		private void textBox__Pattern__Id__KeyPress(object sender, KeyPressEventArgs e)
		{
			MainForm.Integer__KeyPress(e);
		}
		private void textBox__Pattern__Id__TextChanged(object sender, EventArgs e)
		{
			if (this.textBox_WEM__Id != null)
			{
				this.mainForm.Pattern__Id__TextChanged(this.textBox_WEM__Id, ref this.pattern__Id);
			}
		}
		private void textBox__Pattern__Id__Leave(object sender, EventArgs e)
		{
			if (this.textBox_WEM__Id.HasError)
			{
				this.textBox_WEM__Id.ShowMessageBox();
			}
		}

		#endregion	Pattern__Id
		#region		Pattern_Language__Meaning

		private void textBox__Pattern_Language__Meaning__TextChanged(object sender, EventArgs e)
		{
			if (this.textBox_WEM__Meaning != null)
			{
				this.mainForm.Pattern__Meaning__TextChanged(this.textBox_WEM__Meaning);
			}
		}

		private void textBox__Pattern_Language__Meaning__Leave(object sender, EventArgs e)
		{
			if (string.IsNullOrEmpty(this.textBox__Pattern_Language__Meaning.Text))
			{ 
				return;
			}

			if (this.textBox_WEM__Meaning.HasError)
			{
				this.textBox_WEM__Meaning.ShowMessageBox();
			}
		}

		#endregion	Pattern_Language__Meaning
		#region		ComputedString

		private void textBox__Pattern__ComputedString__TextChanged(object sender, EventArgs e)
		{
			if (this.textBox_WEM__UniqueKeyString != null)
			{
				this.mainForm.Pattern__UniqueKeyString__TextChanged(this.textBox_WEM__UniqueKeyString);
			}
		}

		#endregion	ComputedString

		#endregion	(base) events
		#region		(mode) events

		#region		events about FromPatternLetter

		private void bindingSource__FromPatternLetter__CurrentChanged(object sender, EventArgs e)
		{

			this.mainForm.FromPatternLetter__bindingSource__CurrentChanged
			(
				this.bindingSource__FromPatternLetter,
				this.guiColumn__FromPatternLetter__Rank,				
				this.guiColumn__FromPatternLetter__LetterTypeCode,
				this.guiColumn__FromPatternLetter__LetterString,	
				this.textBox__FocusedRank,
				this.textBox__FocusedLetter,
				this.comboBox__SelectedLetter
			);
		}

		private void comboBox__SelectedLetter__SelectedIndexChanged(object sender, EventArgs e)
		{
			MainForm.FromPatternLetter__comboBox__SelectedLetter__SelectedIndexChanged
			(
				this.textBox__FocusedRank,
				this.textBox__FocusedLetter,
				this.comboBox__SelectedLetter,
				this.ranks__letters,
				this.guiTable__FromPatternLetter,
				this.guiColumn__FromPatternLetter__LetterString
			);

			this.compute__ComputedString();
		}
		
		private void button__FromPatternLetter__Delete__Click(object sender, EventArgs e)
		{
			MainForm.Button__PatternFromPattern__FromPatternLetter__Delete__Click
			(
				this.textBox__FocusedRank,
				this.textBox__FocusedLetter,
				this.comboBox__SelectedLetter,
				this.ranks__letters,
				this.guiTable__FromPatternLetter
			);
		}

		private void button__FromPatternLetter__All__Click(object sender, EventArgs e)
		{
			if (this.trueForCreate__falseForUpdate)
			{
				this.try_to_find_the_next_letter_combination_for_the_new_PatternFromPattern();
			}
			else
			{ 
				MainForm.Restore__ranks__letters__from__FromPatternLetters(this.current__FromPattern, this.ranks__letters);
			}

			MainForm.FromPatternLetter__fill__dataGridView(this.ranks__letters, this.guiTable__FromPatternLetter);

			this.compute__ComputedString();
		}

		#endregion	events about FromPatternLetter

		private void comboBox__GuiHorizontalShift_SelectedIndexChanged(object sender, EventArgs e)
		{
			if (this.comboBox_WEM__GuiHorizontalShift != null)
			{
				MainForm.FromPattern__comboBox__GuiHorizontalShift__SelectedIndexChanged
				(
					this.comboBox_WEM__GuiHorizontalShift,
				ref this.selected__GuiHorizontalShift
				);
			}
		}

		#endregion	(mode) events
		#region		ComputedString

		private void compute__ComputedString()
		{
			string computedString 
				= PatternFromPattern
				.Compute_UniqueKeyString
				(
					this.pattern_Remaining_SubStrings,
					this.ranks__symbols,
					this.ranks__letters
				);

			this.textBox__Pattern__ComputedString.Text = computedString;

			this.mainForm.Pattern__UniqueKeyString__TextChanged(this.textBox_WEM__UniqueKeyString);
		}

		#endregion	ComputedString

		private void button__CreateUpdate__Click(object sender, EventArgs e)
		{
			#region		checking

			if (this.textBox_WEM__Id.HasError)
			{
				this.textBox_WEM__Id.ShowMessageBox();

				return;
			}
			if (this.textBox_WEM__UniqueKeyString.HasError)
			{
				this.textBox_WEM__UniqueKeyString.ShowMessageBox();

				return;
			}
			if (this.textBox_WEM__Meaning.HasError)
			{
				this.textBox_WEM__Meaning.ShowMessageBox();

				return;
			}

			#endregion	checking

			if (this.trueForCreate__falseForUpdate)
			{
				#region		(base)

				this.mainForm.Create__Pattern
				(
					this.pattern__Id,
					this.textBox__Pattern__ComputedString.Text,
					this.textBox__Pattern_Language__Meaning.Text,
				out BabebiDataSet.WordOrPatternRow	current__WordOrPattern_,
				out BabebiDataSet.PatternRow			current__Pattern_,
				out BabebiDataSet.Pattern_LanguageRow	current__Pattern_Language_,
					MainForm.ModeCode_FromPattern
				);

				this.current__WordOrPattern		= current__WordOrPattern_;
				this.current__Pattern			= current__Pattern_;
				this.current__Pattern_Language	= current__Pattern_Language_;

				#endregion	(base)
				#region		(mode)

				this.mainForm.PatternFromPattern
				(
					this.pattern__Id,
					this.current__Pattern__PARENT,
					this.selected__GuiHorizontalShift,
					this.ranks__letters,
				out BabebiDataSet.FromPatternRow		current__FromPattern_,
				out BabebiDataSet.PatternFromPatternRow	current__PatternFromPattern_
				);
				this.current__FromPattern			= current__FromPattern_;
				this.current__PatternFromPattern	= current__PatternFromPattern_;

				#region		(old version)
				/*
				/// FromPattern
				this.current__FromPattern
					= this.dataSet.FromPattern
					.AddFromPatternRow
					(
						MainForm.SubscriberCode_Pattern,
						this.pattern__Id,
						this.current__Pattern,
						this.selected__GuiHorizontalShift
					);
				
				/// PatternFromPattern
				this.current__PatternFromPattern
					= this.dataSet.PatternFromPattern
					.AddPatternFromPatternRow
					(
						this.pattern__Id,
						MainForm.ModeCode_FromPattern,
						MainForm.SubscriberCode_Pattern
					);
				
				/// FromPatternLetters
				foreach(KeyValuePair<short, Letter> rank__letter in this.ranks__letters)
				{
					short	rank	= rank__letter.Key;
					Letter	letter	= rank__letter.Value;

					this.dataSet.FromPatternLetter
						.AddFromPatternLetterRow
						(
							MainForm.SubscriberCode_Pattern,
							this.pattern__Id,
							rank,
							letter.TypeCode,
							letter.String
						);
				}
				*/
				#endregion	(old version)

				#endregion	(mode)
			}
			else
			{
				#region		à cause de l'Update du Pattern Id, if any	(BEFORE)

				bool patternIdHasChanged = false;
				if (this.pattern__Id != this.current__FromPattern.SubscriberId)
				{ 
					patternIdHasChanged = true;

					this.current__FromPattern.BeginEdit();
					this.current__WordOrPattern.BeginEdit();
					this.current__Pattern.BeginEdit();
					this.current__PatternFromPattern.BeginEdit();

					this.current__FromPattern.SubscriberId = this.pattern__Id;
				}

				#endregion	à cause de l'Update du Pattern Id, if any	(BEFORE)
				#region		(base)

				this.mainForm.Update__Pattern
				(
					this.pattern__Id,
					this.textBox__Pattern__ComputedString.Text,
					this.textBox__Pattern_Language__Meaning.Text,
					this.current__WordOrPattern,
					this.current__Pattern,
					this.current__Pattern_Language
				);

				#endregion	(base)
				#region		à cause de l'Update du Pattern Id, if any	(AFTER)

				if (patternIdHasChanged)
				{ 
					this.current__FromPattern.EndEdit();
					this.current__WordOrPattern.EndEdit();
					this.current__Pattern.EndEdit();
					this.current__PatternFromPattern.EndEdit();
				}

				#endregion	à cause de l'Update du Pattern Id, if any	(AFTER)
				#region		(mode)

				/// about GuiHorizontalShift
				if (this.selected__GuiHorizontalShift != this.current__FromPattern.GuiHorizontalShift)
				{
					this.current__FromPattern.GuiHorizontalShift = this.selected__GuiHorizontalShift;
				}

				#region		fromPatternLetters

				/// dans le cas de PatternFromPattern__of__the__current__Pattern, c'est biblique car :
				/// - on a forcément le même Pattern parent, et donc les mêmes symboles aux mêmes endroits.
				/// - tous les symboles du Pattern doivent être remplacés par des lettres.
				/// 
				/// => Une fois crées les FromPatternLetters ne changent pas en nombre et en ranks : seules 
				///    les lettres peuvent changer au cours d'un Update.
				///     

				BabebiDataSet.FromPatternLetterRow[] fromPatternLetters
					= this.current__FromPattern.GetFromPatternLetterRows();

				foreach (BabebiDataSet.FromPatternLetterRow fromPatternLetter in fromPatternLetters)
				{
					if ( ! this.ranks__letters.ContainsKey(fromPatternLetter.Rank))
					{ 
						this.dataSet.FromPatternLetter.RemoveFromPatternLetterRow(fromPatternLetter);
					}
				}

				foreach (KeyValuePair<short, Letter> rank_letter in this.ranks__letters)
				{
					short	rank	= rank_letter.Key;
					Letter	letter	= rank_letter.Value;

					BabebiDataSet.FromPatternLetterRow fromPatternLetter
						= this.dataSet.FromPatternLetter
						.FindByFromPatternSubscriberCodeFromPatternSubscriberIdRank
						(
							this.current__FromPattern.SubscriberCode,
							this.current__FromPattern.SubscriberId,
							rank
						);

					if (fromPatternLetter == null)
					{
						this.dataSet.FromPatternLetter
							.AddFromPatternLetterRow
							(
								this.current__FromPattern.SubscriberCode,
								this.current__FromPattern.SubscriberId,
								rank,
								letter.TypeCode,
								letter.String
							);
					}
					else
					{
						if (fromPatternLetter.LetterTypeCode != letter.TypeCode)
						{ 
							fromPatternLetter.LetterTypeCode = letter.TypeCode;
						}

						if (fromPatternLetter.LetterString != letter.String)
						{ 
							fromPatternLetter.LetterString = letter.String;
						}
					}
				}

				#endregion	fromPatternLetters

				#endregion	(mode)
			}

			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
