﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__Pattern__CreateUpdate : Form
	{
		private MainForm	mainForm;
		private bool		trueForCreate__falseForUpdate;

		#region		variables

		private int pattern__Id = -1;

		private BabebiDataSet.LanguageRow	currentLanguage
		{
			get
			{
				return this.mainForm.Current__Language;
			}
		}
		private string						currentLanguageCode
		{
			get
			{
				return this.mainForm.Current__Language.Code;
			}
		}

		#endregion	variables
		#region		error management

		private TextBox_WEM textBox_WEM__Id					;
		private TextBox_WEM textBox_WEM__UniqueKeyString	;
		private TextBox_WEM textBox_WEM__Meaning			;

		#endregion	error variables
		#region		ctors

		public Form__Pattern__CreateUpdate(MainForm mainForm, bool trueForCreate__falseForUpdate) : this()
		{
			this.mainForm = mainForm;
			this.trueForCreate__falseForUpdate = trueForCreate__falseForUpdate;

			this.mainForm.Ctor__CreateUpdate__Pattern
			(
				this,
				this.button__CreateUpdate,
				this.button__Clone,
				MainForm.ModeName_NotDefined,
				this.label__Pattern__Id,
				this.label__Pattern__UniqueKeyString,
				this.label__Pattern_Language__Meaning,
				this.textBox__Pattern__Id,
				this.textBox__Pattern__UniqueKeyString,
				this.textBox__Pattern_Language__Meaning,
				false,
			out	TextBox_WEM textBox_WEM__Id_				,
			out	TextBox_WEM textBox_WEM__UniqueKeyString_	,
			out	TextBox_WEM textBox_WEM__Meaning_			,
				this.trueForCreate__falseForUpdate,
			ref pattern__Id,
				this.mainForm.Current__Pattern,					
				this.mainForm.Current__Pattern_Language
			);
			this.textBox_WEM__Id				= textBox_WEM__Id_				;
			this.textBox_WEM__UniqueKeyString	= textBox_WEM__UniqueKeyString_	;
			this.textBox_WEM__Meaning			= textBox_WEM__Meaning_			;
		}

		public Form__Pattern__CreateUpdate()
		{
			InitializeComponent();
		}

		#endregion	ctors
		#region		control events

		public void button__Clone__Click(object sender, EventArgs e)
		{
			this.mainForm.Clone__Pattern
			(
				this.textBox__Pattern__UniqueKeyString,
				this.textBox__Pattern_Language__Meaning,
				false,
				this.mainForm.Current__Pattern,					
				this.mainForm.Current__Pattern_Language
			);
		}

		#region		Pattern__Id

		private void textBox__Pattern__Id__KeyPress(object sender, KeyPressEventArgs e)
		{
			MainForm.Integer__KeyPress(e);
		}
		private void textBox__Pattern__Id__TextChanged(object sender, EventArgs e)
		{
			this.mainForm.Pattern__Id__TextChanged(this.textBox_WEM__Id, ref this.pattern__Id);
		}
		private void textBox__Pattern__Id__Leave(object sender, EventArgs e)
		{
			if (this.textBox_WEM__Id.HasError)
			{
				this.textBox_WEM__Id.ShowMessageBox();
			}
		}

		#endregion	Pattern__Id
		#region		Pattern__String

		private void textBox__Pattern__String__TextChanged(object sender, EventArgs e)
		{
			this.mainForm.Pattern__UniqueKeyString__TextChanged(this.textBox_WEM__UniqueKeyString);
		}
		private void textBox__Pattern__String__Leave(object sender, EventArgs e)
		{
			if (this.textBox_WEM__UniqueKeyString.HasError)
			{
				this.textBox_WEM__UniqueKeyString.ShowMessageBox();
			}
		}

		#endregion	Pattern__String
		#region		Pattern__Meaning

		private void textBox__Pattern_Language__Meaning__TextChanged(object sender, EventArgs e)
		{
			this.mainForm.Pattern__Meaning__TextChanged(this.textBox_WEM__Meaning);
		}

		private void textBox__Pattern_Language__Meaning__Leave(object sender, EventArgs e)
		{
			if (this.textBox_WEM__Meaning.HasError)
			{
				this.textBox_WEM__Meaning.ShowMessageBox();
			}
		}

		#endregion	Pattern__Meaning

		#endregion	control events

		private void button__CreateUpdate__Click(object sender, EventArgs e)
		{
			#region		checking

			if (this.textBox_WEM__Id.HasError)
			{
				this.textBox_WEM__Id.ShowMessageBox();

				return;
			}
			if (this.textBox_WEM__UniqueKeyString.HasError)
			{
				this.textBox_WEM__UniqueKeyString.ShowMessageBox();

				return;
			}
			if (this.textBox_WEM__Meaning.HasError)
			{
				this.textBox_WEM__Meaning.ShowMessageBox();

				return;
			}

			#endregion	checking

			if (this.trueForCreate__falseForUpdate)
			{
				this.mainForm.Create__Pattern
				(
					this.pattern__Id,
					this.textBox__Pattern__UniqueKeyString.Text,
					this.textBox__Pattern_Language__Meaning.Text,
				out BabebiDataSet.WordOrPatternRow current__WordOrPattern__of__Pattern,
				out BabebiDataSet.PatternRow current__Pattern,
				out BabebiDataSet.Pattern_LanguageRow current__Pattern_Language
				);

				this.mainForm.Current__WordOrPattern__of__Pattern	= current__WordOrPattern__of__Pattern;
				this.mainForm.Current__Pattern						= current__Pattern;
				this.mainForm.Current__Pattern_Language				= current__Pattern_Language;
			}
			else
			{ 
				this.mainForm.Update__Pattern
				(
					this.pattern__Id,
					this.textBox__Pattern__UniqueKeyString.Text,
					this.textBox__Pattern_Language__Meaning.Text,
					this.mainForm.Current__WordOrPattern__of__Pattern,
					this.mainForm.Current__Pattern,
					this.mainForm.Current__Pattern_Language
				);
			}

			#region		is it 'Ex Nihilo'?

			BabebiDataSet.SymbolRow symbol__Vowel		= null;
			BabebiDataSet.SymbolRow symbol__Consonant	= null;
			foreach (BabebiDataSet.SymbolRow symbol in this.mainForm.DataSet.Symbol.Rows)
			{
				if (symbol.TypeCode == MainForm.TypeCode_Vowel)
				{
					symbol__Vowel = symbol;
				}
				else if (symbol.TypeCode == MainForm.TypeCode_Consonant)
				{
					symbol__Consonant = symbol;
				}
				else
				{
					throw new Exception(symbol.TypeCode);
				}
			}
			char symbolChar__Vowel		= symbol__Vowel		.String[0];
			char symbolChar__Consonant	= symbol__Consonant	.String[0];

			///if  only made of symbol-Vowel and symbol-Consonant, then ExNihilo Extension
			bool isExNihilo = true;
			foreach (char c in this.mainForm.Current__Pattern.UniqueKeyString)
			{
				if (c != symbolChar__Vowel && c != symbolChar__Consonant)
				{
					isExNihilo = false;
					break;
				}
			}

			if (isExNihilo)
			{
				this.mainForm.Current__Pattern.ModeCode = MainForm.ModeCode_ExNihilo;

				/// find next Id.
				int symbolClusterId = 0;
				foreach 
				(
					BabebiDataSet.SymbolClusterRow symbolCluster_
					in 
					this.mainForm.DataSet.SymbolCluster.Rows
				)
				{
					if (symbolCluster_.Id > symbolClusterId)
					{	
						symbolClusterId = symbolCluster_.Id;
					}
				}
				symbolClusterId++;

				/// on n'a pas besoin de Current__SymbolCluster__of__PatternExNihilo
				/// car on ne fera plus rien concernant cette row à part peut-être la 
				/// détruire.
				BabebiDataSet.SymbolClusterRow symbolCluster 
					= this.mainForm.DataSet.SymbolCluster
					.AddSymbolClusterRow
					(
						symbolClusterId, 
						this.mainForm.Current__Pattern.UniqueKeyString
					);
				
				short rank = 0;		/// 1-based.
				foreach (char c in this.mainForm.Current__Pattern.UniqueKeyString)
				{
					rank++;

					string s = new string(new char[] { c });

					if (s == symbol__Vowel.String)
					{
						this.mainForm.DataSet.SymbolClusterSymbol
						.AddSymbolClusterSymbolRow
						(
							symbolCluster, 
							rank,
							symbol__Vowel
						);					
					}
					else if (s == symbol__Consonant.String)
					{ 
						this.mainForm.DataSet.SymbolClusterSymbol
						.AddSymbolClusterSymbolRow
						(
							symbolCluster, 
							rank,
							symbol__Consonant
						);					
					}
					else
					{
						throw new Exception(s);
					}
				}

				/// aucun besoin d'une Current__PatternExNihilo car on n'y accède jamais.
				this.mainForm.DataSet.PatternExNihilo
					.AddPatternExNihiloRow
					(
						this.pattern__Id,
						symbolCluster,
						MainForm.ModeCode_ExNihilo
					);
			}

			#endregion	is it 'Ex Nihilo'?

			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
