﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__Pattern__Find : Form
	{
		private MainForm mainForm;

		#region		shortcuts

		private BabebiDataSet.PatternDataTable			table__Pattern;
		private BabebiDataSet.Pattern_LanguageDataTable	table__Pattern_Language;

		#endregion	shortcuts
		#region	guiTable

		private DataSet			guiDataSet;

		private DataTable		guiTable__Pattern;
		private DataColumn		guiColumn__Pattern__Id;
		private DataColumn		guiColumn__Pattern__String;
		private DataColumn		guiColumn__Pattern__Meaning;
		private BindingSource	bindingSource__Pattern;

		#endregion	guiTable

		private BabebiDataSet.PatternRow			selected__Pattern			= null;
		private BabebiDataSet.Pattern_LanguageRow	selected__Pattern_Language	= null;

		#region		ctors

		public Form__Pattern__Find(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;

			this.table__Pattern				= this.mainForm.DataSet.Pattern;
			this.table__Pattern_Language	= this.mainForm.DataSet.Pattern_Language;

			this.guiDataSet = new DataSet("GuiDataSet");

			#region		guiTable__Pattern

			this.guiTable__Pattern = this.guiDataSet.Tables.Add("Pattern");

			this.guiColumn__Pattern__Id			= this.guiTable__Pattern.Columns.Add("Id"		, typeof(int));
			this.guiColumn__Pattern__String		= this.guiTable__Pattern.Columns.Add("String"	, typeof(string));
			this.guiColumn__Pattern__Meaning	= this.guiTable__Pattern.Columns.Add("Meaning"	, typeof(string));

			this.guiTable__Pattern.PrimaryKey = new DataColumn[] { this.guiColumn__Pattern__Id };

			this.bindingSource__Pattern = new BindingSource(this.guiDataSet, this.guiTable__Pattern.TableName);

			this.dataGridView__Pattern.DataSource = this.bindingSource__Pattern;

			this.bindingSource__Pattern.CurrentChanged += bindingSource__Pattern_CurrentChanged;

			#endregion	guiTable__Pattern
		}

		public Form__Pattern__Find()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void button__OK__Click(object sender, EventArgs e)
		{
			if (this.selected__Pattern == null)
			{
				MessageBox.Show("A Pattern must be selected.","Missing value", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			this.mainForm.Current__Pattern			= this.selected__Pattern;
			this.mainForm.Current__Pattern_Language	= this.selected__Pattern_Language;

			this.DialogResult = DialogResult.OK;

			this.Close();
		}

		private void textBox__Pattern__UniqueKeyString__TextChanged(object sender, EventArgs e)
		{
			bool? patternSelecting
				= this.mainForm.textBox__Pattern__UniqueKeyString__TextChanged
				(
					this.textBox__Pattern__UniqueKeyString,
					this.textBox__Pattern__Meaning,
					this.guiTable__Pattern,
					null,
				out BabebiDataSet.PatternRow			selected__Pattern_, 
				out BabebiDataSet.Pattern_LanguageRow	selected__Pattern_Language_
				);

			if (!patternSelecting.HasValue)
			{ 
				this.preventCharEntry = false;

				return;
			}

			this.preventCharEntry = patternSelecting.Value;

			this.selected__Pattern								= selected__Pattern_;
			this.selected__Pattern_Language						= selected__Pattern_Language_;

			this.after_Pattern_selecting();

			#region		(ancienne version)
			/*
			if (this.doNotSearch)
			{
				return;
			}

			string pattern__UniqueKeyString = this.textBox__Pattern__UniqueKeyString.Text;

			this.guiTable__Pattern.Clear();

			if (pattern__UniqueKeyString.Length < 2)
			{
				///
				this.preventCharEntry = false;

				this.selected__Pattern			= null;
				this.selected__Pattern_Language	= null;

				this.doNotSearch = true;
				this.textBox__Pattern__Meaning.Text = null;
				this.doNotSearch = false;

				return;
			}
			else
			{
				DataRow[] selectedPatterns = this.table__Pattern.Select("UniqueKeyString LIKE '*" + pattern__UniqueKeyString + "*'");

				if (selectedPatterns.Length == 1)
				{
					///
					this.preventCharEntry = true;

					this.selected__Pattern = (BabebiDataSet.PatternRow)(selectedPatterns[0]);

					this.selected__Pattern_Language	
						= this.table__Pattern_Language
						.FindByPatternIdLanguageCode
						(
							this.selected__Pattern.Id,
							this.mainForm.Current__Language.Code
						);

					this.doNotSearch = true;
					this.textBox__Pattern__UniqueKeyString.Text		= this.selected__Pattern.UniqueKeyString;
					this.textBox__Pattern__Meaning.Text	= this.selected__Pattern_Language.Meaning;
					this.doNotSearch = false;
				}
				else
				{
					///
					this.preventCharEntry = false;

					DataRow matchingGuiDataRow = null;

					foreach (BabebiDataSet.PatternRow selectedPattern in selectedPatterns)
					{
						BabebiDataSet.Pattern_LanguageRow selectedPattern_Language
							= this.table__Pattern_Language
							.FindByPatternIdLanguageCode
							(
								selectedPattern.Id,
								this.mainForm.Current__Language.Code
							);

						DataRow guiDataRow 
							= this.guiTable__Pattern
							.Rows
							.Add
							(
								selectedPattern.Id,
								selectedPattern.UniqueKeyString,
								selectedPattern_Language.Meaning
							);

						if (matchingGuiDataRow == null && selectedPattern.UniqueKeyString == pattern__UniqueKeyString)
						{
							matchingGuiDataRow = guiDataRow;
						}
					}

					if (matchingGuiDataRow != null)
					{
						///
						this.preventCharEntry = true;

						this.populatePattern(matchingGuiDataRow);
					}
				}
			}
			*/
			#endregion	(ancienne version)
		}

		private void textBox__Pattern__Meaning__TextChanged(object sender, EventArgs e)
		{
			bool? patternSelecting
				= this.mainForm.textBox__Pattern__Meaning__TextChanged
				(
					this.textBox__Pattern__UniqueKeyString,
					this.textBox__Pattern__Meaning,
					this.guiTable__Pattern,
				out BabebiDataSet.PatternRow			selected__Pattern_, 
				out BabebiDataSet.Pattern_LanguageRow	selected__Pattern_Language_
				);

			if (!patternSelecting.HasValue)
			{ 
				return;
			}

			this.selected__Pattern			= selected__Pattern_;
			this.selected__Pattern_Language	= selected__Pattern_Language_;

			this.after_Pattern_selecting();

			#region		(ancienne version)
			/*
			if (this.doNotSearch)
			{
				return;
			}

			string pattern_language__meaning = this.textBox__Pattern__Meaning.Text;

			this.guiTable__Pattern.Clear();

			if (pattern_language__meaning.Length < 2)
			{
				this.selected__Pattern			= null;
				this.selected__Pattern_Language	= null;

				this.doNotSearch = true;
				this.textBox__Pattern__UniqueKeyString.Text = null;
				this.doNotSearch = false;

				return;
			}
			else
			{
				DataRow[] selectedPattern_Languages 
					= this.table__Pattern_Language
					.Select
					(
						"LanguageCode = '" +
						this.mainForm.Current__Language.Code +
						"' AND Meaning LIKE '*" + pattern_language__meaning + "*'"
					);

				if (selectedPattern_Languages.Length == 1)
				{
					this.selected__Pattern_Language	= (BabebiDataSet.Pattern_LanguageRow)(selectedPattern_Languages[0]);
					this.selected__Pattern			=  this.selected__Pattern_Language.PatternRow;

					this.doNotSearch = true;
					this.textBox__Pattern__UniqueKeyString.Text = this.selected__Pattern.UniqueKeyString;
					this.doNotSearch = false;
				}
				else
				{
					DataRow matchingGuiDataRow = null;

					foreach (BabebiDataSet.Pattern_LanguageRow selectedPattern_Language in selectedPattern_Languages)
					{
						BabebiDataSet.PatternRow selectedPattern = selectedPattern_Language.PatternRow;

						DataRow guiDataRow 
							= this.guiTable__Pattern
							.Rows
							.Add
							(
								selectedPattern_Language.PatternId,
								selectedPattern.UniqueKeyString,
								selectedPattern_Language.Meaning
							);

						if (matchingGuiDataRow == null && selectedPattern_Language.Meaning == pattern_language__meaning)
						{
							matchingGuiDataRow = guiDataRow;
						}
					}

					if (matchingGuiDataRow != null)
					{
						this.populatePattern(matchingGuiDataRow);
					}
				}
			}
			*/
			#endregion	(ancienne version)
		}

		private void bindingSource__Pattern_CurrentChanged(object sender, EventArgs e)
		{
			if (this.dataGridView__Pattern.Focused)
			{
				DataRow guiDataRow__Pattern = ((DataRowView)(this.bindingSource__Pattern.Current)).Row; 
				
				int		selectedId = (int)(guiDataRow__Pattern["Id"]);

				this.selected__Pattern
					= this.table__Pattern
					.FindById(selectedId);
			
				this.selected__Pattern_Language
					= this.table__Pattern_Language
					.FindByPatternIdLanguageCode(selectedId, this.mainForm.Current__Language.Code);

				this.after_Pattern_selecting();
			}

			#region		(ancienne version)
			/*
			if (this.dataGridView_Pattern.Focused)
			{
				this.populatePattern(((DataRowView)(this.bindingSource__Pattern.Current)).Row);
			}
			*/
			#endregion	(ancienne version)
		}
					 
		private void after_Pattern_selecting()
		{ 
			this.textBox__SelectedPattern__UniqueKeyString	.Text = this.selected__Pattern.UniqueKeyString;
			this.textBox__SelectedPattern__Meaning			.Text = this.selected__Pattern_Language.Meaning;
			this.textBox__SelectedPattern__Id				.Text = this.selected__Pattern.Id.ToString();
		}

		bool preventCharEntry = false;
		private void textBox__Pattern__UniqueKeyString__KeyPress(object sender, KeyPressEventArgs e)
		{
			MainForm.Searching__UniqueKeyString__KeyPress(this.preventCharEntry, e);
		}
	}
}
