﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__Pattern__FindById : Form
	{
		private MainForm mainForm;

		#region		ctors

		public Form__Pattern__FindById(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;
		}

		public Form__Pattern__FindById()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void textBox__Pattern__Id__KeyPress(object sender, KeyPressEventArgs e)
		{
			char c = e.KeyChar;

			/// les chiffres + back + coller.
			if (char.IsNumber(c) || c == '\b' || c == '\u0016')	
			{
				e.Handled = false;
			}
			else
			{ 
				e.Handled = true;
			}
		}

		private void button__OK__Click(object sender, EventArgs e)
		{
			string patternIdString = this.textBox__Pattern__Id.Text;

			if (string.IsNullOrEmpty(patternIdString))
			{
				MessageBox.Show("There is no Pattern Id.","Missing Id", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			int patternId = int.Parse(patternIdString);

			BabebiDataSet.PatternRow pattern = this.mainForm.DataSet.Pattern.FindById(patternId);

			if (pattern == null)
			{
				MessageBox.Show("'" + patternIdString + "' is not the Id of an existing Pattern.","Not existing Id", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}

			this.mainForm.Current__Pattern			= pattern;

			this.mainForm.Current__Pattern_Language	
				= this.mainForm.DataSet.Pattern_Language
				.FindByPatternIdLanguageCode
				(	
					patternId, 
					this.mainForm.Current__Language.Code
				);

			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
