﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	internal partial class Form__SubStrings : Form
	{
		private		MeaningParser	meaningParser;
		private		string[]		subStrings;

		internal List<string> SubStrings__registered_as_being_unchecked_forever
		{	
			get { return this.meaningParser.MainForm.SubStrings__registered_as_being_not_LanguageWords_forever; }
		}
		internal List<string> SubStrings_that_will_become_languageWords
		{ 
			get { return this.meaningParser.SubSubMeaningList_that_will_become_languageWords; }
		}
		
		private DataTable	dataTable;
		private DataColumn	dataColumn_SubString;
		private DataColumn	dataColumn_Now;
		private DataColumn	dataColumn_Never;

		internal Form__SubStrings
		(
			MeaningParser	meaningParser,
			string[]		subStrings
		)
		: this()
		{
			this.meaningParser	= meaningParser;
			this.subStrings		= subStrings;

			this.dataTable = new DataTable("TABLE");

			this.dataColumn_SubString	= this.dataTable.Columns.Add("SubString"	, typeof(string	));
			this.dataColumn_Now			= this.dataTable.Columns.Add("Now"			, typeof(bool	));
			this.dataColumn_Never		= this.dataTable.Columns.Add("Never"		, typeof(bool	));

			this.dataGridView.DataSource = this.dataTable;

			foreach (string substring in this.subStrings)
			{
				if (this.SubStrings__registered_as_being_unchecked_forever.Contains(substring))
				{
					this.dataTable.Rows.Add(substring, false, true);
				}
				else
				{
					this.dataTable.Rows.Add(substring, true, false);
				}
			}

			this.dataTable.RowChanged += DataTable__RowChanged;
		}
		private Form__SubStrings()
		{
			InitializeComponent();
		}

		private void DataTable__RowChanged(object sender, DataRowChangeEventArgs e)
		{
			DataRow dataRow = e.Row;

			if (e.Action == DataRowAction.Change)
			{
				bool	now			=  dataRow.Field<bool		>(this.dataColumn_Now		);
				bool	never		=  dataRow.Field<bool		>(this.dataColumn_Never		);

				if (never && now)
				{
					dataRow[this.dataColumn_Now] = false;
				}
			}
		}


		private void button__OK_Click(object sender, EventArgs e)
		{
			foreach (DataRow dataRow in this.dataTable.Rows)
			{
				string	subString	=  dataRow.Field<string		>(this.dataColumn_SubString	);
				bool	now			=  dataRow.Field<bool		>(this.dataColumn_Now		);
				bool	never		=  dataRow.Field<bool		>(this.dataColumn_Never		);

				if (now)
				{
					this.SubStrings_that_will_become_languageWords.Add(subString);
				}
				if (never)
				{
					if (!this.SubStrings__registered_as_being_unchecked_forever.Contains(subString))
					{
						this.SubStrings__registered_as_being_unchecked_forever.Add(subString);
					}
				}
				else
				{ 
					if (this.SubStrings__registered_as_being_unchecked_forever.Contains(subString))
					{
						this.SubStrings__registered_as_being_unchecked_forever.Remove(subString);
					}
				}

			}

			this.DialogResult = DialogResult.OK;
			this.Close();
		}
	}


}
