﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__WordByInsertion__CreateUpdate : Form
	{
		private MainForm mainForm;

		private BabebiDataSet dataSet;

		private bool trueForCreate__falseForUpdate
		{
			get
			{
				if (this.current__WordByInsertion== null)
				{
					return true;
				}
				else
				{ 
					if (this.current__WordByInsertion.Id != this.current__Word.Id)
					{
						return true;
					}
					else
					{ 
						return false;
					}
				}
			}
		}

		private BabebiDataSet.WordByInsertionDataTable			table__WordByInsertion		;
		private BabebiDataSet.WordDataTable						table__Word					;
		private BabebiDataSet.Word_LanguageDataTable			table__Word_Language		;
		private BabebiDataSet.LetterDataTable					table__Letter				;
		private BabebiDataSet.LetterClusterDataTable			table__LetterCluster		;
		private BabebiDataSet.LetterClusterLetterDataTable		table__LetterClusterLetter	;

		private DataSet guiDataSet;

		private DataTable guiTable__Parent;

		private DataColumn guiColumn__Parent__Id;
		private DataColumn guiColumn__Parent__String;
		private DataColumn guiColumn__Parent__Meaning;

		private BindingSource bindingSource__Parent;

		private BabebiDataSet.WordRow				current__Word
		{
			get
			{
				return this.mainForm.Current__Word;
			}
		}
		private BabebiDataSet.WordByInsertionRow	current__WordByInsertion
		{
			get
			{
				return this.mainForm.Current__WordByInsertion;
			}
			set
			{
				this.mainForm.Current__WordByInsertion = value;
			}
		}
		private BabebiDataSet.WordRow				current__Word__of__WordByInsertion__Parent
		{
			get
			{
				return this.mainForm.Current__Word__of__WordByInsertion__Parent;
			}
			set
			{
				this.mainForm.Current__Word__of__WordByInsertion__Parent = value;
			}
		}
		private BabebiDataSet.Word_LanguageRow		current__Word_Language__of__WordByInsertion__Parent
		{
			get
			{
				return this.mainForm.Current__Word_Language__of__WordByInsertion__Parent;
			}
			set
			{
				this.mainForm.Current__Word_Language__of__WordByInsertion__Parent = value;
			}
		}

		/// attention : ces Rows correspondent au parent du WordByInsertion que l'on cherche à updater (donc pas au Word lui-même).
		private BabebiDataSet.WordRow			selected__Parent__Word = null;
		private BabebiDataSet.Word_LanguageRow	selected__Parent__Word_Language = null;

		private short selected__InsertionIndex = -1;

		private BabebiDataSet.LetterClusterRow selected__LetterCluster = null;

		List<BabebiDataSet.LetterRow> letterList = new List<BabebiDataSet.LetterRow>();

		#region		error management

		private NoControl_WEM	noControl_WEM__PARENT__Word			;
		private ComboBox_WEM	comboBox_WEM__InsertionIndex		;
		private TextBox_WEM		textBox_WEM__LetterClusterString	;
		private TextBox_WEM		textBox_WEM__UniqueKeyString		;

		#endregion		error management

		#region		ctors

		public Form__WordByInsertion__CreateUpdate(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;
			this.dataSet = this.mainForm.DataSet;

			#region		shortcuts

			this.table__WordByInsertion		= this.dataSet.WordByInsertion;
			this.table__Word				= this.dataSet.Word;
			this.table__Word_Language		= this.dataSet.Word_Language;
			this.table__Letter				= this.dataSet.Letter;
			this.table__LetterCluster		= this.dataSet.LetterCluster;
			this.table__LetterClusterLetter	= this.dataSet.LetterClusterLetter;

			#endregion	shortcuts
			#region		guiTable__Parent

			this.guiDataSet = new DataSet("GuiDataSet");

			this.guiTable__Parent = this.guiDataSet.Tables.Add("Parent");

			this.guiColumn__Parent__Id = this.guiTable__Parent.Columns.Add("Id", typeof(int));
			this.guiColumn__Parent__String = this.guiTable__Parent.Columns.Add("String", typeof(string));
			this.guiColumn__Parent__Meaning = this.guiTable__Parent.Columns.Add("Meaning", typeof(string));

			this.guiTable__Parent.PrimaryKey = new DataColumn[] { this.guiColumn__Parent__Id };

			this.bindingSource__Parent = new BindingSource(this.guiDataSet, this.guiTable__Parent.TableName);

			this.dataGridView_Parent.DataSource = this.bindingSource__Parent;

			this.bindingSource__Parent.CurrentChanged += bindingSource__Parent_CurrentChanged;

			#endregion	guiTable__Parent
			#region		error management

			this.noControl_WEM__PARENT__Word
				= new NoControl_WEM
				(
					"The PARENT Word has not been selected.",
					"Missing PARENT Pattern"
				);

			this.comboBox_WEM__InsertionIndex
				= new ComboBox_WEM
				(
					this.label__InsertionIndex,
					this.comboBox__InsertionIndex,
					"The 'Insertion Index' has not been selected.",
					"Missing 'Insertion Index'",
					( 
						this.trueForCreate__falseForUpdate 
						? 
						null 
						: 
						MainForm.Convert__InsertionIndex__into__ComboBoxSelectedItem(this.current__WordByInsertion.InsertionIndex)
					)
				);

			this.textBox_WEM__LetterClusterString
				= new TextBox_WEM
				(
					this.label__LetterClusterString,
					this.textBox__LetterClusterString,
					"The 'Letter Cluster String' is empty.",
					"Empty 'Letter Cluster String'",
					( this.trueForCreate__falseForUpdate ? null : this.current__WordByInsertion.LetterClusterRow.String )
				);

			this.textBox_WEM__UniqueKeyString
				= new TextBox_WEM
				(
					this.label__ComputedString,
					this.textBox__ComputedString,
					"The 'Computed String' is empty.",
					"Empty 'Computed String'",
					this.current__Word.UniqueKeyString
				);

			#endregion	error management

			if (this.current__WordByInsertion == null)
			{
				#region		CREATE case

				/// pour ne plus avoir cette valeur indéterminée
				this.comboBox__InsertionIndex.SelectedIndex = 0;

				this.button__CreateUpdate.Text = "CREATE";

				#endregion	CREATE case
			}
			else
			{
				#region		UPDATE case
														  
				this.selected__Parent__Word				= this.current__Word__of__WordByInsertion__Parent;
				this.selected__Parent__Word_Language	= this.current__Word_Language__of__WordByInsertion__Parent;

				this.selected__InsertionIndex			= this.mainForm.Current__WordByInsertion.InsertionIndex;

				this.selected__LetterCluster			= this.mainForm.Current__WordByInsertion.LetterClusterRow;

				// will fire no event								
				this.textBox__SelectedParentWord__String	.Text = this.mainForm.textBox__Word__ByInsertion__ParentWordString.Text;
				this.textBox__SelectedParentWord__Meaning	.Text = this.mainForm.textBox__Word__ByInsertion__ParentWordMeaning.Text;
				this.textBox__SelectedParentWord__Id		.Text = this.mainForm.textBox__Word__ByInsertion__ParentWordId.Text;

				this.noControl_WEM__PARENT__Word.ClearError();

				string comboBoxItem__InsertionIndex__SelectedItem 
					= MainForm.Convert__InsertionIndex__into__ComboBoxSelectedItem(this.current__WordByInsertion.InsertionIndex);
				this.comboBox__InsertionIndex.SelectedItem	= comboBoxItem__InsertionIndex__SelectedItem;

				this.textBox__LetterClusterString.Text	= this.current__WordByInsertion.LetterClusterRow.String; //  

				#endregion	UPDATE case
			}
		}

		public Form__WordByInsertion__CreateUpdate()
		{
			InitializeComponent();
		}

		#endregion	ctors

		#region		selecting of the Parent

		private bool tryToImplyInformation(string parentWordUniqueKeyString, string currentWordUniqueKeyString)
		{
			int lengthDifference = currentWordUniqueKeyString.Length - parentWordUniqueKeyString.Length;

			if (lengthDifference < 1)
			{
				return false;
			}

			short insertionIndex = -1;	/// which means : return false;
			string letterClusterString = null;

			if (currentWordUniqueKeyString.StartsWith(parentWordUniqueKeyString))
			{
				/// letterCluster at the end.
				insertionIndex = 32;
				letterClusterString = currentWordUniqueKeyString.Substring(parentWordUniqueKeyString.Length);
			}
			else if (currentWordUniqueKeyString.EndsWith(parentWordUniqueKeyString))
			{
				/// letterCluster at the beginning.
				insertionIndex = 0;
				letterClusterString = currentWordUniqueKeyString.Remove(lengthDifference);
			}
			else
			{
				short parentWordUniqueKeyStringLength = Convert.ToInt16(parentWordUniqueKeyString.Length);

				insertionIndex = 0;
				int charIndex;
				for (charIndex = 0; charIndex < parentWordUniqueKeyStringLength; charIndex++)
				{
					char thisChar = parentWordUniqueKeyString[charIndex];

					if (charIndex < parentWordUniqueKeyStringLength - 1)
					{
						char nextChar = parentWordUniqueKeyString[charIndex + 1];

						string doubleCharString = new string(new char[] { thisChar, nextChar });

						BabebiDataSet.LetterRow doubleCharLetter
							= this.table__Letter.FindByString(doubleCharString);

						if (doubleCharLetter != null)
						{
							if (currentWordUniqueKeyString.Substring(charIndex, 2) == doubleCharString)
							{
								charIndex++;

								insertionIndex++;

								continue;
							}
							else
							{
								break;
							}
						}
					}

					string monoCharString = new string(new char[] { thisChar });

					if (currentWordUniqueKeyString.Substring(charIndex, 1) == monoCharString)
					{
						insertionIndex++;
					}
					else
					{
						break;
					}
				}

				if (insertionIndex == 0)
				{
					return false;
				}

				letterClusterString = currentWordUniqueKeyString.Substring(charIndex , lengthDifference);

				string ending				= currentWordUniqueKeyString.Substring(charIndex + lengthDifference);

				if ( ! parentWordUniqueKeyString.EndsWith(ending))
				{
					return false;
				}
			}

			#region		set everything

			string insertionIndexString
					= MainForm.Convert__InsertionIndex__into__ComboBoxSelectedItem
					(
						insertionIndex
					);
			this.comboBox__InsertionIndex.SelectedItem = insertionIndexString;

			this.textBox__LetterClusterString.Text = letterClusterString;

			#endregion	set everything

			return true;
		}

		private void after_PARENT_Word_Selecting()
		{
			this.noControl_WEM__PARENT__Word.ClearError();

			/// populate
			this.textBox__SelectedParentWord__String	.Text = this.selected__Parent__Word.UniqueKeyString;
			this.textBox__SelectedParentWord__Meaning	.Text = this.selected__Parent__Word_Language.Meaning;
			this.textBox__SelectedParentWord__Id		.Text = this.selected__Parent__Word.Id.ToString();

			if (! this.tryToImplyInformation(this.selected__Parent__Word.UniqueKeyString, this.current__Word.UniqueKeyString))
			{
				this.compute__ComputedString();		
			}
		}

		private void textBox__SearchedParentWord__String__TextChanged(object sender, EventArgs e)
		{
			bool? wordSelecting
				= this.mainForm.textBox__Word__UniqueKeyString__TextChanged
				(
					this.textBox__SearchedParentWord__String,
					this.textBox__SelectedParentWord__Meaning,
					this.guiTable__Parent,
					this.current__Word.UniqueKeyString,
				out BabebiDataSet.WordRow			selected__Word_, 
				out BabebiDataSet.Word_LanguageRow	selected__Word_Language_
				);

			if (!wordSelecting.HasValue)
			{ 
				this.preventCharEntry = false;

				return;
			}

			this.preventCharEntry = wordSelecting.Value;

			this.selected__Parent__Word				= selected__Word_;
			this.selected__Parent__Word_Language	= selected__Word_Language_;

			this.after_PARENT_Word_Selecting();

			#region		(ancienne version)
			/*
			if (this.dontTriggerEvent)
			{
				return;
			}

			// cleaning de l'autre field de recherche car on ne cherche que d'un côté à la fois
			this.dontTriggerEvent = true;
			this.textBox__SearchedParentWord__Meaning.Text = null;
			this.dontTriggerEvent = false;

			string parent__String = this.textBox__SearchedParentWord__String.Text;

			this.guiTable__Parent.Clear();

			if (parent__String.Length < 2)
			{
				return;
			}

			DataRow[] selectedWords
				= this.table__Word
				.Select
				(
					"UniqueKeyString LIKE '*" + parent__String + "*'"
				);

			if (selectedWords.Length == 1)
			{
				this.selected__Parent__Word = (BabebiDataSet.WordRow)(selectedWords[0]);

				this.selected__Parent__Word_Language
					= this.table__Word_Language
					.FindByWordIdLanguageCode
					(
						this.selected__Parent__Word.Id, 
						this.mainForm.Current__Language.Code
					);

				int		id				= this.selected__Parent__Word.Id;
				string	uniqueKeyString	= this.selected__Parent__Word.UniqueKeyString;
				string	meaning			= this.selected__Parent__Word_Language.Meaning;

				this.textBox__SelectedParentWord__Id		.Text = id.ToString();
				this.textBox__SelectedParentWord__String	.Text = uniqueKeyString;
				this.textBox__SelectedParentWord__Meaning	.Text = meaning;

				if (! this.tryToImplyInformation(uniqueKeyString, this.current__Word.UniqueKeyString))
				{
					this.compute__ComputedString();		
				}

				// cleaning of the searching area.
				this.dontTriggerEvent = true;
				this.textBox__SearchedParentWord__Meaning	.Text = null;
				this.textBox__SearchedParentWord__String	.Text = null;
				this.dontTriggerEvent = false;
			}
			else
			{
				DataRow matchingGuiDataRow = null;

				foreach (BabebiDataSet.WordRow selectedWord in selectedWords)
				{
					BabebiDataSet.Word_LanguageRow selectedWord_Language
						= this.table__Word_Language
						.FindByWordIdLanguageCode
						(
							selectedWord.Id,
							this.mainForm.Current__Language.Code
						);

					DataRow guiDataRow
						= this.guiTable__Parent
						.Rows
						.Add
						(
							selectedWord.Id,
							selectedWord.UniqueKeyString,
							selectedWord_Language.Meaning
						);

					if (matchingGuiDataRow == null && selectedWord.UniqueKeyString == parent__String)
					{
						matchingGuiDataRow = guiDataRow;
					}
				}

				if (matchingGuiDataRow != null)
				{
					this.populateParentSelectedInformation(matchingGuiDataRow);
				}
				else
				{
					this.dontTriggerEvent = true;
					this.textBox__SearchedParentWord__Meaning.Text = null;
					this.dontTriggerEvent = false;
				}
			}
			*/
			#endregion	(ancienne version)
		}

		private void textBox__SearchedParentWord__Meaning__TextChanged(object sender, EventArgs e)
		{
			bool? wordSelecting
				= this.mainForm.textBox__Word__UniqueKeyString__TextChanged
				(
					this.textBox__SearchedParentWord__String,
					this.textBox__SelectedParentWord__Meaning,
					this.guiTable__Parent,
					this.current__Word.UniqueKeyString,
				out BabebiDataSet.WordRow			selected__Word_, 
				out BabebiDataSet.Word_LanguageRow	selected__Word_Language_
				);

			if (!wordSelecting.HasValue)
			{ 
				this.preventCharEntry = false;

				return;
			}

			this.preventCharEntry = wordSelecting.Value;

			this.selected__Parent__Word				= selected__Word_;
			this.selected__Parent__Word_Language	= selected__Word_Language_;

			this.after_PARENT_Word_Selecting();

			#region		(ancienne version)
			/*
			if (this.dontTriggerEvent)
			{
				return;
			}

			// cleaning de l'autre field de recherche car on ne cherche que d'un côté à la fois
			this.dontTriggerEvent = true;
			this.textBox__SearchedParentWord__String.Text = null;
			this.dontTriggerEvent = false;


			string parent__meaning = this.textBox__SearchedParentWord__Meaning.Text;

			this.guiTable__Parent.Clear();

			if (parent__meaning.Length < 2)
			{
				return;
			}

			DataRow[] selectedWords_Languages
				= this.table__Word_Language
				.Select
				(
					"LanguageCode = '" + this.mainForm.Current__Language.Code + "' AND Meaning LIKE '*" + parent__meaning + "*'"
				);

			if (selectedWords_Languages.Length == 1)
			{
				this.selected__Parent__Word_Language = (BabebiDataSet.Word_LanguageRow)(selectedWords_Languages[0]);

				this.selected__Parent__Word = this.selected__Parent__Word_Language.WordRowParent;

				int		id				= this.selected__Parent__Word.Id;
				string	uniqueKeyString	= this.selected__Parent__Word.UniqueKeyString;
				string	meaning			= this.selected__Parent__Word_Language.Meaning;

				this.textBox__SelectedParentWord__Id		.Text = id.ToString();
				this.textBox__SelectedParentWord__String	.Text = uniqueKeyString;
				this.textBox__SelectedParentWord__Meaning	.Text = meaning;

				if (! this.tryToImplyInformation(uniqueKeyString, this.current__Word.UniqueKeyString))
				{
					this.compute__ComputedString();		
				}

				// cleaning of the searching area.
				this.dontTriggerEvent = true;
				this.textBox__SearchedParentWord__Meaning.Text = null;
				this.textBox__SearchedParentWord__String.Text = null;
				this.dontTriggerEvent = false;
			}
			else
			{
				DataRow matchingGuiDataRow = null;

				foreach (BabebiDataSet.Word_LanguageRow selectedWord_Language in selectedWords_Languages)
				{
					BabebiDataSet.WordRow selectedWord = selectedWord_Language.WordRowParent;

					DataRow guiDataRow
						= this.guiTable__Parent
						.Rows
						.Add
						(
							selectedWord_Language.WordId,
							selectedWord.UniqueKeyString,
							selectedWord_Language.Meaning
						);

					if (matchingGuiDataRow == null && selectedWord_Language.Meaning == parent__meaning)
					{
						matchingGuiDataRow = guiDataRow;
					}
				}

				if (matchingGuiDataRow != null)
				{
					this.populateParentSelectedInformation(matchingGuiDataRow);
				}
				else
				{
					this.dontTriggerEvent = true;
					this.textBox__SearchedParentWord__String.Text = null;
					this.dontTriggerEvent = false;
				}
			}
			*/
			#endregion	(ancienne version)
		}

		private void bindingSource__Parent_CurrentChanged(object sender, EventArgs e)
		{
			if (this.dataGridView_Parent.Focused)
			{
				DataRow guiDataRow__Pattern = ((DataRowView)(this.bindingSource__Parent.Current)).Row; 
				
				int		selectedId = (int)(guiDataRow__Pattern["Id"]);

				this.selected__Parent__Word
					= this.table__Word
					.FindById(selectedId);
			
				this.selected__Parent__Word_Language
					= this.table__Word_Language
					.FindByWordIdLanguageCode(selectedId, this.mainForm.Current__Language.Code);

				this.after_PARENT_Word_Selecting();
			}

			#region		(ancienne version)
			/*
			if (this.dataGridView_Parent.Focused)
			{
				this.populateParentSelectedInformation(((DataRowView)(this.bindingSource__Parent.Current)).Row);

				// cleaning of the searching area.
				this.dontTriggerEvent = true;
				this.textBox__SearchedParentWord__Meaning.Text = null;
				this.textBox__SearchedParentWord__String.Text = null;
				this.dontTriggerEvent = false;
			}
			*/
			#endregion	(ancienne version)
		}

		private bool preventCharEntry = false;
		private void textBox__Word__UniqueKeyString__KeyPress(object sender, KeyPressEventArgs e)
		{
			MainForm.Searching__UniqueKeyString__KeyPress(this.preventCharEntry, e);
		}

		#endregion	selecting of the Parent

		#region		InsertionIndex & LetterClusterString

		private void comboBox__InsertionIndex__SelectedIndexChanged(object sender, EventArgs e)
		{
			this.mainForm.ComboBox__InsertionIndex__SelectedIndexChanged
				(
					this.comboBox_WEM__InsertionIndex,
					Convert.ToInt16( this.textBox__SelectedParentWord__String.Text.Length ),
				ref this.selected__InsertionIndex
				);

			this.compute__ComputedString();
		}

		private void textBox__LetterCluster__TextChanged(object sender, EventArgs e)
		{
			this.mainForm.textBox__LetterClusterString__TextChanged
			(
				this.textBox_WEM__LetterClusterString, 
			ref this.selected__LetterCluster,
				this.letterList
			);

			this.compute__ComputedString();
		}

		#endregion	InsertionIndex & LetterClusterString

		private void compute__ComputedString()
		{
			#region		trapping of any error about the sources

			if
			(
				this.noControl_WEM__PARENT__Word.HasError
				||
				this.comboBox_WEM__InsertionIndex.HasError
				||
				this.textBox_WEM__LetterClusterString.HasError
			)
			{
				this.textBox__ComputedString.Text = null;

				return;
			}

			#endregion	trapping of any error about the sources
			#region		trapping about a__a ou e__e ou o__o + > 32-chars

			bool hasError = this.mainForm.ByInsertion__Check_Erros_Before_Computing_UniqueKeyString
			(
				this.textBox__SelectedParentWord__String.Text, 
				this.textBox__LetterClusterString.Text,
				this.selected__InsertionIndex,
				this.textBox_WEM__UniqueKeyString
			);
			if (hasError)
			{
				return;
			}

			#endregion	trapping about a__a ou e__e ou o__o + > 32-chars
			#region		the computing itself

			string computedString
				= WordByInsertion.Compute_UniqueKeyString
				(
					this.selected__Parent__Word,
					this.selected__InsertionIndex,
					this.textBox__LetterClusterString.Text
				);

			/// on affiche le resultat même s'il a causé une error.
			this.textBox__ComputedString.Text = computedString;

			#endregion	the computing itself

			this.mainForm.Word__UniqueKeyString__TextChanged(this.textBox_WEM__UniqueKeyString);
		}

		private void button__CreateUpdate__Click(object sender, EventArgs e)
		{
			#region		checking

			if (this.comboBox_WEM__InsertionIndex.HasError)
			{
				this.comboBox_WEM__InsertionIndex.ShowMessageBox();

				return;
			}
			if (this.noControl_WEM__PARENT__Word.HasError)
			{
				this.noControl_WEM__PARENT__Word.ShowMessageBox();

				return;
			}
			if (this.textBox_WEM__LetterClusterString.HasError)
			{
				this.textBox_WEM__LetterClusterString.ShowMessageBox();

				return;
			}
			if (this.textBox_WEM__UniqueKeyString.HasError)
			{
				this.textBox_WEM__UniqueKeyString.ShowMessageBox();

				return;
			}

			#endregion	checking

			/// usefull in both Create or Update modes.
			if (this.selected__LetterCluster == null)
			{
				this.selected__LetterCluster = this.mainForm.build__LetterCluster(this.letterList);
			}

			if (this.current__WordByInsertion == null)
			{
				#region		CREATE case

				this.mainForm.RemovePriorWordExtensionIfAny();

				this.current__Word.ModeCode = MainForm.ModeCode_ByInsertion;

				this.current__WordByInsertion
					= this.table__WordByInsertion
					.AddWordByInsertionRow
					(
						this.current__Word.Id,
						this.selected__Parent__Word,
						this.selected__InsertionIndex,
						this.selected__LetterCluster,
						MainForm.ModeCode_ByInsertion
					);

				this.current__Word__of__WordByInsertion__Parent				= this.selected__Parent__Word;
				this.current__Word_Language__of__WordByInsertion__Parent	= this.selected__Parent__Word_Language;

				this.mainForm.button__Word__ByInsertion__CreateUpdate.Text = "UPDATE";

				#endregion	CREATE case
			}
			else
			{
				#region	UPDATE case

				/// about parent 
				if (this.selected__Parent__Word != this.current__Word__of__WordByInsertion__Parent)
				{
					this.current__Word__of__WordByInsertion__Parent				= this.selected__Parent__Word;
					this.current__Word_Language__of__WordByInsertion__Parent	= this.selected__Parent__Word_Language;
				}

				/// about InsertionIndex
				if ((string)(this.comboBox__InsertionIndex.SelectedItem) != this.mainForm.textBox__Word__ByInsertion__InsertionIndex.Text)
				{
					this.current__WordByInsertion.InsertionIndex = this.selected__InsertionIndex;
				}

				/// about LetterCluster
				this.mainForm.Set_LetterCluster_and_remove_prior_if_not_used_by_other
				(	
					this.selected__LetterCluster,
					this.current__WordByInsertion
				);
				
				#endregion	UPDATE case
			}

			this.mainForm.populate__WordByInsertion(PopulatingType.SettingFieldsOnly);
			
		//	this.mainForm.textBox__Word__ByInsertion__ParentWordId.Text			= this.textBox__SelectedParentWord__Id.Text;
		//	this.mainForm.textBox__Word__ByInsertion__ParentWordString.Text		= this.textBox__SelectedParentWord__String.Text;
		//	this.mainForm.textBox__Word__ByInsertion__ParentWordMeaning.Text	= this.textBox__SelectedParentWord__Meaning.Text;
		//	this.mainForm.textBox__Word__ByInsertion__InsertionIndex.Text		= (string)(this.comboBox__InsertionIndex.SelectedItem);
		//	this.mainForm.textBox__Word__ByInsertion__LetterClusterString.Text	= this.textBox__LetterClusterString.Text;
			

			/// the target !
			Word.SetUniqueKeyString(this.mainForm.Current__Word, this.textBox__ComputedString.Text);
		//	this.mainForm.Current__Word.UniqueKeyString	= this.textBox__ComputedString.Text;

			this.mainForm.textBox__Word__String.Text	= this.textBox__ComputedString.Text;

			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
