﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__WordDerivated__CreateUpdate : Form
	{
		private MainForm mainForm;

		private BabebiDataSet dataSet;

		private bool trueForCreate__falseForUpdate
		{
			get
			{
				if (this.current__WordDerivated == null)
				{
					return true;
				}
				else
				{ 
					if (this.current__WordDerivated.Id != this.current__Word.Id)
					{
						return true;
					}
					else
					{ 
						return false;
					}
				}
			}
		}

		#region		convenient shortcuts

		private BabebiDataSet.WordOrPatternDataTable table__WordOrPattern { get { return this.mainForm.DataSet.WordOrPattern; } }
		private BabebiDataSet.WordDataTable table__Word { get { return this.mainForm.DataSet.Word; } }
		private BabebiDataSet.Word_LanguageDataTable table__Word_Language { get { return this.mainForm.DataSet.Word_Language; } }
		private BabebiDataSet.LanguageWordDataTable table__LanguageWord { get { return this.mainForm.DataSet.LanguageWord; } }
		private BabebiDataSet.Word_LanguageWordDataTable table__Word_LanguageWord { get { return this.mainForm.DataSet.Word_LanguageWord; } }
		private BabebiDataSet.WordDerivatingDataTable table__WordDerivating { get { return this.mainForm.DataSet.WordDerivating; } }
		private BabebiDataSet.WordDerivatedDataTable table__WordDerivated { get { return this.mainForm.DataSet.WordDerivated; } }
		private BabebiDataSet.WordType_LanguageDataTable table__WordType_Language { get { return this.mainForm.DataSet.WordType_Language; } }
		private BabebiDataSet.DerivatingWordType_LanguageDataTable table__DerivatingWordType_Language { get { return this.mainForm.DataSet.DerivatingWordType_Language; } }
		private BabebiDataSet.DerivatedWordType_LanguageDataTable table__DerivatedWordType_Language { get { return this.mainForm.DataSet.DerivatedWordType_Language; } }
		private BabebiDataSet.Derivating_LanguageDataTable table__Derivating_Language { get { return this.mainForm.DataSet.Derivating_Language; } }

		private BabebiDataSet.LanguageRow current__Language { get { return this.mainForm.Current__Language; } }
		private string currentLanguageCode;

		private BabebiDataSet.WordRow current__Word
		{
			get
			{
				return this.mainForm.Current__Word;
			}
		}
		private BabebiDataSet.Word_LanguageRow current__Word_Language
		{
			get
			{
				return this.mainForm.Current__Word_Language;
			}
		}
		private BabebiDataSet.WordType_LanguageRow current__WordType_Language
		{
			get
			{
				return this.mainForm.Current__WordType_Language;
			}
		}

		private BabebiDataSet.WordDerivatedRow current__WordDerivated
		{
			get
			{
				return this.mainForm.Current__WordDerivated;
			}
			set
			{
				this.mainForm.Current__WordDerivated = value;
			}
		}

		private BabebiDataSet.WordDerivatingRow current__WordDerivating
		{
			get
			{
				return this.mainForm.Current__WordDerivating__of__WordDerivated;
			}
			set
			{
				this.mainForm.Current__WordDerivating__of__WordDerivated = value;
			}
		}
		private BabebiDataSet.WordRow current__Word__of__WordDerivating
		{
			get
			{
				return this.mainForm.Current__Word__of__WordDerivating__of__WordDerivated;
			}
			set
			{
				this.mainForm.Current__Word__of__WordDerivating__of__WordDerivated = value;
			}
		}
		private BabebiDataSet.Word_LanguageRow current__Word_Language__of__WordDerivating
		{
			get
			{
				return this.mainForm.Current__Word_Language__of__WordDerivating__of__WordDerivated;
			}
			set
			{
				this.mainForm.Current__Word_Language__of__WordDerivating__of__WordDerivated = value;
			}
		}

		private BabebiDataSet.DerivatedWordType_LanguageRow current__DerivatedWordType_Language__of__WordDerivated
		{
			get
			{
				return this.mainForm.Current__DerivatedWordType_Language__of__WordDerivated;
			}
			set
			{
				this.mainForm.Current__DerivatedWordType_Language__of__WordDerivated = value;
			}
		}
		private BabebiDataSet.Derivating_LanguageRow current__Derivating_Language__of__WordDerivated
		{
			get
			{
				return this.mainForm.Current__Derivating_Language__of__WordDerivated;
			}
			set
			{
				this.mainForm.Current__Derivating_Language__of__WordDerivated = value;
			}
		}

		#endregion	convenient shortcuts
		#region		gui table : WordDerivating

		private DataSet guiDataSet;

		private DataTable guiTable__WordDerivating;

		private DataColumn guiColumn__WordDerivating__Id;
		private DataColumn guiColumn__WordDerivating__String;
		private DataColumn guiColumn__WordDerivating__Meaning;

		private BindingSource bindingSource__WordDerivating;

		#endregion	gui table : WordDerivating

		private BabebiDataSet.WordDerivatingRow				selected__WordDerivating = null;
		private BabebiDataSet.WordRow						selected__Word__of__WordDerivating = null;
		private BabebiDataSet.Word_LanguageRow				selected__Word_Language__of__WordDerivating = null;
		private BabebiDataSet.DerivatedWordType_LanguageRow	selected__DerivatedWordType_Language__of__WordDerivated = null;
		private BabebiDataSet.Derivating_LanguageRow		selected__Derivating_Language__of__WordDerivated = null;

		private bool dontTriggerEvent = false;

		private bool hasError__ComputedString_ = false;
		private bool hasError__ComputedString
		{
			get { return this.hasError__ComputedString_; }
			set
			{
				this.hasError__ComputedString_ = value;

				if (this.hasError__ComputedString_)
				{
					this.label__ComputedString.ForeColor = Color.Red;

					this.textBox__ComputedString.BackColor = SystemColors.Control;
					this.textBox__ComputedString.ForeColor = Color.Red;
				}
				else
				{
					if (this.textBox__ComputedString.Text == this.current__Word.UniqueKeyString)
					{
						this.label__ComputedString.ForeColor = Color.Black;

						this.textBox__ComputedString.BackColor = SystemColors.Control;
						this.textBox__ComputedString.ForeColor = Color.Black;
					}
					else
					{
						this.label__ComputedString.ForeColor = Color.Blue;

						this.textBox__ComputedString.BackColor = SystemColors.Control;
						this.textBox__ComputedString.ForeColor = Color.Blue;
					}
				}
			}
		}

		#region		ctors

		public Form__WordDerivated__CreateUpdate(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;

			this.dataSet = this.mainForm.DataSet;

			this.currentLanguageCode = this.current__Language.Code;

			#region		CREATE or UPDATE button ?

			if (trueForCreate__falseForUpdate)
			{
				this.button__CreateUpdate.Text = "CREATE";
			}
			else
			{
				this.button__CreateUpdate.Text = "UPDATE";
			}

			#endregion	CREATE or UPDATE button ?

			#region		guiTable__WordDerivating

			this.guiDataSet = new DataSet("GuiDataSet");

			/// l'underscore à la fin du TableName pour indiquer que ce n'est pas la vraie table WordDerivating du Babebi DataSet.
			this.guiTable__WordDerivating = this.guiDataSet.Tables.Add("WordDerivating_");

			this.guiColumn__WordDerivating__Id = this.guiTable__WordDerivating.Columns.Add("Id", typeof(int));
			this.guiColumn__WordDerivating__String = this.guiTable__WordDerivating.Columns.Add("String", typeof(string));
			this.guiColumn__WordDerivating__Meaning = this.guiTable__WordDerivating.Columns.Add("Meaning", typeof(string));

			this.guiTable__WordDerivating.PrimaryKey = new DataColumn[] { this.guiColumn__WordDerivating__Id };

			this.bindingSource__WordDerivating = new BindingSource(this.guiDataSet, this.guiTable__WordDerivating.TableName);

			this.dataGridView__Word.DataSource = this.bindingSource__WordDerivating;

			this.bindingSource__WordDerivating.CurrentChanged += bindingSource__WordDerivating__CurrentChanged;

			#endregion	guiTable__WordDerivating

			#region		WordType of (Derivated) Word : it remains constant in either CREATE or UPDATE case.

			this.textBox__WordType__of__Derivated_Word.Text = this.current__Word.WordTypeRow.Name;

			#endregion	WordType of (Derivated) Word : it remains constant in either CREATE or UPDATE case.
			#region		all fields related to the parent WordDerivating (UPDATE case only)

			if (!this.trueForCreate__falseForUpdate)
			{
				/// the rows.
				this.selected__WordDerivating = this.current__WordDerivating;
				this.selected__Word__of__WordDerivating = this.current__Word__of__WordDerivating;
				this.selected__Word_Language__of__WordDerivating = this.current__Word_Language__of__WordDerivating;

				/// the fields.
				this.populate__WordDerivating__Information__after_the_3_WordDerivating_related_rows_finding_();
			}
			#endregion	all fields related to the parent WordDerivating (UPDATE case only)
			#region		DerivatedWordType

			if (trueForCreate__falseForUpdate)
			{
				/// rien de plus.
			}
			else
			{
				/// On ne peut préparer	la comboBox DerivatedWordType que si le parent WordDerivating est choisi.

				this.selected__DerivatedWordType_Language__of__WordDerivated 
					= this.current__DerivatedWordType_Language__of__WordDerivated;

				/// on séte avec la valeur existante après que la Combo a été préparée.

				BabebiDataSet.DerivatedWordType_LanguageRow theCurrentDerivatedWordType_Language
					= this.table__DerivatedWordType_Language
					.FindByDerivatedWordTypeIdLanguageCode
					(
						this.current__DerivatedWordType_Language__of__WordDerivated.DerivatedWordTypeId,
						this.currentLanguageCode
					);

				DerivatedWordTypeComboBoxItem theCurrentDerivatedWordTypeComboBoxItem
					= new DerivatedWordTypeComboBoxItem(theCurrentDerivatedWordType_Language);

				this.comboBox__DerivatedWordType.SelectedItem = theCurrentDerivatedWordTypeComboBoxItem;
			}

			#endregion	DerivatedWordType
			#region		Derivating

			if (trueForCreate__falseForUpdate)
			{
				/// rien à faire car piloté par l'event de la Combo DerivatedWordType.
			}
			else
			{
				this.selected__Derivating_Language__of__WordDerivated = null;

				/// on séte avec la valeur existante après que la Combo a été préparée par la DerivatedWordType précédente.

				BabebiDataSet.Derivating_LanguageRow theCurrentDerivating_Language
					= this.table__Derivating_Language
					.FindByDerivatingIdLanguageCode
					(
						this.current__Derivating_Language__of__WordDerivated.DerivatingId,
						this.currentLanguageCode
					);

				DerivatingComboBoxItem theCurrentDerivatingComboBoxItem
					= new DerivatingComboBoxItem(theCurrentDerivating_Language);

				this.comboBox__Derivating.SelectedItem = theCurrentDerivatingComboBoxItem;
			}

			#endregion	Derivating
			#region		Derivating information (UPDATE case only)

			if (!trueForCreate__falseForUpdate)
			{
				this.textBox__Derivating__String.Text = this.current__Derivating_Language__of__WordDerivated.DerivatingRowParent.LetterClusterString;
				this.textBox__BeforeOrAfter.Text
					=
					(
						this.current__Derivating_Language__of__WordDerivated.DerivatingRowParent.AppendStringAtLast
						?
						"AFTER"
						:
						"BEFORE"
					);
			}
			#endregion	Derivating information (UPDATE case only)
		}

		public Form__WordDerivated__CreateUpdate()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void configure__comboBox__DerivatedWordType()
		{
			List<DerivatedWordTypeComboBoxItem> derivatedWordTypeComboBoxItems = new List<DerivatedWordTypeComboBoxItem>();
			foreach
			(
				BabebiDataSet.DerivatedWordTypeRow theDerivatedWordType
				in
				this.current__Word.WordTypeRow.GetDerivatedWordTypeRows()
			)
			{
				bool isCompatibleWithWorDerivating = false;
				foreach
				(
					BabebiDataSet.DerivatingWordType_DerivatedWordTypeRow theDerivatingWordType_DerivatedWordType
					in
					theDerivatedWordType.GetDerivatingWordType_DerivatedWordTypeRows()
				)
				{
					if (theDerivatingWordType_DerivatedWordType.DerivatingWordTypeRow == this.selected__WordDerivating.DerivatingWordTypeRowParent)
					{
						isCompatibleWithWorDerivating = true;
					}
				}
				if (!isCompatibleWithWorDerivating)
				{
					continue;
				}

				BabebiDataSet.DerivatedWordType_LanguageRow theDerivatedWordType_Language
					= this.table__DerivatedWordType_Language
					.FindByDerivatedWordTypeIdLanguageCode
					(
						theDerivatedWordType.Id,
						this.currentLanguageCode
					);

				DerivatedWordTypeComboBoxItem theDerivatedWordTypeComboBoxItem
					= new DerivatedWordTypeComboBoxItem(theDerivatedWordType_Language);

				derivatedWordTypeComboBoxItems.Add(theDerivatedWordTypeComboBoxItem);
			}

			this.comboBox__DerivatedWordType.Items.Clear();

			if (derivatedWordTypeComboBoxItems.Count != 1)
			{
				this.comboBox__DerivatedWordType.Items.AddRange(derivatedWordTypeComboBoxItems.ToArray());

				this.comboBox__DerivatedWordType.Text = null;
			}
			else
			{
				DerivatedWordTypeComboBoxItem theUniqueDerivatedWordTypeComboBoxItem = derivatedWordTypeComboBoxItems[0];

				this.comboBox__DerivatedWordType.Items.Add(theUniqueDerivatedWordTypeComboBoxItem);

				this.comboBox__DerivatedWordType.SelectedItem = theUniqueDerivatedWordTypeComboBoxItem;
			}
		}

		/// <summary>
		/// Cette methode opère après les 3 (selected) WordDerivating rows aient été sétées.
		/// </summary>
		private void populate__WordDerivating__Information__after_the_3_WordDerivating_related_rows_finding_()
		{
			this.textBox__SelectedWord__Id		.Text = this.selected__Word__of__WordDerivating.Id.ToString();
			this.textBox__SelectedWord__String	.Text = this.selected__Word__of__WordDerivating.UniqueKeyString;
			this.textBox__SelectedWord__Meaning	.Text = this.selected__Word_Language__of__WordDerivating.Meaning;

			this.textBox__WordType__of__Derivating_Word.Text
				= this.selected__Word_Language__of__WordDerivating
				.WordType_LanguageRowParent
				.Name;

			this.textBox__DerivatingWordType.Text
				= this.table__DerivatingWordType_Language
				.FindByDerivatingWordTypeIdLanguageCode
				(
					this.selected__WordDerivating.DerivatingWordTypeId,
					this.currentLanguageCode
				)
				.Name;
		
			this.configure__comboBox__DerivatedWordType();
			/// ce qui va déclencher le recalcul de la computed string.
		}

		#region		selecting of the (parent) Word(Derivating)

		/// <summary>
		/// Cette methode opère après le table__WordDerivating.Find(wordId).
		/// </summary>
		private void populate__WordDerivating__Information__from___this_selected__WordDerivating___()
		{
			int selectedWordId = this.selected__WordDerivating.WordId;

			this.selected__Word__of__WordDerivating
				= this.selected__WordDerivating
				.WordRowParent;

			this.selected__Word_Language__of__WordDerivating
				= this.table__Word_Language
				.FindByWordIdLanguageCode
				(
					selectedWordId,
					this.currentLanguageCode
				);
			
			this.populate__WordDerivating__Information__after_the_3_WordDerivating_related_rows_finding_();
		}
		
		private void populate__Selected__WordDerivating__Information(DataRow guiWordDerivatingDataRow)
		{
			int		selectedWordId = (int)(guiWordDerivatingDataRow["Id"]);

			this.selected__WordDerivating
				= this.table__WordDerivating
				.FindByWordId(selectedWordId);

			this.populate__WordDerivating__Information__from___this_selected__WordDerivating___();
		}

		private void textBox__Word__String__TextChanged(object sender, EventArgs e)
		{
			if (this.dontTriggerEvent)
			{
				return;
			}

			// cleaning de l'autre field de recherche car on ne cherche que d'un côté à la fois
			this.dontTriggerEvent = true;
			this.textBox__Word__Meaning.Text = null;
			this.dontTriggerEvent = false;

			string word__String = this.textBox__Word__String.Text;

			this.guiTable__WordDerivating.Clear();

			if (word__String.Length < 2)
			{ 
				return;
			}
			
			DataRow[] selectedWordDerivatings 
				= this.table__WordDerivating
				.Select
				(
					"WordUniqueKeyString LIKE '*" + word__String + "*'"		/// la filter expression utilise une Colonne-Expression.
				);

			if (selectedWordDerivatings.Length == 1)
			{
				this.selected__WordDerivating = (BabebiDataSet.WordDerivatingRow)(selectedWordDerivatings[0]);

				this.selected__Word__of__WordDerivating = this.selected__WordDerivating.WordRowParent;

				this.selected__Word_Language__of__WordDerivating
					= this.table__Word_Language
					.FindByWordIdLanguageCode
					(
						this.selected__Word__of__WordDerivating.Id, 
						this.currentLanguageCode
					);

				this.populate__WordDerivating__Information__after_the_3_WordDerivating_related_rows_finding_();

				// cleaning of the searching area.
				this.dontTriggerEvent = true;
				this.textBox__Word__Meaning.Text	= null;
				this.textBox__Word__String.Text	= null;
				this.dontTriggerEvent = false;
			}
			else
			{
				DataRow matchingGuiDataRow = null;

				foreach (BabebiDataSet.WordDerivatingRow selectedWordDerivating in selectedWordDerivatings)
				{
					BabebiDataSet.WordRow selectedWord = selectedWordDerivating.WordRowParent;
					
					BabebiDataSet.Word_LanguageRow selectedWord_Language
						= this.table__Word_Language
						.FindByWordIdLanguageCode
						(
							selectedWordDerivating.WordId,
							this.currentLanguageCode
						);

					DataRow guiDataRow 
						= this.guiTable__WordDerivating
						.Rows
						.Add
						(
							selectedWord.Id,
							selectedWord.UniqueKeyString,
							selectedWord_Language.Meaning
						);

					if (matchingGuiDataRow == null && selectedWordDerivating.WordUniqueKeyString == word__String)
					{
						matchingGuiDataRow = guiDataRow;
					}
				}

				if (matchingGuiDataRow != null)
				{
					this.populate__Selected__WordDerivating__Information(matchingGuiDataRow);
				}
				else
				{
					this.dontTriggerEvent = true;
					this.textBox__Word__Meaning.Text	= null; 
					this.dontTriggerEvent = false;
				}
			}
		}
		private void textBox__Word__Meaning__TextChanged(object sender, EventArgs e)
		{
			if (this.dontTriggerEvent)
			{
				return;
			}

			// cleaning de l'autre field de recherche car on ne cherche que d'un côté à la fois
			this.dontTriggerEvent = true;
			this.textBox__Word__String.Text = null;
			this.dontTriggerEvent = false;


			string parent__meaning = this.textBox__Word__Meaning.Text;

			this.guiTable__WordDerivating.Clear();

			if (parent__meaning.Length < 2)
			{
				return;
			}

			string filteringString 
				= "LanguageCode = '" + this.mainForm.Current__Language.Code + "'" 
				+ " AND " 
				+ "Meaning LIKE '*" + parent__meaning + "*'"
				+ " AND "
				+ "WordHasDerivating = TRUE";

			BabebiDataSet.Word_LanguageRow[] selectedWord_Languages 
				= 
				(BabebiDataSet.Word_LanguageRow[])
				(this.table__Word_Language.Select(filteringString));

			#region		// must have the optional Derivating

		//	List<BabebiDataSet.Word_LanguageRow> selectedWord_LanguageList = new List<BabebiDataSet.Word_LanguageRow>();
		//	foreach (BabebiDataSet.Word_LanguageRow compatibleWord_Language in compatibleWord_Languages)
		//	{ 
		//		if (compatibleWord_Language.WordRowParent.HasDerivating)
		//		{
		//			selectedWord_LanguageList.Add(compatibleWord_Language);
		//		}
		//	}
		//	BabebiDataSet.Word_LanguageRow[] selectedWord_Languages = selectedWord_LanguageList.ToArray();

			#endregion	// must have the optional Derivating

			if (selectedWord_Languages.Length == 1)
			{
				this.selected__Word_Language__of__WordDerivating = selectedWord_Languages[0];

				this.selected__Word__of__WordDerivating 
					= this.selected__Word_Language__of__WordDerivating.WordRowParent;

				this.selected__WordDerivating 
					= this.table__WordDerivating
					.FindByWordId
					(
						this.selected__Word__of__WordDerivating.Id
					);
				
				this.populate__WordDerivating__Information__after_the_3_WordDerivating_related_rows_finding_();

				// cleaning of the searching area.
				this.dontTriggerEvent = true;
				this.textBox__Word__Meaning.Text = null;
				this.textBox__Word__String.Text = null;
				this.dontTriggerEvent = false;
			}
			else
			{
				DataRow matchingGuiDataRow = null;

				foreach (BabebiDataSet.Word_LanguageRow selectedWord_Language in selectedWord_Languages)
				{
					BabebiDataSet.WordRow selectedWord = selectedWord_Language.WordRowParent;

					DataRow guiDataRow
						= this.guiTable__WordDerivating
						.Rows
						.Add
						(
							selectedWord.Id,
							selectedWord.UniqueKeyString,
							selectedWord_Language.Meaning
						);

					if (matchingGuiDataRow == null && selectedWord_Language.Meaning == parent__meaning)
					{
						matchingGuiDataRow = guiDataRow;
					}
				}

				if (matchingGuiDataRow != null)
				{
					this.populate__Selected__WordDerivating__Information(matchingGuiDataRow);
				}
				else
				{
					this.dontTriggerEvent = true;
					this.textBox__Word__String.Text = null;
					this.dontTriggerEvent = false;
				}
			}
		}

		private void bindingSource__WordDerivating__CurrentChanged(object sender, EventArgs e)
		{
			if (this.dataGridView__Word.Focused)
			{
				this.populate__Selected__WordDerivating__Information(((DataRowView)(this.bindingSource__WordDerivating.Current)).Row);

				// cleaning of the searching area.
				this.dontTriggerEvent = true;
				this.textBox__Word__Meaning.Text = null;
				this.textBox__Word__String.Text = null;
				this.dontTriggerEvent = false;
			}
		}

		#endregion	selecting of the (parent) Word(Derivating)

		private void comboBox__DerivatedWordType__SelectedIndexChanged(object sender, EventArgs e)
		{
			DerivatedWordTypeComboBoxItem selectedDerivatedWordTypeComboBoxItem 
				= (DerivatedWordTypeComboBoxItem)(this.comboBox__DerivatedWordType.SelectedItem);

			this.selected__DerivatedWordType_Language__of__WordDerivated
				= selectedDerivatedWordTypeComboBoxItem
				.Row;

			BabebiDataSet.DerivatingWordType_DerivatedWordTypeRow selectedDerivatingWordType_DerivatedWordType
				= this.mainForm.DataSet.DerivatingWordType_DerivatedWordType
				.FindByDerivatingWordTypeIdDerivatedWordTypeId
				(
					this.selected__WordDerivating.DerivatingWordTypeId,
					this.selected__DerivatedWordType_Language__of__WordDerivated.DerivatedWordTypeId
				);

			List<DerivatingComboBoxItem> derivatingComboBoxItems = new List<DerivatingComboBoxItem>();
			foreach
			(
				BabebiDataSet.DerivatingRow theDerivating
				in
				selectedDerivatingWordType_DerivatedWordType.GetDerivatingRows()
			)
			{
				BabebiDataSet.Derivating_LanguageRow theDerivating_Language
					= this.table__Derivating_Language
					.FindByDerivatingIdLanguageCode
					(
						theDerivating.Id,
						this.currentLanguageCode
					);

				DerivatingComboBoxItem theDerivatingComboBoxItem = new DerivatingComboBoxItem(theDerivating_Language);

				derivatingComboBoxItems.Add(theDerivatingComboBoxItem);
			}

			this.comboBox__Derivating.Items.Clear();

			if (derivatingComboBoxItems.Count != 1)
			{
				this.comboBox__Derivating.Items.AddRange(derivatingComboBoxItems.ToArray());

				this.comboBox__Derivating.Text = null;

				this.compute__ComputedString();
			}
			else
			{
				DerivatingComboBoxItem theUniqueDerivatingComboBoxItem = derivatingComboBoxItems[0];

				this.comboBox__Derivating.Items.Add(theUniqueDerivatingComboBoxItem);

				this.comboBox__Derivating.SelectedItem = theUniqueDerivatingComboBoxItem;
			}
		}

		private void comboBox__Derivating__SelectedIndexChanged(object sender, EventArgs e)
		{
			this.selected__Derivating_Language__of__WordDerivated 
				= 
				(
					(DerivatingComboBoxItem)
					(this.comboBox__Derivating.SelectedItem)
				)
				.Row;
			
			this.textBox__Derivating__String.Text = this.selected__Derivating_Language__of__WordDerivated.DerivatingRowParent.LetterClusterString;
			this.textBox__BeforeOrAfter.Text
				=
				(
					this.selected__Derivating_Language__of__WordDerivated.DerivatingRowParent.AppendStringAtLast
					?
					"AFTER"
					:
					"BEFORE"
				);

			this.compute__ComputedString();
		}

		private void compute__ComputedString()
		{
			#region		checking

			/// en mode Update, les informations nécessaires sont initialisées et elles ne peuvent plus
			/// être nullifiées par la suite (effet combo).
			if (trueForCreate__falseForUpdate)
			{
				if
				(
					this.selected__WordDerivating == null
					||
					this.selected__DerivatedWordType_Language__of__WordDerivated == null
					||
					this.selected__Derivating_Language__of__WordDerivated == null
				)
				{
					this.textBox__ComputedString.Text = null;

					return;
				}
			}

			#endregion	checking

			if (this.selected__Derivating_Language__of__WordDerivated == null)
			{
				this.textBox__ComputedString.Text = null;

				this.hasError__ComputedString = false;

				return;
			}

			this.textBox__ComputedString.Text
				= WordDerivated.Compute_UniqueKeyString
				(
					this.selected__WordDerivating, 
					this.selected__Derivating_Language__of__WordDerivated.DerivatingRowParent
				);

			if(this.textBox__ComputedString.Text.Length > 32)
			{
				this.hasError__ComputedString = true;

				MessageBox.Show
				(
					"The 'Computed String' has more than 32 characters, which is not possible",
					"Computed String too long",
					MessageBoxButtons.OK,
					MessageBoxIcon.Error
				);
			}
			else
			{ 
				this.hasError__ComputedString = false;
			}
		}

		private void button__CreateUpdate__Click(object sender, EventArgs e)
		{
			if (this.hasError__ComputedString)
			{ 
				MessageBox.Show
				(
					"The 'Computed String' displays an error. Unable to create/update the 'Derivated' definition of the current Word.",
					"Error on 'Computed String'",
					MessageBoxButtons.OK,
					MessageBoxIcon.Error
				);

				return;
			}

			if (this.trueForCreate__falseForUpdate)
			{
				#region		checking

				if (this.selected__WordDerivating == null)
				{ 
					MessageBox.Show
					(
						"The 'Derivating Word' has not been selected yet : unable to create the 'Derivated' definition of the current Word.",
						"No Derivating Word selected",
						MessageBoxButtons.OK,
						MessageBoxIcon.Error
					);

					return;
				}

				if (selected__DerivatedWordType_Language__of__WordDerivated == null)
				{ 
					MessageBox.Show
					(
						"The 'Derivated Word Type' has not been selected yet : unable to create the 'Derivated' definition of the current Word.",
						"No Derivating Word selected",
						MessageBoxButtons.OK,
						MessageBoxIcon.Error
					);

					return;
				}

				if (selected__Derivating_Language__of__WordDerivated == null)
				{ 
					MessageBox.Show
					(
						"The 'Derivating' has not been selected yet : unable to create the 'Derivated' definition of the current Word.",
						"No Derivating Word selected",
						MessageBoxButtons.OK,
						MessageBoxIcon.Error
					);

					return;
				}

				#endregion	checking

				this.mainForm.RemovePriorWordExtensionIfAny();
;
				this.current__Word.ModeCode = MainForm.ModeCode_Derivated;

				this.current__WordDerivated
					= this.table__WordDerivated
					.AddWordDerivatedRow
					(
						this.current__Word.Id,
						MainForm.ModeCode_Derivated,
						this.current__Word.WordTypeId, 
						this.selected__DerivatedWordType_Language__of__WordDerivated.DerivatedWordTypeId,
						this.selected__WordDerivating.WordId,
						this.selected__WordDerivating.DerivatingWordTypeId,
						this.selected__Derivating_Language__of__WordDerivated.DerivatingId
					);

				this.mainForm.button__Pattern__FromPattern__CreateUpdate.Text = "UPDATE";
			}
			else
			{
				this.current__WordDerivated.BeginEdit();

				this.current__WordDerivated.WordDerivatingId		= this.selected__WordDerivating.WordId;
				this.current__WordDerivated.DerivatingWordTypeId	= this.selected__WordDerivating.DerivatingWordTypeId;
				this.current__WordDerivated.DerivatedWordTypeId		= this.selected__DerivatedWordType_Language__of__WordDerivated.DerivatedWordTypeId;
				this.current__WordDerivated.DerivatingId			= this.selected__Derivating_Language__of__WordDerivated.DerivatingId;

				this.current__WordDerivated.EndEdit();
			}

			this.current__WordDerivating								= this.selected__WordDerivating;
			this.current__Word__of__WordDerivating						= this.selected__Word__of__WordDerivating;
			this.current__Word_Language__of__WordDerivating				= this.selected__Word_Language__of__WordDerivating;
			this.current__DerivatedWordType_Language__of__WordDerivated	= this.selected__DerivatedWordType_Language__of__WordDerivated;
			this.current__Derivating_Language__of__WordDerivated		= this.selected__Derivating_Language__of__WordDerivated;

			this.mainForm.populate__WordDerivated(PopulatingType.SettingFieldsOnly);

			/// the target !
			Word.SetUniqueKeyString(this.current__Word, this.textBox__ComputedString.Text);
		//	this.current__Word.UniqueKeyString			= this.textBox__ComputedString.Text;

			this.mainForm.textBox__Word__String.Text	= this.current__Word.UniqueKeyString;

			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
