﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Babebi4
{
	public partial class Form__WordDerivating__Append : Form
	{
		private MainForm mainForm;

		private BabebiDataSet.Word_LanguageRow	current__Word_Language
		{
			get { return this.mainForm.Current__Word_Language; }
		}
		private BabebiDataSet.WordRow			current__Word
		{
			get { return this.mainForm.Current__Word; }
		}
		private BabebiDataSet.LanguageRow		current__Language
		{
			get { return this.mainForm.Current__Language; }
		}
		private string							currentLanguageCode
		{
			get { return this.mainForm.Current__Language.Code; }
		}

		public bool IsClosed = false;

		#region		ctors

		public Form__WordDerivating__Append(MainForm mainForm) : this()
		{
			this.mainForm = mainForm;

			List<DerivatingWordTypeComboBoxItem> derivatingWordTypeComboBoxItems
				= DerivatingWordTypeComboBoxItem.BuildDerivatingWordTypeComboBoxItems
				(
					this.current__Language
				);

			foreach (DerivatingWordTypeComboBoxItem derivatingWordTypeComboBoxItem in derivatingWordTypeComboBoxItems.ToList())
			{
				if (derivatingWordTypeComboBoxItem.Row.WordTypeId != this.current__Word.WordTypeId)
				{
					derivatingWordTypeComboBoxItems.Remove(derivatingWordTypeComboBoxItem);
				}
			}

			if (derivatingWordTypeComboBoxItems.Count != 1)
			{
				this.comboBox__DerivatingWordType.Items.AddRange(derivatingWordTypeComboBoxItems.ToArray());
			}
			else
			{
				DerivatingWordTypeComboBoxItem theDerivatingWordTypeComboBoxItem = derivatingWordTypeComboBoxItems[0];

				this.comboBox__DerivatingWordType.Items.Add(theDerivatingWordTypeComboBoxItem);

				this.comboBox__DerivatingWordType.SelectedItem = theDerivatingWordTypeComboBoxItem;

				this.button__Append__Click(null, null);

				this.IsClosed = true;
			}
		}

		public Form__WordDerivating__Append()
		{
			InitializeComponent();
		}

		#endregion	ctors

		private void button__Append__Click(object sender, EventArgs e)
		{

			if (this.comboBox__DerivatingWordType.SelectedItem == null)
			{
				MessageBox.Show("A 'Derivating Word Type' must be selected.", "Missing Value", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}
			DerivatingWordTypeComboBoxItem selectedDerivatingWordTypeComboBoxItem		
				= (DerivatingWordTypeComboBoxItem)(this.comboBox__DerivatingWordType.SelectedItem);
		
			this.mainForm.Current__Word.HasDerivating = true;

			this.mainForm.Current__WordDerivating 
				= this.mainForm.DataSet.WordDerivating
				.AddWordDerivatingRow
				(
					this.current__Word.Id,
					selectedDerivatingWordTypeComboBoxItem.Row.WordTypeId,
					selectedDerivatingWordTypeComboBoxItem.Row.DerivatingWordTypeId
				);

			this.DialogResult = DialogResult.OK;

			this.Close();
		}
	}
}
